/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.java.v1.JavaDocLexer;
import oracle.javatools.parser.java.v1.JavaSyntaxCodes;
import oracle.javatools.parser.java.v1.JavaSyntaxRecognizer;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeBlockSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.CommonRoot;
import oracle.javatools.parser.java.v1.symbol.ControlStatement;
import oracle.javatools.parser.java.v1.symbol.CreatorExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionList;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionWrapper;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.ForStatement;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.ImportSymbol;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.OperatorExpression;
import oracle.javatools.parser.java.v1.symbol.PackageSymbol;
import oracle.javatools.parser.java.v1.symbol.ParameterSymbol;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.SqlStatement;
import oracle.javatools.parser.java.v1.symbol.StatementSymbol;
import oracle.javatools.parser.java.v1.symbol.SwitchCaseLabel;
import oracle.javatools.parser.java.v1.symbol.TryStatement;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

@Deprecated
public class JavaSymbolFactory
implements JavaSyntaxCodes {
    static final int SYNTAX_ROOT = 10;
    private Scope currentScope = null;
    private ReadTextBuffer buffer;
    private Map nameMap;
    private int classCount = 0;
    private int variableCount = 0;
    private int expressionCount = 0;

    public JavaSymbolFactory(ReadTextBuffer buffer, Scope scope) {
        this.buffer = buffer;
        this.currentScope = scope;
        this.nameMap = new HashMap();
    }

    TypeSymbol newTypeSymbol() {
        return new TypeSymbol(this.currentScope);
    }

    ReadTextBuffer getReadTextBuffer() {
        return this.buffer;
    }

    Map getNameMap() {
        return this.nameMap;
    }

    private JavaSymbol pushScope(Scope newScope) {
        newScope.setEnclosingScope(this.currentScope);
        this.currentScope = newScope;
        return (JavaSymbol)((Object)newScope);
    }

    private void popScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public JavaSymbol createAndFinishErrorSymbol(SyntaxToken token, CommonRoot root) {
        ErrorSymbol newSymbol = new ErrorSymbol(token.getContextString());
        newSymbol.startOffset = token.getStartOffset();
        newSymbol.endOffset = token.getEndOffset();
        newSymbol.dataValue = token.getDataValue();
        root.addError(newSymbol);
        return newSymbol;
    }

    public JavaSymbol createSymbol(SyntaxToken token, JavaSymbol parent) {
        return this.createSymbol(token.getCode(), token.getStartOffset(), token.getEndOffset(), parent);
    }

    public JavaSymbol createSymbol(int syntaxCode, int startOffset, int endOffset, JavaSymbol parent) {
        JavaSymbol symbol;
        JavaSymbol reporter = null;
        switch (syntaxCode) {
            case 10: {
                symbol = new CommonRoot();
                break;
            }
            case 25: {
                RootSymbol rs;
                reporter = rs = new RootSymbol();
                symbol = this.pushScope(rs);
                break;
            }
            case 40: {
                symbol = new PackageSymbol();
                break;
            }
            case 50: {
                symbol = new ImportSymbol();
                break;
            }
            case 60: {
                symbol = new ClassSymbol(syntaxCode, -1);
                break;
            }
            case 99: {
                symbol = new NameSymbol(syntaxCode);
                break;
            }
            case 200: 
            case 400: {
                symbol = new ClassSymbol(syntaxCode, this.classCount++);
                break;
            }
            case 65: {
                symbol = new ClassBodySymbol();
                this.pushScope((ClassSymbol)parent);
                break;
            }
            case 280: {
                symbol = new MemberSymbol(syntaxCode);
                break;
            }
            case 212: {
                symbol = new ClassListSymbol(syntaxCode);
                break;
            }
            case 300: {
                symbol = this.pushScope(new FieldSymbol());
                break;
            }
            case 260: {
                symbol = this.pushScope(new MemberSymbol(syntaxCode));
                break;
            }
            case 340: 
            case 370: {
                symbol = this.pushScope(new MethodSymbol(syntaxCode));
                break;
            }
            case 500: {
                CodeBlockSymbol cbs = new CodeBlockSymbol(syntaxCode);
                reporter = cbs;
                symbol = this.pushScope(cbs);
                break;
            }
            case 501: 
            case 509: {
                symbol = this.pushScope(new CodeBlockSymbol(syntaxCode));
                break;
            }
            case 510: {
                symbol = new CodeElement(syntaxCode);
                break;
            }
            case 591: {
                symbol = new SwitchCaseLabel(syntaxCode);
                break;
            }
            case 520: {
                symbol = this.pushScope(new StatementSymbol(syntaxCode));
                break;
            }
            case 522: {
                symbol = this.pushScope(new SqlStatement());
                break;
            }
            case 532: {
                symbol = this.pushScope(new ForStatement());
                break;
            }
            case 531: 
            case 533: 
            case 534: 
            case 536: 
            case 537: {
                symbol = this.pushScope(new ControlStatement(syntaxCode));
                break;
            }
            case 535: {
                symbol = this.pushScope(new TryStatement());
                break;
            }
            case 542: {
                symbol = this.pushScope(new CatchClause());
                break;
            }
            case 541: 
            case 543: {
                symbol = new ControlStatement(syntaxCode);
                break;
            }
            case 570: 
            case 571: 
            case 580: {
                symbol = new JavaSymbol(syntaxCode);
                break;
            }
            case 560: 
            case 581: {
                symbol = new CodeElement(syntaxCode);
                break;
            }
            case 582: 
            case 583: {
                symbol = new ExpressionSymbol(syntaxCode, this.expressionCount++);
                break;
            }
            case 609: 
            case 619: {
                symbol = new NameSymbol(syntaxCode);
                break;
            }
            case 321: 
            case 611: 
            case 772: {
                symbol = new ExpressionList(syntaxCode, this.expressionCount++);
                break;
            }
            case 640: {
                ExpressionWrapper ew = new ExpressionWrapper(syntaxCode, this.expressionCount++);
                reporter = ew;
                symbol = ew;
                break;
            }
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: {
                symbol = new OperatorExpression(syntaxCode, this.expressionCount++);
                break;
            }
            case 320: 
            case 600: 
            case 605: 
            case 610: 
            case 700: 
            case 701: 
            case 723: 
            case 770: 
            case 771: {
                symbol = new ExpressionSymbol(syntaxCode, this.expressionCount++);
                break;
            }
            case 760: {
                symbol = new ClassSymbol(syntaxCode, this.classCount++);
                break;
            }
            case 750: 
            case 751: {
                symbol = new CreatorExpressionSymbol(syntaxCode, this.expressionCount++, this.newTypeSymbol());
                break;
            }
            case 352: {
                symbol = new ClassListSymbol(syntaxCode);
                break;
            }
            case 311: {
                symbol = new VariableSymbol(this.variableCount++);
                if (parent.code != 560) break;
                this.popScope();
                break;
            }
            case 100: {
                symbol = this.newTypeSymbol();
                break;
            }
            case 359: {
                symbol = new ParameterSymbol();
                break;
            }
            case 351: {
                symbol = new JavaSymbol(syntaxCode);
                break;
            }
            case 151: 
            case 152: 
            case 155: 
            case 721: 
            case 722: {
                symbol = new NameSymbol(syntaxCode);
                break;
            }
            case 143: {
                symbol = new CommentSymbol(syntaxCode);
                break;
            }
            case 111: 
            case 159: 
            case 170: {
                symbol = new JavaSymbol(syntaxCode);
                break;
            }
            default: {
                System.err.println("JavaSymbolFactory - create: Unknown syntax code " + syntaxCode);
                symbol = new JavaSymbol(syntaxCode);
            }
        }
        if (reporter != null && parent.code == 10) {
            ((CommonRoot)parent).setRoot((ErrorReporter)((Object)reporter));
        }
        symbol.parent = parent;
        symbol.startOffset = startOffset;
        symbol.endOffset = endOffset;
        return symbol;
    }

    public void finishSymbol(JavaSymbol symbol, SyntaxToken token) {
        symbol.endOffset = token.getEndOffset();
        symbol.dataValue = token.getDataValue();
        this.finishSymbol(symbol);
    }

    public boolean forceFinishSymbol(JavaSymbol symbol, int endOffset) {
        try {
            symbol.endOffset = endOffset;
            this.finishSymbol(symbol);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void finishSymbol(JavaSymbol symbol) {
        try {
            JavaSymbol parent = symbol.parent;
            switch (symbol.code) {
                case 25: {
                    this.popScope();
                }
                case 10: 
                case 40: 
                case 50: 
                case 60: {
                    break;
                }
                case 99: {
                    NameSymbol sqlContext = (NameSymbol)symbol;
                    sqlContext.recordName(this.buffer);
                    ((RootSymbol)parent).setSqlContext(sqlContext);
                    break;
                }
                case 200: 
                case 400: {
                    this.popScope();
                }
                case 65: 
                case 280: {
                    break;
                }
                case 212: {
                    ((ClassSymbol)parent).setBaseInterfaces((ClassListSymbol)symbol);
                    break;
                }
                case 260: 
                case 300: 
                case 340: 
                case 370: {
                    this.popScope();
                    break;
                }
                case 500: 
                case 501: 
                case 509: {
                    this.popScope();
                    CodeBlockSymbol block = (CodeBlockSymbol)symbol;
                    if (parent instanceof CodeBlockSymbol) break;
                    if (parent instanceof MemberSymbol) {
                        ((MemberSymbol)parent).setBlock(block);
                        break;
                    }
                    if (symbol.code == 509 || parent.code == 10) break;
                    ((StatementSymbol)parent).setBlock(block);
                    break;
                }
                case 510: {
                    if (!(parent instanceof CodeBlockSymbol)) break;
                    ((CodeBlockSymbol)parent).addCodeElement((CodeElement)symbol);
                    break;
                }
                case 522: {
                    ((SqlStatement)symbol).recordStatement(this.buffer);
                }
                case 520: {
                    this.popScope();
                }
                case 591: {
                    StatementSymbol toBeAdded;
                    StatementSymbol thisStatement = (StatementSymbol)symbol;
                    StatementSymbol childStatement = thisStatement.getChild();
                    StatementSymbol statementSymbol = toBeAdded = childStatement != null ? childStatement : thisStatement;
                    if (parent instanceof CodeElement) {
                        ((CodeElement)parent).setStatement(toBeAdded);
                        break;
                    }
                    if (parent instanceof ControlStatement) {
                        ((ControlStatement)parent).setPrimaryClause(toBeAdded);
                        break;
                    }
                    ((StatementSymbol)parent).setChild(toBeAdded);
                    break;
                }
                case 531: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: {
                    this.popScope();
                    ((StatementSymbol)parent).setChild((StatementSymbol)symbol);
                    break;
                }
                case 541: 
                case 543: {
                    ControlStatement clause = (ControlStatement)symbol;
                    ((ControlStatement)parent).setEndClause(clause.getPrimaryClause());
                    break;
                }
                case 542: {
                    this.popScope();
                    ((TryStatement)parent).addCatchClause((CatchClause)symbol);
                    break;
                }
                case 570: 
                case 571: 
                case 580: {
                    break;
                }
                case 560: {
                    if (!(parent instanceof StatementSymbol)) break;
                    ((StatementSymbol)parent).setExpression(((CodeElement)symbol).getExpression());
                    break;
                }
                case 581: {
                    ((ForStatement)parent.parent).addInit((CodeElement)symbol);
                    break;
                }
                case 582: {
                    ExpressionSymbol expr = (ExpressionSymbol)symbol;
                    expr.setCategory(1);
                    ((ForStatement)parent.parent).setConditional(expr);
                    break;
                }
                case 583: {
                    ExpressionSymbol expr = (ExpressionSymbol)symbol;
                    expr.setCategory(1);
                    ((ForStatement)parent.parent).addUpdate((ExpressionSymbol)symbol);
                    break;
                }
                case 611: 
                case 772: {
                    ExpressionSymbol args = (ExpressionSymbol)symbol;
                    args.setCategory(9);
                    break;
                }
                case 321: {
                    ((ExpressionSymbol)symbol).setCategory(34);
                    break;
                }
                case 609: 
                case 619: {
                    if (parent.code != 320) break;
                    ExpressionSymbol varinit = (ExpressionSymbol)parent;
                    varinit.setCategory(-1);
                    varinit.setName((NameSymbol)symbol);
                    break;
                }
                case 605: {
                    if (parent.code == 772) {
                        while (!(parent instanceof CreatorExpressionSymbol)) {
                            parent = parent.parent;
                        }
                        CreatorExpressionSymbol creator = (CreatorExpressionSymbol)parent;
                        creator.getClassType().incrementArrayDimension(1);
                    }
                }
                case 610: {
                    ExpressionSymbol parenE = (ExpressionSymbol)symbol;
                    parenE.setCategory(40);
                    break;
                }
                case 640: {
                    ((ExpressionWrapper)symbol).process(this);
                    break;
                }
                case 600: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: {
                    break;
                }
                case 700: 
                case 701: {
                    ExpressionSymbol primary = (ExpressionSymbol)symbol;
                    if (JavaSyntaxRecognizer.isLiteral(primary.getExactCode())) {
                        ((ExpressionSymbol)symbol).setCategory(33);
                        break;
                    }
                    ((ExpressionSymbol)symbol).setCategory(17);
                    break;
                }
                case 750: 
                case 751: {
                    break;
                }
                case 723: {
                    ((ExpressionSymbol)symbol).setCategory(19);
                    break;
                }
                case 760: {
                    this.popScope();
                }
                case 770: 
                case 771: {
                    break;
                }
                case 352: {
                    ((MethodSymbol)parent).setThrows((ClassListSymbol)symbol);
                    break;
                }
                case 320: {
                    ExpressionSymbol varinit = (ExpressionSymbol)symbol;
                    if (parent instanceof VariableSymbol) {
                        ((VariableSymbol)parent).setInitializer(varinit);
                    }
                    if (varinit.getCategory() != -1) break;
                    varinit.dataValue = -1;
                    break;
                }
                case 311: {
                    VariableSymbol var = (VariableSymbol)symbol;
                    if (parent instanceof FieldSymbol) {
                        FieldSymbol field = (FieldSymbol)parent;
                        MemberSymbol m = (MemberSymbol)field.parent;
                        var.useType(m.getType(), this);
                        var.setModifiers(m.getModifiers());
                        field.addVariable(var);
                        break;
                    }
                    if (parent instanceof ParameterSymbol) {
                        ParameterSymbol param = (ParameterSymbol)parent;
                        MethodSymbol method = (MethodSymbol)param.parent.parent;
                        var.useType(param.getType(), this);
                        var.setModifiers(param.getModifiers());
                        method.addParameter(var);
                        break;
                    }
                    if (parent.code == 571) {
                        CatchClause clause = (CatchClause)parent.parent;
                        var.useType(clause.getThrowableType(), this);
                        clause.setThrowable(var);
                        break;
                    }
                    CodeElement decl = (CodeElement)parent;
                    var.setModifiers(decl.getModifiers());
                    try {
                        TypeSymbol type = this.newTypeSymbol();
                        type.useExpression(decl.getExpression(), this.buffer, this.nameMap);
                        var.useType(type, this);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (parent.parent.code == 520) {
                        this.pushScope((StatementSymbol)parent.parent);
                    }
                    decl.addVariable(var);
                    break;
                }
                case 100: {
                    TypeSymbol type = (TypeSymbol)symbol;
                    if (parent.code == 280) {
                        ((MemberSymbol)parent).setType(type);
                        break;
                    }
                    if (parent.code == 359) {
                        ((ParameterSymbol)parent).setType(type);
                        break;
                    }
                    ((CatchClause)parent.parent).setThrowableType(type);
                    break;
                }
                case 351: 
                case 359: {
                    break;
                }
                case 152: {
                    NameSymbol name = (NameSymbol)symbol;
                    if (parent.code == 200) {
                        TypeSymbol type = this.newTypeSymbol();
                        type.setName(name);
                        type.startOffset = name.startOffset;
                        type.endOffset = name.endOffset;
                        ((ClassSymbol)parent).setBaseClass(type);
                    } else if (parent instanceof ClassListSymbol) {
                        TypeSymbol type = this.newTypeSymbol();
                        type.setName(name);
                        type.startOffset = name.startOffset;
                        type.endOffset = name.endOffset;
                        ((ClassListSymbol)parent).addClass(type);
                    } else {
                        ((Nameable)((Object)parent)).setName(name);
                    }
                    name.recordName(this.buffer);
                    name.uniquefy(this.nameMap);
                    break;
                }
                case 151: {
                    NameSymbol name = (NameSymbol)symbol;
                    if (parent instanceof StatementSymbol) {
                        ((StatementSymbol)parent).addLabel(name);
                    } else {
                        ((Nameable)((Object)parent)).setName(name);
                    }
                    name.recordName(this.buffer);
                    name.uniquefy(this.nameMap);
                    break;
                }
                case 159: {
                    break;
                }
                case 721: {
                    ((Nameable)((Object)parent)).setName((NameSymbol)symbol);
                    NameSymbol nameSymbol = (NameSymbol)symbol;
                    nameSymbol.recordName(this.buffer, symbol.dataValue);
                    nameSymbol.uniquefy(this.nameMap);
                    break;
                }
                case 155: 
                case 722: {
                    ((Nameable)((Object)parent)).setName((NameSymbol)symbol);
                    NameSymbol nameSymbol = (NameSymbol)symbol;
                    nameSymbol.recordName(this.buffer, symbol.dataValue);
                    nameSymbol.uniquefy(this.nameMap);
                    break;
                }
                case 143: {
                    CommentSymbol comment = (CommentSymbol)symbol;
                    ((Commentable)((Object)parent)).setComment(comment);
                    comment.recordName(this.buffer);
                    break;
                }
                case 170: {
                    if (parent.code == 571) {
                        ((CatchClause)parent.parent).setModifiers(symbol.dataValue);
                        break;
                    }
                    if (!(parent instanceof HasModifiers)) break;
                    ((HasModifiers)parent).setModifiers(symbol.dataValue);
                    break;
                }
                case 111: {
                    if (parent instanceof TypeSymbol) {
                        TypeSymbol type = (TypeSymbol)parent;
                        type.incrementArrayDimension(symbol.dataValue);
                        break;
                    }
                    if (parent instanceof MethodSymbol) {
                        MethodSymbol method = (MethodSymbol)parent;
                        method.getType().incrementArrayDimension(symbol.dataValue);
                        break;
                    }
                    if (parent instanceof VariableSymbol) {
                        VariableSymbol variable = (VariableSymbol)parent;
                        variable.incrementArrayDimension(symbol.dataValue);
                        break;
                    }
                    if (parent instanceof ParameterSymbol) {
                        ParameterSymbol param = (ParameterSymbol)parent;
                        param.getType().incrementArrayDimension(symbol.dataValue);
                        break;
                    }
                    while (!(parent instanceof CreatorExpressionSymbol)) {
                        parent = parent.parent;
                    }
                    CreatorExpressionSymbol creator = (CreatorExpressionSymbol)parent;
                    creator.getClassType().incrementArrayDimension(symbol.dataValue);
                    break;
                }
                default: {
                    System.err.println("JavaSymbolFactory, finish: Unknown syntax code " + symbol.code);
                }
            }
            symbol.doneParsing();
        }
        catch (ClassCastException e) {
            try {
                symbol.parent.internalError("I'm the parent");
            }
            catch (Exception exception) {
                // empty catch block
            }
            symbol.internalError("Class cast exception during finishSymbol");
            e.printStackTrace();
        }
        catch (NullPointerException npe) {
            symbol.reportSyntaxError(JavaSyntaxRecognizer.SYNTAXERR_SKIPPING);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void postProcess(RootSymbol rootSym) {
        JavaSymbolFactory.processJavadoc(rootSym);
    }

    public static void processJavadoc(RootSymbol rootSymbol) {
        JavaDocLexer lexer = new JavaDocLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        ClassSymbol[] classes = rootSymbol.getClasses();
        if (classes != null) {
            for (ClassSymbol oneClass : classes) {
                if (oneClass == null) continue;
                JavaSymbolFactory.processOneJavadoc(oneClass, lexer, lexerToken);
                JavaSymbolFactory.processJavadoc(oneClass, lexer, lexerToken);
            }
        }
    }

    private static void processJavadoc(ClassSymbol classSymbol, JavaDocLexer lexer, LexerToken lexerToken) {
        for (MemberSymbol oneMember : classSymbol.getMembers()) {
            if (oneMember == null) continue;
            JavaSymbolFactory.processOneJavadoc(oneMember, lexer, lexerToken);
            if (oneMember.whatAmI() != 289) continue;
            InnerClassSymbol innerClass = (InnerClassSymbol)oneMember;
            ClassSymbol innerClassSymbol = innerClass.getClassDefinition();
            JavaSymbolFactory.processJavadoc(innerClassSymbol, lexer, lexerToken);
        }
    }

    private static void processOneJavadoc(Commentable commentable, JavaDocLexer lexer, LexerToken lexerToken) {
        CommentSymbol comment = commentable.getComment();
        if (comment != null) {
            comment.processFlags(lexer, lexerToken);
        }
    }
}

