/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;

@Deprecated
public class ClassBodySymbol
extends JavaSymbol {
    private ArrayList members = ClassBodySymbol.allocArrayList();
    private ArrayList constructors = ClassBodySymbol.allocArrayList();
    private ArrayList fields = ClassBodySymbol.allocArrayList();
    private ArrayList methods = ClassBodySymbol.allocArrayList();
    private ArrayList innerClasses = ClassBodySymbol.allocArrayList();
    private ArrayList initializers = ClassBodySymbol.allocArrayList();
    private MemberSymbol[] memberArray = null;
    private MethodSymbol[] constructorArray = null;
    private MethodSymbol[] methodArray = null;
    private FieldSymbol[] fieldArray = null;
    private InnerClassSymbol[] innerClassArray = null;
    private MemberSymbol[] initializerArray = null;

    ClassBodySymbol() {
        super(65);
    }

    void addInitializer(MemberSymbol sinit) {
        this.initializers.add(sinit);
        this.members.add(sinit);
    }

    void addConstructor(MethodSymbol constructor) {
        this.constructors.add(constructor);
        this.members.add(constructor);
    }

    void addMethod(MethodSymbol method) {
        this.methods.add(method);
        this.members.add(method);
    }

    void addField(FieldSymbol field) {
        this.fields.add(field);
        this.members.add(field);
    }

    void addInnerClass(InnerClassSymbol cls) {
        this.innerClasses.add(cls);
        this.members.add(cls);
    }

    @Override
    void doneParsing() {
        this.generateMemberArray();
        this.generateMethodArray();
        this.generateConstructorArray();
        this.generateFieldArray();
        this.generateInnerClassArray();
        this.generateInitializerArray();
        ((ClassSymbol)this.parent).setBody(this);
    }

    void doneParsingLocalClass(boolean named, ClassSymbol cls) {
        MemberSymbol[] members = this.listMembers();
        int length = members.length;
        for (int i = 0; i < length; ++i) {
            CommentSymbol comment = members[i].getComment();
            if (comment == null) continue;
            comment.useDefaultFlags();
        }
        JavaSymbol findMember = this.parent;
        while (findMember != null) {
            if (findMember instanceof MemberSymbol) {
                MemberSymbol enclosingMember = (MemberSymbol)findMember;
                enclosingMember.addLocalClass(cls);
                break;
            }
            findMember = findMember.parent;
        }
    }

    public MemberSymbol[] listMembers() {
        if (this.memberArray == null) {
            this.generateMemberArray();
        }
        return this.memberArray;
    }

    public MethodSymbol[] listMethods() {
        if (this.methodArray == null) {
            this.generateMethodArray();
        }
        return this.methodArray;
    }

    public MethodSymbol[] listConstructors() {
        if (this.constructorArray == null) {
            this.generateConstructorArray();
        }
        return this.constructorArray;
    }

    public FieldSymbol[] listFields() {
        if (this.fieldArray == null) {
            this.generateFieldArray();
        }
        return this.fieldArray;
    }

    public InnerClassSymbol[] listInnerClasses() {
        if (this.innerClassArray == null) {
            this.generateInnerClassArray();
        }
        return this.innerClassArray;
    }

    public MemberSymbol[] listInitializers() {
        if (this.initializerArray == null) {
            this.generateInitializerArray();
        }
        return this.initializerArray;
    }

    ClassSymbol getEnclosingClass() {
        return (ClassSymbol)this.parent;
    }

    private void generateMemberArray() {
        int size = this.members.size();
        this.memberArray = size > 0 ? this.members.toArray(new MemberSymbol[size]) : MemberSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.members);
        this.members = null;
    }

    private void generateMethodArray() {
        int size = this.methods.size();
        this.methodArray = size > 0 ? this.methods.toArray(new MethodSymbol[size]) : MethodSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.methods);
        this.methods = null;
    }

    private void generateConstructorArray() {
        int size = this.constructors.size();
        this.constructorArray = size > 0 ? this.constructors.toArray(new MethodSymbol[size]) : MethodSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.constructors);
        this.constructors = null;
    }

    private void generateFieldArray() {
        int size = this.fields.size();
        this.fieldArray = size > 0 ? this.fields.toArray(new FieldSymbol[size]) : FieldSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.fields);
        this.fields = null;
    }

    private void generateInnerClassArray() {
        int size = this.innerClasses.size();
        this.innerClassArray = size > 0 ? this.innerClasses.toArray(new InnerClassSymbol[size]) : InnerClassSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.innerClasses);
        this.innerClasses = null;
    }

    private void generateInitializerArray() {
        int size = this.initializers.size();
        this.initializerArray = size > 0 ? this.initializers.toArray(new MemberSymbol[size]) : MemberSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.initializers);
        this.initializers = null;
    }
}

