/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.util.EventObject;
import oracle.javatools.data.ChangeInfo;

public class StructureChangeEvent
extends EventObject {
    private final ChangeInfo[] _changeDetails;

    public StructureChangeEvent(Object source, ChangeInfo changeDetail) {
        this(source, StructureChangeEvent.toChangeDetails(changeDetail));
    }

    public StructureChangeEvent(Object source, ChangeInfo[] changeDetails) {
        super(source);
        this._changeDetails = changeDetails != null ? changeDetails : new ChangeInfo[]{};
    }

    public ChangeInfo[] getChangeDetails() {
        int n = this._changeDetails.length;
        ChangeInfo[] copy = new ChangeInfo[n];
        System.arraycopy(this._changeDetails, 0, copy, 0, n);
        return copy;
    }

    protected static ChangeInfo[] toChangeDetails(ChangeInfo changeDetail) {
        if (changeDetail == null) {
            return new ChangeInfo[0];
        }
        return new ChangeInfo[]{changeDetail};
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("StructureChangeEvent[");
        for (ChangeInfo change : this._changeDetails) {
            builder.append(change);
        }
        builder.append("]");
        return builder.toString();
    }
}

