/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.data.AuditedWriteList;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.Structure;

public class ListStructure
extends Structure
implements List {
    private final List<Object> _list = Collections.synchronizedList(new AuditedWriteList(new ArrayList()));

    private ListStructure() {
    }

    public static final ListStructure newInstance() {
        return new ListStructure();
    }

    static final ListStructure newChainForOverriding(ListStructure found, HashStructure firstHash, String fullName) {
        return new ChainForOverriding(found, firstHash, fullName);
    }

    public void add(int index, Object obj) {
        this.checkObjectForAdd(obj);
        obj = ListStructure.intern(obj);
        this._list.add(index, obj);
        this.markDirty(true);
        this.fireValueAdded(Integer.toString(index), this, obj);
    }

    @Override
    public boolean add(Object obj) {
        this.checkObjectForAdd(obj);
        obj = ListStructure.intern(obj);
        this._list.add(obj);
        this.markDirty(true);
        this.fireValueAdded(Integer.toString(this._list.size() - 1), this, obj);
        return true;
    }

    public boolean addPlaceholder(Object obj) {
        this.checkObjectForAdd(obj);
        obj = ListStructure.intern(obj);
        this._list.add(obj);
        this.firePlaceholderValueAdded(Integer.toString(this._list.size() - 1), this, obj);
        return true;
    }

    public boolean addAll(final int index, Collection coll) {
        final boolean[] modified = new boolean[]{false};
        if (coll != null) {
            if (coll instanceof ListStructure) {
                ArrayList newColl = new ArrayList();
                newColl.addAll(coll);
                coll = newColl;
            }
            Iterator checkIter = coll.iterator();
            final Iterator addIter = coll.iterator();
            while (checkIter.hasNext()) {
                this.checkObjectForAdd(checkIter.next(), false);
            }
            this.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    int i = index;
                    while (addIter.hasNext()) {
                        ListStructure.this.add(i++, addIter.next());
                        modified[0] = true;
                    }
                }
            });
        }
        return modified[0];
    }

    @Override
    public boolean addAll(Collection coll) {
        return this.addAll(this.size(), coll);
    }

    @Override
    public void clear() {
        final int n = this.size();
        if (n > 0) {
            this.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    for (int i = n - 1; i >= 0; --i) {
                        ListStructure.this.remove(i);
                    }
                }
            });
        }
    }

    @Override
    public boolean contains(Object obj) {
        return this._list.contains(obj);
    }

    @Override
    public boolean containsAll(Collection coll) {
        return this._list.containsAll(coll);
    }

    public Object get(int index) {
        return this._list.get(index);
    }

    @Override
    public int indexOf(Object obj) {
        if (obj instanceof Structure) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                Object item = this.get(i);
                if (item != obj) continue;
                return i;
            }
            return -1;
        }
        return this._list.indexOf(obj);
    }

    @Override
    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public Object iteratorLock() {
        return this._list;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int _curIndex = -1;
            private int _removeCount = 0;
            private final Iterator _iter = ListStructure.access$000(ListStructure.this).iterator();
            private Object _cur;

            @Override
            public boolean hasNext() {
                return this._iter.hasNext();
            }

            public Object next() {
                ++this._curIndex;
                this._cur = this._iter.next();
                return this._cur;
            }

            @Override
            public void remove() {
                this._iter.remove();
                ListStructure.this.dirtyAndMaybeDetach(this._cur);
                ListStructure.this.fireValueRemoved(Integer.toString(this._curIndex - this._removeCount++), ListStructure.this, this._cur);
            }
        };
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj instanceof Structure) {
            int n = this.size();
            for (int i = n - 1; i >= 0; --i) {
                Object item = this.get(i);
                if (item != obj) continue;
                return i;
            }
            return -1;
        }
        return this._list.lastIndexOf(obj);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        Object obj = this._list.remove(index);
        this.dirtyAndMaybeDetach(obj);
        this.fireValueRemoved(Integer.toString(index), this, obj);
        return obj;
    }

    @Override
    public boolean remove(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection coll) {
        final boolean[] modified = new boolean[]{false};
        if (coll != null) {
            final Iterator iter = coll.iterator();
            this.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    while (iter.hasNext()) {
                        modified[0] = modified[0] | ListStructure.this.remove(iter.next());
                    }
                }
            });
        }
        return modified[0];
    }

    @Override
    public boolean retainAll(final Collection coll) {
        final boolean[] modified = new boolean[]{false};
        if (coll != null) {
            final Iterator iter = this.iterator();
            this.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (coll.contains(obj)) continue;
                        iter.remove();
                        modified[0] = true;
                    }
                }
            });
        }
        return modified[0];
    }

    public Object set(int index, Object newValue) {
        this.checkObjectForAdd(newValue);
        Object oldValue = this._list.set(index, newValue);
        this.dirtyAndMaybeDetach(oldValue);
        this.fireValueModified(Integer.toString(index), this, oldValue, newValue);
        return oldValue;
    }

    public List subList(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public Object[] toArray() {
        return this._list.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        return this._list.toArray(array);
    }

    public boolean mirror(final List list) {
        if (this != list) {
            boolean equal;
            int size = this.size();
            boolean bl = equal = list == null && size == 0 || list != null && size == list.size();
            if (equal) {
                Iterator iter = this.iterator();
                Iterator otherIter = list.iterator();
                while (iter.hasNext()) {
                    if (!ListStructure.areDifferent(iter.next(), otherIter.next())) continue;
                    equal = false;
                    break;
                }
            }
            if (!equal) {
                this.applyBatchChanges(new Runnable(){

                    @Override
                    public void run() {
                        ListStructure.this.clear();
                        ListStructure.this.addAll((Collection)list);
                    }
                });
                return true;
            }
        }
        return false;
    }

    public void internalPreprsist() {
        if (this._list.size() > 0) {
            final HashSet keys = new HashSet();
            final Collator collator = Collator.getInstance();
            try {
                Comparator c = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        HashStructure hash1 = (HashStructure)o1;
                        HashStructure hash2 = (HashStructure)o2;
                        keys.clear();
                        keys.addAll(hash1.persistentKeySet());
                        keys.addAll(hash2.persistentKeySet());
                        Object[] keyArray = keys.toArray(new String[keys.size()]);
                        Arrays.sort(keyArray);
                        for (Object key : keyArray) {
                            String s2;
                            Object v2;
                            Object v1 = hash1.getObject((String)key);
                            if (v1 == (v2 = hash2.getObject((String)key))) continue;
                            if (v1 == null) {
                                return -1;
                            }
                            if (v2 == null) {
                                return 1;
                            }
                            String s1 = this.toString(v1);
                            int comp = collator.compare(s1, s2 = this.toString(v2));
                            if (comp == 0) continue;
                            return comp;
                        }
                        return 0;
                    }

                    private String toString(Object obj) {
                        if (obj instanceof URL) {
                            return ((URL)obj).getPath();
                        }
                        return obj.toString();
                    }
                };
                Collections.sort(this._list, c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    String getNameOfChild(Structure struct) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            if (struct != this.get(i)) continue;
            return Integer.toString(i);
        }
        return null;
    }

    @Override
    void removeChild(Structure child) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != child) continue;
            iter.remove();
            break;
        }
    }

    public ListStructure copyTo(ListStructure dest) {
        final ListStructure finalDest = dest != null ? dest : ListStructure.newInstance();
        finalDest.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                ListStructure.deepCopy(ListStructure.this, finalDest);
            }
        });
        return finalDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deepCopy(ListStructure srcList, ListStructure destList) {
        if (!srcList.equalsImpl(destList)) {
            destList.clear();
            Object object = srcList.iteratorLock();
            synchronized (object) {
                for (Object obj : srcList) {
                    if (obj instanceof HashStructure) {
                        HashStructure hash = (HashStructure)obj;
                        destList.add(hash.copyTo(null));
                        continue;
                    }
                    if (obj instanceof ListStructure) {
                        ListStructure list = (ListStructure)obj;
                        destList.add(list.copyTo(null));
                        continue;
                    }
                    destList.add(obj);
                }
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ListStructure)obj);
    }

    protected boolean equalsImpl(ListStructure other) {
        return ((Object)this._list).equals(other._list);
    }

    @Override
    public int hashCode() {
        return ((Object)this._list).hashCode();
    }

    private void dirtyAndMaybeDetach(Object obj) {
        this.markDirty(true);
        this.maybeDetach(obj);
    }

    private void maybeDetach(Object obj) {
        if (obj instanceof Structure) {
            ((Structure)obj).setParent(null);
        }
    }

    private void checkObjectForAdd(Object obj) {
        this.checkObjectForAdd(obj, true);
    }

    private void checkObjectForAdd(Object obj, boolean reparentNow) {
        if (obj != null) {
            Class<?> type = obj.getClass();
            if (type == HashStructure.Impl.class || type == ListStructure.class) {
                if (reparentNow) {
                    this.checkAndSetParent((Structure)obj, null);
                } else {
                    this.checkForCycleWith((Structure)obj);
                }
            } else if (type != String.class && type != Boolean.class && type != Integer.class && type != Long.class && type != Float.class && type != Double.class && type != URL.class) {
                throw new IllegalArgumentException("Type not supported by ListStructure: " + type.getName());
            }
        }
    }

    static /* synthetic */ List access$000(ListStructure x0) {
        return x0._list;
    }

    private static final class ChainForOverriding
    extends ListStructure {
        private final ListStructure _found;
        private ListStructure _firstList;
        private final HashStructure _firstHash;
        private final String _fullName;

        ChainForOverriding(ListStructure found, HashStructure firstHash, String fullName) {
            this._found = found;
            this._firstHash = firstHash;
            this._fullName = fullName;
        }

        @Override
        public void add(int index, Object obj) {
            this.getWriteList().add(index, obj);
        }

        @Override
        public boolean add(Object obj) {
            return this.getWriteList().add(obj);
        }

        @Override
        public boolean addAll(int index, Collection coll) {
            return this.getWriteList().addAll(index, coll);
        }

        @Override
        public boolean addAll(Collection coll) {
            return this.getWriteList().addAll(coll);
        }

        @Override
        public void clear() {
            this.getWriteList().clear();
        }

        @Override
        public boolean contains(Object obj) {
            return this.getReadList().contains(obj);
        }

        @Override
        public boolean containsAll(Collection coll) {
            return this.getReadList().containsAll(coll);
        }

        @Override
        public Object get(final int index) {
            class DL
            extends Structure {
                private final Object _obj;
                private boolean _copyHappened;

                DL(Object obj) {
                    this._obj = obj;
                }

                @Override
                public void markDirty(boolean dirty) {
                    if (!this._copyHappened && dirty) {
                        if (!concurrentModDetector.hasNext()) {
                            throw new ConcurrentModificationException();
                        }
                        concurrentModDetector.next();
                        ChainForOverriding.this.set(index, this._obj);
                        this._copyHappened = true;
                    }
                }

                @Override
                void removeChild(Structure child) {
                }
            }
            if (this._firstList != null) {
                return this._firstList.get(index);
            }
            Object obj = this._found.get(index);
            final Iterator concurrentModDetector = this._found.iterator();
            if (obj instanceof HashStructure) {
                HashStructure hash = (HashStructure)obj;
                HashStructure hashCopy = hash.copyTo(null);
                DL dl = new DL(hashCopy);
                hashCopy.setParent(dl);
                return hashCopy;
            }
            if (obj instanceof ListStructure) {
                ListStructure list = (ListStructure)obj;
                ListStructure listCopy = list.copyTo(null);
                DL dl = new DL(listCopy);
                listCopy.setParent(dl);
                return listCopy;
            }
            return obj;
        }

        @Override
        public int indexOf(Object obj) {
            return this.getReadList().indexOf(obj);
        }

        @Override
        public boolean isEmpty() {
            return this.getReadList().isEmpty();
        }

        @Override
        public Iterator iterator() {
            if (this._firstList != null) {
                return this._firstList.iterator();
            }
            final ListStructure copy = this.getListCopy();
            class DL
            extends Structure {
                private boolean _copyHappened;

                DL() {
                }

                @Override
                public void markDirty(boolean dirty) {
                    if (!this._copyHappened && dirty) {
                        ChainForOverriding.this._firstHash.putListStructure(ChainForOverriding.this._fullName, copy);
                        this._copyHappened = true;
                    }
                }

                @Override
                void removeChild(Structure child) {
                }
            }
            DL dl = new DL();
            copy.setParent(dl);
            return copy.iterator();
        }

        @Override
        public int lastIndexOf(Object obj) {
            return this.getReadList().lastIndexOf(obj);
        }

        @Override
        public ListIterator listIterator() {
            if (this._firstList != null) {
                return this._firstList.listIterator();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator listIterator(int i) {
            if (this._firstList != null) {
                return this._firstList.listIterator(i);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(int index) {
            return this.getWriteList().remove(index);
        }

        @Override
        public boolean remove(Object obj) {
            return this.getWriteList().remove(obj);
        }

        @Override
        public boolean removeAll(Collection coll) {
            return this.getWriteList().removeAll(coll);
        }

        @Override
        public boolean retainAll(Collection coll) {
            return this.getWriteList().retainAll(coll);
        }

        @Override
        public Object set(int index, Object obj) {
            return this.getWriteList().set(index, obj);
        }

        @Override
        public List subList(int i, int j) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.getReadList().size();
        }

        @Override
        public Object[] toArray() {
            return this.getListCopy().toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.getListCopy().toArray(array);
        }

        @Override
        protected boolean equalsImpl(ListStructure other) {
            if (this._firstList == null) {
                return other == null;
            }
            return this._firstList.equalsImpl(other);
        }

        private ListStructure getWriteList() {
            if (this._firstList == null) {
                ListStructure existingList = this._firstHash.getListStructure(this._fullName);
                if (existingList != null) {
                    this._firstList = existingList;
                } else {
                    this._firstList = this.getListCopy();
                    this._firstHash.putListStructure(this._fullName, this._firstList);
                }
            }
            return this._firstList;
        }

        private ListStructure getReadList() {
            return this._firstList != null ? this._firstList : this._found;
        }

        private ListStructure getListCopy() {
            return this.getReadList().copyTo(null);
        }
    }
}

