/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.list;

import java.awt.EventQueue;
import java.util.Observable;
import java.util.Observer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.list.CompareList;
import oracle.javatools.compare.algorithm.list.CompareListItem;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareElement;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;

public abstract class ListCompareContributor
extends TextCompareContributor {
    private CompareList _compareList;
    private TextBuffer _textBuffer;

    @Override
    public TextBuffer getTextBuffer() {
        if (this._textBuffer != null) {
            return this._textBuffer;
        }
        this._textBuffer = TextBufferFactory.createTextBuffer();
        for (int i = 0; i < this._compareList.getSize(); ++i) {
            this._textBuffer.append((char[])this._compareList.getItem(i).getData());
        }
        return this._textBuffer;
    }

    public CompareList getCompareList() {
        if (this._compareList == null) {
            this._compareList = this.getCompareListImpl();
        }
        return this._compareList;
    }

    protected abstract CompareList getCompareListImpl();

    public void setCompareList(CompareList compareSet) {
        this._compareList = compareSet;
    }

    protected void addCompareListListeners() {
        this._compareList.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (ListCompareContributor.this.getPropertyChangeSupport() == null) {
                    return;
                }
                ListCompareContributor.this.fireChangeEvent();
                boolean modified = ListCompareContributor.this._compareList.isModified();
                this.firePropertyChange("modified", !modified, modified);
            }

            private void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.firePropertyChange(propertyName, oldValue, newValue);
                        }
                    });
                    return;
                }
                ListCompareContributor.this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }

    @Override
    public int getLength() {
        return this._compareList.getSize();
    }

    @Override
    public boolean equal(int thisIndex, SequenceCompareContributor other, int otherIndex) {
        return this._compareList.getItem(thisIndex).compareTo(((ListCompareContributor)other).getCompareList().getItem(otherIndex)) == 0;
    }

    @Override
    public SequenceCompareElement getElement(SequenceCompareDifference difference, ContributorKind contributor) {
        return difference.getLength(contributor) <= 0 ? null : this._compareList.getItem(difference.getStart(contributor));
    }

    @Override
    public UndoableEdit deleteElement(final int start, int end) {
        final CompareListItem item = this._compareList.getItem(start);
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public void undo() {
                super.undo();
                ListCompareContributor.this._compareList.insertItem(start, item);
                ListCompareContributor.this._compareList.notifyObservers();
            }

            @Override
            public void redo() {
                super.redo();
                ListCompareContributor.this._compareList.removeItem(start);
                ListCompareContributor.this._compareList.notifyObservers();
            }
        };
        this._compareList.removeItem(start);
        this._compareList.notifyObservers();
        super.deleteElement(start, end);
        return edit;
    }

    @Override
    public UndoableEdit insertElement(final int index, boolean after, SequenceCompareElement element) {
        CompareListItem item = (CompareListItem)element;
        try {
            item = (CompareListItem)item.clone();
        }
        catch (CloneNotSupportedException cnse) {
            // empty catch block
        }
        final CompareListItem final_item = item;
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public void undo() {
                super.undo();
                ListCompareContributor.this._compareList.removeItem(index);
                ListCompareContributor.this._compareList.notifyObservers();
            }

            @Override
            public void redo() {
                super.redo();
                ListCompareContributor.this._compareList.insertItem(index, final_item);
                ListCompareContributor.this._compareList.notifyObservers();
            }
        };
        this._compareList.insertItem(index, item);
        this._compareList.notifyObservers();
        super.insertElement(index, after, element);
        return edit;
    }

    @Override
    public UndoableEdit replaceElement(final int start, int end, SequenceCompareElement element) {
        CompareListItem item = (CompareListItem)element;
        try {
            item = (CompareListItem)item.clone();
        }
        catch (CloneNotSupportedException cnse) {
            // empty catch block
        }
        final CompareListItem final_item = item;
        final CompareListItem oldItem = this._compareList.getItem(start);
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public void undo() {
                super.undo();
                ListCompareContributor.this._compareList.removeItem(start);
                ListCompareContributor.this._compareList.insertItem(start, oldItem);
                ListCompareContributor.this._compareList.notifyObservers();
            }

            @Override
            public void redo() {
                super.redo();
                ListCompareContributor.this._compareList.removeItem(start);
                ListCompareContributor.this._compareList.insertItem(start, final_item);
                ListCompareContributor.this._compareList.notifyObservers();
            }
        };
        this._compareList.removeItem(start);
        this._compareList.insertItem(start, item);
        this._compareList.notifyObservers();
        super.replaceElement(start, end, element);
        return edit;
    }
}

