/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import oracle.javatools.compare.algorithm.list.CompareListItem;

public class CompareList
extends Observable {
    private final ArrayList _items = new ArrayList();
    private Object _clearState = null;

    public CompareList() {
        this.clearModified();
    }

    public CompareListItem getItem(int index) {
        return (CompareListItem)this._items.get(index);
    }

    public int getSize() {
        return this._items.size();
    }

    public void addItem(CompareListItem item) {
        this._items.add(item);
    }

    public void appendItem(CompareListItem item) {
        int i = this.binarySearch(item);
        if (i >= 0) {
            throw new IllegalStateException();
        }
        this._items.add(Math.abs(i + 1), item);
        this.clearModified();
    }

    public void insertItem(int index, CompareListItem item) {
        this._items.add(index, item);
        this.setChanged();
    }

    public CompareListItem removeItem(int index) {
        CompareListItem item = (CompareListItem)this._items.remove(index);
        this.setChanged();
        return item;
    }

    public void clearModified() {
        boolean wasModified = this.isModified();
        this._clearState = this.getState();
        if (wasModified) {
            this.setChanged();
        }
    }

    public boolean isModified() {
        return this._clearState != null && !this._clearState.equals(this.getState());
    }

    public final void sort() {
        Collections.sort(this._items);
    }

    protected final CompareListItem[] getItems() {
        return this._items.toArray(new CompareListItem[0]);
    }

    int indexOf(CompareListItem item) {
        return this._items.indexOf(item);
    }

    int binarySearch(CompareListItem item) {
        return Collections.binarySearch(this._items, item);
    }

    private Object getState() {
        ArrayList<CompareListItem> ids = new ArrayList<CompareListItem>();
        for (int i = 0; i < this.getSize(); ++i) {
            ids.add(this.getItem(i));
        }
        Collections.sort(ids);
        return ids;
    }
}

