/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.chararray.CharArrayCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;

public final class CompareUtils {
    private static int limit = 32768;

    public static int setLimit(int newLimit) {
        int currentLimit = limit;
        limit = newLimit;
        return currentLimit;
    }

    public static void replaceText(TextBuffer target, int offset, int length, char[] data) {
        if (length > 0 && data.length > 0 && length < limit && data.length < limit) {
            SequenceCompareModel model = null;
            try {
                char[] oldData = target.getChars(offset, length);
                CharArrayCompareContributor oneContrib = new CharArrayCompareContributor(oldData);
                CharArrayCompareContributor twoContrib = new CharArrayCompareContributor(data);
                model = (SequenceCompareModel)new SequenceCompareAlgorithm().compare(oneContrib, twoContrib);
                model.setType(CompareType.CHARACTER);
            }
            catch (Throwable e) {
                model = null;
                e.printStackTrace();
            }
            if (model != null) {
                SequenceCompareDifference[] things = model.getDifferenceBlocks();
                int count = things.length;
                if (count > 0) {
                    ContributorKind FIRST = ContributorKind.FIRST;
                    ContributorKind SECOND = ContributorKind.SECOND;
                    for (int i = count - 1; i >= 0; --i) {
                        SequenceCompareDifference thing = things[i];
                        int oldStart = thing.getStart(FIRST);
                        int oldLength = thing.getLength(FIRST);
                        int newStart = thing.getStart(SECOND);
                        int newLength = thing.getLength(SECOND);
                        try {
                            if (oldLength > 0) {
                                target.remove(oldStart + offset, oldLength);
                            }
                            if (newLength <= 0) continue;
                            char[] tmpData = new char[newLength];
                            System.arraycopy(data, newStart, tmpData, 0, newLength);
                            target.insert(oldStart + offset, tmpData);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return;
            }
        }
        if (length > 0) {
            target.remove(offset, length);
        }
        if (data.length > 0) {
            target.insert(offset, data);
        }
    }

    private CompareUtils() {
    }
}

