/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

final class StringReadTextBuffer
implements ReadTextBuffer {
    private String dataSource;

    StringReadTextBuffer(String dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int getLength() {
        return this.dataSource.length();
    }

    @Override
    public char getChar(int offset) throws IndexOutOfBoundsException {
        return this.dataSource.charAt(offset);
    }

    @Override
    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length");
        }
        char[] buffer = new char[length];
        if (length > 0) {
            this.dataSource.getChars(offset, offset + length, buffer, 0);
        }
        return buffer;
    }

    @Override
    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (length == 0) {
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            if (offset > this.getLength()) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            return "";
        }
        return this.dataSource.substring(offset, offset + length);
    }

    @Override
    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.getChars(offset, length);
        segment.offset = 0;
        segment.count = length;
    }

    @Override
    public void readLock() {
    }

    @Override
    public boolean tryReadLock() {
        return true;
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public int getLockStatus() {
        return -1;
    }
}

