/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.awt.EventQueue;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Version;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.util.ArrayMap;
import oracle.javatools.util.Log;

public final class ReadWriteLock {
    private static final Logger LOGGER;
    public static final int DEFAULT_WAIT_INTERVAL = 2000;
    public static final int DEFAULT_DEADLOCK_INTERVAL = 20000;
    public static final int DEFAULT_HISTORY_LIMIT;
    public static final EnumSet<Options> DEFAULT_OPTIONS;
    private final Object internalLock = new Object();
    private volatile Object name;
    private Map<Thread, ThreadState> readers = new ArrayMap<Thread, ThreadState>();
    private Thread writeThread;
    private ThreadState writeState;
    private CopyOnWriteArrayList<WriteLockRequestListener> writeRequestListeners = new CopyOnWriteArrayList();
    private final boolean collectHistory;
    private final int historyLimit;
    private final EnumSet<Options> options;
    private final boolean logUpgrades;
    private final boolean logDeadlocks;
    private final boolean logDialogs;
    private final int waitInterval;
    private final int deadlockInterval;
    private boolean deadlockReported;
    private static final int PUBLIC_LOCK_METHOD_INDEX = 2;
    private static final int DUMP_THREADS_DELTA_INDEX = 2;
    private Set<Thread> blockedThreads;
    private volatile Log eventLog;
    private static final Set<String> apiMethods;

    private void invariants() {
        if (this.blockedThreads.isEmpty()) {
            this.deadlockReported = false;
        }
    }

    public ReadWriteLock() {
        this(null);
    }

    public ReadWriteLock(String name) {
        this(name, DEFAULT_OPTIONS, 2000, 20000, DEFAULT_HISTORY_LIMIT);
    }

    public ReadWriteLock(String name, EnumSet<Options> options, int waitInterval, int deadlockInterval, int historyLimit) {
        this.setName(name);
        if (options == null) {
            options = DEFAULT_OPTIONS;
        }
        this.options = options;
        this.logDeadlocks = options.contains((Object)Options.DEADLOCKS);
        this.logDialogs = options.contains((Object)Options.DIALOGS);
        this.logUpgrades = options.contains((Object)Options.UPGRADES);
        this.collectHistory = options.contains((Object)Options.HISTORY) || options.contains((Object)Options.NESTED_HISTORY);
        this.historyLimit = options.contains((Object)Options.NESTED_HISTORY) ? historyLimit : 0;
        this.waitInterval = waitInterval;
        this.deadlockInterval = deadlockInterval;
        this.blockedThreads = new HashSet<Thread>();
    }

    public final void setName(String name) {
        this.name = name != null ? name : Integer.valueOf(System.identityHashCode(this));
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public void readLock() {
        this.readLockInternal(true);
    }

    public boolean tryReadLock() {
        return this.readLockInternal(false);
    }

    public void readUnlock() {
        this.readUnlockInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        Object object = this.internalLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (thread != this.writeThread && !this.readers.containsKey(thread)) {
                throw new IllegalMonitorStateException("no lock of " + this + " held from " + thread);
            }
            this.writeRequestListeners.add(listener);
            return !this.blockedThreads.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        Object object = this.internalLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (thread != this.writeThread && !this.readers.containsKey(thread)) {
                throw new IllegalMonitorStateException("no lock of " + this + " held from " + thread);
            }
            this.writeRequestListeners.remove(listener);
        }
    }

    public void writeLock() {
        this.writeLockInternal(true, null);
    }

    public boolean tryWriteLock() {
        return this.writeLockInternal(false, null);
    }

    public void writeUnlock() {
        this.writeUnlockInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLockFromReadLock() {
        ThreadState state;
        Thread thread = Thread.currentThread();
        int readCount = 0;
        Object object = this.internalLock;
        synchronized (object) {
            this.invariants();
            state = this.readers.get(thread);
            if (state != null && thread != this.writeThread) {
                this.logEvent(Event.READ_UNLOCK_UPGRADE);
                readCount = state.readCount;
                state.readCount = 0;
                this.readers.remove(thread);
                this.notifyBlockedThreads();
            }
            this.invariants();
        }
        this.writeLockInternal(true, state);
        if (readCount > 0) {
            object = this.internalLock;
            synchronized (object) {
                state = this.writeState;
                this.readers.put(thread, state);
                state.readCount = readCount;
                this.logEvent(Event.READ_LOCK_UPGRADE);
                this.invariants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadLockHeld() {
        Object object = this.internalLock;
        synchronized (object) {
            return this.readers.containsKey(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteLockHeld() {
        Object object = this.internalLock;
        synchronized (object) {
            return this.writeThread == Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockHeld() {
        Object object = this.internalLock;
        synchronized (object) {
            return this.isReadLockHeld() || this.isWriteLockHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadHoldCount() {
        Object object = this.internalLock;
        synchronized (object) {
            ThreadState state = this.readers.get(Thread.currentThread());
            return state != null ? state.readCount : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteHoldCount() {
        Object object = this.internalLock;
        synchronized (object) {
            return this.writeThread == Thread.currentThread() ? this.writeState.writeCount : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendSnapshot(StringBuilder buffer) {
        Object object = this.internalLock;
        synchronized (object) {
            if (this.writeThread != null) {
                this.appendThreadState(buffer, this.writeThread, false, this.writeThread.getStackTrace());
            }
            for (ThreadState state : this.readers.values()) {
                Thread thread = state.thread;
                if (thread == this.writeThread) continue;
                this.appendThreadState(buffer, thread, false, thread.getStackTrace());
            }
            for (Thread thread : this.blockedThreads) {
                if (thread == this.writeThread || this.readers.containsKey(thread)) continue;
                this.appendThreadState(buffer, thread, false, thread.getStackTrace());
            }
        }
    }

    public String toString() {
        return "lock '" + this.name + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readLockInternal(boolean block) {
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            boolean acquired;
            this.logEvent(Event.READ_LOCK_REQUEST);
            this.invariants();
            long start = 0L;
            int nominalElapsed = 0;
            while (true) {
                if (this.writeThread == null || this.writeThread == thread) {
                    ThreadState state = this.readers.get(thread);
                    if (state == null) {
                        state = thread == this.writeThread ? this.writeState : new ThreadState(thread, this.collectHistory);
                        this.readers.put(thread, state);
                    }
                    state.readCount++;
                    this.traceReadLock(state);
                    acquired = true;
                    this.logEvent(Event.READ_LOCK_GRANT);
                    break;
                }
                if (!block) {
                    acquired = false;
                    this.logEvent(Event.READ_LOCK_DENIAL);
                    break;
                }
                if (start == 0L) {
                    start = System.currentTimeMillis();
                } else {
                    this.traceDeadlock(start, nominalElapsed);
                }
                this.block(this.waitInterval);
                nominalElapsed += this.waitInterval;
            }
            this.invariants();
            return acquired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUnlockInternal() {
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            this.invariants();
            ThreadState state = this.readers.get(thread);
            if (state == null) {
                throw new IllegalMonitorStateException("read lock of " + this + " not held from " + thread);
            }
            this.traceReadUnlock(state);
            if (--state.readCount == 0) {
                this.readers.remove(thread);
                this.notifyBlockedThreads();
            }
            this.logEvent(Event.READ_UNLOCK);
            this.invariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLockInternal(boolean block, ThreadState upgrade) {
        if (block) {
            for (WriteLockRequestListener listener : this.writeRequestListeners) {
                try {
                    if (this.eventLog != null) {
                        this.eventLog.trace("WRITE_LOCK_REQUEST_NOTIFY for {0}: {1}", this, (Object)listener);
                    }
                    listener.writeRequested(this);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "unexpected exception invoked write request listener " + listener, e);
                }
            }
        }
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            boolean acquired;
            this.logEvent(Event.WRITE_LOCK_REQUEST);
            this.invariants();
            this.traceUpgrade();
            long start = 0L;
            int nominalElapsed = 0;
            while (true) {
                ThreadState state = this.readers.get(thread);
                if (this.writeThread == thread || this.writeThread == null && this.readers.isEmpty() || this.writeThread == null && state != null && this.readers.size() == 1) {
                    if (this.writeThread == null) {
                        this.writeThread = thread;
                        if (state == null) {
                            state = upgrade != null ? upgrade : new ThreadState(thread, this.collectHistory);
                        }
                        this.writeState = state;
                    }
                    this.writeState.writeCount++;
                    this.traceWriteLock(this.writeState);
                    acquired = true;
                    this.logEvent(Event.WRITE_LOCK_GRANT);
                    break;
                }
                if (!block) {
                    acquired = false;
                    this.logEvent(Event.WRITE_LOCK_DENIAL);
                    break;
                }
                if (start == 0L) {
                    start = System.currentTimeMillis();
                } else {
                    this.traceDeadlock(start, nominalElapsed);
                }
                this.block(this.waitInterval);
                nominalElapsed += this.waitInterval;
            }
            this.invariants();
            return acquired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlockInternal() {
        Thread thread = Thread.currentThread();
        Object object = this.internalLock;
        synchronized (object) {
            this.invariants();
            if (this.writeThread == null || this.writeThread != thread) {
                throw new IllegalMonitorStateException("write lock of " + this + " not held from " + thread);
            }
            this.traceWriteUnlock(this.writeState);
            if (--this.writeState.writeCount == 0) {
                this.writeThread = null;
                this.writeState = null;
                this.internalLock.notifyAll();
            }
            this.logEvent(Event.WRITE_UNLOCK);
            this.invariants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block(int interval) {
        Thread thread = Thread.currentThread();
        this.blockedThreads.add(thread);
        try {
            this.internalLock.wait(interval);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blockedThreads.remove(thread);
        }
    }

    private void notifyBlockedThreads() {
        if (this.writeThread == null && !this.blockedThreads.isEmpty()) {
            switch (this.readers.size()) {
                case 0: {
                    this.internalLock.notify();
                    break;
                }
                case 1: {
                    this.internalLock.notifyAll();
                }
            }
        }
    }

    private void traceUpgrade() {
        Thread thread;
        if (this.logUpgrades && (thread = Thread.currentThread()) != this.writeThread && this.readers.containsKey(thread)) {
            StackTraceElement element;
            String methodName;
            int depth;
            IllegalMonitorStateException exception = new IllegalMonitorStateException("lock " + this.name + " upgraded");
            StackTraceElement[] trace = exception.getStackTrace();
            for (depth = 3; depth < trace.length && ("writeLock".equals(methodName = (element = trace[depth]).getMethodName()) || apiMethods.contains(element.getClassName() + ":" + methodName)); ++depth) {
            }
            StringBuilder buffer = new StringBuilder();
            this.appendThreadState(buffer, thread, false, trace);
            LOGGER.log(Level.SEVERE, "lock upgrade; lock ''{0}'' upgraded on thread ''{1}'':{2}", new Object[]{this.name, thread.getName(), buffer, new FeedbackLogOptions((Throwable)exception, depth)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDeadlock(long start, int nominalElapsed) {
        int actualElapsed;
        int elapsed;
        if (this.logDeadlocks && !this.deadlockReported && (elapsed = Math.min(nominalElapsed, actualElapsed = (int)(System.currentTimeMillis() - start))) > this.deadlockInterval) {
            String see;
            StringBuilder buffer = new StringBuilder();
            Thread currentThread = Thread.currentThread();
            this.appendThreadState(buffer, currentThread, true, new Throwable().getStackTrace());
            for (Thread thread : this.blockedThreads) {
                if (thread == currentThread || thread == this.writeThread || this.readers.containsKey(thread)) continue;
                this.appendThreadState(buffer, thread, false, thread.getStackTrace());
            }
            boolean allThreadsRunnable = true;
            if (this.writeThread != null) {
                StackTraceElement[] trace = this.writeThread.getStackTrace();
                if (this.suppressBecauseShowingDialog(trace)) {
                    this.deadlockReported = true;
                    return;
                }
                this.appendThreadState(buffer, this.writeThread, false, trace);
                allThreadsRunnable &= this.writeThread.getState() == Thread.State.RUNNABLE;
            }
            for (ThreadState state : this.readers.values()) {
                Thread thread = state.thread;
                if (thread == currentThread || thread == this.writeThread) continue;
                StackTraceElement[] trace = thread.getStackTrace();
                if (this.suppressBecauseShowingDialog(trace)) {
                    this.deadlockReported = true;
                    return;
                }
                this.appendThreadState(buffer, thread, false, trace);
                allThreadsRunnable &= thread.getState() == Thread.State.RUNNABLE;
            }
            File file = ReadWriteLock.logFile(allThreadsRunnable);
            boolean needThreadDump = true;
            if (file != null) {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] threads = null;
                Boolean synchronizer = false;
                Method getMethod = null;
                Method lockedMonitorsMethod = null;
                Method lockedStackDepth = null;
                Method lockedSynchronizersMethod = null;
                Method deadlockedThreadsMethod = null;
                try {
                    Method monitorMethod = ThreadMXBean.class.getMethod("isObjectMonitorUsageSupported", new Class[0]);
                    Boolean monitor = (Boolean)monitorMethod.invoke((Object)bean, new Object[0]);
                    Method synchronizerMethod = ThreadMXBean.class.getMethod("isSynchronizerUsageSupported", new Class[0]);
                    synchronizer = (Boolean)synchronizerMethod.invoke((Object)bean, new Object[0]);
                    getMethod = ThreadMXBean.class.getMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                    lockedMonitorsMethod = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                    Class<?> monitorInfo = Class.forName("java.lang.management.MonitorInfo");
                    lockedStackDepth = monitorInfo.getMethod("getLockedStackDepth", new Class[0]);
                    lockedSynchronizersMethod = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                    deadlockedThreadsMethod = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                    threads = (ThreadInfo[])getMethod.invoke((Object)bean, bean.getAllThreadIds(), monitor, synchronizer);
                    needThreadDump = false;
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
                catch (ClassNotFoundException e) {
                }
                finally {
                    if (threads == null) {
                        threads = bean.getThreadInfo(bean.getAllThreadIds(), Integer.MAX_VALUE);
                    }
                }
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(file);
                    writer.print("Thread '");
                    writer.print(currentThread.getName());
                    writer.print("' blocked on lock '");
                    writer.print(this.getName());
                    writer.print("' for more than ");
                    writer.print(this.deadlockInterval);
                    writer.println("ms");
                    writer.println();
                    writer.print("Oracle ");
                    writer.print(Version.NAME_SHORT);
                    writer.print(" ");
                    writer.print(Version.VER);
                    writer.print(" ");
                    writer.print(Version.BUILD_NUM);
                    writer.print(" (");
                    writer.print(Version.BUILD_LABEL);
                    writer.println(")");
                    writer.print(System.getProperty("java.vendor"));
                    writer.print(" Java ");
                    writer.println(System.getProperty("java.runtime.version"));
                    writer.print(Runtime.getRuntime().freeMemory() / 1000000L);
                    writer.print("MB free of ");
                    writer.print(Runtime.getRuntime().maxMemory() / 1000000L);
                    writer.println("MB");
                    writer.println();
                    Diagnostics.writeBanner(writer, "Lock Dump " + this.options);
                    int i0 = 0;
                    int i1 = buffer.indexOf("\n");
                    while (i1 >= 0) {
                        writer.append(buffer, i0, i1);
                        writer.println();
                        i0 = i1 + 1;
                        i1 = buffer.indexOf("\n", i0);
                    }
                    writer.append(buffer, i0, buffer.length());
                    writer.println();
                    Diagnostics.writeBanner(writer, "Thread Dump");
                    for (ThreadInfo thread : threads) {
                        Object[] locks;
                        writer.println();
                        writer.print("\"");
                        writer.print(thread.getThreadName());
                        writer.print("\" id=");
                        writer.print(thread.getThreadId());
                        writer.print(" ");
                        writer.print((Object)thread.getThreadState());
                        String lockName = thread.getLockName();
                        if (lockName != null) {
                            writer.print(" on ");
                            writer.print(lockName);
                        }
                        if (thread.getLockOwnerName() != null) {
                            writer.print(" owned by \"");
                            writer.print(thread.getLockOwnerName());
                            writer.print("\" id=");
                            writer.print(thread.getLockOwnerId());
                        }
                        if (thread.isSuspended()) {
                            writer.print(" (suspended)");
                        }
                        if (thread.isInNative()) {
                            writer.print(" (in native)");
                        }
                        writer.println();
                        StackTraceElement[] stackTrace = thread.getStackTrace();
                        for (int i = 0; i < stackTrace.length; ++i) {
                            writer.print("\tat ");
                            writer.println(stackTrace[i]);
                            if (i == 0 && lockName != null) {
                                Thread.State ts = thread.getThreadState();
                                switch (ts) {
                                    case BLOCKED: {
                                        writer.print("\t-  blocked on ");
                                        writer.println(lockName);
                                        break;
                                    }
                                    case WAITING: {
                                        writer.print("\t-  waiting on ");
                                        writer.println(lockName);
                                        break;
                                    }
                                    case TIMED_WAITING: {
                                        writer.print("\t-  waiting on ");
                                        writer.println(lockName);
                                        break;
                                    }
                                }
                            }
                            if (lockedMonitorsMethod == null) continue;
                            try {
                                for (Object monitor : (Object[])lockedMonitorsMethod.invoke((Object)thread, new Object[0])) {
                                    if ((Integer)lockedStackDepth.invoke(monitor, new Object[0]) != i) continue;
                                    writer.print("\t-  locked ");
                                    writer.println(monitor);
                                }
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                continue;
                            }
                            catch (InvocationTargetException e) {
                                // empty catch block
                            }
                        }
                        if (lockedSynchronizersMethod == null || (locks = (Object[])lockedSynchronizersMethod.invoke((Object)thread, new Object[0])).length <= 0) continue;
                        writer.println();
                        writer.println("\tLocked synchronizers:");
                        for (Object lock : locks) {
                            writer.println("\t- ");
                            writer.println(lock);
                        }
                    }
                    writer.println();
                    long[] ids = synchronizer != false && deadlockedThreadsMethod != null ? (long[])deadlockedThreadsMethod.invoke((Object)bean, new Object[0]) : bean.findMonitorDeadlockedThreads();
                    if (ids != null) {
                        ThreadInfo[] deadlockedThreads = getMethod != null ? (ThreadInfo[])getMethod.invoke((Object)ids, true, true) : bean.getThreadInfo(ids);
                        if (deadlockedThreads != null) {
                            writer.println("Found deadlock:");
                            for (ThreadInfo thread : deadlockedThreads) {
                                writer.print("\t\"");
                                writer.print(thread.getThreadName());
                                writer.print("\" id=");
                                writer.print(thread.getThreadId());
                                writer.print(" ");
                                writer.print((Object)thread.getThreadState());
                                String lockName = thread.getLockName();
                                if (lockName != null) {
                                    writer.print(" on ");
                                    writer.print(lockName);
                                }
                                if (thread.getLockOwnerName() != null) {
                                    writer.print(" owned by \"");
                                    writer.print(thread.getLockOwnerName());
                                    writer.print("\" id=");
                                    writer.print(thread.getLockOwnerId());
                                }
                                if (thread.isSuspended()) {
                                    writer.print(" (suspended)");
                                }
                                if (thread.isInNative()) {
                                    writer.print(" (in native)");
                                }
                                writer.println();
                            }
                        }
                        writer.println();
                    }
                    Diagnostics.writeBanner(writer, "System Configuration");
                    writer.println();
                    for (Map.Entry<Object, Object> entry : new ArrayList<Map.Entry<Object, Object>>(System.getProperties().entrySet())) {
                        writer.print(entry.getKey());
                        writer.print("=");
                        writer.println(entry.getValue());
                    }
                }
                catch (Throwable e) {
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                see = "See full log at \"" + file.getAbsolutePath() + "\"\n";
                if (needThreadDump) {
                    see = see + "[To file bug, also include thread dump if possible.]\n";
                }
            } else {
                see = "";
            }
            LOGGER.log(Level.SEVERE, "lock {0}; thread ''{1}'' blocked on lock ''{2}'' for more than {3}ms:\n{4}\n{5}\n", new Object[]{allThreadsRunnable ? "starvation" : "deadlock", currentThread.getName(), this.name, this.deadlockInterval, buffer, see});
            this.deadlockReported = true;
        }
    }

    private static File logFile(boolean allThreadsRunnable) {
        return Diagnostics.newFile(allThreadsRunnable ? "STARVATION" : "DEADLOCK", String.valueOf(Thread.currentThread().getId()));
    }

    private boolean suppressBecauseShowingDialog(StackTraceElement[] trace) {
        if (this.logDialogs) {
            return false;
        }
        if (trace.length == 0) {
            return false;
        }
        for (StackTraceElement element : trace) {
            if (!"java.awt.Dialog".equals(element.getClassName()) || !"show".equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    private void traceReadLock(ThreadState state) {
        if (state.historySize++ < this.historyLimit || this.collectHistory && state.readCount == 1) {
            state.history.add(new Throwable("readLock"));
        }
    }

    private void traceReadUnlock(ThreadState state) {
        if (state.historySize++ < this.historyLimit || this.collectHistory && state.readCount == 1) {
            state.history.add(new Throwable("readUnlock"));
        }
    }

    private void traceWriteLock(ThreadState state) {
        if (state.historySize++ < this.historyLimit || this.collectHistory && state.writeCount == 1) {
            state.history.add(new Throwable("writeLock"));
        }
    }

    private void traceWriteUnlock(ThreadState state) {
        if (state.historySize++ < this.historyLimit || this.collectHistory && state.writeCount == 1) {
            state.history.add(new Throwable("writeUnlock"));
        }
    }

    private void appendThreadState(StringBuilder buffer, Thread thread, boolean blocked, StackTraceElement[] currentTrace) {
        ThreadState state = this.readers.get(thread);
        if (thread == this.writeThread) {
            state = this.writeState;
        }
        int readCount = 0;
        int writeCount = 0;
        ArrayList<StackTraceElement[]> unpairedCalls = new ArrayList<StackTraceElement[]>();
        int methodPairs = 0;
        int classPairs = 0;
        int discardedSize = 0;
        if (state != null) {
            readCount = state.readCount;
            writeCount = state.writeCount;
            if (state.history != null && !state.history.isEmpty()) {
                discardedSize = state.historySize - state.history.size();
                List history = state.history;
                for (Throwable call : history) {
                    StackTraceElement[] thisTrace = call.getStackTrace();
                    if (unpairedCalls.isEmpty()) {
                        unpairedCalls.add(thisTrace);
                        continue;
                    }
                    String thisType = thisTrace[2].getMethodName();
                    if (thisType.endsWith("Lock")) {
                        unpairedCalls.add(thisTrace);
                        continue;
                    }
                    StackTraceElement[] lastTrace = (StackTraceElement[])unpairedCalls.get(unpairedCalls.size() - 1);
                    String lastType = lastTrace[2].getMethodName();
                    if (!lastType.regionMatches(0, thisType, 0, 4)) continue;
                    StackTraceElement thisCaller = thisTrace[3];
                    StackTraceElement lastCaller = lastTrace[3];
                    if (thisCaller.getClassName().equals(lastCaller.getClassName())) {
                        unpairedCalls.remove(unpairedCalls.size() - 1);
                        if (thisCaller.getMethodName().equals(lastCaller.getMethodName())) {
                            ++methodPairs;
                            continue;
                        }
                        ++classPairs;
                        continue;
                    }
                    unpairedCalls.add(thisTrace);
                }
            }
        }
        buffer.append("\n\"");
        buffer.append(thread.getName());
        buffer.append("\" id=");
        buffer.append(thread.getId());
        buffer.append(", ");
        if (blocked || this.blockedThreads.contains(thread)) {
            buffer.append("blocked, ");
        }
        this.appendCounted(buffer, readCount, " read", ", ");
        this.appendCounted(buffer, writeCount, " write", "");
        if (this.collectHistory) {
            int pairedSize = 2 * classPairs + 2 * methodPairs;
            int unpairedSize = unpairedCalls.size();
            int calls = unpairedSize + pairedSize;
            if (calls > 0) {
                buffer.append(", ");
                if (pairedSize == 0 && discardedSize == 0) {
                    this.appendCounted(buffer, unpairedSize, " unpaired history trace", "");
                } else {
                    this.appendCounted(buffer, calls, " history trace", "");
                    if (discardedSize > 0) {
                        buffer.append(" (");
                        buffer.append(discardedSize);
                        buffer.append(" discarded)");
                    }
                    buffer.append(", ");
                    if (unpairedSize == 0) {
                        buffer.append("none");
                    } else {
                        buffer.append(unpairedSize);
                    }
                    buffer.append(" unpaired");
                }
            }
        } else {
            buffer.append(", no history collected");
        }
        buffer.append(":\n");
        this.appendStackTrace(buffer, currentTrace);
        int count = 0;
        for (StackTraceElement[] trace : unpairedCalls) {
            buffer.append("\nUnpaired history trace ");
            buffer.append(++count);
            buffer.append(" for \"");
            buffer.append(thread.getName());
            buffer.append("\"\n");
            this.appendStackTrace(buffer, trace);
        }
    }

    private void appendStackTrace(StringBuilder buffer, StackTraceElement[] trace) {
        if (trace == null || trace.length == 0) {
            buffer.append("\t[No trace available]\n");
            return;
        }
        int i = 0;
        String type = trace[0].getClassName();
        String method = trace[0].getMethodName();
        if (type.equals("oracle.javatools.buffer.ReadWriteLock") && method.startsWith("trace")) {
            i = 2;
        } else if (type.equals("java.lang.Thread") && method.equals("dumpThreads")) {
            i = 2;
        }
        while (i < trace.length) {
            buffer.append("\tat ");
            buffer.append(trace[i]);
            buffer.append('\n');
            ++i;
        }
    }

    private void appendCounted(StringBuilder buffer, int count, String head, String tail) {
        if (count == 0) {
            buffer.append("no");
        } else {
            buffer.append(count);
        }
        buffer.append(head);
        if (count == 0 || count > 1) {
            buffer.append('s');
        }
        buffer.append(tail);
    }

    private static EnumSet<Options> parseOptions(String text) {
        EnumSet<Options> options;
        if (text != null) {
            options = EnumSet.noneOf(Options.class);
            for (String token : text.split(",")) {
                String option = token.trim().toUpperCase();
                if ("".equals(option)) continue;
                try {
                    options.add(Options.valueOf(option));
                }
                catch (Exception e) {
                    if ("ALL".equals(option)) {
                        options = EnumSet.allOf(Options.class);
                        continue;
                    }
                    if ("NONE".equals(option)) {
                        options = EnumSet.noneOf(Options.class);
                        continue;
                    }
                    if ("TRUE".equals(option)) {
                        options = EnumSet.allOf(Options.class);
                        continue;
                    }
                    StringBuilder expectedOptions = new StringBuilder();
                    for (Options constant : (Options[])Options.class.getEnumConstants()) {
                        expectedOptions.append("'");
                        expectedOptions.append(constant.toString().toLowerCase());
                        expectedOptions.append("', ");
                    }
                    expectedOptions.append("or 'all'");
                    LOGGER.log(Level.WARNING, "option ''{0}'' from property \"oracle.javatools.lock\" not recognized: expected {1}", new Object[]{token.trim(), expectedOptions});
                }
            }
            for (Options option : options) {
                switch (option) {
                    case DEADLOCKS: {
                        LOGGER.log(Level.CONFIG, "deadlock logging enabled");
                        break;
                    }
                    case UPGRADES: {
                        LOGGER.log(Level.CONFIG, "upgrade logging enabled");
                        break;
                    }
                    case HISTORY: {
                        LOGGER.log(Level.CONFIG, "history logging enabled");
                    }
                }
            }
        } else {
            options = EnumSet.allOf(Options.class);
        }
        return options;
    }

    public void setEventLog(Log log) {
        if (log == this.eventLog) {
            return;
        }
        if (this.eventLog != null) {
            this.eventLog.trace("stop logging lock events for {0}", this);
        }
        if (log != null && log.isEnabled()) {
            StringBuilder buffer = new StringBuilder();
            this.appendSummaryThreadState(buffer, this.writeState);
            for (ThreadState state : this.readers.values()) {
                if (state == this.writeState) continue;
                this.appendSummaryThreadState(buffer, state);
            }
            if (buffer.length() == 0) {
                buffer.append(", no locked threads");
            }
            log.trace("start logging lock events for {0}{1}", this, (Object)buffer);
            this.eventLog = log;
        } else {
            this.eventLog = null;
        }
    }

    private void logEvent(Event event) {
        if (this.eventLog == null) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        switch (event) {
            case READ_LOCK_REQUEST: {
                if (this.writeThread == currentThread) {
                    return;
                }
                if (this.readers.containsKey(currentThread)) {
                    return;
                }
                if (!EventQueue.isDispatchThread()) break;
                return;
            }
            case READ_LOCK_GRANT: {
                if (this.writeThread == currentThread) {
                    return;
                }
                if (this.readers.get(currentThread).readCount > 1) {
                    return;
                }
                if (!EventQueue.isDispatchThread()) break;
                return;
            }
            case READ_LOCK_DENIAL: {
                break;
            }
            case READ_UNLOCK: {
                if (this.writeThread == currentThread) {
                    return;
                }
                if (this.readers.containsKey(currentThread)) {
                    return;
                }
                if (!EventQueue.isDispatchThread()) break;
                return;
            }
            case WRITE_LOCK_REQUEST: {
                if (this.writeThread != currentThread) break;
                return;
            }
            case WRITE_LOCK_GRANT: {
                if (this.writeState.writeCount <= 1) break;
                return;
            }
            case WRITE_LOCK_DENIAL: {
                break;
            }
            case WRITE_UNLOCK: {
                if (this.writeThread == null) break;
                return;
            }
            case READ_LOCK_UPGRADE: {
                break;
            }
        }
        StringBuilder buffer = new StringBuilder();
        this.appendSummaryThreadState(buffer, currentThread);
        this.eventLog.trace("{0} for {1}{2}", (Object)event, (Object)this, (Object)buffer);
    }

    private void appendSummaryThreadState(StringBuilder buffer, Thread currentThread) {
        ThreadState currentState = null;
        if (currentThread != null) {
            currentState = currentThread == this.writeThread ? this.writeState : this.readers.get(currentThread);
            buffer.append("; ");
            if (currentState != null) {
                if (this.blockedThreads.contains(currentState.thread)) {
                    buffer.append("blocked, ");
                }
                this.appendCounted(buffer, currentState.readCount, " read", ", ");
                this.appendCounted(buffer, currentState.writeCount, " write", "");
            } else {
                buffer.append("no reads, no writes");
            }
        }
        boolean other = false;
        if (this.writeState != null && this.writeState != currentState) {
            other = true;
            buffer.append("; other locked threads:");
            this.appendSummaryThreadState(buffer, this.writeState);
        }
        for (ThreadState state : this.readers.values()) {
            if (state == currentState || state == this.writeState) continue;
            if (!other) {
                buffer.append("; other locked threads:");
                other = true;
            }
            this.appendSummaryThreadState(buffer, state);
        }
    }

    private void appendSummaryThreadState(StringBuilder buffer, ThreadState state) {
        if (state == null) {
            return;
        }
        buffer.append("\n                                                        ");
        buffer.append(state.thread);
        buffer.append(": ");
        if (this.blockedThreads.contains(state.thread)) {
            buffer.append("blocked, ");
        }
        this.appendCounted(buffer, state.readCount, " read", ", ");
        this.appendCounted(buffer, state.writeCount, " write", "");
    }

    public static void registerApiMethod(String className, String methodName) {
        apiMethods.add(className + ":" + methodName);
    }

    static {
        int limit;
        LOGGER = Logger.getLogger("oracle.javatools.lock");
        String value = System.getProperty("oracle.javatools.lock.history.limit");
        if (value != null) {
            try {
                limit = Integer.parseInt(value);
                if (limit <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                limit = 100;
                LOGGER.log(Level.WARNING, "Value ''{0}'' of property \"oracle.javatools.lock.history.limit\" not valid: expected positive integer", new Object[]{value});
            }
        } else {
            limit = 100;
        }
        DEFAULT_HISTORY_LIMIT = limit;
        String text = System.getProperty("oracle.javatools.lock");
        DEFAULT_OPTIONS = text != null ? ReadWriteLock.parseOptions(text) : (Version.DEBUG_BUILD == 0 ? EnumSet.of(Options.DEADLOCKS, Options.UPGRADES) : EnumSet.of(Options.DEADLOCKS, Options.UPGRADES, Options.HISTORY, Options.NESTED_HISTORY));
        apiMethods = Collections.synchronizedSet(new HashSet());
    }

    private static enum Event {
        READ_LOCK_REQUEST,
        READ_LOCK_GRANT,
        READ_LOCK_DENIAL,
        READ_UNLOCK,
        WRITE_LOCK_REQUEST,
        WRITE_LOCK_GRANT,
        WRITE_LOCK_DENIAL,
        WRITE_UNLOCK,
        READ_LOCK_UPGRADE,
        READ_UNLOCK_UPGRADE;

    }

    private static class ThreadState {
        private Thread thread;
        private int readCount;
        private int writeCount;
        private List<Throwable> history;
        private int historySize;

        public ThreadState(Thread thread, boolean collectHistory) {
            this.thread = thread;
            if (collectHistory) {
                this.history = new ArrayList<Throwable>();
            }
        }
    }

    public static enum Options {
        DEADLOCKS,
        UPGRADES,
        HISTORY,
        NESTED_HISTORY,
        DIALOGS;

    }
}

