/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.util.EncodingsData;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.UtilArb;
import sun.io.ByteToCharConverter;

public final class Encodings {
    public static final String UTF8_ENCODING = "UTF-8";
    private static final String LOADED_KEY = "encodings-loaded";
    private static File _encodingsFile;
    private static String[] _encodings;
    private static String _defaultEncoding;
    private static EncodingsData _data;

    private Encodings() {
    }

    public static void setEncodingsFile(File encodingsFile) {
        _encodingsFile = encodingsFile;
    }

    public static boolean isSupported(String encoding) {
        boolean supported = false;
        try {
            supported = Charset.isSupported(encoding);
            if (!supported) {
                String s = new String(new byte[0], encoding);
                supported = true;
            }
        }
        catch (IllegalCharsetNameException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return supported;
    }

    public static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            InputStreamReader isr = new InputStreamReader(System.in);
            _defaultEncoding = isr.getEncoding().intern();
        }
        return _defaultEncoding;
    }

    public static String getDefaultIanaEncoding() {
        if (Encodings.isDefaultCp1252()) {
            return "windows-1252";
        }
        return Encodings.convertJdk2IanaEncoding(Encodings.getDefaultEncoding());
    }

    public static String convertJdk2IanaEncoding(String jdkEncoding) {
        if (jdkEncoding == null) {
            return null;
        }
        EncodingsData data = Encodings.getEncodingsData();
        String ianaName = (String)data.getJdk2IanaMap().get(jdkEncoding.toUpperCase());
        if (ianaName == null) {
            ianaName = jdkEncoding;
            try {
                Charset cs = Charset.forName(jdkEncoding);
                if (cs != null) {
                    ianaName = cs.name();
                }
            }
            catch (IllegalCharsetNameException e) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return ianaName;
    }

    public static synchronized String[] getEncodings() {
        Encodings.ensureInit();
        return (String[])_encodings.clone();
    }

    public static boolean isDefaultCp1252() {
        return "Cp1252".equalsIgnoreCase(Encodings.getDefaultEncoding());
    }

    public static void initComboBox(final JComboBox comboBox, final boolean addDefaultItem, String selectedEncoding) {
        String curEncoding;
        String string = curEncoding = selectedEncoding == null ? Encodings.getDefaultEncoding() : selectedEncoding;
        if (_encodings == null) {
            comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{curEncoding}));
            comboBox.setSelectedItem(curEncoding);
            comboBox.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (!Boolean.TRUE.equals(comboBox.getClientProperty(Encodings.LOADED_KEY))) {
                        comboBox.removeAllItems();
                        comboBox.addItem(UtilArb.getString(0));
                        comboBox.setSelectedIndex(0);
                        comboBox.removePopupMenuListener(this);
                        Encodings.loadEncodings(comboBox, addDefaultItem, curEncoding);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        } else {
            Encodings.populateComboBox(comboBox, addDefaultItem, curEncoding);
        }
    }

    public static void loadEncodings(final JComboBox comboBox, final boolean addDefaultItem, final String selectedEncoding) {
        if (comboBox == null) {
            return;
        }
        if (Boolean.TRUE.equals(comboBox.getClientProperty(LOADED_KEY))) {
            comboBox.setSelectedItem(selectedEncoding);
            return;
        }
        SwingWorker worker = new SwingWorker(){
            private String[] _encodings;

            @Override
            public Object construct() {
                this._encodings = Encodings.getEncodings();
                return this._encodings;
            }

            @Override
            public void finished() {
                if (this._encodings != null) {
                    Encodings.populateComboBox(comboBox, addDefaultItem, selectedEncoding);
                }
            }
        };
        worker.start();
    }

    private static void populateComboBox(JComboBox comboBox, boolean addDefaultItem, String selectedEncoding) {
        EncodingsComboBoxModel model = new EncodingsComboBoxModel(_encodings, addDefaultItem);
        comboBox.setModel(model);
        comboBox.putClientProperty(LOADED_KEY, Boolean.TRUE);
        int idx = 0;
        idx = selectedEncoding != null ? model.indexOf(selectedEncoding) : (addDefaultItem ? 0 : model.indexOf(Encodings.getDefaultEncoding()));
        comboBox.setSelectedIndex(idx);
    }

    private static synchronized void ensureInit() {
        if (_encodings == null) {
            SortedMap<String, Charset> encMap = Charset.availableCharsets();
            TreeSet<String> encodings = new TreeSet<String>(new CharsetComparator());
            for (Charset ch : encMap.values()) {
                String chName = ch.name();
                if (chName.length() >= "X-ORACLE-".length() && "X-ORACLE-".equalsIgnoreCase(chName.substring(0, "X-ORACLE-".length()))) continue;
                encodings.add(ch.name());
                Set<String> aliases = ch.aliases();
                encodings.addAll(aliases);
            }
            String defaultEncoding = Encodings.getDefaultEncoding();
            if (encodings.contains(defaultEncoding)) {
                encodings.remove(defaultEncoding);
            }
            encodings.add(defaultEncoding);
            EncodingsData data = Encodings.getEncodingsData();
            for (String key : data.getEncodingsList()) {
                if (encodings.contains(key)) continue;
                try {
                    ByteToCharConverter conv = ByteToCharConverter.getConverter((String)key);
                    encodings.add(key);
                }
                catch (UnsupportedEncodingException e) {}
            }
            _encodings = encodings.toArray(new String[encodings.size()]);
        }
    }

    private static synchronized EncodingsData getEncodingsData() {
        if (_data == null) {
            if (_encodingsFile != null) {
                try {
                    _data = new EncodingsData(_encodingsFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (_data == null) {
                _data = new EncodingsData();
            }
        }
        return _data;
    }

    private static class EncodingsComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private static final String DEF = "Default";
        private int _selection;
        private ArrayList _names;
        private Map _nameMap;

        private EncodingsComboBoxModel(String[] _encodings, boolean addDefault) {
            this._names = new ArrayList(addDefault ? _encodings.length + 1 : _encodings.length);
            this._nameMap = new HashMap();
            int startPos = 0;
            if (addDefault) {
                this._addElement(DEF, startPos++);
            }
            for (int i = 0; i < _encodings.length; ++i) {
                String val = _encodings[i];
                this._addElement(val, startPos++);
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            String val;
            String key;
            int newSel;
            if (anItem != null && (newSel = this._names.indexOf(key = (val = anItem.toString()).toUpperCase())) != this._selection) {
                this._selection = newSel;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.getElementAt(this._selection);
        }

        @Override
        public int getSize() {
            return this._names.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index == -1) {
                return null;
            }
            String key = this._names.get(index).toString();
            return this._nameMap.get(key);
        }

        private int indexOf(Object enc) {
            if (enc == null) {
                return -1;
            }
            return this._names.indexOf(enc.toString().toUpperCase());
        }

        private void _addElement(String element, int idx) {
            String key = element.toUpperCase();
            this._names.add(idx, key);
            this._nameMap.put(key, element);
        }

        public void addElement(Object obj) {
            this.insertElementAt(obj, this.getSize());
        }

        private void _remove(int idx) {
            if (idx == this._selection) {
                this._selection = idx == 0 ? (this.getSize() == 1 ? -1 : 0) : idx - 1;
                this.fireContentsChanged(this, -1, -1);
            }
            this._names.remove(idx);
            this.fireIntervalRemoved(this, idx, idx);
        }

        @Override
        public void removeElement(Object obj) {
            String val = obj.toString();
            String key = val.toUpperCase();
            if ((val = (String)this._nameMap.get(key)) != null) {
                this._nameMap.remove(key);
                int idx = this._names.indexOf(val);
                this._remove(idx);
            }
        }

        public void insertElementAt(Object obj, int idx) {
            String val = obj.toString();
            if (!this._nameMap.containsKey(val.toUpperCase())) {
                this._addElement(val, idx);
                this.fireIntervalAdded(this, idx, idx);
            }
        }

        @Override
        public void removeElementAt(int index) {
            String val = (String)this._names.get(index);
            String key = val.toUpperCase();
            this._nameMap.remove(key);
            this._remove(index);
        }
    }

    private static class CharsetComparator
    implements Comparator {
        private CharsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareToIgnoreCase(s2);
        }
    }
}

