/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.EventObject;

public class URLFileSystemEvent
extends EventObject {
    public static final int FILE_ADDED = 1;
    public static final int FILE_CHANGED = 2;
    public static final int FILE_REMOVED = 3;
    public static final int FILE_RENAMED = 4;
    public static final int DIRECTORY_ADDED = 10;
    public static final int DIRECTORY_REMOVED = 11;
    public static final int DIRECTORY_RENAMED = 12;
    public static final int READ_ONLY_CHANGED = 13;
    private URL[] _rootURLs;
    private URL _changeURL;
    private URL _oldURL;
    private int _eventType;

    public static boolean isValidEventType(int eventType) {
        switch (eventType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public URL[] getRootURLs() {
        return this._rootURLs;
    }

    public URL getURL() {
        return this._changeURL;
    }

    public URL getNewURL() {
        return this.getURL();
    }

    public URL getOldURL() {
        return this._oldURL;
    }

    public int getEventType() {
        return this._eventType;
    }

    public URLFileSystemEvent(URL[] rootURLs, URL affectedURL, int eventType) {
        this(rootURLs, affectedURL, null, eventType);
    }

    public URLFileSystemEvent(URL[] rootURLs, URL newURL, URL oldURL, int eventType) {
        super(rootURLs);
        this._rootURLs = rootURLs;
        this._changeURL = newURL;
        this._oldURL = oldURL;
        this._eventType = eventType;
        if (oldURL == null ? URLFileSystemEvent.isRenameEvent(eventType) : !URLFileSystemEvent.isRenameEvent(eventType)) {
            // empty if block
        }
    }

    private static boolean isRenameEvent(int eventType) {
        return eventType == 12 || eventType == 4;
    }

    protected String getEventTypeString() {
        return URLFileSystemEvent.getEventTypeString(this.getEventType());
    }

    protected static String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "FILE_ADDED";
            }
            case 2: {
                return "FILE_CHANGED";
            }
            case 3: {
                return "FILE_REMOVED";
            }
            case 4: {
                return "FILE_RENAMED";
            }
            case 10: {
                return "DIRECTORY_ADDED";
            }
            case 11: {
                return "DIRECTORY_REMOVED";
            }
            case 12: {
                return "DIRECTORY_RENAMED";
            }
            case 13: {
                return "READ_ONLY_CHANGED";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public String toString() {
        URL[] roots = this.getRootURLs();
        StringBuffer rootBuffer = new StringBuffer();
        int numRoots = roots.length;
        String separator = "";
        for (int i = 0; i < numRoots; ++i) {
            rootBuffer.append(separator);
            separator = ", ";
            rootBuffer.append(roots[i]);
        }
        if (URLFileSystemEvent.isRenameEvent(this._eventType)) {
            return "roots: " + rootBuffer.toString() + ", old url: " + this.getOldURL() + ", new url: " + this.getNewURL() + ", event: " + this.getEventTypeString();
        }
        return "roots: " + rootBuffer.toString() + ", url: " + this.getURL() + ", event: " + this.getEventTypeString();
    }
}

