/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public final class JarUtil {
    static final String JAR_URL_SEPARATOR = "!/";
    static final String FILE_PROTOCOL_PREFIX = "file:";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final Logger logger = Logger.getLogger(JarUtil.class.getName());

    private JarUtil() {
    }

    public static String getJarEntry(URL jarURL) {
        String urlPathStr;
        int bangPos;
        if (JarUtil.isJarURL(jarURL) && (bangPos = (urlPathStr = jarURL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            return urlPathStr.substring(bangPos + 2);
        }
        return null;
    }

    public static URL getJarFileURL(URL jarURL) {
        if (JarUtil.isJarURL(jarURL)) {
            try {
                String urlPathStr = jarURL.getPath();
                int bangSlashPos = urlPathStr.indexOf(JAR_URL_SEPARATOR);
                if (bangSlashPos >= 0) {
                    String resultStr = urlPathStr.substring(0, bangSlashPos);
                    return JarUtil.checkAndCreateNewJarFileURL(resultStr);
                }
                if (urlPathStr.endsWith("!")) {
                    String resultStr = urlPathStr.substring(0, urlPathStr.length() - 1);
                    return JarUtil.checkAndCreateNewJarFileURL(resultStr);
                }
                return JarUtil.checkAndCreateNewJarFileURL(urlPathStr);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid JAR URL: " + jarURL, e);
            }
        }
        return jarURL;
    }

    public static Manifest getManifest(URL jarURL) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static Manifest getManifest(File jarFile) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getMainClass(File jarFile) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getMainClass(URL jarURL) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static String getClassPath(File jarFile) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getClassPath(URL jarURL) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static boolean isJarURL(URL jarURL) {
        return jarURL != null ? jarURL.getProtocol().equals("jar") || jarURL.getProtocol().equals("wsjar") : false;
    }

    public static JarIndex getJarIndex(URL jarURL) throws IOException {
        return JarIndex.getInstance(JarUtil.getJarFileURL(jarURL));
    }

    @Deprecated
    public static JarIndex getJarIndex(URL jarURL, boolean full) throws IOException {
        return JarUtil.getJarIndex(jarURL);
    }

    public static void releaseJarIndex(URL jarURL) {
        JarIndex.uncache(JarUtil.getJarFileURL(jarURL));
    }

    public static boolean isArchive(String pathname) {
        int offset = pathname.length() - 4;
        return pathname.regionMatches(true, offset, ".jar", 0, 4) || pathname.regionMatches(true, offset, ".zip", 0, 4);
    }

    private static URL getManifestFileURL(File jarFile) {
        return URLFactory.newJarURL(jarFile, MANIFEST_FILE);
    }

    private static URL getManifestFileURL(URL jarURL) {
        return URLFactory.newJarURL(jarURL, MANIFEST_FILE);
    }

    private static String getMainClassImpl(URL manifestFileURL) throws IOException {
        return JarUtil.getManifestMainAttribute(manifestFileURL, true);
    }

    private static String getClassPathImpl(URL manifestFileURL) throws IOException {
        return JarUtil.getManifestMainAttribute(manifestFileURL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifestImpl(URL manifestFileURL) throws IOException {
        InputStream manifestIn = null;
        try {
            manifestIn = URLFileSystem.openInputStream(manifestFileURL);
            Manifest manifest = new Manifest(manifestIn);
            return manifest;
        }
        finally {
            if (manifestIn != null) {
                try {
                    manifestIn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getManifestMainAttribute(URL manifestFileURL, boolean getMainClass) throws IOException {
        return JarUtil.getJarIndex(manifestFileURL).getManifestMainAttribute(getMainClass);
    }

    static URL newJarFileURLImpl(String urlStr) {
        try {
            return JarUtil.checkAndCreateNewJarFileURL(urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static URL checkAndCreateNewJarFileURL(String urlStr) throws MalformedURLException {
        if (urlStr.indexOf(":") == -1) {
            logger.warning("Missing protocol prefix in JAR url: " + urlStr + ". The prefix " + FILE_PROTOCOL_PREFIX + " has been added to the URL.");
            urlStr = FILE_PROTOCOL_PREFIX + urlStr;
        }
        return new URL(urlStr);
    }
}

