/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import oracle.ide.Version;
import oracle.ide.net.AlikeStrings;
import oracle.ide.net.InflaterInputStream;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.util.Maps;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class JarIndex {
    private static long TIMESTAMP_INTERVAL = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private static final String JAR_CHARSETNAME = "UTF8";
    private static final boolean CACHE_ENABLED = !Boolean.getBoolean("ide.jar.nocache");
    private static final Map<URL, JarIndex> _cache = CACHE_ENABLED ? new Maps.CacheMap(Maps.CacheMap.SOFT) : null;
    private static final boolean FILE_CACHE_ENABLED = PlatformUtils.isWindows() && !Boolean.getBoolean("ide.jar.nofilecache");
    private static final IdentityHashMap<JarIndex, JarIndex> _fileCache = new IdentityHashMap();
    private static final int FILE_CACHE_TIMEOUT = 5000;
    private static final int FILE_CACHE_INITIAL_DELAY = 15000;
    private static final long IO_WARNING_THRESHOLD;
    private static final int IO_MOVING_AVERAGE_SIZE = 5;
    private static final EnumSet<TaskOptions> FULL_INDEX;
    private final URL _jarFileURL;
    private volatile long _timestamp = -1L;
    private int[] _offsets;
    private int[] _cSizes;
    private int[] _ucSizes;
    private int[] _dostimes;
    private int[] _table;
    private int[] _tableData;
    private int _tableLen;
    private boolean _pathlessFiles;
    private AlikeStrings _entryNamesPool;
    private long _lastTimestampCheck = -1L;
    private long[] _durations = new long[5];
    private int _nDuration;
    private boolean _alreadyWarned;
    private URLTempFile _tempFile;
    private boolean _invalid;
    private RandomAccessFile _fileHandle;
    private String[] _manifestAttributes;
    private String lastEntryName;
    private int lastIndex;

    private JarIndex(URL jarFileURL) {
        this._jarFileURL = jarFileURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarIndex getInstance(URL jarFileURL) {
        if (!CACHE_ENABLED) {
            return new JarIndex(jarFileURL);
        }
        Map<URL, JarIndex> map = _cache;
        synchronized (map) {
            JarIndex instance = _cache.get(jarFileURL);
            if (instance == null) {
                instance = new JarIndex(jarFileURL);
                _cache.put(jarFileURL, instance);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncache(URL jarFileURL) {
        Map<URL, JarIndex> map = _cache;
        synchronized (map) {
            _cache.remove(jarFileURL);
        }
    }

    public void visit(final Visitor visitor) throws IOException {
        this.run(FULL_INDEX, new JarIndexTask<Void>(){

            @Override
            public Void run(RandomAccessFile jar) {
                JarIndexEntry entry;
                for (int i = 0; i < JarIndex.this._cSizes.length && visitor.visit(entry = new JarIndexEntry(JarIndex.this._entryNamesPool.getStringFromIndex(i), JarIndex.this._cSizes[i], JarIndex.this._ucSizes[i], JarIndex.this._dostimes[i])); ++i) {
                }
                return null;
            }
        });
    }

    public boolean isEmpty() {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Boolean>(){

                @Override
                public Boolean run(RandomAccessFile jar) throws IOException {
                    return JarIndex.this._offsets.length == 0;
                }
            });
        }
        catch (IOException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int dirEntryIndex(final String entryName) {
        JarIndex jarIndex = this;
        synchronized (jarIndex) {
            if (entryName.equals(this.lastEntryName)) {
                return this.lastIndex;
            }
        }
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Integer>(){

                @Override
                public Integer run(RandomAccessFile jar) throws IOException {
                    JarIndex.this.lastEntryName = entryName;
                    JarIndex.this.lastIndex = JarIndex.this.dirEntryIndexImpl(entryName.endsWith("/") ? entryName : entryName + "/");
                    return JarIndex.this.lastIndex;
                }
            });
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Deprecated
    public int entryIndex(final String entryName) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Integer>(){

                @Override
                public Integer run(RandomAccessFile jar) throws IOException {
                    if (entryName.endsWith("/")) {
                        return JarIndex.this.dirEntryIndexImpl(entryName);
                    }
                    return JarIndex.this._entryNamesPool.binarySearch(entryName);
                }
            });
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Deprecated
    public int getNumEntries() {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Integer>(){

                @Override
                public Integer run(RandomAccessFile jar) throws IOException {
                    return JarIndex.this._offsets.length;
                }
            });
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Deprecated
    public JarIndexEntry getEntryAt(final int i) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<JarIndexEntry>(){

                @Override
                public JarIndexEntry run(RandomAccessFile jar) throws IOException {
                    return new JarIndexEntry(JarIndex.this._entryNamesPool.getStringFromIndex(i), JarIndex.this._cSizes[i], JarIndex.this._ucSizes[i], JarIndex.this._dostimes[i]);
                }
            });
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Deprecated
    public String getEntryNameAt(final int i) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<String>(){

                @Override
                public String run(RandomAccessFile jar) throws IOException {
                    return JarIndex.this._entryNamesPool.getStringFromIndex(i);
                }
            });
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String[] getEntries() {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<String[]>(){

                @Override
                public String[] run(RandomAccessFile jar) {
                    int numEntries = JarIndex.this._offsets.length;
                    String[] entryArray = new String[numEntries];
                    for (int i = 0; i < numEntries; ++i) {
                        entryArray[i] = JarIndex.this._entryNamesPool.getStringFromIndex(i);
                    }
                    return entryArray;
                }
            });
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public int getSize(final String entryName) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Integer>(){

                @Override
                public Integer run(RandomAccessFile jar) {
                    int entryIndex;
                    if (entryName != null && (entryIndex = JarIndex.this._entryNamesPool.binarySearch(entryName)) >= 0) {
                        return JarIndex.this._ucSizes[entryIndex];
                    }
                    return -1;
                }
            });
        }
        catch (IOException e) {
            return -1;
        }
    }

    public String[] list(final String dirEntryName) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<String[]>(){

                @Override
                public String[] run(RandomAccessFile jar) {
                    String[] res;
                    if (dirEntryName.length() > 0 && ((res = JarIndex.this.listImpl(dirEntryName.endsWith("/") ? dirEntryName : dirEntryName + "/")) != null && res.length > 0 || !JarIndex.this._pathlessFiles || !dirEntryName.equals("./"))) {
                        return res;
                    }
                    return JarIndex.this.listImpl("");
                }
            });
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public InputStream openInputStream(final String entryName) throws IOException {
        if (entryName != null) {
            return this.run(EnumSet.of(TaskOptions.OFFSETS), new JarIndexTask<InputStream>(){

                @Override
                public InputStream run(RandomAccessFile jar) throws IOException {
                    byte[] localHeader = new byte[30];
                    int[] offsetAndSizes = JarIndex.this.getLOC(jar, localHeader, entryName);
                    if (offsetAndSizes != null) {
                        int dataLength = offsetAndSizes[1];
                        byte[] dataBytes = new byte[dataLength];
                        jar.readFully(dataBytes);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(dataBytes);
                        int compressionMethod = JarIndex.getCompressionMethod(localHeader);
                        switch (compressionMethod) {
                            case 0: {
                                return inputStream;
                            }
                            case 8: {
                                return new InflaterInputStream(inputStream, new Inflater(true));
                            }
                        }
                        throw new IOException("Unsupported compression method (" + compressionMethod + ")");
                    }
                    throw new FileNotFoundException(JarIndex.this.getJarEntryString(entryName));
                }
            });
        }
        throw new FileNotFoundException(this.getJarEntryString(entryName));
    }

    public boolean exists(final String entryName) {
        boolean exists = false;
        final boolean[] checkedFullIndex = new boolean[1];
        try {
            exists = this.run(EnumSet.noneOf(TaskOptions.class), new JarIndexTask<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean run(RandomAccessFile jar) throws IOException {
                    boolean openedJar;
                    if (JarIndex.this._entryNamesPool != null) {
                        checkedFullIndex[0] = true;
                        return entryName.endsWith("/") ? JarIndex.this.dirEntryIndexImpl(entryName) >= 0 : JarIndex.this._entryNamesPool.binarySearch(entryName) >= 0;
                    }
                    boolean bl = openedJar = jar == null;
                    if (openedJar) {
                        jar = JarIndex.this.openJarFile();
                    }
                    try {
                        Boolean bl2 = JarIndex.this.getLOC(jar, new byte[30], entryName) != null;
                        return bl2;
                    }
                    finally {
                        if (openedJar) {
                            JarIndex.closeJarFile(jar);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!checkedFullIndex[0] && !exists && entryName.endsWith("/")) {
            try {
                exists = this.run(FULL_INDEX, new JarIndexTask<Boolean>(){

                    @Override
                    public Boolean run(RandomAccessFile jar) throws IOException {
                        return JarIndex.this.dirEntryIndexImpl(entryName) >= 0;
                    }
                });
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return exists;
    }

    public boolean isDirectory(final String entryName) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Boolean>(){

                @Override
                public Boolean run(RandomAccessFile jar) throws IOException {
                    return JarIndex.this.dirEntryIndexImpl(entryName.endsWith("/") ? entryName : entryName + "/") >= 0;
                }
            });
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        if (FILE_CACHE_ENABLED) {
            ArrayList<JarIndex> openJars;
            IdentityHashMap<JarIndex, JarIndex> identityHashMap = _fileCache;
            synchronized (identityHashMap) {
                openJars = new ArrayList<JarIndex>(_fileCache.keySet());
                _fileCache.clear();
            }
            Iterator i$ = openJars.iterator();
            while (i$.hasNext()) {
                JarIndex jarIndex;
                JarIndex jarIndex2 = jarIndex = (JarIndex)i$.next();
                synchronized (jarIndex2) {
                    try {
                        jarIndex._fileHandle.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    jarIndex._fileHandle = null;
                    jarIndex._invalid = true;
                }
            }
        }
    }

    public byte[] getBytes(final String entryName) throws IOException {
        if (entryName != null) {
            return this.run(EnumSet.of(TaskOptions.FULL, TaskOptions.OFFSETS), new JarIndexTask<byte[]>(){

                @Override
                public byte[] run(RandomAccessFile jar) throws IOException {
                    byte[] localHeader = new byte[30];
                    int[] offsetAndSizes = JarIndex.this.getLOC(jar, localHeader, entryName);
                    if (offsetAndSizes != null) {
                        int dataLength = offsetAndSizes[1];
                        byte[] dataBytes = new byte[dataLength];
                        jar.readFully(dataBytes);
                        int compressionMethod = JarIndex.getCompressionMethod(localHeader);
                        switch (compressionMethod) {
                            case 0: {
                                return dataBytes;
                            }
                            case 8: {
                                ByteArrayInputStream in = new ByteArrayInputStream(dataBytes);
                                int ucDataLength = offsetAndSizes[2];
                                byte[] ucDataBytes = new byte[ucDataLength];
                                Inflater inf = new Inflater(true);
                                InflaterInputStream inflater = new InflaterInputStream(in, inf, dataLength);
                                int bytesRead = inflater.read(ucDataBytes, 0, ucDataLength);
                                inf.end();
                                if (bytesRead == ucDataLength) {
                                    return ucDataBytes;
                                }
                                throw new IOException("Unexpected EOF -- corrupted jar file");
                            }
                        }
                        throw new IOException("Unsupported compression method (" + compressionMethod + ")");
                    }
                    return new byte[0];
                }
            });
        }
        return new byte[0];
    }

    public long getTimestamp(final String entryName) {
        try {
            return this.run(FULL_INDEX, new JarIndexTask<Long>(){

                @Override
                public Long run(RandomAccessFile jar) {
                    int entryIndex;
                    if (entryName != null && (entryIndex = JarIndex.this._entryNamesPool.binarySearch(entryName)) >= 0) {
                        int dtime = JarIndex.this._dostimes[entryIndex];
                        GregorianCalendar gc = new GregorianCalendar((dtime >> 25 & 0x7F) + 80 + 1900, (dtime >> 21 & 0xF) - 1, dtime >> 16 & 0x1F, dtime >> 11 & 0x1F, dtime >> 5 & 0x3F, dtime << 1 & 0x3E);
                        return gc.getTimeInMillis();
                    }
                    return JarIndex.this.getTimestamp();
                }
            });
        }
        catch (IOException e) {
            return this.getTimestamp();
        }
    }

    public long getTimestamp() {
        long timestamp = this._timestamp;
        return timestamp == -1L ? URLFileSystem.lastModified(this._jarFileURL) : timestamp;
    }

    String getManifestMainAttribute(final boolean getMainClass) {
        try {
            return this.run(EnumSet.of(TaskOptions.MANIFEST), new JarIndexTask<String>(){

                @Override
                public String run(RandomAccessFile jar) {
                    if (JarIndex.this._manifestAttributes != null) {
                        return getMainClass ? JarIndex.this._manifestAttributes[0] : JarIndex.this._manifestAttributes[1];
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            return null;
        }
    }

    String canonicalize(String entryName) {
        return entryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFullIndex(RandomAccessFile jar) throws IOException {
        long startTime = System.nanoTime();
        try {
            int j;
            int commentLen;
            int extraFieldLen;
            int filenameLen;
            CDIRData data = this.findCDIR(jar);
            if (data == null) {
                this.initArrays(0);
                this._entryNamesPool = new AlikeStrings(new String[0]);
                return;
            }
            byte[] cdir = new byte[data.size];
            jar.seek(data.offset);
            jar.readFully(cdir);
            this.initArrays(data.numEntries);
            String[] entryNames = new String[data.numEntries];
            int numLoops = 0;
            for (j = 0; j < data.size && numLoops < data.numEntries; j += 46 + filenameLen + extraFieldLen + commentLen, ++numLoops) {
                int dostime = JarIndex.get4LE(cdir, j + 12);
                int compressedSize = JarIndex.get4LE(cdir, j + 20);
                int uncompressedSize = JarIndex.get4LE(cdir, j + 24);
                filenameLen = JarIndex.get2LE(cdir, j + 28);
                extraFieldLen = JarIndex.get2LE(cdir, j + 30);
                commentLen = JarIndex.get2LE(cdir, j + 32);
                int offset = JarIndex.get4LE(cdir, j + 42);
                int entryNameOffset = j + 46;
                if (entryNameOffset + filenameLen > data.size) {
                    this.initArrays(0);
                    this._entryNamesPool = new AlikeStrings(new String[0]);
                    throw new IOException("Invalid entry offset in " + URLFileSystem.getPlatformPathName(this._jarFileURL));
                }
                String entryName = new String(cdir, entryNameOffset, filenameLen, JAR_CHARSETNAME);
                if (!this._pathlessFiles && entryName.indexOf(47) < 0) {
                    this._pathlessFiles = true;
                }
                entryNames[numLoops] = entryName;
                this._offsets[numLoops] = offset;
                this._cSizes[numLoops] = compressedSize;
                this._ucSizes[numLoops] = uncompressedSize;
                this._dostimes[numLoops] = dostime;
            }
            if (j < data.size) {
                // empty if block
            }
            this.sortArrays(entryNames, 0, numLoops - 1);
            this._entryNamesPool = new AlikeStrings(entryNames);
            this._table = null;
            this._tableData = null;
            this._tableLen = 0;
        }
        finally {
            PerformanceLogger.get().log("indexjar", this._jarFileURL.toString(), System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHashIndex(RandomAccessFile jar) throws IOException {
        PerformanceLogger.get().startTiming("hashjar_" + this._jarFileURL.toString());
        try {
            CDIRData data = this.findCDIR(jar);
            if (data == null) {
                this._tableLen = 0;
                this._table = new int[0];
                this._tableData = new int[0];
                return;
            }
            byte[] cdir = new byte[data.size];
            jar.seek(data.offset);
            jar.readFully(cdir);
            this._tableLen = data.numEntries / 2 + 1;
            this._table = new int[this._tableLen];
            this._tableData = new int[data.numEntries * 3 + 1];
            int j = 0;
            for (int numLoops = 0; j < data.size && numLoops < data.numEntries; ++numLoops) {
                int compressedSize = JarIndex.get4LE(cdir, j + 20);
                int filenameLen = JarIndex.get2LE(cdir, j + 28);
                int extraFieldLen = JarIndex.get2LE(cdir, j + 30);
                int commentLen = JarIndex.get2LE(cdir, j + 32);
                int offset = JarIndex.get4LE(cdir, j + 42);
                int entryNameOffset = j + 46;
                int hash = JarIndex.hash(cdir, j + 46, filenameLen) % this._tableLen;
                int k = numLoops * 3 + 1;
                this._tableData[k] = offset;
                this._tableData[k + 1] = compressedSize;
                this._tableData[k + 2] = this._table[hash];
                this._table[hash] = k;
                j = entryNameOffset + filenameLen + extraFieldLen + commentLen;
            }
        }
        finally {
            PerformanceLogger.get().stopTiming("hashjar_" + this._jarFileURL.toString(), "Created hash index for " + URLFileSystem.getFileName(this._jarFileURL), 500);
        }
    }

    private void initArrays(int size) {
        this._offsets = new int[size];
        this._cSizes = new int[size];
        this._ucSizes = new int[size];
        this._dostimes = new int[size];
    }

    private void sortArrays(String[] _entryNames, int lo, int hi) {
        int i = lo;
        int j = hi;
        String pivot = _entryNames[(i + j) / 2];
        while (true) {
            if (_entryNames[i].compareTo(pivot) < 0) {
                ++i;
                continue;
            }
            while (pivot.compareTo(_entryNames[j]) < 0) {
                --j;
            }
            if (i <= j) {
                String temp1 = _entryNames[i];
                _entryNames[i] = _entryNames[j];
                _entryNames[j] = temp1;
                int temp2 = this._offsets[i];
                this._offsets[i] = this._offsets[j];
                this._offsets[j] = temp2;
                temp2 = this._cSizes[i];
                this._cSizes[i] = this._cSizes[j];
                this._cSizes[j] = temp2;
                temp2 = this._ucSizes[i];
                this._ucSizes[i] = this._ucSizes[j];
                this._ucSizes[j] = temp2;
                temp2 = this._dostimes[i];
                this._dostimes[i] = this._dostimes[j];
                this._dostimes[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            this.sortArrays(_entryNames, lo, j);
        }
        if (i < hi) {
            this.sortArrays(_entryNames, i, hi);
        }
    }

    private int[] getOffsetAndSizes(String jarEntryName) {
        int entryIndex;
        if (jarEntryName != null && (entryIndex = this._entryNamesPool.binarySearch(jarEntryName)) >= 0) {
            return new int[]{this._offsets[entryIndex], this._cSizes[entryIndex], this._ucSizes[entryIndex]};
        }
        return new int[]{-1, -1, -1};
    }

    private int[] getLOC(RandomAccessFile jar, byte[] localHeader, String entryName) throws IOException {
        if (this._entryNamesPool == null) {
            return this.getLOCFromHash(jar, localHeader, entryName);
        }
        int[] offsetAndSizes = this.getOffsetAndSizes(entryName);
        int offset = offsetAndSizes[0];
        if (offset >= 0) {
            jar.seek(offset);
            jar.read(localHeader, 0, 30);
            if (localHeader[0] == 80 && localHeader[1] == 75 && localHeader[2] == 3 && localHeader[3] == 4) {
                int filenameLength = (localHeader[26] & 0xFF) + ((localHeader[27] & 0xFF) << 8);
                byte[] filenameBytes = new byte[filenameLength];
                jar.readFully(filenameBytes);
                String filename = new String(filenameBytes, JAR_CHARSETNAME);
                if (ModelUtil.areDifferent(filename, entryName)) {
                    throw new IOException("Mismatched entry names '" + filename + "' and '" + entryName + "' for jar file" + this._jarFileURL.toString());
                }
                int extraFieldLength = (localHeader[28] & 0xFF) + ((localHeader[29] & 0xFF) << 8);
                jar.skipBytes(extraFieldLength);
                return offsetAndSizes;
            }
            throw new IOException("Corrupt entry offset for URL " + this._jarFileURL.toString());
        }
        throw new FileNotFoundException(this.getJarEntryString(entryName));
    }

    private int[] getLOCFromHash(RandomAccessFile jar, byte[] localHeader, String entryName) throws IOException {
        if (this._tableLen == 0) {
            throw new FileNotFoundException(this.getJarEntryString(entryName));
        }
        byte[] b = entryName.getBytes(JAR_CHARSETNAME);
        int hash = JarIndex.hash(b, 0, b.length);
        int i = this._table[hash % this._tableLen];
        while (i != 0) {
            int nlen;
            int offset = this._tableData[i];
            jar.seek(offset);
            jar.read(localHeader, 0, 30);
            if ((long)JarIndex.get4LE(localHeader, 0) == 67324752L && (nlen = JarIndex.get2LE(localHeader, 26)) > 0 && nlen == b.length) {
                byte[] buffer = new byte[nlen];
                jar.seek(offset + 30);
                jar.readFully(buffer);
                boolean match = true;
                for (int j = 0; j < nlen; ++j) {
                    if (b[j] == buffer[j]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    int extraFieldLength = (localHeader[28] & 0xFF) + ((localHeader[29] & 0xFF) << 8);
                    jar.skipBytes(extraFieldLength);
                    return new int[]{this._tableData[i + 0], this._tableData[i + 1], 0};
                }
            }
            i = this._tableData[i + 2];
        }
        throw new FileNotFoundException(this.getJarEntryString(entryName));
    }

    private String getJarEntryString(String entryName) {
        return this._jarFileURL.toString() + "!/" + entryName;
    }

    private static int getCompressionMethod(byte[] localHeader) {
        return (localHeader[8] & 0xFF) + ((localHeader[9] & 0xFF) << 8);
    }

    private static int get2LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8);
    }

    private static int get4LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8) + ((b[i + 2] & 0xFF) << 16) + (b[i + 3] << 24);
    }

    private int dirEntryIndexImpl(String entryName) {
        String nextEntry;
        int index = this._entryNamesPool.binarySearch(entryName);
        if (index >= 0) {
            return index;
        }
        if (this._pathlessFiles && entryName.equals("./")) {
            return 0;
        }
        int insertPoint = -index - 1;
        if (insertPoint < this._offsets.length && (nextEntry = this._entryNamesPool.getStringFromIndex(insertPoint)).startsWith(entryName)) {
            return insertPoint;
        }
        return -1;
    }

    private String[] listImpl(String dirEntryName) {
        String entryName;
        ArrayList<String> list = new ArrayList<String>();
        int n = this._offsets.length;
        int dirLen = dirEntryName.length();
        int i = this._entryNamesPool.binarySearch(dirEntryName);
        if (i >= 0) {
            ++i;
        } else if (dirLen > 0) {
            if ((i = -i - 1) >= this._offsets.length) {
                return new String[0];
            }
        } else {
            i = 0;
        }
        while (i < n && (entryName = this._entryNamesPool.getStringFromIndex(i)).startsWith(dirEntryName)) {
            if (entryName.length() != dirLen) {
                String listEntry;
                int endEntry = entryName.indexOf(47, dirLen);
                String string = listEntry = endEntry >= dirLen ? entryName.substring(dirLen, endEntry + 1) : entryName.substring(dirLen);
                if (!list.contains(listEntry)) {
                    list.add(listEntry);
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private static int hash(byte[] b, int offset, int len) {
        int n = offset + len;
        if (n > b.length) {
            n = b.length;
        }
        int h = 0;
        for (int i = offset; i < n; ++i) {
            h = 31 * h + b[i];
        }
        return h & Integer.MAX_VALUE;
    }

    private CDIRData findCDIR(RandomAccessFile jar) throws IOException {
        CDIRData cdir = null;
        long length = jar.length();
        long seek = length - 22L;
        byte[] bytes = new byte[22];
        for (int remainingZipCommentLength = 65535; seek >= 0L && remainingZipCommentLength > 0; --seek, --remainingZipCommentLength) {
            jar.seek(seek);
            jar.readFully(bytes);
            if (bytes[0] != 80 || bytes[1] != 75 || bytes[2] != 5 || bytes[3] != 6) continue;
            int actualCommentLength = 65535 - remainingZipCommentLength;
            if (actualCommentLength > 0 && actualCommentLength != JarIndex.get2LE(bytes, 20)) break;
            cdir = new CDIRData(JarIndex.get2LE(bytes, 10), JarIndex.get4LE(bytes, 12), JarIndex.get4LE(bytes, 16));
            break;
        }
        return cdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <V> V run(Set<TaskOptions> options, JarIndexTask<V> task) throws IOException {
        V v;
        RandomAccessFile jar = null;
        try {
            try {
                if (options.contains((Object)TaskOptions.OFFSETS)) {
                    jar = this.openJarFile();
                }
                if (this.checkTimestamp(options.contains((Object)TaskOptions.OFFSETS))) {
                    this._entryNamesPool = null;
                    this._table = null;
                    this._manifestAttributes = null;
                }
                if (options.contains((Object)TaskOptions.FULL) && this._entryNamesPool == null || options.contains((Object)TaskOptions.MANIFEST) && this._manifestAttributes == null || !options.contains((Object)TaskOptions.FULL) && !options.contains((Object)TaskOptions.MANIFEST) && this._table == null && this._entryNamesPool == null) {
                    if (jar == null) {
                        jar = this.openJarFile();
                    }
                    if (options.contains((Object)TaskOptions.FULL) && this._entryNamesPool == null) {
                        this.buildFullIndex(jar);
                    } else if (options.contains((Object)TaskOptions.MANIFEST) && this._manifestAttributes == null) {
                        this.buildManifestCache();
                    } else if (this._table == null) {
                        this.buildHashIndex(jar);
                    }
                }
            }
            catch (FileNotFoundException e) {
                this._tableLen = 0;
                this._table = new int[0];
                this._tableData = new int[0];
                this.initArrays(0);
                this._entryNamesPool = new AlikeStrings(new String[0]);
            }
            v = task.run(jar);
        }
        catch (Throwable throwable) {
            JarIndex.closeJarFile(jar);
            throw throwable;
        }
        JarIndex.closeJarFile(jar);
        return v;
    }

    private boolean checkTimestamp(boolean forceTimestampCheck) {
        if (this._fileHandle != null && !this._invalid) {
            return false;
        }
        if (forceTimestampCheck || this._timestamp == -1L || System.nanoTime() - this._lastTimestampCheck > TIMESTAMP_INTERVAL) {
            this._invalid = false;
            long start = System.nanoTime();
            long timestamp = URLFileSystem.lastModified(this._jarFileURL);
            this._lastTimestampCheck = System.nanoTime();
            this.warnIfSlowIO(this._lastTimestampCheck - start);
            if (timestamp != this._timestamp) {
                this._timestamp = timestamp;
                return true;
            }
        }
        return false;
    }

    private void warnIfSlowIO(long duration) {
        if (!this._alreadyWarned) {
            this._durations[this._nDuration++] = duration;
            if (this._nDuration == 5) {
                this._nDuration = 0;
            }
            long total = 0L;
            for (int i = 0; i < 5; ++i) {
                total += this._durations[i];
            }
            long average = total / 5L;
            if (average > IO_WARNING_THRESHOLD) {
                this._alreadyWarned = true;
                Logger.getLogger(JarIndex.class.getName()).log(Level.WARNING, "SLOW I/O: {0}ms wait at URLFileSystem.lastModified for {1}", new Object[]{TimeUnit.MILLISECONDS.convert(average, TimeUnit.NANOSECONDS), URLFileSystem.getPlatformPathName(this._jarFileURL)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openJarFile() throws FileNotFoundException {
        if (FILE_CACHE_ENABLED) {
            if (this._fileHandle == null) {
                this._fileHandle = this.openJarFileImpl();
                IdentityHashMap<JarIndex, JarIndex> identityHashMap = _fileCache;
                synchronized (identityHashMap) {
                    _fileCache.put(this, this);
                }
            }
            return this._fileHandle;
        }
        return this.openJarFileImpl();
    }

    private RandomAccessFile openJarFileImpl() throws FileNotFoundException {
        if (this._tempFile == null) {
            this._tempFile = new URLTempFile(JarUtil.getJarFileURL(this._jarFileURL));
        }
        return new RandomAccessFile(this._tempFile.getFile(), "r");
    }

    private static void closeJarFile(RandomAccessFile jar) {
        if (!FILE_CACHE_ENABLED && jar != null) {
            try {
                jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildManifestCache() {
        InputStream manifestIn = null;
        try {
            manifestIn = this.openInputStream("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestIn);
            this._manifestAttributes = new String[2];
            this._manifestAttributes[0] = manifest.getMainAttributes().getValue("Main-Class");
            this._manifestAttributes[1] = manifest.getMainAttributes().getValue("Class-Path");
        }
        catch (IOException e) {
        }
        finally {
            if (manifestIn != null) {
                try {
                    manifestIn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static {
        if (FILE_CACHE_ENABLED) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    JarIndex.flushCache();
                }
            };
            Timer timer = new Timer("JarIndex Timer", true);
            timer.scheduleAtFixedRate(task, 15000L, 5000L);
        }
        int threshold = Version.DEBUG_BUILD == 0 ? Integer.MAX_VALUE : 200;
        String text = System.getProperty("ide.jar.threshold");
        if (text != null) {
            try {
                threshold = Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        IO_WARNING_THRESHOLD = TimeUnit.NANOSECONDS.convert(threshold, TimeUnit.MILLISECONDS);
        FULL_INDEX = EnumSet.of(TaskOptions.FULL);
    }

    private static final class CDIRData {
        final int numEntries;
        final int size;
        final long offset;

        CDIRData(int numEntries, int size, int offset) {
            this.numEntries = numEntries;
            this.size = size;
            this.offset = offset;
        }
    }

    private static interface JarIndexTask<V> {
        public V run(RandomAccessFile var1) throws IOException;
    }

    private static enum TaskOptions {
        FULL,
        OFFSETS,
        MANIFEST;

    }

    public static interface Visitor {
        public boolean visit(JarIndexEntry var1);
    }
}

