/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class HttpURLFileSystemHelper
extends URLFileSystemHelper {
    private HashMap _unreachableMap = new HashMap();
    private String _proxyHost;
    private String _proxyPort;
    private static final int DEFAULT_PORT = 80;

    @Override
    public String getSystemDisplayName(URL url) {
        if (URLFileSystem.isRoot(url)) {
            return URLFileSystem.getPlatformPathName(url);
        }
        return URLFileSystem.getFileName(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLength(URL url) {
        long l;
        this._checkProxy();
        if (this._unreachableMap.containsKey(url.getHost())) {
            return -1L;
        }
        URLConnection urlConnection = url.openConnection();
        try {
            l = urlConnection.getContentLength();
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (NoRouteToHostException nrex) {
                this._unreachableMap.put(url.getHost(), null);
                return -1L;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        try {
            urlConnection.getInputStream().close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lastModified(URL url) {
        long l;
        this._checkProxy();
        if (this._unreachableMap.containsKey(url.getHost())) {
            return -1L;
        }
        URLConnection urlConnection = url.openConnection();
        try {
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)urlConnection;
                httpCon.setRequestMethod("HEAD");
            }
            l = urlConnection.getLastModified();
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (NoRouteToHostException nrex) {
                this._unreachableMap.put(url.getHost(), null);
                return -1L;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        try {
            urlConnection.getInputStream().close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(URL url) {
        boolean result = false;
        this._checkProxy();
        String host = url.getHost();
        if (!this._unreachableMap.containsKey(host)) {
            InputStream in = null;
            try {
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpCon = (HttpURLConnection)connection;
                    in = httpCon.getInputStream();
                    int code = httpCon.getResponseCode();
                    result = code >= 100 & code < 400;
                    if (code == 200) {
                        String resolvedFile;
                        String requestedFile = URLFileSystem.getFileName(url);
                        result = requestedFile.equals(resolvedFile = URLFileSystem.getFileName(httpCon.getURL()));
                    }
                }
            }
            catch (NoRouteToHostException nrex) {
                this._unreachableMap.put(host, null);
            }
            catch (ConnectException ce) {
                ce.toString();
            }
            catch (IOException ex) {
                ex.toString();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    @Override
    public boolean canCreate(URL url) {
        boolean result = false;
        this._checkProxy();
        String host = url.getHost();
        if (!this._unreachableMap.containsKey(host)) {
            while (url != null) {
                if (this.exists(url)) {
                    result = this.canWrite(url);
                    break;
                }
                url = this.getParent(url);
            }
        }
        return result;
    }

    @Override
    public URL getParent(URL url) {
        URL parent = super.getParent(url);
        if (parent != null && parent.equals(url)) {
            parent = null;
        }
        return parent;
    }

    @Override
    public InputStream openInputStream(URL url) throws IOException {
        this._checkProxy();
        String host = url.getHost();
        try {
            if (!this._unreachableMap.containsKey(host)) {
                URLConnection connection = url.openConnection();
                return connection.getInputStream();
            }
        }
        catch (NoRouteToHostException ex) {
            this._unreachableMap.put(host, null);
            throw ex;
        }
        throw new IOException();
    }

    private void _checkProxy() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (this._areDifferent(this._proxyHost, proxyHost) || this._areDifferent(this._proxyPort, proxyPort)) {
            this._unreachableMap.clear();
            this._proxyHost = proxyHost;
            this._proxyPort = proxyPort;
        }
    }

    private boolean _areDifferent(String s1, String s2) {
        return s1 == null ? s2 != null : !s1.equals(s2);
    }

    @Override
    protected boolean haveSamePort(URL url1, URL url2) {
        int p1 = url1.getPort() != -1 ? url1.getPort() : 80;
        int p2 = url2.getPort() != -1 ? url2.getPort() : 80;
        return p1 == p2;
    }
}

