/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.util.HashMap;

final class AlikeStrings {
    private char[] _buffer;
    private int[] _segments;
    private int[] _strings;
    private int[] _storedStrings;
    private int _bufferSize;
    private int _segmentSize;
    private int _stringSize;

    private int addInFullDict(HashMap words, HashMap fullStrings, String full, String token) {
        int tokenIndex;
        Integer Index;
        Integer val;
        int tokenLength = token.length();
        Integer iKey = (Integer)fullStrings.get(full);
        if (iKey != null) {
            return iKey;
        }
        String root = full.substring(0, full.length() - tokenLength);
        int rootIndex = -1;
        if (!root.equals("") && (val = (Integer)fullStrings.get(root)) != null) {
            rootIndex = val;
        }
        if ((Index = (Integer)words.get(token)) == null) {
            int newSize = this._bufferSize + tokenLength;
            while (newSize > this._buffer.length) {
                char[] nBuffer = new char[this._buffer.length * 2];
                System.arraycopy(this._buffer, 0, nBuffer, 0, this._bufferSize);
                this._buffer = nBuffer;
            }
            token.getChars(0, tokenLength, this._buffer, this._bufferSize);
            int nSize = this._segmentSize + 2;
            while (nSize > this._segments.length) {
                int[] nBuffer = new int[this._segments.length * 2];
                System.arraycopy(this._segments, 0, nBuffer, 0, this._segmentSize);
                this._segments = nBuffer;
            }
            this._segments[this._segmentSize] = this._bufferSize;
            this._segments[this._segmentSize + 1] = tokenLength;
            words.put(token, new Integer(this._segmentSize));
            tokenIndex = this._segmentSize;
            this._segmentSize = nSize;
            this._bufferSize = newSize;
        } else {
            tokenIndex = Index;
        }
        int nSize = this._stringSize + 2;
        while (nSize > this._strings.length) {
            int[] nBuffer = new int[this._strings.length * 2];
            System.arraycopy(this._strings, 0, nBuffer, 0, this._stringSize);
            this._strings = nBuffer;
        }
        this._strings[this._stringSize] = tokenIndex;
        this._strings[this._stringSize + 1] = rootIndex;
        fullStrings.put(full, new Integer(this._stringSize));
        this._stringSize = nSize;
        return nSize - 2;
    }

    void packStringArray(String[] src) {
        this._storedStrings = new int[src.length * 2];
        int ccount = 0;
        HashMap words = new HashMap(src.length * 2, 1.5f);
        HashMap fulls = new HashMap(src.length * 5, 1.5f);
        this.addInFullDict(words, fulls, ".class", ".class");
        for (int i = 0; i < src.length; ++i) {
            String full;
            String cword;
            int sindex = 0;
            int lastpos = 0;
            String current = src[i];
            int currentLength = current.length();
            int j = 0;
            while (j < currentLength) {
                char c = current.charAt(j);
                if (j - lastpos < 2) {
                    ++j;
                    continue;
                }
                if (Character.isUpperCase(c) || Character.isDigit(c) || c == '.') {
                    cword = current.substring(lastpos, j);
                    full = current.substring(0, j);
                    sindex = this.addInFullDict(words, fulls, full, cword);
                    lastpos = j++;
                    continue;
                }
                if (c == '/' || c == '$' || c == '-' || c == '_') {
                    cword = current.substring(lastpos, ++j);
                    full = current.substring(0, j);
                    sindex = this.addInFullDict(words, fulls, full, cword);
                    lastpos = j;
                    continue;
                }
                ++j;
            }
            cword = current.substring(lastpos, j);
            if (cword.equals(".class")) {
                this._storedStrings[ccount + 1] = -currentLength;
            } else {
                this._storedStrings[ccount + 1] = currentLength;
                if (!cword.equals("")) {
                    full = current.substring(0, j);
                    sindex = this.addInFullDict(words, fulls, full, cword);
                }
            }
            this._storedStrings[ccount] = sindex;
            ccount += 2;
        }
        int[] nBuffer = new int[this._stringSize];
        System.arraycopy(this._strings, 0, nBuffer, 0, this._stringSize);
        this._strings = nBuffer;
        nBuffer = new int[this._segmentSize];
        System.arraycopy(this._segments, 0, nBuffer, 0, this._segmentSize);
        this._segments = nBuffer;
        char[] nchar = new char[this._bufferSize];
        System.arraycopy(this._buffer, 0, nchar, 0, this._bufferSize);
        this._buffer = nchar;
    }

    public String getStringFromIndex(int index) {
        String s = new String(this.getCharsFromIndex(index));
        return s;
    }

    public char[] getCharsFromIndex(int index) {
        char[] res;
        index *= 2;
        int curseg = this._storedStrings[index++];
        int curl = this._storedStrings[index];
        if (curl < 0) {
            curl = -curl;
            res = new char[curl];
            System.arraycopy(this._buffer, 0, res, curl -= 6, 6);
        } else {
            res = new char[curl];
        }
        do {
            int segment = this._strings[curseg++];
            int segstart = this._segments[segment++];
            int segsize = this._segments[segment];
            curseg = this._strings[curseg];
            if (segstart < 0 || (curl -= segsize) < 0 || segsize < 0 || segstart + segsize > this._buffer.length || curl + segsize > res.length) continue;
            System.arraycopy(this._buffer, segstart, res, curl, segsize);
        } while (curseg != -1);
        return res;
    }

    int compareToString(int index, String s) {
        int nres;
        int segment;
        int segend;
        int segstart;
        int curseg = this._storedStrings[index++];
        int curl = this._storedStrings[index];
        int slen = s.length();
        if (curl < 0) {
            curl = -curl;
            segstart = 0;
            segend = 6;
        } else {
            segment = this._strings[curseg++];
            segstart = this._segments[segment++];
            segend = segstart + this._segments[segment];
            curseg = this._strings[curseg];
        }
        int res = curl - slen;
        if (slen > curl) {
            slen = curl;
        }
        while (--segend >= segstart) {
            if (--curl >= slen || --slen < 0 || (nres = this._buffer[segend] - s.charAt(slen)) == 0) continue;
            res = nres;
        }
        while (curseg != -1) {
            segment = this._strings[curseg++];
            segstart = this._segments[segment++];
            segend = segstart + this._segments[segment];
            curseg = this._strings[curseg];
            while (--segend >= segstart) {
                if (--curl >= slen || (nres = this._buffer[segend] - s.charAt(--slen)) == 0) continue;
                res = nres;
            }
        }
        return res;
    }

    public int binarySearch(String s) {
        int low = 0;
        int high = (this._storedStrings.length >> 1) - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = this.compareToString(mid * 2, s);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public AlikeStrings(String[] stringToPack) {
        int len = stringToPack.length + 2;
        this._buffer = new char[len * 50];
        this._segments = new int[len * 6];
        this._strings = new int[len * 8];
        this.packStringArray(stringToPack);
    }
}

