/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.SimpleType;
import oracle.jdeveloper.xml.dtd.grammar.DtdAttribute;
import oracle.jdeveloper.xml.dtd.grammar.DtdConstrainingFacet;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdFactory;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoader;
import oracle.jdeveloper.xml.dtd.grammar.DtdSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;
import oracle.jdevimpl.xml.dtd.parser.AbstractDtdParser;
import oracle.jdevimpl.xml.dtd.parser.AbstractParser;
import oracle.jdevimpl.xml.dtd.parser.DtdElementContentParser;
import org.xml.sax.SAXException;

public class SgmlDtdParser
extends AbstractDtdParser {
    private DtdElementContentParser _contentParser;

    public SgmlDtdParser() {
    }

    protected SgmlDtdParser(SgmlDtdParser sgmlDtdParser) {
        super(sgmlDtdParser);
    }

    protected SgmlDtdParser(AbstractParser abstractParser, DtdLoader loader) {
        super(abstractParser, loader);
    }

    protected void parseElementDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        boolean listOfElements = this.reader.tryRead(40);
        this.reader.skipWhiteSpace();
        String elemName = this.reader.scanQName();
        DtdElement element = this.dtdNamespaceLoader.findElement(elemName);
        if (element == null) {
            element = this.dtdNamespaceLoader.createElement(elemName);
        }
        ObjectArray elements = new ObjectArray();
        elements.addElement(element);
        this.reader.skipWhiteSpace();
        if (listOfElements) {
            while (this.reader.tryRead(124)) {
                this.reader.skipWhiteSpace();
                elemName = this.reader.scanQName();
                element = this.dtdNamespaceLoader.findElement(elemName);
                if (element == null) {
                    element = this.dtdNamespaceLoader.createElement(elemName);
                }
                elements.addElement(element);
                this.reader.skipWhiteSpace();
            }
            this.reader.tryRead(41);
            this.reader.skipWhiteSpace();
        }
        boolean startTagRequired = this.reader.read() == 45;
        this.reader.skipWhiteSpace();
        boolean endTagRequired = this.reader.read() == 45;
        this.reader.skipWhiteSpace();
        DtdElementContentParser.Content contentRV = this.getContentParser().parseContent(this.err, this.reader);
        ComplexType contentType = contentRV.type;
        this.reader.skipWhiteSpace();
        String elemCommentInfo = "";
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            elemCommentInfo = this.getParsedComment(true);
        }
        String contentAsString = SgmlDtdParser.getContentString(contentType);
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            element = (DtdElement)elements.elementAt(i);
            this.dtdNamespaceLoader.setElementDefinition(element, contentType, startTagRequired, endTagRequired);
            this.dtdNamespaceLoader.addElement(element);
            if (elemCommentInfo != null && elemCommentInfo.length() > 0) {
                this.dtdNamespaceLoader.setDescription(element, elemCommentInfo);
            }
            this.declHandler.elementDecl(element.getName(), contentAsString);
        }
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            this.parseComment(true);
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    protected void parseWhiteSpace() throws SAXException, IOException {
        this.reader.skipWhiteSpace();
    }

    protected void parseAttlistDecl() throws SAXException, IOException {
        boolean hasMoreAttributes;
        this.reader.requireWhiteSpace();
        boolean lparen = this.reader.tryRead(40);
        ObjectArray elements = new ObjectArray();
        elements.addElement(this.parseAttlistElement());
        if (lparen) {
            this.reader.skipWhiteSpace();
            while (!this.reader.isEOF() && this.reader.tryRead(124)) {
                elements.addElement(this.parseAttlistElement());
                this.parseWhiteSpace();
            }
            this.reader.tryRead(41);
        }
        boolean bl = hasMoreAttributes = this.reader.skipWhiteSpace() && this.reader.peek() != 62;
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            this.parseComment(true);
            boolean bl2 = hasMoreAttributes = this.reader.skipWhiteSpace() && this.reader.peek() != 62;
        }
        while (hasMoreAttributes) {
            this.parseAttlist(elements);
            hasMoreAttributes = this.reader.skipWhiteSpace();
            if (!hasMoreAttributes) {
                if (this.reader.isEOF()) {
                    this.reader.popXMLReader();
                }
                this.reader.skipWhiteSpace();
                if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
                    this.parseComment(true);
                    hasMoreAttributes = this.reader.skipWhiteSpace();
                }
            } else if (this.reader.isEOF()) {
                this.reader.popXMLReader();
                hasMoreAttributes = this.reader.skipWhiteSpace();
                if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
                    this.parseComment(true);
                }
                hasMoreAttributes = this.reader.skipWhiteSpace();
            }
            hasMoreAttributes &= this.reader.peek() != 62;
        }
        if (!hasMoreAttributes && !this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    protected String getNoQuotesAttrValue() throws SAXException, IOException {
        return this.parseAttrValueWithoutQuotes();
    }

    protected int processParseEntityValue(int i) throws SAXException, IOException {
        while (i != 34 && i != 39) {
            i = this.reader.read();
        }
        return i;
    }

    private DtdElement parseAttlistElement() throws SAXException, IOException {
        this.parseWhiteSpace();
        String qName = this.reader.scanQName();
        DtdElement element = this.dtdNamespaceLoader.findElement(qName);
        if (element == null) {
            element = this.dtdNamespaceLoader.createElement(qName);
        }
        return element;
    }

    private void parseAttlist(ObjectArray elements) throws SAXException, IOException {
        SimpleType simpleType;
        String attrName = this.reader.scanQName();
        if (attrName == null) {
            return;
        }
        int attrType = 3;
        boolean hasEnumConstraint = false;
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(cCDATA, 0, cCDATA.length)) {
            attrType = 3;
        } else if (this.reader.tryRead(cIDREFS, 0, cIDREFS.length)) {
            attrType = 6;
        } else if (this.reader.tryRead(cIDREF, 0, cIDREF.length)) {
            attrType = 1;
        } else if (this.reader.tryRead(cID, 0, cID.length)) {
            attrType = 0;
        } else if (this.reader.tryRead(cENTITY, 0, cENTITY.length)) {
            attrType = 2;
        } else if (this.reader.tryRead(cENTITIES, 0, cENTITIES.length)) {
            attrType = 7;
        } else if (this.reader.tryRead(cNMTOKENS, 0, cNMTOKENS.length)) {
            attrType = 8;
        } else if (this.reader.tryRead(cNMTOKEN, 0, cNMTOKEN.length)) {
            attrType = 5;
        } else if (this.reader.tryRead(cNAME, 0, cNAME.length)) {
            attrType = 4;
            this.reader.requireWhiteSpace();
        } else if (this.reader.tryRead(cNUMBER, 0, cNUMBER.length)) {
            attrType = 10;
            this.reader.requireWhiteSpace();
        } else if (this.reader.tryRead(cNOTATION, 0, cNOTATION.length)) {
            attrType = 9;
            this.reader.requireWhiteSpace();
            hasEnumConstraint = true;
        } else if (this.reader.tryRead(40)) {
            attrType = 3;
            hasEnumConstraint = true;
        } else {
            this.err.error0(133, 0);
            attrType = 3;
        }
        DtdConstrainingFacet enumFacet = null;
        StringBuffer enumStr = null;
        if (hasEnumConstraint) {
            enumFacet = DtdFactory.getConstrainingFacet(this.dtdNamespaceLoader, 10);
            enumStr = new StringBuffer(40);
            if (attrType == 9 && !this.reader.tryRead(40)) {
                this.err.error1(100, 0, "(");
            }
            while (!this.reader.isEOF()) {
                this.reader.skipWhiteSpace();
                String listValue = attrType == 9 ? this.reader.scanQName() : this.reader.scanNmToken();
                try {
                    enumFacet.setValue(listValue);
                }
                catch (Exception e) {
                    this.err.error0(1, 0);
                }
                enumStr.append(listValue);
                this.reader.skipWhiteSpace();
                if (this.reader.tryRead(124)) {
                    enumStr.append('|');
                    continue;
                }
                if (this.reader.tryRead(41)) break;
                this.err.error2(101, 0, ")", "|");
            }
            enumStr.append(')');
        }
        String attrValue = null;
        boolean isRequired = false;
        boolean isFixed = false;
        boolean isImplied = false;
        this.parseWhiteSpace();
        if (this.reader.tryRead(35)) {
            if (this.reader.tryRead(cFIXED, 0, cFIXED.length)) {
                isFixed = true;
                this.reader.requireWhiteSpace();
            } else if (this.reader.tryRead(cREQUIRED, 0, cREQUIRED.length)) {
                isRequired = true;
            } else if (this.reader.tryRead(cIMPLIED, 0, cIMPLIED.length)) {
                isImplied = true;
            } else {
                this.err.error0(288, 0);
            }
        } else {
            attrValue = this.parseAttrValue();
        }
        if (this.isQuote()) {
            attrValue = this.parseAttrValue();
        }
        String attrDefaultValue = null;
        String attrFixedValue = null;
        if (isFixed) {
            if (attrValue == null) {
                this.err.error0(1, 0);
            }
            attrFixedValue = attrValue;
        } else {
            attrDefaultValue = attrValue;
        }
        char c = (char)this.reader.peek();
        this.reader.skipWhiteSpace();
        String attrCommentInfo = "";
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            attrCommentInfo = this.getParsedComment(true);
        } else {
            this.reader.push(c);
        }
        if (enumFacet != null) {
            SimpleType baseType = GrammarFactory.getBuiltInType(attrType);
            DtdSimpleType dtdSimpleType = DtdFactory.getSimpleType(this.dtdNamespaceLoader, baseType);
            dtdSimpleType.addConstrainingFacet(enumFacet);
            simpleType = dtdSimpleType;
        } else {
            simpleType = GrammarFactory.getBuiltInType(attrType);
        }
        String constraint = "";
        if (isRequired) {
            constraint = "#REQUIRED";
        } else if (isFixed) {
            constraint = "#REQUIRED";
        } else if (isImplied) {
            constraint = "#IMPLIED";
        } else if (enumFacet != null) {
            constraint = enumStr.toString();
        }
        DtdAttribute attribute = this.dtdNamespaceLoader.createAttribute(attrName, isRequired, attrDefaultValue, attrFixedValue, simpleType);
        for (int i = 0; i < elements.size(); ++i) {
            DtdElement element = (DtdElement)elements.elementAt(i);
            this.declHandler.attributeDecl(element.getName(), attrName, DtdFactory.typeToString(attrType), constraint, attrValue);
            this.dtdNamespaceLoader.addAttribute(element, attribute);
            if (attrCommentInfo == null || attrCommentInfo.length() <= 0) continue;
            this.dtdNamespaceLoader.setDescription(attribute, attrCommentInfo);
        }
    }

    private DtdElementContentParser getContentParser() {
        if (this._contentParser == null) {
            this._contentParser = new DtdElementContentParser(this.dtdNamespaceLoader, false);
        }
        return this._contentParser;
    }

    private static String getContentString(ComplexType type) {
        switch (type.getDerivationMethod()) {
            case 2: {
                return SgmlDtdParser.getGroupString(type.getContentGroup());
            }
            case 0: {
                String baseGroup = SgmlDtdParser.getGroupString(((ComplexType)type.getBaseType()).getContentGroup());
                String inclusion = " +" + SgmlDtdParser.getGroupString(type.getContentGroup());
                return baseGroup + inclusion;
            }
            case 1: {
                String baseGroup = SgmlDtdParser.getGroupString(((ComplexType)type.getBaseType()).getContentGroup());
                String exclusion = " -" + SgmlDtdParser.getGroupString(type.getContentGroup());
                return baseGroup + exclusion;
            }
        }
        return "#ANY";
    }

    private static String getGroupString(ContentGroup group) {
        if (group != null) {
            return group.toString();
        }
        return "EMPTY";
    }

    private static class ObjectArray {
        private Object[] array;
        private int curCount;

        public ObjectArray() {
            this(5);
        }

        public ObjectArray(int i) {
            this.array = new Object[i];
        }

        public void addElement(Object obj) {
            int i = this.array.length;
            if (i <= this.curCount) {
                Object[] aobj = new Object[i * 2 + 1];
                System.arraycopy(this.array, 0, aobj, 0, i);
                this.array = aobj;
            }
            this.array[this.curCount++] = obj;
        }

        public Object elementAt(int i) {
            return this.array[i];
        }

        public int size() {
            return this.curCount;
        }

        public Object clone() {
            ObjectArray clone = new ObjectArray(this.curCount);
            System.arraycopy(this.array, 0, clone.array, 0, this.curCount);
            return clone;
        }
    }
}

