/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator.prospective;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.validator.prospective.ProspectiveValidationContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProspectiveValidator {
    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static Set<DomPosition> findValidInsertionPositions(ProspectiveValidationContext context, XmlKey keyToInsert, Node nodeToInsert, DomPosition requestedPosition, XmlKey containerKey) {
        block20: {
            block18: {
                block19: {
                    keyNamespace = null;
                    keyName = null;
                    keyQName = null;
                    if (keyToInsert == null) break block18;
                    if (keyToInsert.getNodeType() != 1) break block19;
                    keyQName = keyToInsert.getElementQName();
                    keyNamespace = keyQName.getNamespace();
                    keyName = keyQName.getName();
                    if (keyQName.isVariation()) {
                        keyQName = QualifiedName.getQualifiedName(keyNamespace, keyName);
                    }
                    break block20;
                }
                return null;
            }
            if (nodeToInsert == null) ** GOTO lbl22
            if (nodeToInsert.getNodeType() == 1) {
                keyNamespace = nodeToInsert.getNamespaceURI();
                keyName = DomUtils.getLocalName(nodeToInsert);
                keyQName = QualifiedName.getQualifiedName(keyNamespace, keyName);
            } else {
                return null;
lbl22:
                // 1 sources

                return null;
            }
        }
        if (requestedPosition.hasAttributeQName()) {
            return Collections.emptySet();
        }
        if (requestedPosition.hasTextOffset()) {
            return null;
        }
        validPositions = null;
        parent = requestedPosition.getContainerNode();
        if (containerKey == null) {
            containerKey = context.getNodeXmlKey(parent);
        }
        if (DomUtils.isElement(parent) && (parentDef = (ElementDef)context.getGrammarComponent(containerKey)) != null) {
            elementType = parentDef.getType();
            if (elementType instanceof ComplexType) {
                complexType = (ComplexType)elementType;
                group = complexType.getContentGroup();
                if (group.getVariety() == 9) {
                    validPositions = new LinkedHashSet<T>();
                    previousChild = null;
                    currentChild = DomUtils.getFirstElementChild(parent);
                    currentChildName = null;
                    if (currentChild != null) {
                        currentChildName = QualifiedName.getQualifiedName(currentChild.getNamespaceURI(), DomUtils.getLocalName(currentChild));
                    }
                    flatGroup = (FlattenedContentGroup)ProspectiveValidator._createFlattenedParticle(context.getGrammarResolver(), group);
                    flatSequence = flatGroup.getFlattenedParticles();
                    for (FlattenedParticle flatParticle : flatSequence) {
                        particleMaxOccurs = flatParticle.getMaxOccurs();
                        matchingChildren = new ArrayList<Element>(5);
                        while (currentChild != null && (particleMaxOccurs == -1 || matchingChildren.size() < particleMaxOccurs) && flatParticle.accepts(currentChildName)) {
                            matchingChildren.add(currentChild);
                            previousChild = currentChild;
                            currentChild = DomUtils.getNextElementSibling(currentChild);
                            if (currentChild != null) {
                                currentChildName = QualifiedName.getQualifiedName(currentChild.getNamespaceURI(), DomUtils.getLocalName(currentChild));
                                continue;
                            }
                            currentChildName = null;
                        }
                        if (particleMaxOccurs != -1 && matchingChildren.size() >= particleMaxOccurs || !flatParticle.accepts(keyQName)) continue;
                        if (matchingChildren.isEmpty()) {
                            if (currentChild == null) {
                                if (previousChild == null) {
                                    validPositions.add(DomPositionFactory.inside(parent));
                                    continue;
                                }
                                validPositions.add(DomPositionFactory.after(previousChild));
                                continue;
                            }
                            validPositions.add(DomPositionFactory.before(currentChild));
                            continue;
                        }
                        for (Node matchingChild : matchingChildren) {
                            validPositions.add(DomPositionFactory.before(matchingChild));
                            validPositions.add(DomPositionFactory.after(matchingChild));
                        }
                    }
                }
            } else {
                validPositions = Collections.emptySet();
            }
        }
        return validPositions;
    }

    public static DomPosition chooseBestPosition(ProspectiveValidationContext context, XmlKey keyToInsert, Node nodeToInsert, DomPosition requestedPosition, XmlKey containerKey, Set<DomPosition> validPositions) {
        DomPosition bestPosition = null;
        if (validPositions == null) {
            DomPosition posFromComparator = ProspectiveValidator._getPositionFromComparator(context, keyToInsert, nodeToInsert, requestedPosition, containerKey);
            bestPosition = posFromComparator != null ? posFromComparator : requestedPosition;
        } else if (!validPositions.isEmpty()) {
            DomPosition posFromComparator = ProspectiveValidator._getPositionFromComparator(context, keyToInsert, nodeToInsert, requestedPosition, containerKey);
            if (DomUtils.containsPositionOrEquivalent(DocumentTreeTraversal.INSTANCE, validPositions, posFromComparator)) {
                bestPosition = posFromComparator;
            } else if (DomUtils.containsPositionOrEquivalent(DocumentTreeTraversal.INSTANCE, validPositions, requestedPosition)) {
                bestPosition = requestedPosition;
            } else {
                Iterator<DomPosition> iter = validPositions.iterator();
                DomPosition lastPosition = null;
                while (iter.hasNext()) {
                    lastPosition = iter.next();
                }
                bestPosition = lastPosition;
            }
        }
        return bestPosition;
    }

    public static Node insertNodeAtValidPosition(ProspectiveValidationContext context, Node nodeToInsert, DomPosition requestedPosition) {
        if (context == null || nodeToInsert == null || requestedPosition == null) {
            throw new IllegalArgumentException("ProspectiveValidator: Null argument passed to insertNodeAtValidPosition()");
        }
        Set<DomPosition> validPositions = ProspectiveValidator.findValidInsertionPositions(context, null, nodeToInsert, requestedPosition, null);
        DomPosition bestPosition = ProspectiveValidator.chooseBestPosition(context, null, nodeToInsert, requestedPosition, null, validPositions);
        if (bestPosition != null) {
            DomUtils.insertNodeAtPosition(bestPosition, nodeToInsert);
            return nodeToInsert;
        }
        return null;
    }

    private static DomPosition _getPositionFromComparator(ProspectiveValidationContext context, XmlKey keyToInsert, Node nodeToInsert, DomPosition requestedPosition, XmlKey containerKey) {
        Comparator comparator;
        DomPosition computedPosition = null;
        Node parent = requestedPosition.getContainerNode();
        if ((parent != null || nodeToInsert != null) && (comparator = context.getInsertionComparator(parent)) != null) {
            computedPosition = DomUtils.getPositionFromComparator(parent, nodeToInsert, comparator);
        }
        return computedPosition;
    }

    private static FlattenedParticle _createFlattenedParticle(GrammarResolver resolver, Particle particle) {
        FlattenedParticle flattenedParticle = null;
        if (particle instanceof ElementDef) {
            ElementDef elementDef = (ElementDef)particle;
            flattenedParticle = new FlattenedElementDef(elementDef);
        } else if (particle instanceof Wildcard) {
            Wildcard wildcard = (Wildcard)particle;
            flattenedParticle = new FlattenedWildcard(resolver, wildcard);
        } else if (particle instanceof ContentGroup) {
            ContentGroup group = (ContentGroup)particle;
            flattenedParticle = new FlattenedContentGroup(resolver, group);
        }
        return flattenedParticle;
    }

    private static class FlattenedContentGroup
    extends FlattenedParticle {
        private List _flattenedParticles = null;
        private final GrammarResolver _resolver;
        private final ContentGroup _contentGroup;

        public FlattenedContentGroup(GrammarResolver resolver, ContentGroup contentGroup) {
            this._resolver = resolver;
            this._contentGroup = contentGroup;
        }

        public int getVariety() {
            return this._contentGroup.getVariety();
        }

        public boolean accepts(QualifiedName elementQName) {
            List flatParticles = this.getFlattenedParticles();
            Iterator iter = flatParticles.iterator();
            FlattenedParticle flatParticle = null;
            while (iter.hasNext()) {
                flatParticle = (FlattenedParticle)iter.next();
                if (!flatParticle.accepts(elementQName)) continue;
                return true;
            }
            return false;
        }

        public int getMaxOccurs() {
            List flatParticles = this.getFlattenedParticles();
            if (this._contentGroup.getMaxOccurs() != -1) {
                boolean isChoice;
                Iterator itr_p = flatParticles.iterator();
                int maxOccurs = 0;
                boolean bl = isChoice = this._contentGroup.getVariety() == 8;
                while (itr_p.hasNext()) {
                    FlattenedParticle flatParticle = (FlattenedParticle)itr_p.next();
                    int particleMaxOccurs = flatParticle.getMaxOccurs();
                    if (particleMaxOccurs == -1) {
                        return -1;
                    }
                    if (isChoice) {
                        if (particleMaxOccurs <= maxOccurs) continue;
                        maxOccurs = particleMaxOccurs;
                        continue;
                    }
                    maxOccurs += particleMaxOccurs;
                }
                return maxOccurs * this._contentGroup.getMaxOccurs();
            }
            return -1;
        }

        public List getFlattenedParticles() {
            if (this._flattenedParticles == null) {
                this._flattenedParticles = new ArrayList();
                Collection particles = this._contentGroup.getComponents();
                if (particles != null) {
                    for (Object object : particles) {
                        Particle particle;
                        FlattenedParticle flatParticle;
                        if (!(object instanceof Particle) || (flatParticle = ProspectiveValidator._createFlattenedParticle(this._resolver, particle = (Particle)object)) == null) continue;
                        if (this.getVariety() == 9 && flatParticle instanceof FlattenedContentGroup) {
                            FlattenedContentGroup flatGroup = (FlattenedContentGroup)flatParticle;
                            if (flatGroup.getVariety() == 9) {
                                this._flattenedParticles.addAll(flatGroup.getFlattenedParticles());
                                continue;
                            }
                            this._flattenedParticles.add(flatGroup);
                            continue;
                        }
                        this._flattenedParticles.add(flatParticle);
                    }
                }
            }
            return this._flattenedParticles;
        }
    }

    private static class FlattenedWildcard
    extends FlattenedParticle {
        private final GrammarResolver _resolver;
        private final Wildcard _wildcard;

        public FlattenedWildcard(GrammarResolver resolver, Wildcard wildcard) {
            this._resolver = resolver;
            this._wildcard = wildcard;
        }

        public boolean accepts(QualifiedName elementQName) {
            String namespace = elementQName.getNamespace();
            if (TypeUtils.wildcardAllowsNamespace(this._wildcard, namespace)) {
                if (this._wildcard.getProcessingRule() == 0) {
                    Grammar g = this._resolver.getGrammarForNamespace(namespace);
                    if (g != null && g.getElementDefByName(elementQName.getName()) != null) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        public int getMaxOccurs() {
            return this._wildcard.getMaxOccurs();
        }
    }

    private static class FlattenedElementDef
    extends FlattenedParticle {
        private final ElementDef _elementDef;
        private final SubstitutionGroup _substGroup;

        public FlattenedElementDef(ElementDef elementDef) {
            this._elementDef = elementDef;
            this._substGroup = elementDef.getSubstitutionGroup();
        }

        public boolean accepts(QualifiedName elementQName) {
            return this._elementDef.getQualifiedName().equals(elementQName) ? !this._elementDef.isAbstract() : this._substGroup != null && this._substGroup.getElementDefByName(elementQName) != null;
        }

        public int getMaxOccurs() {
            return this._elementDef.getMaxOccurs();
        }
    }

    private static abstract class FlattenedParticle {
        private FlattenedParticle() {
        }

        public abstract boolean accepts(QualifiedName var1);

        public abstract int getMaxOccurs();
    }
}

