/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.functions;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunction;

public class MethodFunction
implements MetadataFunction {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata.MetadataEvaluator");
    private String _className;
    private String _nameAndSig;
    private Method _method;
    private boolean _isMacro;

    public MethodFunction(String className, String nameAndSig, boolean isMacro) {
        this._className = className;
        this._nameAndSig = nameAndSig;
        this._isMacro = isMacro;
    }

    public Object evaluate(Map implicitObjects, Object[] args) throws MetadataException {
        try {
            return this._getJavaMethod().invoke(null, args);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Unable to evaluate MethodFunction: class " + this._className + " nameAndSig " + this._nameAndSig + "\n" + e.getMessage(), e.getCause());
            throw new MetadataException(e.getMessage(), e);
        }
    }

    public Class[] getArgumentTypes() {
        try {
            return this._getJavaMethod().getParameterTypes();
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Unable to getArgTypes MethodFunction: class " + this._className + " nameAndSig" + this._nameAndSig + "\n" + e.getMessage(), e);
            return null;
        }
    }

    public Class getReturnType() {
        try {
            return this._getJavaMethod().getReturnType();
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Unable to getReturnType MethodFunction: class " + this._className + " nameAndSig" + this._nameAndSig + "\n" + e.getMessage());
            return null;
        }
    }

    public boolean isMacro() {
        return this._isMacro;
    }

    private Method _getJavaMethod() throws ClassNotFoundException, NoSuchMethodException {
        Class methodClass;
        if (this._method == null && (methodClass = ClassLoaderUtils.loadClass((String)this._className)) != null) {
            String name = null;
            Class[] argTypes = null;
            int parenIndex = this._nameAndSig.indexOf(40);
            if (parenIndex != -1) {
                String[] types;
                name = this._nameAndSig.substring(0, parenIndex);
                String sigString = this._nameAndSig.substring(parenIndex + 1, this._nameAndSig.length() - 1);
                if (sigString != null && !"".equals(sigString) && (types = sigString.split(",")) != null) {
                    argTypes = new Class[types.length];
                    for (int i = 0; i < types.length; ++i) {
                        String type = types[i].trim();
                        if (Character.isUpperCase(type.charAt(0))) {
                            type = "java.lang." + type;
                        }
                        argTypes[i] = ClassLoaderUtils.loadClass((String)type);
                    }
                }
            } else {
                name = this._nameAndSig;
            }
            this._method = methodClass.getMethod(name, argTypes);
        }
        return this._method;
    }
}

