/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.functions.MethodFunction;

public class MetadataFunctionRegistry {
    private final ConcurrentHashMap<String, MetadataFunctionItem> _functionItemMap = new ConcurrentHashMap();
    private static final Logger _LOGGER = Logger.getLogger(MetadataFunctionRegistry.class.getName());

    public void registerMethod(String qname, String className, String nameAndSig, boolean isMacro) {
        this._functionItemMap.put(qname, new MetadataFunctionItem(className, nameAndSig, isMacro));
    }

    public void registerInstanceFunction(String qname, String className) {
        this._functionItemMap.put(qname, new MetadataFunctionItem(className));
    }

    public void unregisterFunction(String qname) {
        this._functionItemMap.remove(qname);
    }

    public MetadataFunction getFunction(String prefix, String name) {
        assert (prefix != null);
        assert (name != null);
        MetadataFunctionItem metadataFunctionItem = this._functionItemMap.get(prefix + ":" + name);
        if (metadataFunctionItem == null) {
            return null;
        }
        return metadataFunctionItem.getMetadataFunction();
    }

    private class MetadataFunctionItem {
        private boolean _isMethodFunction;
        private String _className;
        private String _nameAndSig;
        private boolean _isMacro;
        private WeakReference<MetadataFunction> _weakReferenceMetadataFunction;

        public MetadataFunctionItem(String className, String nameAndSig, boolean isMacro) {
            this._isMethodFunction = true;
            this._className = className;
            this._nameAndSig = nameAndSig;
            this._isMacro = isMacro;
        }

        public MetadataFunctionItem(String className) {
            this._isMethodFunction = false;
            this._className = className;
        }

        public MetadataFunction getMetadataFunction() {
            MetadataFunction metadataFunction = null;
            if (this._weakReferenceMetadataFunction != null && (metadataFunction = (MetadataFunction)this._weakReferenceMetadataFunction.get()) != null) {
                return metadataFunction;
            }
            if (this._isMethodFunction) {
                metadataFunction = new MethodFunction(this._className, this._nameAndSig, this._isMacro);
                this._weakReferenceMetadataFunction = new WeakReference<MetadataFunction>(metadataFunction);
            } else {
                try {
                    Class clazz = ClassLoaderUtils.loadClass((String)this._className);
                    Object instance = clazz.newInstance();
                    if (instance instanceof MetadataFunction) {
                        metadataFunction = (MetadataFunction)instance;
                        this._weakReferenceMetadataFunction = new WeakReference<MetadataFunction>(metadataFunction);
                    }
                }
                catch (Exception e) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Exception creating object for instance metadata function; classname={0}");
                    lr.setThrown(e);
                    lr.setParameters(new Object[]{this._className});
                    _LOGGER.log(lr);
                }
            }
            return metadataFunction;
        }
    }
}

