/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.LayeredMetadataEvaluator;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.metadata.MetadataValueConverter;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.Expression;
import oracle.bali.xml.metadata.el.Function;
import oracle.bali.xml.metadata.el.PropertyResolver;
import oracle.bali.xml.metadata.el.PropertyResolverProxy;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.DefaultPropertyResolver;
import oracle.bali.xml.metadata.el.parser.ExpressionParser;
import oracle.bali.xml.metadata.el.parser.ExpressionParserFactory;
import oracle.bali.xml.metadata.el.parser.FunctionMapper;
import oracle.bali.xml.metadata.structured.MutableStructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataConverter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreMetadataEvaluator
extends LayeredMetadataEvaluator {
    private final MetadataProvider _provider;
    private final GrammarResolver _grammarResolver;
    private final MetadataProvider _metadataLanguageProvider;
    private final GrammarResolver _metadataLanguageGrammarResolver;
    private final Map _implicitObjects;
    private final MetadataValueConverter _converter;
    private final BaliElEvaluator _elEvaluator;
    private static final QualifiedName _PREFERRED_PREFIX = QualifiedName.getQualifiedName("http://xmlns.oracle.com/bali/xml/metadata", "preferredPrefix");
    private static final Set<Class<?>> _TYPES_EL_SUPPORTS = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Integer.class, Float.class, Double.class, Number.class, Short.class, Long.class, Byte.class, Character.class));

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver) {
        this(provider, grammarResolver, null);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver, MetadataEvaluator base) {
        this(provider, grammarResolver, base, Locale.getDefault());
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver, MetadataEvaluator base, Locale locale) {
        this(provider, grammarResolver, MetadataSchemaRegistry.getInstance().getMetadataProvider(), MetadataSchemaRegistry.getInstance().getMetadataGrammarResolver(), base, locale);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver, MetadataProvider metadataLanguageProvider, GrammarResolver metadataLanguageGrammarResolver, MetadataEvaluator base, Locale locale) {
        super(base);
        if (provider == null) {
            throw new IllegalArgumentException("MetadataProvider must not be null");
        }
        if (grammarResolver == null) {
            throw new IllegalArgumentException("GrammarResolver must not be null");
        }
        if (metadataLanguageProvider == null) {
            throw new IllegalArgumentException("metadataLanguageProvider must not be null");
        }
        if (metadataLanguageGrammarResolver == null) {
            throw new IllegalArgumentException("metadataLanguageGrammarResolver must not be null");
        }
        this._provider = provider;
        this._grammarResolver = grammarResolver;
        this._metadataLanguageProvider = metadataLanguageProvider;
        this._metadataLanguageGrammarResolver = metadataLanguageGrammarResolver;
        this._implicitObjects = new HashMap();
        this._implicitObjects.put("evaluator", this);
        this._implicitObjects.put("provider", provider);
        this._implicitObjects.put("locale", locale);
        this._converter = new MetadataValueConverter(this._metadataLanguageGrammarResolver);
        this._elEvaluator = new BaliElEvaluator();
    }

    @Override
    protected Collection getLayerPseudoXmlKeys(Object masterKey) {
        return this._provider.getPseudoXmlKeys(masterKey);
    }

    @Override
    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        List<StructuredMetadataBean> beans = this._provider.getGlobalMetadata(globalItemName);
        ArrayList<StructuredMetadataBean> convertedBeans = new ArrayList<StructuredMetadataBean>();
        for (StructuredMetadataBean bean : beans) {
            NamespaceStructuredMetadataConverter converter = new NamespaceStructuredMetadataConverter(bean.getOwnerNS());
            convertedBeans.add(converter.convertStructuredMetadataBean(bean, null));
        }
        return convertedBeans;
    }

    @Override
    protected LayeredMetadataEvaluator.MetadataInfo getLayerMetadataInfo(Object key, Object itemKey, Node node) {
        LayeredMetadataEvaluator.MetadataInfo info = null;
        try {
            Object metadata;
            HashMap<String, Object> additionalObjects = new HashMap<String, Object>();
            additionalObjects.put("node", node);
            additionalObjects.put("key", key);
            additionalObjects.put("itemKey", itemKey);
            Class expectedType = this._converter.getExpectedMetadataType(itemKey);
            Class elSupportedType = Object.class;
            if (_TYPES_EL_SUPPORTS.contains(expectedType)) {
                elSupportedType = expectedType;
            }
            if ((metadata = this.getMetadataProvider().getMetadataItem(key, itemKey)) != null) {
                if (metadata instanceof String) {
                    String value = (String)metadata;
                    if (value.length() > 0 && (info = this.evaluateValue(value, elSupportedType, additionalObjects)) != null) {
                        info.value = this._converter.coerceMetadataValue(info.value, itemKey);
                    }
                } else if (expectedType.isInstance(metadata)) {
                    info = new LayeredMetadataEvaluator.MetadataInfo(this, metadata, 0);
                } else {
                    this.getLogger().log(Level.WARNING, "Metadata for key " + key + ", item key " + itemKey + ", node " + node + "is not of expected type: " + expectedType);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error getting metadata for key " + key + ", item key " + itemKey + ", node " + node, e);
        }
        return info;
    }

    protected LayeredMetadataEvaluator.MetadataInfo evaluateValue(String value, Class expectedType, Map additionalObjects) throws MetadataException {
        return this._elEvaluator.evaluateValue(value, expectedType, additionalObjects);
    }

    protected MetadataProvider getMetadataProvider() {
        return this._provider;
    }

    protected Map getImplicitObjects() {
        return this._implicitObjects;
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider) {
        this(provider, grammarProvider, null);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider, MetadataEvaluator base) {
        this(provider, grammarProvider, base, Locale.getDefault());
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider, MetadataEvaluator base, Locale locale) {
        this(provider, grammarProvider, MetadataSchemaRegistry.getInstance().getMetadataProvider(), MetadataSchemaRegistry.getInstance().getMetadataGrammars(), base, locale);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider, MetadataProvider metadataLanguageProvider, GrammarProvider metadataLanguageGrammarProvider, MetadataEvaluator base, Locale locale) {
        this(provider, new GrammarResolver(grammarProvider), metadataLanguageProvider, new GrammarResolver(metadataLanguageGrammarProvider), base, locale);
    }

    private static class VariableResolverMap
    extends BaseMap {
        private final VariableResolver _resolver;

        public VariableResolverMap(VariableResolver resolver) {
            this._resolver = resolver;
        }

        public int size() {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        public Object get(Object key) {
            if (key instanceof String) {
                return this._resolver.resolveVariable((String)key);
            }
            return null;
        }
    }

    private static abstract class BaseMap
    implements Map {
        private BaseMap() {
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void clear() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Set keySet() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Collection values() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static class NamedNodeJavaMap
    extends BaseMap {
        private final NamedNodeMap _nodeMap;

        public NamedNodeJavaMap(NamedNodeMap nodeMap) {
            this._nodeMap = nodeMap;
        }

        public int size() {
            return this._nodeMap.getLength();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean containsKey(Object key) {
            if (key instanceof String) {
                return this._nodeMap.getNamedItem((String)key) != null;
            }
            return false;
        }

        public Object get(Object key) {
            Node node;
            if (key instanceof String && (node = this._nodeMap.getNamedItemNS(null, (String)key)) != null) {
                return node.getNodeValue();
            }
            return null;
        }
    }

    private class NamespaceStructuredMetadataConverter
    extends StructuredMetadataConverter {
        private final XmlKey _ownerNSKey;

        public NamespaceStructuredMetadataConverter(XmlKey ownerNSKey) {
            this._ownerNSKey = ownerNSKey;
        }

        public void addProperty(MutableStructuredMetadataBean bean, QualifiedName propertyName, String value) {
            bean.addProperty(propertyName, this.convertValue(value));
        }

        public void setBeanTextValue(MutableStructuredMetadataBean bean, String beanTextValue) {
            bean.setValue(this.convertValue(beanTextValue));
        }

        private String convertValue(String value) {
            try {
                LayeredMetadataEvaluator.MetadataInfo info;
                HashMap<String, XmlKey> additionalObjects = new HashMap<String, XmlKey>();
                additionalObjects.put("ownerNS", this._ownerNSKey);
                if (value != null && value.length() > 0 && (info = CoreMetadataEvaluator.this.evaluateValue(value, String.class, additionalObjects)) != null) {
                    return (String)info.value;
                }
            }
            catch (Exception e) {
                CoreMetadataEvaluator.this.getLogger().log(Level.WARNING, "Error converting value,  " + value, e);
            }
            return value;
        }
    }

    private class BaliElEvaluator {
        private final ExpressionParser _parser;
        private final FunctionMapper _fmapper;
        private final PropertyResolver _presolver;
        private final Map<String, Expression> _exprMap = new HashMap<String, Expression>();

        public BaliElEvaluator() {
            this._parser = ExpressionParserFactory.newInstance().newExpressionParser();
            this._fmapper = new MetadataFunctionMapper();
            this._presolver = new MetadataPropertyResolver();
        }

        public LayeredMetadataEvaluator.MetadataInfo evaluateValue(String value, Class expectedType, Map additionalObjects) throws MetadataException {
            try {
                value = value.replace('$', '#');
                Expression expr = this._exprMap.get(value);
                HashMap evaluationObjects = new HashMap(CoreMetadataEvaluator.this.getImplicitObjects());
                evaluationObjects.putAll(additionalObjects);
                MetadataVariableResolver vresolver = new MetadataVariableResolver(evaluationObjects);
                int cacheType = 0;
                if (expr == null) {
                    expr = this._parser.parseExpression(value, expectedType, this._fmapper, this._presolver, vresolver);
                    int n = cacheType = expr.isConstant() ? 1 : 0;
                    if (cacheType == 0) {
                        this._exprMap.put(value, expr);
                    }
                }
                Object metadataValue = expr.getValue(vresolver);
                return new LayeredMetadataEvaluator.MetadataInfo(CoreMetadataEvaluator.this, metadataValue, cacheType);
            }
            catch (ELException e) {
                CoreMetadataEvaluator.this.getLogger().log(Level.WARNING, e.getMessage(), e);
                throw new MetadataException(e.getMessage(), e);
            }
        }

        private class MetadataPropertyResolver
        extends PropertyResolverProxy {
            private PropertyResolver _presolver = DefaultPropertyResolver.sharedInstance();

            private MetadataPropertyResolver() {
            }

            protected PropertyResolver getPropertyResolver() {
                return this._presolver;
            }

            public Object getValue(Object base, String name) throws ELException {
                if ("attr".equals(name) && base instanceof Node) {
                    return new NamedNodeJavaMap(((Node)base).getAttributes());
                }
                return super.getValue(base, name);
            }
        }

        private class MetadataVariableResolver
        implements VariableResolver {
            private Map _evaluationObjects;

            public MetadataVariableResolver(Map evaluationObjects) {
                this._evaluationObjects = evaluationObjects;
            }

            public Object resolveVariable(String name) {
                return this._evaluationObjects.get(name);
            }
        }

        private class MetadataFunctionAdapter
        extends Function {
            private MetadataFunction _function;

            public MetadataFunctionAdapter(MetadataFunction function) {
                this._function = function;
            }

            public Object evaluate(VariableResolver vresolver, Object[] args) {
                try {
                    return this._function.evaluate(new VariableResolverMap(vresolver), args);
                }
                catch (MetadataException e) {
                    CoreMetadataEvaluator.this.getLogger().log(Level.WARNING, e.getMessage());
                    throw new ELException(e);
                }
            }

            public Class[] getArgumentTypes() {
                return this._function.getArgumentTypes();
            }

            public Class getReturnType() {
                return this._function.getReturnType();
            }

            public boolean isMacro() {
                return this._function.isMacro();
            }
        }

        private class MetadataFunctionMapper
        implements FunctionMapper {
            private Map<String, Function> _functionMap = new HashMap<String, Function>();

            private MetadataFunctionMapper() {
            }

            public Function resolveFunction(String prefix, String name) {
                String qname = prefix + ":" + name;
                Function elFunction = this._functionMap.get(qname);
                if (elFunction == null) {
                    Object metadataFunction = null;
                    metadataFunction = CoreMetadataEvaluator.this.getMetadataProvider().getFunction(prefix, name);
                    if (!(metadataFunction instanceof MetadataFunction)) {
                        metadataFunction = CoreMetadataEvaluator.this._metadataLanguageProvider.getFunction(prefix, name);
                    }
                    if (metadataFunction instanceof MetadataFunction) {
                        elFunction = new MetadataFunctionAdapter((MetadataFunction)metadataFunction);
                        this._functionMap.put(qname, elFunction);
                    } else {
                        CoreMetadataEvaluator.this.getLogger().log(Level.WARNING, "function {0} not found or of wrong type. Got: {1}", new Object[]{qname, metadataFunction});
                    }
                }
                return elFunction;
            }
        }
    }
}

