/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private static final QualifiedName _TYPE_ID = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "ID");
    private static final QualifiedName _TYPE_IDREF = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "IDREF");
    private static final QualifiedName _TYPE_IDREFS = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "IDREFS");

    public static boolean isElementDefOfType(ElementDef elementDef, String typeNamespace, String typeName) {
        QualifiedName[] types = new QualifiedName[]{QualifiedName.getQualifiedName(typeNamespace, typeName)};
        return TypeUtils.matchElementDefToType(elementDef, types) == 0;
    }

    public static int matchElementDefToType(ElementDef elementDef, QualifiedName[] types) {
        if (elementDef != null && types != null & types.length > 0) {
            Type currentType = elementDef.getType();
            while (currentType != null) {
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].getName().equals(currentType.getName()) || !types[i].getNamespace().equals(currentType.getTargetNamespace())) continue;
                    return i;
                }
                if (currentType instanceof ComplexType) {
                    ComplexType complexType = (ComplexType)currentType;
                    Type newType = complexType.getBaseType();
                    if (currentType == newType) break;
                    currentType = newType;
                    continue;
                }
                currentType = null;
            }
        }
        return -1;
    }

    public static boolean isSimpleTypeElement(GrammarComponent grammarComponent) {
        if (grammarComponent instanceof ElementDef) {
            ElementDef ed = (ElementDef)grammarComponent;
            Type t = ed.getType();
            return t.getVariety() == 0 || t.getVariety() == 1 || t.getVariety() == 2;
        }
        return false;
    }

    public static boolean isSimpleTypeOrComplexTextOnlyElement(GrammarComponent grammarComponent) {
        if (grammarComponent instanceof ElementDef) {
            ElementDef ed = (ElementDef)grammarComponent;
            Type t = ed.getType();
            return t.getVariety() == 0 || t.getVariety() == 1 || t.getVariety() == 2 || t.getVariety() == 5;
        }
        return false;
    }

    public static SimpleType getSimpleTypeAncestor(Type type) {
        while (type != null) {
            if (type instanceof SimpleType) {
                return (SimpleType)type;
            }
            if (!(type instanceof ComplexType)) break;
            type = ((ComplexType)type).getBaseType();
        }
        return null;
    }

    public static ConstrainingFacet findFacet(SimpleType simple, int facetId) {
        Collection facets = simple.getConstrainingFacets();
        if (facets != null) {
            for (ConstrainingFacet facet : facets) {
                if (facet.getFacetID() != facetId) continue;
                return facet;
            }
        }
        return null;
    }

    public static List getElementWildcards(ElementDef elementDef) {
        Type type = elementDef.getType();
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            return TypeUtils.getElementWildcards(complexType);
        }
        return Collections.EMPTY_LIST;
    }

    public static List getElementWildcards(ComplexType complexType) {
        ArrayList wildcards = new ArrayList();
        if (complexType != null) {
            ContentGroup group = complexType.getContentGroup();
            TypeUtils._addGroupWildcards(group, wildcards);
        }
        return wildcards;
    }

    public static Wildcard getMatchingWildcard(List wildcards, String namespace) {
        Wildcard match = null;
        if (wildcards != null) {
            for (Wildcard wildcard : wildcards) {
                if (!TypeUtils.wildcardAllowsNamespace(wildcard, namespace)) continue;
                match = wildcard;
                break;
            }
        }
        return match;
    }

    public static List<Grammar> getAllowableGrammars(GrammarProvider gp, List wildcards) {
        ArrayList<Grammar> allowableGs = new ArrayList<Grammar>();
        Collection grammars = gp.getGrammars();
        for (Grammar g : grammars) {
            if (!TypeUtils.wildcardsAllowNamespace(wildcards, g.getTargetNamespace())) continue;
            allowableGs.add(g);
        }
        return Collections.unmodifiableList(allowableGs);
    }

    public static boolean wildcardsAllowNamespace(List wildcards, String namespace) {
        for (Wildcard wc : wildcards) {
            if (!TypeUtils.wildcardAllowsNamespace(wc, namespace)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardAllowsNamespace(Wildcard wildcard, String namespace) {
        boolean allows = false;
        switch (wildcard.getVariety()) {
            case 0: {
                allows = true;
                break;
            }
            case 1: {
                String targetNamespace;
                if (namespace == null || namespace.equals(targetNamespace = wildcard.getTargetNamespace())) break;
                allows = true;
                break;
            }
            case 2: {
                List namespaceList = wildcard.getNamespaceConstraintList();
                if (!namespaceList.contains(namespace)) break;
                allows = true;
                break;
            }
        }
        return allows;
    }

    public static boolean isIdType(SimpleType simpleType) {
        return TypeUtils.instanceOfBuiltInType(simpleType, _TYPE_ID);
    }

    public static boolean isIdRefType(SimpleType simpleType) {
        return TypeUtils.instanceOfBuiltInType(simpleType, _TYPE_IDREF);
    }

    public static boolean isIdRefsType(SimpleType simpleType) {
        return TypeUtils.instanceOfBuiltInType(simpleType, _TYPE_IDREFS);
    }

    public static boolean instanceOfBuiltInType(SimpleType simpleType, QualifiedName typeName) {
        QualifiedName qName;
        String localName;
        boolean matches = false;
        SimpleType builtInType = simpleType.getBuiltInBaseType();
        if (builtInType != null && (localName = builtInType.getName()) != null && (qName = QualifiedName.getQualifiedName(builtInType.getTargetNamespace(), localName)).equals(typeName)) {
            matches = true;
        }
        return matches;
    }

    public static void printContentGroup(ContentGroup group) {
        int variety = group.getVariety();
        String varietyString = "UNKNOWN-GROUP";
        if (variety == 7) {
            varietyString = "ALL";
        } else if (variety == 8) {
            varietyString = "CHOICE";
        } else if (variety == 9) {
            varietyString = "SEQUENCE";
        }
        System.out.println("<" + varietyString + ">");
        Collection grammarComponents = group.getComponents();
        for (GrammarComponent component : grammarComponents) {
            if (component instanceof ContentGroup) {
                TypeUtils.printContentGroup((ContentGroup)component);
                continue;
            }
            if (component instanceof Wildcard) {
                System.out.println("WILDCARD");
                continue;
            }
            if (component instanceof ElementDef) {
                ElementDef def = (ElementDef)component;
                System.out.println(def.getQualifiedName().getQualifiedName());
                continue;
            }
            System.out.println("UNKNOWN PARTICLE");
        }
        System.out.println("</" + varietyString + ">");
    }

    private static void _addGroupWildcards(ContentGroup group, List wildcards) {
        Collection groupComponents;
        if (group != null && (groupComponents = group.getComponents()) != null) {
            for (GrammarComponent component : groupComponents) {
                if (component instanceof Wildcard) {
                    Wildcard wildcard = (Wildcard)component;
                    wildcards.add(wildcard);
                    continue;
                }
                if (!(component instanceof ContentGroup)) continue;
                ContentGroup subGroup = (ContentGroup)component;
                TypeUtils._addGroupWildcards(subGroup, wildcards);
            }
        }
    }

    private TypeUtils() {
    }
}

