/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.PrefixName;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.grammar.util.SimpleTypeValueProvider;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.util.XmlNameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeManager {
    private static JavaTypeManager _typeManager = null;
    private static final Logger _LOGGER = Logger.getLogger(JavaTypeManager.class.getName());
    private final Object _classLoaderMapLock = new Object();
    private final ConcurrentHashMap<QualifiedName, SimpleTypeConverter> _typeConverterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<QualifiedName, String> _externallyRegisteredTypeConverterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<QualifiedName, SimpleTypeValueProvider> _simpleTypeValueProvider;
    private final WeakHashMap<ClassLoader, ConcurrentHashMap<QualifiedName, WeakReference<SimpleTypeConverter>>> _classLoaderToExternalTypeConverterMap = new WeakHashMap();

    public static JavaTypeManager getInstance() {
        if (_typeManager == null) {
            _typeManager = new JavaTypeManager();
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "string", new StringSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "string", new StringValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "boolean", new BooleanSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "boolean", new BooleanValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "decimal", new DecimalSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "decimal", new DecimalValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "float", new FloatSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "float", new FloatValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "double", new DoubleSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "double", new DoubleValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "integer", new IntegerSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "integer", new IntegerValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "long", new LongSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "long", new LongValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "unsignedInt", new IntSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "unsignedInt", new IntValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "int", new IntSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "int", new IntValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "short", new ShortSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "short", new ShortValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "byte", new ByteSimpleTypeConverter());
            _typeManager.registerSimpleTypeValueProvider("http://www.w3.org/2001/XMLSchema", "byte", new ByteValueProvider());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "anyURI", new AnyUriSimpleTypeConverter());
            _typeManager._registerInternalSimpleTypeConverter("http://www.w3.org/2001/XMLSchema", "QName", new QNameSimpleTypeConverter());
            _typeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASS, new JavaClassConverter());
            _typeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSINSTANCE, new JavaClassInstanceConverter());
            _typeManager._registerInternalSimpleTypeConverter(XmlMetadataConstants.TYPE_JAVACLASSORDIRECTOBJECT, new JavaClassOrDirectObjectConverter());
        }
        return _typeManager;
    }

    public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
        Object javaObject = value;
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() simpleType parameter cannot be null");
        }
        if (value == null) {
            throw new GrammarException("JavaTypeManager:convertToJavaType() value parameter cannot be null");
        }
        if (simpleType.getVariety() == 0) {
            SimpleTypeConverter converter = this.findBestMatch(simpleType, this._typeConverterMap, true);
            if (converter != null) {
                javaObject = converter.convertToJavaType(value, simpleType);
            }
        } else if (simpleType.getVariety() == 1) {
            javaObject = this._handleListVariety(value, simpleType);
        } else if (simpleType.getVariety() == 2) {
            javaObject = value;
        } else {
            throw new GrammarException("JavaTypeManager:convertToJavaType() does not currently support union variety simpleTypes");
        }
        return javaObject;
    }

    public Class getJavaClass(SimpleType simpleType) throws GrammarException {
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager:getJavaClass() type parameter cannot be null");
        }
        Class javaClass = String.class;
        if (simpleType.getVariety() == 0) {
            SimpleTypeConverter converter = this.findBestMatch(simpleType, this._typeConverterMap, true);
            if (converter != null) {
                javaClass = converter.getJavaClass(simpleType);
            }
        } else if (simpleType.getVariety() == 1) {
            javaClass = List.class;
        } else if (simpleType.getVariety() == 2) {
            javaClass = String.class;
        } else {
            throw new GrammarException("JavaTypeManager:convertToJavaType() does not currently support union variety simpleTypes");
        }
        return javaClass;
    }

    public String convertToString(Object javaType, SimpleType simpleType) throws GrammarException {
        if (javaType == null) {
            throw new IllegalArgumentException("JavaTypeManager.covnertToString(): javaType parameter cannot be null");
        }
        if (simpleType == null) {
            throw new GrammarException("JavaTypeManager.covnertToString(): simpleType parameter cannot be null");
        }
        String s = javaType.toString();
        if (simpleType.getVariety() == 0) {
            SimpleTypeConverter converter = this.findBestMatch(simpleType, this._typeConverterMap, true);
            if (converter != null) {
                s = converter.convertToString(javaType, simpleType);
            }
        } else if (simpleType.getVariety() == 1) {
            s = this._handleListVarietyStringRepresentation(javaType, simpleType);
        } else if (simpleType.getVariety() != 2) {
            throw new GrammarException("JavaTypeManager.covnertToString(): unsupported SimpleType encountered.");
        }
        return s;
    }

    public String getSimpleTypeValue(SimpleType type) {
        if (type == null) {
            throw new IllegalArgumentException("JavaTypeManager:getSimpleTypeValue() type parameter cannot be null");
        }
        SimpleTypeValueProvider provider = this.findBestMatch(type, this._simpleTypeValueProvider, false);
        if (provider != null) {
            return provider.createNewValue(type);
        }
        return null;
    }

    public void registerSimpleTypeConverter(String namespace, String simpleTypeName, SimpleTypeConverter converter) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeConverter(qName, converter);
    }

    public void registerSimpleTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        if (simpleTypeName != null && converter != null) {
            this._typeConverterMap.put(simpleTypeName, converter);
        }
    }

    public void registerSimpleTypeConverter(String namespace, String simpleTypeName, String converterClassName) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeConverter(qName, converterClassName);
    }

    public void registerSimpleTypeConverter(QualifiedName simpleTypeName, String converterClassName) {
        if (simpleTypeName != null && converterClassName != null) {
            this._externallyRegisteredTypeConverterMap.put(simpleTypeName, converterClassName);
        }
    }

    public final void registerSimpleTypeValueProvider(String namespace, String simpleTypeName, SimpleTypeValueProvider provider) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this.registerSimpleTypeValueProvider(qName, provider);
    }

    public void registerSimpleTypeValueProvider(QualifiedName simpleTypeName, SimpleTypeValueProvider provider) {
        if (simpleTypeName != null) {
            this._simpleTypeValueProvider.put(simpleTypeName, provider);
        }
    }

    private List _handleListVariety(String value, SimpleType simpleType) throws GrammarException {
        SimpleType listItemType;
        SimpleTypeConverter itemConverter;
        ArrayList<Object> list = new ArrayList<Object>(3);
        if (value != null && (itemConverter = this._getConverterForListItem(listItemType = simpleType.getListItemType())) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                String item = tokenizer.nextToken();
                Object javaObject = item;
                javaObject = itemConverter.convertToJavaType(item, listItemType);
                list.add(javaObject);
            }
        }
        return list;
    }

    private String _handleListVarietyStringRepresentation(Object javaType, SimpleType simpleType) throws GrammarException {
        List l;
        StringBuilder sb = new StringBuilder(3);
        SimpleType listItemType = simpleType.getListItemType();
        SimpleTypeConverter itemConverter = this._getConverterForListItem(listItemType);
        if (itemConverter != null && (l = JavaTypeManager._as(List.class, javaType)) != null) {
            for (Object o : l) {
                String s = itemConverter.convertToString(o, listItemType);
                if (s == null) continue;
                sb.append(s);
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }

    private SimpleTypeConverter _getConverterForListItem(SimpleType simpleType) {
        if (simpleType != null) {
            return this.findBestMatch(simpleType, this._typeConverterMap, true);
        }
        return null;
    }

    public <T> T findBestMatch(SimpleType simpleType, ConcurrentHashMap<QualifiedName, T> search, boolean findTypeConverter) {
        T o = this._getExactMatch(simpleType, search, findTypeConverter);
        if (o == null && (o = this._getExactMatch(simpleType.getBuiltInBaseType(), search, findTypeConverter)) == null) {
            o = this._getExactMatch(simpleType.getPrimitiveType(), search, findTypeConverter);
        }
        return o;
    }

    private <T> T _getExactMatch(SimpleType simpleType, ConcurrentHashMap<QualifiedName, T> search, boolean findTypeConverter) {
        String simpleName;
        SimpleTypeConverter o = null;
        if (simpleType != null && (simpleName = simpleType.getName()) != null && simpleName.length() > 0 && XmlNameUtils.isValidName(simpleName)) {
            QualifiedName key;
            String typeNamespace = simpleType.getTargetNamespace();
            if ("string".equals(simpleName)) {
                typeNamespace = "http://www.w3.org/2001/XMLSchema";
            }
            if ("boolean".equals(simpleName)) {
                typeNamespace = "http://www.w3.org/2001/XMLSchema";
            }
            if ((o = (SimpleTypeConverter)search.get(key = QualifiedName.getQualifiedName(typeNamespace, simpleName))) == null && findTypeConverter && (o = this._checkForCachedExternallyRegisteredTypeConverter(key)) == null && (o = this._getExternallyRegisteredTypeConverter(key)) != null) {
                this._registerExternalTypeConverter(key, o);
            }
        }
        return (T)o;
    }

    private SimpleTypeConverter _getExternallyRegisteredTypeConverter(QualifiedName key) {
        SimpleTypeConverter o = null;
        String className = this._externallyRegisteredTypeConverterMap.get(key);
        if (className != null) {
            try {
                Class c = ClassLoaderUtils.loadClass((String)className);
                if (c != null) {
                    o = (SimpleTypeConverter)c.newInstance();
                }
            }
            catch (ClassNotFoundException cnfe) {
                _LOGGER.log(Level.WARNING, "JavaTypeManager._getExternallyRegisteredTypeConverter - ClassNotFoundException: {0}", cnfe);
            }
            catch (IllegalAccessException iae) {
                _LOGGER.log(Level.WARNING, "JavaTypeManager._getExternallyRegisteredTypeConverter - IllegalAccessException: {0}", iae);
            }
            catch (InstantiationException ie) {
                _LOGGER.log(Level.WARNING, "JavaTypeManager._getExternallyRegisteredTypeConverter - InstantiationException: {0}", ie);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleTypeConverter _checkForCachedExternallyRegisteredTypeConverter(QualifiedName key) {
        SimpleTypeConverter o = null;
        ClassLoader classLoader = ClassLoaderUtils.getContextClassLoader();
        ConcurrentHashMap<QualifiedName, WeakReference<SimpleTypeConverter>> typeConverterMap = null;
        Object object = this._classLoaderMapLock;
        synchronized (object) {
            typeConverterMap = this._classLoaderToExternalTypeConverterMap.get(classLoader);
        }
        if (typeConverterMap != null) {
            WeakReference<SimpleTypeConverter> weakReferenceSimpleTypeConverter = typeConverterMap.get(key);
            if (weakReferenceSimpleTypeConverter == null) {
                return null;
            }
            o = (SimpleTypeConverter)weakReferenceSimpleTypeConverter.get();
            if (o == null) {
                return null;
            }
            return o;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _registerExternalTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        ClassLoader classLoader = ClassLoaderUtils.getContextClassLoader();
        ConcurrentHashMap<QualifiedName, WeakReference<SimpleTypeConverter>> typeConverterMap = null;
        Object object = this._classLoaderMapLock;
        synchronized (object) {
            typeConverterMap = this._classLoaderToExternalTypeConverterMap.get(classLoader);
            if (typeConverterMap == null) {
                typeConverterMap = new ConcurrentHashMap();
                this._classLoaderToExternalTypeConverterMap.put(classLoader, typeConverterMap);
            }
        }
        typeConverterMap.put(simpleTypeName, new WeakReference<SimpleTypeConverter>(converter));
    }

    private static <T> T _as(Class<T> clazz, Object o) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }

    private void _registerInternalSimpleTypeConverter(String namespace, String simpleTypeName, SimpleTypeConverter converter) {
        QualifiedName qName = QualifiedName.getQualifiedName(namespace, simpleTypeName);
        this._registerInternalSimpleTypeConverter(qName, converter);
    }

    private void _registerInternalSimpleTypeConverter(QualifiedName simpleTypeName, SimpleTypeConverter converter) {
        if (simpleTypeName != null && converter != null) {
            this._typeConverterMap.put(simpleTypeName, converter);
        }
    }

    private JavaTypeManager() {
        this._simpleTypeValueProvider = new ConcurrentHashMap();
    }

    private static class JavaClassOrDirectObjectConverter
    extends SimpleTypeConverter {
        private JavaClassOrDirectObjectConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return ClassLoaderUtils.loadClass((String)value);
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Object.class;
        }
    }

    private static class JavaClassInstanceConverter
    extends SimpleTypeConverter {
        private JavaClassInstanceConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                Class c = ClassLoaderUtils.loadClass((String)value);
                return c.newInstance();
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Object.class;
        }
    }

    private static class JavaClassConverter
    extends SimpleTypeConverter {
        private static HashMap _sPrimitiveTypes = new HashMap();

        private JavaClassConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            Class primitiveClass = (Class)_sPrimitiveTypes.get(value);
            if (primitiveClass != null) {
                return primitiveClass;
            }
            if (Character.isUpperCase(value.charAt(0))) {
                value = "java.lang." + value;
            }
            if (value.endsWith("[]")) {
                return String[].class;
            }
            try {
                return ClassLoaderUtils.loadClass((String)value);
            }
            catch (Exception e) {
                throw new GrammarException("error converting to Java class", e);
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Class.class;
        }

        static {
            _sPrimitiveTypes.put("char", Character.TYPE);
            _sPrimitiveTypes.put("byte", Byte.TYPE);
            _sPrimitiveTypes.put("short", Short.TYPE);
            _sPrimitiveTypes.put("int", Integer.TYPE);
            _sPrimitiveTypes.put("long", Long.TYPE);
            _sPrimitiveTypes.put("float", Float.TYPE);
            _sPrimitiveTypes.put("double", Double.TYPE);
            _sPrimitiveTypes.put("boolean", Boolean.TYPE);
        }
    }

    private static class ByteValueProvider
    implements SimpleTypeValueProvider {
        private byte _count = 0;

        ByteValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            byte by = this._count;
            this._count = (byte)(by + 1);
            return Integer.toHexString(by);
        }
    }

    private static class ShortValueProvider
    implements SimpleTypeValueProvider {
        private short _count = 0;

        ShortValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            short s = this._count;
            this._count = (short)(s + 1);
            return String.valueOf(s);
        }
    }

    private static class LongValueProvider
    implements SimpleTypeValueProvider {
        private long _count = 0L;

        LongValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "12345" + this._count++;
        }
    }

    private static class IntValueProvider
    implements SimpleTypeValueProvider {
        private int _count = 0;

        IntValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "12" + this._count++;
        }
    }

    private static class IntegerValueProvider
    implements SimpleTypeValueProvider {
        private long _count = 0L;

        IntegerValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "123" + this._count++;
        }
    }

    private static class DoubleValueProvider
    implements SimpleTypeValueProvider {
        private double _count = 0.0;

        DoubleValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            double d = this._count;
            this._count = d + 1.0;
            return "123.12" + d;
        }
    }

    private static class FloatValueProvider
    implements SimpleTypeValueProvider {
        private float _count = 0.0f;

        FloatValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            float f = this._count;
            this._count = f + 1.0f;
            return "123." + f;
        }
    }

    private static class DecimalValueProvider
    implements SimpleTypeValueProvider {
        private double _count = 0.0;

        DecimalValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            double d = this._count;
            this._count = d + 1.0;
            return "123.123" + d;
        }
    }

    private static class BooleanValueProvider
    implements SimpleTypeValueProvider {
        private BooleanValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "false";
        }
    }

    private static class StringValueProvider
    implements SimpleTypeValueProvider {
        private StringValueProvider() {
        }

        public String createNewValue(SimpleType type) {
            return "abc";
        }
    }

    private static class QNameSimpleTypeConverter
    extends SimpleTypeConverter {
        private QNameSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                String prefix = null;
                String localName = null;
                int sepIndex = value.indexOf(58);
                if (sepIndex != -1) {
                    prefix = value.substring(0, sepIndex);
                    if (sepIndex + 1 < value.length()) {
                        localName = value.substring(sepIndex + 1);
                    }
                } else {
                    localName = value;
                }
                return PrefixName.getPrefixName(prefix, localName);
            }
            catch (Exception e) {
                throw new GrammarException("QNameSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return PrefixName.class;
        }

        public String convertToString(Object javaType, SimpleType simpleType) {
            if (javaType == null) {
                return null;
            }
            PrefixName pn = null;
            pn = (PrefixName)JavaTypeManager._as(this.getJavaClass(simpleType), javaType);
            if (pn != null) {
                return pn.getPrefixName();
            }
            return super.convertToString(javaType, simpleType);
        }
    }

    private static class AnyUriSimpleTypeConverter
    extends SimpleTypeConverter {
        private AnyUriSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return new URI(value);
            }
            catch (Exception e) {
                throw new GrammarException("AnyUriSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return URI.class;
        }
    }

    private static class ByteSimpleTypeConverter
    extends SimpleTypeConverter {
        private ByteSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Byte.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("ByteSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Byte.class;
        }
    }

    private static class ShortSimpleTypeConverter
    extends SimpleTypeConverter {
        private ShortSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Short.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("ShortSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Short.class;
        }
    }

    private static class IntSimpleTypeConverter
    extends SimpleTypeConverter {
        private IntSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("IntSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Integer.class;
        }
    }

    private static class LongSimpleTypeConverter
    extends SimpleTypeConverter {
        private LongSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Long.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("LongSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Long.class;
        }
    }

    private static class IntegerSimpleTypeConverter
    extends SimpleTypeConverter {
        private IntegerSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return new BigInteger(value);
            }
            catch (Exception e) {
                throw new GrammarException("IntegerSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return BigInteger.class;
        }
    }

    private static class DoubleSimpleTypeConverter
    extends SimpleTypeConverter {
        private DoubleSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Double.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("DoubleSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Double.class;
        }
    }

    private static class FloatSimpleTypeConverter
    extends SimpleTypeConverter {
        private FloatSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return Float.valueOf(value);
            }
            catch (Exception e) {
                throw new GrammarException("FloatSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return Float.class;
        }
    }

    private static class DecimalSimpleTypeConverter
    extends SimpleTypeConverter {
        private DecimalSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            try {
                return new BigDecimal(value);
            }
            catch (Exception e) {
                throw new GrammarException("DecimalSimpleTypeConverter: " + value + " cannot be converted to this type");
            }
        }

        public Class getJavaClass(SimpleType type) {
            return BigDecimal.class;
        }
    }

    private static class BooleanSimpleTypeConverter
    extends SimpleTypeConverter {
        private BooleanSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            if ("true".equals(value) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value) || "0".equals(value)) {
                return Boolean.FALSE;
            }
            throw new GrammarException("BooleanSimpleTypeConverter: " + value + " cannot be converted to this type");
        }

        public Class getJavaClass(SimpleType type) {
            return Boolean.class;
        }
    }

    private static class StringSimpleTypeConverter
    extends SimpleTypeConverter {
        private StringSimpleTypeConverter() {
        }

        public Object convertToJavaType(String value, SimpleType simpleType) throws GrammarException {
            return value;
        }

        public Class getJavaClass(SimpleType type) {
            return String.class;
        }
    }
}

