/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleElementDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.grammar.schema.OracleWildcard;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;

public class OracleContentGroup
implements ContentGroup {
    private OracleSchemaFactory _factory = null;
    private XSDGroup _xsdGroup = null;
    private ArrayList _components = null;
    private Annotation _annotation = null;

    public String getName() {
        return this._xsdGroup.getName();
    }

    public String getTargetNamespace() {
        return this._xsdGroup.getTargetNS();
    }

    public int getMinOccurs() {
        return this._xsdGroup.getMinOccurs();
    }

    public int getMaxOccurs() {
        int maxOccurs = this._xsdGroup.getMaxOccurs();
        if (0x7FFFFFF8 == maxOccurs) {
            maxOccurs = -1;
        }
        return maxOccurs;
    }

    public Collection getComponents() {
        return this._getComponents();
    }

    public int getVariety() {
        int groupVariety = this._xsdGroup.getOrder();
        if (2 == groupVariety) {
            return 7;
        }
        if (1 == groupVariety) {
            return 8;
        }
        if (0 == groupVariety) {
            return 9;
        }
        return 10;
    }

    public Annotation getAnnotation() {
        if (this._annotation == null) {
            this._annotation = new OracleAnnotation((XSDNode)this._xsdGroup);
        }
        return this._annotation;
    }

    OracleContentGroup(OracleSchemaFactory factory, XSDGroup xsdGroup) {
        this._factory = factory;
        this._xsdGroup = xsdGroup;
    }

    private synchronized ArrayList _getComponents() {
        if (this._components == null) {
            this._components = new ArrayList();
            Vector xsdParticles = this._xsdGroup.getNodeVector();
            if (xsdParticles != null) {
                for (int i = 0; i < xsdParticles.size(); ++i) {
                    Object particle = xsdParticles.get(i);
                    if (particle == null) continue;
                    if (particle instanceof XSDElement) {
                        XSDElement element = (XSDElement)particle;
                        OracleElementDef elementWrapper = this._factory.getElementWrapper(element);
                        this._components.add(elementWrapper);
                        continue;
                    }
                    if (particle instanceof XSDGroup) {
                        XSDGroup particleGroup = (XSDGroup)particle;
                        OracleContentGroup groupWrapper = this._factory.getContentGroupWrapper(particleGroup);
                        this._components.add(groupWrapper);
                        continue;
                    }
                    if (!(particle instanceof XSDAny)) continue;
                    XSDAny xsdAny = (XSDAny)particle;
                    OracleWildcard wildcardWrapper = this._factory.getWildcardWrapper(xsdAny);
                    this._components.add(wildcardWrapper);
                }
            }
        }
        return this._components;
    }
}

