/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.instance;

import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.LayeredGrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceDtdCreator;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlInstanceGrammarProvider
extends LayeredGrammarProvider {
    private Grammar _dtd = null;
    private Map _dtdMap = Collections.EMPTY_MAP;
    private SchemaGrammarProvider _schemaProvider = null;
    private Set _processedSchemaIdentifiers = Collections.EMPTY_SET;
    private boolean _isValidRemoteUrl = false;
    private Set<URL> _validRemoteUrls = Collections.emptySet();
    private GrammarIdentifier _processedDtdIdentifier = null;
    private boolean _fixedDtd = false;
    private XmlInstanceDtdCreator _dtdCreator = null;
    private static final Logger _sLogger = Logger.getLogger("oracle.bali.xml.grammar");

    public XmlInstanceGrammarProvider() {
        this(null);
    }

    public XmlInstanceGrammarProvider(GrammarProvider base) {
        super(new SchemaGrammarProvider(base));
        this._schemaProvider = (SchemaGrammarProvider)super.getBaseGrammarProvider();
        this._schemaProvider.setEntityResolver(new OurEntityResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSchemaIdentifiers(Set grammarIdentifiers, Set<URL> validRemoteUrls) {
        boolean grammarProviderChanged = false;
        if (!((Object)this._processedSchemaIdentifiers).equals(grammarIdentifiers) || validRemoteUrls != null) {
            grammarProviderChanged = true;
            this._processedSchemaIdentifiers = grammarIdentifiers;
            if (validRemoteUrls != null) {
                this._validRemoteUrls = validRemoteUrls;
            }
            this._schemaProvider.clearSchemas();
            Set locations = this._getSchemaLocations(grammarIdentifiers);
            locations = this._removeExistingGrammarLocations(locations);
            for (String location : locations) {
                URL schemaLocation = null;
                try {
                    schemaLocation = new URL(location);
                }
                catch (MalformedURLException e) {
                    schemaLocation = null;
                }
                if (schemaLocation == null || !this._shouldLoad(schemaLocation)) continue;
                try {
                    if (this._validRemoteUrls.contains(schemaLocation)) {
                        this._isValidRemoteUrl = true;
                    }
                    this._schemaProvider.addSchema(schemaLocation);
                }
                catch (Exception e) {
                    XmlInstanceGrammarProvider._getLogger().log(Level.WARNING, "Attempt to load schema file referenced in instance document failed:" + schemaLocation);
                    XmlInstanceGrammarProvider._getLogger().log(Level.FINER, "Underlying exception preventing schema loading:", e);
                }
                finally {
                    this._isValidRemoteUrl = false;
                }
            }
        }
        return grammarProviderChanged;
    }

    public boolean setDtdIdentifier(GrammarIdentifier dtdIdentifier) {
        if (!(this._dtdCreator == null || this._fixedDtd || this._processedDtdIdentifier != null && this._processedDtdIdentifier.equals(dtdIdentifier))) {
            GrammarProviderEvent event = this.createEvent();
            this._processedDtdIdentifier = dtdIdentifier;
            if (this._dtd != null) {
                event.notifyGrammarRemoved(this._dtd);
                this._dtd = null;
                this._dtdMap = Collections.EMPTY_MAP;
            }
            Set locations = this._getDtdLocation(dtdIdentifier);
            locations = this._removeExistingGrammarLocations(locations);
            for (String location : locations) {
                URL dtdLocation = null;
                try {
                    dtdLocation = new URL(location);
                }
                catch (MalformedURLException e) {
                    dtdLocation = null;
                }
                if (dtdLocation == null || !this._shouldLoad(dtdLocation)) continue;
                Grammar dtdGrammar = null;
                try {
                    dtdGrammar = this._dtdCreator.createDtd(dtdLocation);
                }
                catch (Exception ge) {
                    dtdGrammar = null;
                }
                if (dtdGrammar == null) continue;
                this._dtd = dtdGrammar;
                this._dtdMap = Collections.singletonMap(this._dtd.getTargetNamespace(), this._dtd);
                event.notifyGrammarAdded(this._dtd);
                break;
            }
            this.fireEvent(event);
            return !event.isEmpty();
        }
        return false;
    }

    public void setDTD(Grammar newDTD) {
        this._fixedDtd = true;
        GrammarProviderEvent event = this.createEvent();
        if (this._dtd != null) {
            event.notifyGrammarRemoved(this._dtd);
        }
        this._dtd = newDTD;
        if (this._dtd != null) {
            this._dtdMap = Collections.singletonMap(this._dtd.getTargetNamespace(), this._dtd);
            event.notifyGrammarAdded(this._dtd);
        } else {
            this._dtdMap = Collections.EMPTY_MAP;
        }
        this.fireEvent(event);
    }

    public void setDtdCreator(XmlInstanceDtdCreator dtdCreator) {
        this._dtdCreator = dtdCreator;
    }

    @Override
    protected Map getLayerGrammarMap() {
        return this._dtdMap;
    }

    private Set _getDtdLocation(GrammarIdentifier dtdIdentifier) {
        if (dtdIdentifier != null) {
            String publicId;
            String location = dtdIdentifier.getLocation();
            if (location == null && (publicId = dtdIdentifier.getPublicId()) != null) {
                location = this._dtdCreator.getSystemId(publicId);
            }
            if (location != null) {
                location = this._dtdCreator.getLocationAlias(location);
                return Collections.singleton(location);
            }
        }
        return Collections.EMPTY_SET;
    }

    private Set _getSchemaLocations(Set schemaIdentifiers) {
        HashSet<String> locations = new HashSet<String>();
        for (GrammarIdentifier id : schemaIdentifiers) {
            String locationId = id.getLocation();
            if (locationId == null) continue;
            String locationAlias = this.getSchemaLocationAlias(locationId);
            locations.add(locationAlias);
        }
        return locations;
    }

    private Set _removeExistingGrammarLocations(Set locations) {
        Collection currentGrammars = this.getGrammars();
        for (Grammar g : currentGrammars) {
            URL gURL;
            GrammarIdentifier id = g.getGrammarIdentifier();
            String gLocation = id.getLocation();
            if (gLocation == null && (gURL = g.getLocation()) != null) {
                gLocation = gURL.toExternalForm();
            }
            if (gLocation == null) continue;
            locations.remove(gLocation);
        }
        return locations;
    }

    protected String getSchemaLocationAlias(String location) {
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _shouldLoad(URL url) {
        if (!this._validRemoteUrls.contains(url) && "http".equals(url.getProtocol()) && !Boolean.getBoolean("jdev.load.remote.schemas")) {
            return false;
        }
        boolean openWorked = true;
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception e) {
            openWorked = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignored) {}
            }
        }
        return openWorked;
    }

    private static Logger _getLogger() {
        return _sLogger;
    }

    private class OurEntityResolver
    implements EntityResolver {
        private OurEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId != null) {
                String alias = XmlInstanceGrammarProvider.this.getSchemaLocationAlias(systemId);
                if (alias == null) {
                    alias = systemId;
                }
                if (!XmlInstanceGrammarProvider.this._isValidRemoteUrl && alias.startsWith("http:") && !Boolean.getBoolean("jdev.load.remote.schemas")) {
                    if (alias.endsWith(".xsd")) {
                        XmlInstanceGrammarProvider._getLogger().log(Level.WARNING, "Ignoring remote included or imported .xsd file:  " + systemId);
                        return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"windows-1252\" ?><schema xmlns=\"http://www.w3.org/2001/XMLSchema\" />"));
                    }
                    XmlInstanceGrammarProvider._getLogger().log(Level.WARNING, "Ignoring reference to remote file:  " + systemId);
                    return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"windows-1252\" ?>"));
                }
                if (!systemId.equals(alias)) {
                    return new InputSource(alias);
                }
            }
            return null;
        }
    }
}

