/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.traversal;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SimulateInsertingFragmentTreeTraversal
extends TreeTraversal {
    private final List _fakeChildren;
    private final DomPosition _position;

    public SimulateInsertingFragmentTreeTraversal(Element simulatedParent, DocumentFragment fragment) {
        this(DomPositionFactory.inside(simulatedParent), DomUtils.nodeListToList(fragment.getChildNodes()));
    }

    public SimulateInsertingFragmentTreeTraversal(DomPosition simulatedPosition, List simulatedChildren) {
        if (simulatedPosition == null || simulatedChildren == null) {
            throw new IllegalArgumentException("null argument");
        }
        this._position = simulatedPosition;
        this._fakeChildren = new ArrayList(simulatedChildren);
    }

    public Node getFirstChild(Node parent) {
        if (this._isPositionContainer(parent) && this._fakeStartAtFirstChild()) {
            return this._firstFakeChild();
        }
        return parent.getFirstChild();
    }

    public Node getLastChild(Node parent) {
        Node lastFake;
        if (this._isPositionContainer(parent) && this._fakeEndAtLastChild() && (lastFake = this._lastFakeChild()) != null) {
            return lastFake;
        }
        return parent.getLastChild();
    }

    public Node getParentNode(Node child) {
        if (this._fakeChildren.contains(child)) {
            return this._container();
        }
        return child.getParentNode();
    }

    public Node getNextSibling(Node node) {
        int fakeIndex = this._fakeChildren.indexOf(node);
        if (fakeIndex == -1) {
            Node realNext = node.getNextSibling();
            if (this._isRealChildOfContainer(node) && this._fakeStartAfter(node)) {
                return this._firstFakeChild();
            }
            return realNext;
        }
        if (fakeIndex == this._fakeChildren.size() - 1) {
            if (this._position.isAfter()) {
                return this._position.getTargetNode().getNextSibling();
            }
            if (this._position.isBefore()) {
                return this._position.getTargetNode();
            }
            return null;
        }
        return this._fakeChild(fakeIndex + 1);
    }

    public String toString() {
        return "[" + super.toString() + " pos=" + this._position + " fakeChildren=" + this._fakeChildren + "]";
    }

    public Node getPreviousSibling(Node node) {
        int fakeIndex = this._fakeChildren.indexOf(node);
        if (fakeIndex == -1) {
            if (this._isRealChildOfContainer(node) && this._fakeEndBefore(node)) {
                return this._lastFakeChild();
            }
            return node.getPreviousSibling();
        }
        if (fakeIndex == 0) {
            if (this._position.isBefore()) {
                return this._position.getTargetNode().getPreviousSibling();
            }
            if (this._position.isAfter()) {
                return this._position.getTargetNode();
            }
            return this._position.getTargetNode().getLastChild();
        }
        return this._fakeChild(fakeIndex - 1);
    }

    private boolean _fakeStartAfter(Node node) {
        Node container = this._container();
        Node realLast = container.getLastChild();
        return realLast == node && this._position.isInside() || this._position.isBefore() && this._position.getTargetNode() == node.getNextSibling() || this._position.isAfter() && this._position.getTargetNode() == node;
    }

    private boolean _fakeEndBefore(Node node) {
        return this._position.isBefore() && this._position.getTargetNode() == node || this._position.isAfter() && this._position.getTargetNode() == node.getPreviousSibling();
    }

    private boolean _fakeStartAtFirstChild() {
        Node container = this._container();
        Node realFirst = container.getFirstChild();
        return realFirst == null || this._position.isBefore() && this._position.getTargetNode() == realFirst;
    }

    private boolean _fakeEndAtLastChild() {
        Node container = this._container();
        Node realLast = container.getLastChild();
        return this._position.isInside() || realLast == null || this._position.isAfter() && this._position.getTargetNode() == realLast;
    }

    private Node _fakeChild(int i) {
        if (i >= 0 && i < this._fakeChildren.size()) {
            return (Node)this._fakeChildren.get(i);
        }
        return null;
    }

    private Node _lastFakeChild() {
        return this._fakeChild(this._fakeChildren.size() - 1);
    }

    private Node _firstFakeChild() {
        return this._fakeChild(0);
    }

    private Node _container() {
        return this._position.getContainerNode();
    }

    private boolean _isPositionContainer(Node node) {
        return this._container() == node;
    }

    private boolean _isRealChildOfContainer(Node node) {
        return node.getParentNode() == this._container();
    }
}

