/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.Preferences;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.ide.hover.HoverOptions;
import oracle.ide.hover.Hoverable;
import oracle.ide.panels.Navigable;
import oracle.ide.peek.Peekable;
import oracle.ideimpl.panels.SearchableNavigable;
import oracle.ideimpl.peek.HoverOptionsPanel;
import oracle.ideimpl.peek.PeekBundle;
import oracle.ideimpl.peek.PeekHookHandler;
import oracle.javatools.data.PropertyStorage;

@RegisteredByExtension(value="oracle.peek")
final class PeekAddin
implements Addin {
    private static Hover hover;
    private static HideListener hideL;
    private static ActivationListener peekL;
    private static boolean altDown;
    private static boolean shiftDown;
    private static boolean ctrlDown;

    PeekAddin() {
    }

    public void initialize() {
        this.updateOptions();
        Toolkit.getDefaultToolkit().addAWTEventListener(peekL, 131128L);
        SearchableNavigable peekOptionsNavigable = new SearchableNavigable(PeekBundle.get("PEEK_OPTIONS_PANEL_NAME"), HoverOptionsPanel.class);
        peekOptionsNavigable.setSearchTags(PeekBundle.get("PEEK_OPTIONS_PANEL_TAGS"));
        ClientSetting.registerUI((Navigable)peekOptionsNavigable);
    }

    public static void showPeek(Point p) {
        if (hover != null) {
            return;
        }
        if (!Ide.getMainWindow().isActive()) {
            return;
        }
        JLayeredPane c = Ide.getMainWindow().getLayeredPane();
        SwingUtilities.convertPointFromScreen(p, c);
        Point screenP = MouseInfo.getPointerInfo().getLocation();
        HoverOptions hoverOptions = HoverOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        List<HoverFlavor> flavors = PeekAddin.getAppropriateFlavors(hoverOptions);
        if (flavors.isEmpty()) {
            return;
        }
        for (Component comp = SwingUtilities.getDeepestComponentAt(c, p.x, p.y); comp != null; comp = comp.getParent()) {
            if (comp instanceof Hoverable) {
                hover = ((Hoverable)((Object)comp)).hover((Point)screenP.clone(), flavors);
            }
            if (flavors.contains(HoverFlavor.getFlavor("source")) && !hoverOptions.isSmartEnabled() && hover == null && comp instanceof Peekable) {
                hover = ((Peekable)((Object)comp)).peek((Point)screenP.clone());
            }
            if (hover == null) {
                continue;
            }
            hover.addHoverListener(hideL);
            break;
        }
    }

    private static List<HoverFlavor> getAppropriateFlavors(HoverOptions hoverOptions) {
        boolean isSmart = hoverOptions.isSmartEnabled() && hoverOptions.getSmartActivator().isSuitable(shiftDown, ctrlDown, altDown);
        ArrayList<HoverFlavor> flavors = new ArrayList<HoverFlavor>();
        if (isSmart) {
            for (HoverFlavor flavor : hoverOptions.getFlavorPriority()) {
                if (!hoverOptions.isFlavorSmartEnabled(flavor)) continue;
                flavors.add(flavor);
            }
        } else {
            for (HoverFlavor flavor : hoverOptions.getFlavorPriority()) {
                if (!hoverOptions.getFlavorActivator(flavor).isSuitable(shiftDown, ctrlDown, altDown)) continue;
                flavors.add(flavor);
            }
        }
        return flavors;
    }

    public static void hidePeek() {
        peekL.steadyTimer.stop();
        if (hover != null) {
            hover.removeHoverListener(hideL);
            hover.hideHover();
        }
        hover = null;
    }

    private void updateOptions() {
        Collection<HoverFlavor> flavors = PeekHookHandler.get().hoverFlavors();
        HoverOptions hoverOptions = HoverOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        ArrayList<HoverFlavor> optionFlavors = new ArrayList<HoverFlavor>(hoverOptions.getFlavorPriority());
        for (HoverFlavor flavor : flavors) {
            HoverFlavor optionFlavor;
            if (optionFlavors.contains(flavor)) continue;
            int i = optionFlavors.size();
            while (--i >= 0 && (optionFlavor = (HoverFlavor)optionFlavors.get(i)).getDefaultPriority() >= flavor.getDefaultPriority()) {
            }
            optionFlavors.add(i + 1, flavor);
            hoverOptions.setFlavorActivator(flavor, flavor.getDefaultHoverActivator());
            hoverOptions.setFlavorSmartEnabled(flavor, flavor.isDefaultSmartEnable());
        }
        hoverOptions.setFlavorPriority(optionFlavors);
    }

    static {
        hideL = new HideListener();
        peekL = new ActivationListener();
        altDown = false;
        shiftDown = false;
        ctrlDown = false;
    }

    private static class ActivationListener
    implements AWTEventListener,
    ActionListener {
        private static final int STEADY_DURATION = 350;
        private static final int DONT_SHOW_DURATION = 350;
        private Timer steadyTimer = new Timer(350, this);
        private long dontShowBefore = -1L;

        private ActivationListener() {
            this.steadyTimer.setRepeats(false);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                ctrlDown = ke.isControlDown();
                altDown = ke.isAltDown();
                shiftDown = ke.isShiftDown();
                if (ke.getKeyCode() == 27) {
                    PeekAddin.hidePeek();
                }
                if (ke.getKeyCode() != 17 && ke.getKeyCode() != 16 && ke.getKeyCode() != 18 && hover != null && hover.shouldHideHover(ke)) {
                    PeekAddin.hidePeek();
                    this.dontShowForABit();
                }
                if (MouseInfo.getPointerInfo() == null) {
                    return;
                }
            }
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                ctrlDown = me.isControlDown();
                altDown = me.isAltDown();
                shiftDown = me.isShiftDown();
                switch (me.getID()) {
                    case 500: 
                    case 501: 
                    case 502: 
                    case 507: {
                        if (hover == null || !(event.getSource() instanceof Component)) {
                            PeekAddin.hidePeek();
                        } else if (!hover.isPointWithinHover(me.getLocationOnScreen())) {
                            PeekAddin.hidePeek();
                        }
                        this.dontShowForABit();
                        break;
                    }
                    case 503: {
                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                        if (pointerInfo == null) {
                            return;
                        }
                        if (System.currentTimeMillis() <= this.dontShowBefore || hover != null) break;
                        this.steadyTimer.restart();
                    }
                }
            }
        }

        private void dontShowForABit() {
            this.steadyTimer.stop();
            this.dontShowBefore = System.currentTimeMillis() + 350L;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.steadyTimer.stop();
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            PeekAddin.showPeek(MouseInfo.getPointerInfo().getLocation());
        }
    }

    private static class HideListener
    implements HoverListener {
        private HideListener() {
        }

        @Override
        public void hoverChange(HoverEvent event) {
            if (event.isHidden()) {
                PeekAddin.hidePeek();
            }
        }
    }
}

