/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.peek;

import java.util.StringTokenizer;
import javax.swing.JComponent;
import oracle.ide.peek.Peek;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.ghost.UIConstants;

public final class CodePeek
extends Peek {
    private BasicEditorPane ep = (BasicEditorPane)this.getContentComponent();

    public CodePeek(JComponent comp, String fileName) {
        super(comp, (JComponent)new BasicEditorPane());
        this.ep.setOpaque(true);
        this.ep.putClientProperty((Object)UIConstants.VETO_CONVERSION, (Object)Boolean.TRUE);
        if (fileName != null) {
            this.ep.setLanguageSupport(fileName);
        }
    }

    public void setText(String text) {
        text = CodePeek.trimCommonWhitespace(text);
        this.ep.setEditable(true);
        this.ep.setText(text);
        this.ep.setCaretPosition(0);
        this.ep.setEditable(false);
    }

    private static String trimCommonWhitespace(String text) {
        int i;
        String line;
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        String startSeq = "";
        int firstLine = 0;
        while (startSeq.length() == 0) {
            char c;
            if (!st.hasMoreTokens()) {
                return text;
            }
            line = st.nextToken();
            ++firstLine;
            if (line.equals("\n")) continue;
            for (i = 0; i < line.length() && Character.isWhitespace(c = line.charAt(i)); ++i) {
                startSeq = startSeq + c;
            }
        }
        if (startSeq.length() == 0) {
            return text;
        }
        block2: while (st.hasMoreTokens()) {
            line = st.nextToken();
            if (line.equals("\n")) continue;
            int len = Math.min(line.length(), startSeq.length());
            for (i = 0; i < len; ++i) {
                char cs;
                char cl = line.charAt(i);
                if (cl == (cs = startSeq.charAt(i))) continue;
                startSeq = line.substring(0, i);
                continue block2;
            }
        }
        StringBuffer sb = new StringBuffer();
        st = new StringTokenizer(text, "\n", true);
        for (i = 0; i < firstLine - 1; ++i) {
            sb.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            String line2 = st.nextToken();
            if (line2.equals("\n")) {
                sb.append("\n");
                continue;
            }
            if (line2.length() >= startSeq.length()) {
                sb.append(line2.substring(startSeq.length()));
                continue;
            }
            sb.append(line2);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public BasicEditorPane getEditor() {
        return this.ep;
    }
}

