/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import oracle.ideimpl.peek.PeekBundle;

public enum HoverActivator {
    OFF,
    NONE,
    SHIFT,
    CONTROL,
    ALT,
    CONTROL_SHIFT,
    ALT_SHIFT,
    CONTROL_ALT;


    public boolean requiresAlt() {
        switch (this) {
            case ALT: 
            case ALT_SHIFT: 
            case CONTROL_ALT: {
                return true;
            }
        }
        return false;
    }

    public boolean requiresShift() {
        switch (this) {
            case ALT_SHIFT: 
            case CONTROL_SHIFT: 
            case SHIFT: {
                return true;
            }
        }
        return false;
    }

    public boolean requiresControl() {
        switch (this) {
            case CONTROL_ALT: 
            case CONTROL_SHIFT: 
            case CONTROL: {
                return true;
            }
        }
        return false;
    }

    public String getDisplayName() {
        return PeekBundle.get(this.name());
    }

    public boolean isSuitable(boolean shiftDown, boolean controlDown, boolean altDown) {
        if (this == OFF) {
            return false;
        }
        return shiftDown == this.requiresShift() && controlDown == this.requiresControl() && altDown == this.requiresAlt();
    }
}

