/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.interactor.IlvManagerMagViewInteractor;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.util.IlvCSSJViews;
import ilog.views.util.beans.IlvConvertForSetters;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvSDMRenderer
implements Serializable {
    public static final String PSEUDOCLASS_PREFIX = "__PSEUDO__";
    private String a;
    private IlvConvertForSetters b = new IlvCSSJViews.ConvertWithBGO();
    private IlvSDMEngine c;
    private static Map<Class, BeanInfo> d = Collections.synchronizedMap(new HashMap());
    private ViewsChangedListener e = new ViewsChangedListener();

    protected IlvSDMRenderer() {
    }

    public void setAlias(String string) {
        this.a = string;
    }

    public String getAlias() {
        if (this.a != null) {
            return this.a;
        }
        return IlvRendererUtil.getRendererAlias(this.getClass().getName());
    }

    public void setEngine(IlvSDMEngine ilvSDMEngine) {
        this.c = ilvSDMEngine;
    }

    public IlvSDMEngine getEngine() {
        return this.c;
    }

    public abstract IlvGraphic createNodeGraphic(IlvSDMEngine var1, Object var2);

    public abstract IlvGraphic createLinkGraphic(IlvSDMEngine var1, Object var2, IlvGraphic var3, IlvGraphic var4);

    public void addNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        ilvSDMEngine.getGrapher().addNode(ilvGraphic, bl);
    }

    public void addLinkGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        ilvSDMEngine.getGrapher().addLink((IlvLinkImage)ilvGraphic, bl);
    }

    public void nodeGraphicAdded(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
    }

    public void linkGraphicAdded(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
    }

    protected final void setLayerName(IlvGrapher ilvGrapher, int n, String string) {
        ilvGrapher.setNumberOfLayer(n + 1);
        String string2 = ilvGrapher.getLayerName(n);
        if (string2 == null) {
            int n2 = 0;
            String string3 = string;
            while (ilvGrapher.getLayer(string3) >= 0) {
                string3 = string + " " + ++n2;
            }
            ilvGrapher.setLayerName(n, string3);
        }
    }

    public void removeNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic.getGraphicBag() instanceof IlvGrapher) {
            ((IlvGrapher)ilvGraphic.getGraphicBag()).removeNode(ilvGraphic, bl);
        }
    }

    public void removeLinkGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic.getGraphicBag() instanceof IlvGrapher) {
            ((IlvGrapher)ilvGraphic.getGraphicBag()).removeLink((IlvLinkImage)ilvGraphic, bl);
        }
    }

    public void removeAll(IlvSDMEngine ilvSDMEngine) {
        if (this.needsViewListeners()) {
            this.a((IlvManager)ilvSDMEngine.getGrapher(), false);
        }
    }

    public void prepareRendering(IlvSDMEngine ilvSDMEngine) {
        if (this.needsViewListeners()) {
            this.a((IlvManager)ilvSDMEngine.getGrapher(), true);
        }
    }

    public void renderingDone(IlvSDMEngine ilvSDMEngine) {
    }

    public void propertyChanged(IlvSDMEngine ilvSDMEngine, Object object, String string, Object object2, Object object3, IlvGraphic ilvGraphic) {
        this.propertiesChanged(ilvSDMEngine, object, string == null ? null : Collections.singletonList(string), ilvGraphic);
    }

    public void propertiesChanged(IlvSDMEngine ilvSDMEngine, Object object, Collection<String> collection, IlvGraphic ilvGraphic) {
        this.customize(ilvSDMEngine, object, ilvGraphic, null);
    }

    public Object getGraphicProperty(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, Class clazz) {
        String string2;
        if (string == null) {
            return null;
        }
        Object object2 = null;
        int n = string.indexOf(58);
        String string3 = string2 = n == -1 ? string : string.substring(n);
        if (n == -1 && ilvSDMEngine.isMetadataEnabled()) {
            String string4 = "sdm:" + string;
            object2 = ilvSDMEngine.getModel().getObjectProperty(object, string4);
            if (object2 != null) {
                string = string4;
            } else {
                object2 = ilvSDMEngine.getModel().getObjectProperty(object, string);
            }
        } else {
            object2 = ilvSDMEngine.getModel().getObjectProperty(object, string);
        }
        if (clazz != null) {
            return this.convert(object2, clazz, string2);
        }
        return object2;
    }

    public void updateObjectProperties(IlvSDMEngine ilvSDMEngine, Object object, String string, Object object2, String[] stringArray) {
        IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
        if (ilvSDMModel.isEditable()) {
            Object object3;
            if (string.startsWith("@")) {
                string = string.substring(1);
            } else if (ilvSDMEngine.isMetadataEnabled()) {
                boolean bl;
                boolean bl2 = bl = string.indexOf(58) != -1;
                if (!bl) {
                    string = "sdm:" + string;
                }
            }
            Object object4 = object3 = string.equals("__ID") ? ilvSDMModel.getID(object) : ilvSDMModel.getObjectProperty(object, string);
            if (object3 != null && object2 != null && object2.getClass() != object3.getClass()) {
                try {
                    object2 = IlvValueConverter.convert((Object)object2, object3.getClass());
                }
                catch (Exception exception) {
                    return;
                }
            }
            if (string.equals("__ID")) {
                if (object2 != null) {
                    ilvSDMModel.setID(object, object2.toString());
                }
            } else {
                ilvSDMModel.setObjectProperty(object, string, object2);
            }
        }
    }

    protected final Object convert(Object object, Class clazz, String string) {
        if (clazz != null && string != null && object != null) {
            PropertyDescriptor[] propertyDescriptorArray = null;
            try {
                propertyDescriptorArray = IlvSDMRenderer.a(clazz).getPropertyDescriptors();
            }
            catch (IntrospectionException introspectionException) {
                return object;
            }
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!string.equals(propertyDescriptorArray[i].getName())) continue;
                return this.convert(object, propertyDescriptorArray[i], clazz);
            }
        }
        return object;
    }

    protected final Object convert(Object object, PropertyDescriptor propertyDescriptor, Class clazz) {
        return this.b.convert(object, propertyDescriptor, clazz, false);
    }

    final Object a(Object object, PropertyDescriptor propertyDescriptor, boolean bl, Class clazz) {
        return this.b.convert(object, propertyDescriptor, clazz, bl);
    }

    public IlvRect getLinkConnectionRectangle(IlvSDMEngine ilvSDMEngine, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (ilvGraphic instanceof IlvDefinitionRectInterface) {
            IlvRect ilvRect = ((IlvDefinitionRectInterface)ilvGraphic).getDefinitionRect();
            ilvGraphic.boundingBox(ilvTransformer);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect);
            }
            return ilvRect;
        }
        if (ilvGraphic instanceof IlvGeneralPath) {
            IlvRect ilvRect = ((IlvGeneralPath)ilvGraphic).getShapeBounds(ilvTransformer);
            return ilvRect;
        }
        return ilvGraphic.boundingBox(ilvTransformer);
    }

    public IlvGraphic getEncapsulatedGraphic(IlvGraphic ilvGraphic) {
        return ilvGraphic;
    }

    public void customize(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, String[] stringArray) {
        try {
            BeanInfo beanInfo = IlvSDMRenderer.a(ilvGraphic.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Object object2;
                Method method = propertyDescriptorArray[i].getWriteMethod();
                if (method == null || (object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, propertyDescriptorArray[i].getName(), stringArray, ilvGraphic.getClass())) == null) continue;
                if (object2.getClass() != propertyDescriptorArray[i].getPropertyType()) {
                    object2 = this.convert(object2, propertyDescriptorArray[i], null);
                }
                Object[] objectArray = new Object[]{object2};
                try {
                    method.invoke((Object)ilvGraphic, objectArray);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static BeanInfo a(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = d.get(clazz);
        if (beanInfo == null) {
            beanInfo = Introspector.getBeanInfo(clazz);
            d.put(clazz, beanInfo);
        }
        return beanInfo;
    }

    public void nodeGraphicBBoxChanged(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, IlvRect ilvRect, IlvRect ilvRect2, String[] stringArray) {
    }

    protected final boolean getLocation(IlvSDMEngine ilvSDMEngine, Object object, IlvPoint ilvPoint) {
        float f;
        float f2 = IlvRendererUtil.getGraphicPropertyAsFloat(ilvSDMEngine, object, "x", null, Float.NaN);
        if (!Float.isNaN(f2) && !Float.isNaN(f = IlvRendererUtil.getGraphicPropertyAsFloat(ilvSDMEngine, object, "y", null, Float.NaN))) {
            ilvPoint.x = f2;
            ilvPoint.y = f;
            return true;
        }
        return false;
    }

    public void setParameter(String string) {
    }

    public String getParameter() {
        return null;
    }

    public Object getAuxiliaryBean() {
        return null;
    }

    public Object[] getAuxiliaryBeans() {
        Object object = this.getAuxiliaryBean();
        if (object != null) {
            return new Object[]{object};
        }
        return null;
    }

    public IlvRect computeBBox(IlvSDMEngine ilvSDMEngine, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        return ilvManagerView.computeBBox(ilvTransformer);
    }

    protected boolean needsViewListeners() {
        return false;
    }

    protected void addViewListeners(IlvManagerView ilvManagerView) {
    }

    protected void removeViewListeners(IlvManagerView ilvManagerView) {
    }

    private void a(IlvManager ilvManager, boolean bl) {
        Enumeration enumeration = ilvManager.getViews();
        while (enumeration.hasMoreElements()) {
            IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
            this.a(ilvManagerView, bl);
        }
        ilvManager.removeManagerViewsListener((ManagerViewsChangedListener)this.e);
        if (bl) {
            ilvManager.addManagerViewsListener((ManagerViewsChangedListener)this.e);
        }
    }

    private void a(IlvManagerView ilvManagerView, boolean bl) {
        this.removeViewListeners(ilvManagerView);
        if (bl) {
            this.addViewListeners(ilvManagerView);
        }
    }

    protected void moveResizeNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, IlvRect ilvRect, int n) {
        IlvRect ilvRect2 = ilvGraphic.boundingBox();
        if (ilvGraphic instanceof IlvDefinitionRectInterface) {
            ilvRect2 = ((IlvDefinitionRectInterface)ilvGraphic).getDefinitionRect();
        }
        this.a(ilvGraphic, ilvRect2, ilvRect, n);
    }

    public void callMoveResizeNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, IlvRect ilvRect, int n) {
        this.moveResizeNodeGraphic(ilvSDMEngine, object, ilvGraphic, ilvRect, n);
    }

    void a(IlvGraphic ilvGraphic, IlvRect ilvRect, IlvRect ilvRect2, int n) {
        ilvRect2 = new IlvRect(ilvRect2);
        if (ilvRect2.width == 0.0f) {
            ilvRect2.width = ilvRect.width;
        }
        if (ilvRect2.height == 0.0f) {
            ilvRect2.height = ilvRect.height;
        }
        if ((n & 2) != 0) {
            ilvRect2.x -= ilvRect2.width;
        } else if ((n & 1) == 0) {
            ilvRect2.x -= ilvRect2.width / 2.0f;
        }
        if ((n & 8) != 0) {
            ilvRect2.y -= ilvRect2.height;
        } else if ((n & 4) == 0) {
            ilvRect2.y -= ilvRect2.height / 2.0f;
        }
        if (!ilvRect2.equals((Object)ilvRect)) {
            if (ilvRect2.width != ilvRect.width || ilvRect2.height != ilvRect.height) {
                if (ilvGraphic instanceof IlvDefinitionRectInterface) {
                    ((IlvDefinitionRectInterface)ilvGraphic).setDefinitionRect(ilvRect2);
                } else if (ilvGraphic instanceof IlvGeneralPath) {
                    ((IlvGeneralPath)ilvGraphic).setShapeBounds(ilvRect2);
                } else {
                    ilvGraphic.moveResize(ilvRect2);
                }
            } else {
                ilvGraphic.translate(ilvRect2.x - ilvRect.x, ilvRect2.y - ilvRect.y);
            }
        }
    }

    public boolean processServerAction(int n, int n2, IlvManagerView ilvManagerView) {
        return false;
    }

    private class ViewsChangedListener
    implements ManagerViewsChangedListener,
    Serializable {
        private ViewsChangedListener() {
        }

        public void viewChanged(ManagerViewsChangedEvent managerViewsChangedEvent) {
            IlvManagerView ilvManagerView = managerViewsChangedEvent.getManagerView();
            if (!(ilvManagerView.getInteractor() instanceof IlvManagerMagViewInteractor)) {
                if (managerViewsChangedEvent.getType() == 1) {
                    IlvSDMRenderer.this.a(ilvManagerView, true);
                }
                if (managerViewsChangedEvent.getType() == 2) {
                    IlvSDMRenderer.this.a(ilvManagerView, false);
                }
            }
        }
    }
}

