/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.dxf.IlvDXFReader;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.IlvRectangle;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.io.IlvSingleValueNamedProperty;
import ilog.views.prototypes.IlvGraphicGroup;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvPrototype;
import ilog.views.prototypes.IlvPrototypeLibrary;
import ilog.views.svg.SVGInputStream;
import ilog.views.svg.SVGStreamFactory;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlvURLGraphic
extends IlvGraphicSet {
    private static WeakHashMap a = new WeakHashMap(20);
    private static String b = "_IlvURLGraphic_url";
    private Color c;
    private Color d;
    private IlvTransformer e;

    public IlvURLGraphic() {
        this.a();
    }

    private void a() {
        IlvRectangle ilvRectangle = new IlvRectangle(new IlvRect(0.0f, 0.0f, 20.0f, 20.0f));
        ilvRectangle.setFillOn(true);
        ilvRectangle.setBackground(Color.gray);
        ilvRectangle.setStrokeOn(false);
        while (this.getCardinal() > 0) {
            this.removeObject(this.getObject(0), false);
        }
        this.addObject((IlvGraphic)ilvRectangle, false);
    }

    public void setURL(String string) {
        String string2 = this.getURL();
        if (string2 == null && string == null || string2 != null && string != null && string.equals(string2)) {
            return;
        }
        if (string != null && !IlvURLGraphic.isSupported(string)) {
            int n = string.lastIndexOf(46);
            String string3 = n > 0 ? string.substring(n) : string;
            Logger.getLogger("ilog.views.sdm", "ilog.views.sdm.messages").log(Level.SEVERE, "URLGraphic.FileNotSupported", new Object[]{string3, string});
            this.a();
            return;
        }
        while (this.getCardinal() > 0) {
            this.removeObject(this.getObject(0), false);
        }
        if (string != null) {
            this.addObject(IlvURLGraphic.get(string), false);
        }
        if (this.e != null) {
            IlvTransformer ilvTransformer = this.e;
            this.e = null;
            this.applyTransform(ilvTransformer);
        }
        if (this.c != null) {
            IlvURLGraphic.a(this, this.c, true);
        }
        if (this.d != null) {
            IlvURLGraphic.a(this, this.d, false);
        }
    }

    public String getURL() {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            String string = IlvURLGraphic.getURL(ilvGraphic);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public IlvURLGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException, IOException {
        super(ilvInputStream);
        try {
            this.setURL(ilvInputStream.readString("url"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setForeground(ilvInputStream.readColor("foreground"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setBackground(ilvInputStream.readColor("background"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            IlvTransformer ilvTransformer = ilvInputStream.readTransformer("transformer");
            this.applyTransform(ilvTransformer);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        Vector<IlvGraphic> vector = new Vector<IlvGraphic>();
        while (this.getCardinal() > 0) {
            IlvGraphic ilvGraphic = this.getObject(0);
            vector.addElement(ilvGraphic);
            this.removeObject(ilvGraphic, false);
        }
        super.write(ilvOutputStream);
        for (int i = 0; i < vector.size(); ++i) {
            this.addObject((IlvGraphic)vector.elementAt(i), false);
        }
        String string = this.getURL();
        if (string != null) {
            ilvOutputStream.write("url", string);
        }
        if (this.c != null) {
            ilvOutputStream.write("foreground", this.c);
        }
        if (this.d != null) {
            ilvOutputStream.write("background", this.d);
        }
        if (this.e != null) {
            ilvOutputStream.write("transformer", this.e);
        }
    }

    public IlvURLGraphic(IlvURLGraphic ilvURLGraphic) {
        super((IlvGraphicSet)ilvURLGraphic);
        this.setURL(ilvURLGraphic.getURL());
        if (ilvURLGraphic.c != null) {
            this.setForeground(ilvURLGraphic.c);
        }
        if (ilvURLGraphic.d != null) {
            this.setBackground(ilvURLGraphic.d);
        }
    }

    public IlvGraphic copy() {
        return new IlvURLGraphic(this);
    }

    public void flush() {
        String string = this.getURL();
        if (string != null && a.containsKey(string)) {
            a.remove(string);
        }
    }

    public static IlvGraphic get(String string) {
        IlvGraphic ilvGraphic = (IlvGraphic)a.get(string);
        if (ilvGraphic == null) {
            block12: {
                try {
                    if (string.endsWith(".svg") || string.endsWith(".svgz")) {
                        URL uRL = new URL(string);
                        SVGStreamFactory sVGStreamFactory = new SVGStreamFactory();
                        sVGStreamFactory.getReaderConfigurator().setAlwaysUseBoundingBox(true);
                        SVGInputStream sVGInputStream = new SVGInputStream(uRL.openStream(), sVGStreamFactory);
                        sVGInputStream.setDocumentBase(uRL);
                        ilvGraphic = new IlvGraphicSet();
                        sVGInputStream.read((IlvGraphicBag)((IlvGraphicSet)ilvGraphic));
                        IlvURLGraphic.a(ilvGraphic);
                        break block12;
                    }
                    if (string.endsWith(".ivl") || string.indexOf(".ivl#") > 0) {
                        try {
                            IlvPrototype ilvPrototype = IlvPrototypeLibrary.getPrototype((String)string, IlvURLGraphic.class);
                            if (ilvPrototype != null) {
                                ilvGraphic = new IlvGraphicGroup((IlvGroup)ilvPrototype.createInstance(null));
                            }
                            break block12;
                        }
                        catch (IlvReadFileException ilvReadFileException) {
                            URL uRL = new URL(string);
                            IlvInputStream ilvInputStream = new IlvInputStream(uRL.openStream());
                            ilvInputStream.setDocumentBase(uRL);
                            ilvGraphic = new IlvGraphicSet();
                            ilvInputStream.read((IlvGraphicBag)((IlvGraphicSet)ilvGraphic));
                        }
                        break block12;
                    }
                    if (string.endsWith(".dxf") || string.endsWith(".DXF")) {
                        ilvGraphic = new IlvGraphicSet();
                        IlvDXFReader ilvDXFReader = new IlvDXFReader();
                        URL uRL = new URL(string);
                        ilvDXFReader.read(uRL, (IlvGraphicBag)((IlvGraphicSet)ilvGraphic));
                    } else if (string.endsWith(".gif") || string.endsWith(".GIF") || string.endsWith(".png") || string.endsWith(".PNG") || string.endsWith(".jpg") || string.endsWith(".JPG") || string.endsWith(".jpeg") || string.endsWith(".JPEG")) {
                        IlvIcon ilvIcon = new IlvIcon();
                        ilvIcon.setHighQualityRendering(true);
                        ilvIcon.setImageLocation(string);
                        ilvGraphic = ilvIcon;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ilvGraphic = null;
                }
            }
            if (ilvGraphic == null) {
                ilvGraphic = new IlvRectangle(new IlvRect(0.0f, 0.0f, 20.0f, 20.0f));
                ilvGraphic.setFillOn(true);
                ilvGraphic.setBackground(Color.gray);
            }
            a.put(string, ilvGraphic);
        }
        ilvGraphic = ilvGraphic.copy();
        ilvGraphic.setNamedProperty((IlvNamedProperty)new IlvSingleValueNamedProperty(b, (Object)string));
        return ilvGraphic;
    }

    public static boolean isSupported(String string) {
        return string != null && (string.endsWith(".svg") || string.endsWith(".svgz") || string.endsWith(".dxf") || string.endsWith(".DXF") || string.endsWith(".gif") || string.endsWith(".GIF") || string.endsWith(".png") || string.endsWith(".PNG") || string.endsWith(".jpg") || string.endsWith(".JPG") || string.endsWith(".jpeg") || string.endsWith(".JPEG") || string.endsWith(".ivl") || string.indexOf(".ivl#") > 0);
    }

    public static String getURL(IlvGraphic ilvGraphic) {
        IlvSingleValueNamedProperty ilvSingleValueNamedProperty = (IlvSingleValueNamedProperty)ilvGraphic.getNamedProperty(b);
        if (ilvSingleValueNamedProperty != null) {
            return (String)ilvSingleValueNamedProperty.getValue();
        }
        return null;
    }

    private static void a(IlvGraphic ilvGraphic) {
        Vector vector = new Vector();
        IlvURLGraphic.a(ilvGraphic, vector);
        for (int i = 0; i < vector.size(); ++i) {
            IlvGraphic ilvGraphic2 = (IlvGraphic)vector.elementAt(i);
            IlvGraphicBag ilvGraphicBag = ilvGraphic2.getGraphicBag();
            if (ilvGraphicBag == null) continue;
            ilvGraphicBag.removeObject(ilvGraphic2, false);
        }
    }

    private static void a(IlvGraphic ilvGraphic, Vector vector) {
        Shape shape;
        if (ilvGraphic instanceof IlvGeneralPath) {
            shape = ((IlvGeneralPath)ilvGraphic).getShape();
            PathIterator pathIterator = shape.getPathIterator(null);
            float[] fArray = new float[6];
            boolean bl = true;
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(fArray);
                if (n != 0 && n != 4) {
                    bl = false;
                }
                pathIterator.next();
            }
            if (bl) {
                vector.addElement(ilvGraphic);
            }
        }
        if (ilvGraphic instanceof IlvGraphicSet) {
            shape = ((IlvGraphicSet)ilvGraphic).getObjects();
            if (shape == null || !shape.hasMoreElements()) {
                vector.addElement(ilvGraphic);
            } else {
                while (shape.hasMoreElements()) {
                    IlvURLGraphic.a(shape.nextElement(), vector);
                }
            }
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.c;
        this.c = color;
        this.registerBlinkingResource(color2, color);
        IlvURLGraphic.a(this, color, true);
    }

    public void setBackground(Color color) {
        Color color2 = this.d;
        this.d = color;
        this.registerBlinkingResource(color2, color);
        IlvURLGraphic.a(this, color, false);
    }

    public Color getForeground() {
        return this.c;
    }

    public Color getBackground() {
        return this.d;
    }

    private static void a(IlvGraphicSet ilvGraphicSet, Color color, boolean bl) {
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvGraphicSet.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (ilvGraphic instanceof IlvGraphicSet) {
                IlvURLGraphic.a((IlvGraphicSet)ilvGraphic, color, bl);
                continue;
            }
            if (bl) {
                ilvGraphic.setForeground(color);
                continue;
            }
            ilvGraphic.setBackground(color);
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        super.applyTransform(ilvTransformer);
        if (this.e == null) {
            this.e = new IlvTransformer(ilvTransformer);
        } else {
            this.e.compose(ilvTransformer);
        }
    }
}

