/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGrapherObjectProperty;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperGrapherEdgeProperty;
import ilog.views.hypergraph.IlvHyperGrapherNodeProperty;
import ilog.views.hypergraph.IlvHyperGrapherObjectProperty;
import ilog.views.hypergraph.IlvSegmentedHyperEdge;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgeConnector;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgePinConnector;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgePinConnectorSelection;
import ilog.views.hypergraph.edgeconnector.IlvHyperGrapherPin;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.internal.IlvIteratorGraphicEnumeration;
import ilog.views.internal.IlvUtility;
import ilog.views.internal.impl.IlvEmptyGraphicEnumeration;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.collections.IlvCollections;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public class IlvHyperGrapher
extends IlvGrapher {
    private static final String a = "Copyright (c) 1996-2006 by ILOG.All Rights Reserved. DECOMPILATION OR ALTERATION OF THE PRESENT CODE IS ILLEGAL. ILOG is the author of and owns this byte-code. Its source code is a trade secret of ILOG. Contact info@ilog.com for more details.";
    private int b = 2;
    private boolean c;
    private boolean d;
    private boolean e;
    private boolean f;
    private int g = 0;
    private boolean h = false;
    private HashSet i;
    private HashSet j;
    private HashSet k;
    private HashSet l = new HashSet();
    private HashSet m;
    private Vector n;

    public IlvHyperGrapher() {
    }

    public IlvHyperGrapher(int n) {
        super(n);
    }

    public IlvHyperGrapher(int n, int n2) {
        super(n, n2);
    }

    public IlvHyperGrapher(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
    }

    public IlvHyperGrapher(IlvHyperGrapher ilvHyperGrapher) {
        super((IlvGrapher)ilvHyperGrapher);
    }

    public IlvGraphic copy() {
        return new IlvHyperGrapher(this);
    }

    public void addObject(IlvGraphic ilvGraphic, int n, boolean bl) {
        if (ilvGraphic instanceof IlvHyperEdge && ((IlvHyperEdge)ilvGraphic).a()) {
            this.a((IlvHyperEdge)ilvGraphic, n, bl);
            return;
        }
        if (!this.d && ilvGraphic instanceof IlvHyperEdge) {
            throw new IllegalArgumentException("IlvHyperEdge objects must be added using addHyperEdge: " + ilvGraphic);
        }
        super.addObject(ilvGraphic, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(IlvGraphic ilvGraphic, int n, boolean bl) {
        if (ilvGraphic instanceof IlvManager && !(ilvGraphic instanceof IlvHyperGrapher)) {
            throw new IllegalArgumentException("The input manager cannot be a node in a hypergrapher.\nUse IlvHyperGrapher as node in nested hypergraphers");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.c = true;
            try {
                super.addNode(ilvGraphic, n, bl);
                IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
                if (ilvHyperEdgeConnector != null) {
                    ilvHyperEdgeConnector.actOnOwnerInserted(ilvGraphic, bl);
                }
            }
            finally {
                this.c = false;
            }
        }
    }

    public void unmakeNode(IlvGraphic ilvGraphic) {
        if (this.isNode(ilvGraphic)) {
            if (this.getHyperEdgesFromCount(ilvGraphic) > 0 || this.getHyperEdgesToCount(ilvGraphic) > 0) {
                throw new IllegalArgumentException("Node " + ilvGraphic + " cannot become non-node because it has hyperedges");
            }
            super.unmakeNode(ilvGraphic);
        }
    }

    public void addHyperEdge(IlvHyperEdge ilvHyperEdge, boolean bl) {
        this.addHyperEdge(ilvHyperEdge, this.getLinksInsertionLayer(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHyperEdge(IlvHyperEdge ilvHyperEdge, int n, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (ilvHyperEdge.getGraphicBag() != null) {
                throw new IllegalArgumentException("Object " + (Object)((Object)ilvHyperEdge) + "is already in a bag");
            }
            if (ilvHyperEdge.getFromEndsCount() + ilvHyperEdge.getToEndsCount() > 0 && !this.f) {
                IlvHyperGrapher ilvHyperGrapher = IlvHyperGrapher.getLowestCommonHyperGrapher(ilvHyperEdge);
                if (ilvHyperGrapher == null) {
                    throw new IllegalArgumentException("End nodes of hyperedge should be in same hypergrapher hierarchy");
                }
                while (ilvHyperGrapher != this && ilvHyperGrapher != null) {
                    ilvHyperGrapher = ilvHyperGrapher.getParent();
                }
                if (ilvHyperGrapher == null) {
                    throw new IllegalArgumentException("End nodes are not in sub graphers of this hypergrapher.");
                }
            }
            if (!this.h(ilvHyperEdge)) {
                throw new IllegalArgumentException("The hyperedge has not the minimal number of end points " + this.getMinHyperEdgeEndCount() + ".");
            }
            this.a(ilvHyperEdge.getFromEnds());
            this.a(ilvHyperEdge.getToEnds());
            this.d = true;
            try {
                this.b(ilvHyperEdge);
                ilvHyperEdge.b();
                super.addObject((IlvGraphic)ilvHyperEdge, n, bl);
            }
            finally {
                this.d = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvHyperEdge ilvHyperEdge, int n, boolean bl) {
        ilvHyperEdge.a(false);
        boolean bl2 = false;
        try {
            this.a(ilvHyperEdge.getFromEnds());
            this.a(ilvHyperEdge.getToEnds());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = true;
        }
        if (bl2) {
            this.b(ilvHyperEdge, n, bl);
        } else {
            this.f = true;
            try {
                this.addHyperEdge(ilvHyperEdge, n, bl);
            }
            finally {
                this.f = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInterGraphHyperEdge(IlvHyperEdge ilvHyperEdge, boolean bl) {
        IlvHyperGrapher ilvHyperGrapher = IlvHyperGrapher.getLowestCommonHyperGrapher(ilvHyperEdge);
        if (ilvHyperGrapher == null) {
            throw new IllegalArgumentException("End nodes of hyperedge should be in a same grapher hierarchy");
        }
        IlvHyperGrapher ilvHyperGrapher2 = ilvHyperGrapher;
        synchronized (ilvHyperGrapher2) {
            try {
                ilvHyperGrapher.f = true;
                ilvHyperGrapher.addHyperEdge(ilvHyperEdge, bl);
            }
            finally {
                ilvHyperGrapher.f = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInterGraphHyperEdge(IlvHyperEdge ilvHyperEdge, int n, boolean bl) {
        IlvHyperGrapher ilvHyperGrapher = IlvHyperGrapher.getLowestCommonHyperGrapher(ilvHyperEdge);
        if (ilvHyperGrapher == null) {
            throw new IllegalArgumentException("End nodes of edge should be in a same grapher hierarchy");
        }
        IlvHyperGrapher ilvHyperGrapher2 = ilvHyperGrapher;
        synchronized (ilvHyperGrapher2) {
            try {
                ilvHyperGrapher.f = true;
                ilvHyperGrapher.addHyperEdge(ilvHyperEdge, n, bl);
            }
            finally {
                ilvHyperGrapher.f = false;
            }
        }
    }

    public static IlvHyperGrapher getLowestCommonHyperGrapher(IlvHyperEdge ilvHyperEdge) {
        int n;
        IlvManager ilvManager;
        IlvGraphicBag ilvGraphicBag;
        IlvGraphic ilvGraphic;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        if (ilvHyperEdge.getFromEndsCount() + ilvHyperEdge.getToEndsCount() <= 0) {
            throw new IllegalArgumentException("Hyperedge must have at least one end node");
        }
        boolean bl = true;
        IlvManager ilvManager2 = null;
        int n2 = 0;
        Iterator iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvGraphic = ilvHyperEdgeEnd.getNode();
            if (ilvGraphic == null) {
                throw new IllegalArgumentException("Hyperedge cannot have a null node as end");
            }
            ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag == null || !(ilvGraphicBag instanceof IlvHyperGrapher)) {
                throw new IllegalArgumentException("Origin end nodes must be already in a hypergrapher");
            }
            ilvManager = (IlvManager)ilvGraphicBag;
            n = IlvHyperGrapher.a(ilvManager);
            if (bl) {
                ilvManager2 = ilvManager;
                n2 = n;
                bl = false;
                continue;
            }
            if (n > n2) {
                ilvManager = IlvHyperGrapher.a(ilvManager, n, n2);
            } else if (n < n2) {
                ilvManager2 = IlvHyperGrapher.a(ilvManager2, n2, n);
                n2 = n;
            }
            while (ilvManager != ilvManager2) {
                ilvManager = ilvManager.getParent();
                ilvManager2 = ilvManager2.getParent();
                --n2;
            }
            if (ilvManager2 != null) continue;
            return null;
        }
        iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvGraphic = ilvHyperEdgeEnd.getNode();
            if (ilvGraphic == null) {
                throw new IllegalArgumentException("Hyperedge cannot have a null node as end");
            }
            ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag == null) {
                throw new IllegalArgumentException("Destination end nodes must be already in a grapher");
            }
            ilvManager = (IlvManager)ilvGraphicBag;
            n = IlvHyperGrapher.a(ilvManager);
            if (bl) {
                ilvManager2 = ilvManager;
                n2 = n;
                bl = false;
                continue;
            }
            if (n > n2) {
                ilvManager = IlvHyperGrapher.a(ilvManager, n, n2);
            } else if (n < n2) {
                ilvManager2 = IlvHyperGrapher.a(ilvManager2, n2, n);
                n2 = n;
            }
            while (ilvManager != ilvManager2) {
                ilvManager = ilvManager.getParent();
                ilvManager2 = ilvManager2.getParent();
                --n2;
            }
            if (ilvManager2 != null) continue;
            return null;
        }
        while (ilvManager2 != null && !(ilvManager2 instanceof IlvHyperGrapher)) {
            ilvManager2 = ilvManager2.getParent();
        }
        return (IlvHyperGrapher)ilvManager2;
    }

    public static IlvHyperGrapher getLowestCommonHyperGrapher(Iterator iterator) {
        boolean bl = true;
        IlvManager ilvManager = null;
        int n = 0;
        while (iterator.hasNext()) {
            IlvGraphic ilvGraphic = (IlvGraphic)iterator.next();
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag == null || !(ilvGraphicBag instanceof IlvHyperGrapher)) {
                throw new IllegalArgumentException("Node must be already in a hypergrapher");
            }
            IlvManager ilvManager2 = (IlvManager)ilvGraphicBag;
            int n2 = IlvHyperGrapher.a(ilvManager2);
            if (bl) {
                ilvManager = ilvManager2;
                n = n2;
                bl = false;
                continue;
            }
            if (n2 > n) {
                ilvManager2 = IlvHyperGrapher.a(ilvManager2, n2, n);
            } else if (n2 < n) {
                ilvManager = IlvHyperGrapher.a(ilvManager, n, n2);
                n = n2;
            }
            while (ilvManager2 != ilvManager) {
                ilvManager2 = ilvManager2.getParent();
                ilvManager = ilvManager.getParent();
                --n;
            }
            if (ilvManager != null) continue;
            return null;
        }
        while (ilvManager != null && !(ilvManager instanceof IlvHyperGrapher)) {
            ilvManager = ilvManager.getParent();
        }
        return (IlvHyperGrapher)ilvManager;
    }

    private static int a(IlvManager ilvManager) {
        int n = 0;
        while (ilvManager != null) {
            ilvManager = ilvManager.getParent();
            ++n;
        }
        return n;
    }

    private static IlvManager a(IlvManager ilvManager, int n, int n2) {
        do {
            ilvManager = ilvManager.getParent();
        } while (--n > n2 && ilvManager != null);
        return ilvManager;
    }

    protected IlvObjectProperty makeObjectProperty(IlvGraphic ilvGraphic) {
        IlvHyperGrapherObjectProperty ilvHyperGrapherObjectProperty = null;
        if (this.c) {
            ilvHyperGrapherObjectProperty = new IlvHyperGrapherNodeProperty();
            this.c = false;
            return ilvHyperGrapherObjectProperty;
        }
        if (this.d) {
            try {
                ilvHyperGrapherObjectProperty = new IlvHyperGrapherEdgeProperty();
                this.d = false;
                this.d((IlvHyperEdge)ilvGraphic);
                this.e((IlvHyperEdge)ilvGraphic);
                this.setMovable(ilvGraphic, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return ilvHyperGrapherObjectProperty;
        }
        return super.makeObjectProperty(ilvGraphic);
    }

    private final void a(Iterator iterator) {
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (ilvObjectProperty instanceof IlvHyperGrapherNodeProperty) continue;
            throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node in a hypergraph");
        }
    }

    private final void d(IlvHyperEdge ilvHyperEdge) {
        Iterator iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            this.a(ilvHyperEdgeEnd);
        }
    }

    private final void e(IlvHyperEdge ilvHyperEdge) {
        Iterator iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            this.b(ilvHyperEdgeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        Object object;
        if (ilvGraphic instanceof IlvHyperEdgeConnector && !(object = (IlvHyperEdgeConnector)ilvGraphic).allowRemoval()) {
            return;
        }
        object = this.getTreeLock();
        synchronized (object) {
            this.a(ilvGraphic);
            if (bl) {
                this.initReDraws();
            }
            this.a(bl);
            try {
                if (this.isNode(ilvGraphic)) {
                    this.removeNode(ilvGraphic, bl);
                } else if (this.isLink(ilvGraphic)) {
                    this.removeLink((IlvLinkImage)ilvGraphic, bl);
                } else if (this.isHyperEdge(ilvGraphic)) {
                    this.removeHyperEdge((IlvHyperEdge)ilvGraphic, bl);
                } else {
                    if (ilvGraphic instanceof IlvHyperGrapher) {
                        IlvHyperGrapher.a((IlvHyperGrapher)ilvGraphic, bl);
                    }
                    super.removeObject(ilvGraphic, bl);
                }
            }
            finally {
                this.b(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(IlvGraphic ilvGraphic, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.a(ilvGraphic);
            if (bl) {
                this.initReDraws();
            }
            this.a(bl);
            try {
                IlvHyperEdgeConnector ilvHyperEdgeConnector;
                if (ilvGraphic instanceof IlvHyperGrapher) {
                    IlvHyperGrapher.a((IlvHyperGrapher)ilvGraphic, bl);
                }
                if ((ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic)) != null) {
                    ilvHyperEdgeConnector.actOnOwnerRemoved(ilvGraphic, bl);
                }
                this.disconnectHyperEdgesFrom(ilvGraphic, bl);
                this.disconnectHyperEdgesTo(ilvGraphic, bl);
                super.removeNode(ilvGraphic, bl);
            }
            finally {
                this.b(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHyperEdge(IlvHyperEdge ilvHyperEdge, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.a((IlvGraphic)ilvHyperEdge);
            if (bl) {
                this.initReDraws();
            }
            this.a(bl);
            try {
                this.e = true;
                super.removeObject((IlvGraphic)ilvHyperEdge, bl);
            }
            finally {
                this.e = false;
                this.b(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    protected void objectRemoved(IlvGraphic ilvGraphic) {
        super.objectRemoved(ilvGraphic);
        if (this.e && ilvGraphic instanceof IlvHyperEdge) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphic;
            this.f(ilvHyperEdge);
            this.g(ilvHyperEdge);
            this.c(ilvHyperEdge);
            this.e = false;
        }
    }

    private static void a(IlvHyperGrapher ilvHyperGrapher, boolean bl) {
        IlvHyperGrapher.a((IlvManager)ilvHyperGrapher, ilvHyperGrapher, bl);
    }

    private static void a(IlvManager ilvManager, IlvHyperGrapher ilvHyperGrapher, boolean bl) {
        IlvManager ilvManager2;
        IlvHyperGrapher ilvHyperGrapher2;
        if (ilvManager instanceof IlvHyperGrapher && (ilvHyperGrapher2 = (IlvHyperGrapher)ilvManager).getExternalInterGraphHyperEdgesCount() > 0) {
            ilvManager2 = new ArrayList(ilvHyperGrapher2.j);
            int n = ilvManager2.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)((Object)ilvManager2.get(i));
                IlvHyperGrapher.a(ilvHyperEdge, ilvHyperGrapher2, bl);
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            ilvHyperGrapher2 = ilvManager.getManagers();
            while (ilvHyperGrapher2.hasMoreElements()) {
                ilvManager2 = (IlvManager)ilvHyperGrapher2.nextElement();
                IlvHyperGrapher.a(ilvManager2, ilvHyperGrapher, bl);
            }
        }
    }

    private static void a(IlvHyperEdge ilvHyperEdge, IlvHyperGrapher ilvHyperGrapher, boolean bl) {
        int n;
        IlvGraphic[] ilvGraphicArray = ilvHyperEdge.getFromArray();
        for (n = 0; n < ilvGraphicArray.length; ++n) {
            if (ilvGraphicArray[n].getGraphicBag() != ilvHyperGrapher) continue;
            IlvHyperGrapher.a(ilvGraphicArray[n], ilvHyperEdge, true, false, bl);
        }
        ilvGraphicArray = ilvHyperEdge.getToArray();
        for (n = 0; n < ilvGraphicArray.length; ++n) {
            if (ilvGraphicArray[n].getGraphicBag() != ilvHyperGrapher) continue;
            IlvHyperGrapher.a(ilvGraphicArray[n], ilvHyperEdge, false, true, bl);
        }
    }

    private static boolean b(IlvHyperGrapher ilvHyperGrapher, IlvHyperEdge ilvHyperEdge) {
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvHyperEdge.getFrom();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            if (!IlvUtility.isOutside((IlvGrapher)ilvHyperGrapher, (IlvGraphic)ilvGraphicEnumeration.nextElement())) continue;
            return true;
        }
        ilvGraphicEnumeration = ilvHyperEdge.getTo();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            if (!IlvUtility.isOutside((IlvGrapher)ilvHyperGrapher, (IlvGraphic)ilvGraphicEnumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public void removeHyperEdgesFrom(IlvGraphic ilvGraphic, boolean bl) {
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (ilvObjectProperty instanceof IlvHyperGrapherNodeProperty) {
            IlvHyperGrapherNodeProperty ilvHyperGrapherNodeProperty = (IlvHyperGrapherNodeProperty)ilvObjectProperty;
            this.a(ilvHyperGrapherNodeProperty.c(), bl);
        }
    }

    public void removeHyperEdgesTo(IlvGraphic ilvGraphic, boolean bl) {
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (ilvObjectProperty instanceof IlvHyperGrapherNodeProperty) {
            IlvHyperGrapherNodeProperty ilvHyperGrapherNodeProperty = (IlvHyperGrapherNodeProperty)ilvObjectProperty;
            this.a(ilvHyperGrapherNodeProperty.d(), bl);
        }
    }

    private void a(IlvGraphicVector ilvGraphicVector, boolean bl) {
        if (ilvGraphicVector != null) {
            int n = ilvGraphicVector.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicVector.elementAt(i);
                if (ilvHyperEdge.getGraphicBag() == null) continue;
                if (ilvHyperEdge.getGraphicBag() == this) {
                    this.removeHyperEdge(ilvHyperEdge, bl);
                    continue;
                }
                ilvHyperEdge.getGraphicBag().removeObject((IlvGraphic)ilvHyperEdge, bl);
            }
        }
    }

    private final void f(IlvHyperEdge ilvHyperEdge) {
        Iterator iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            this.c(ilvHyperEdgeEnd);
        }
    }

    private final void g(IlvHyperEdge ilvHyperEdge) {
        Iterator iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            this.d(ilvHyperEdgeEnd);
        }
    }

    private void a(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (ilvGraphic.getGraphicBag() != this) {
            throw new IllegalArgumentException("object is not in this grapher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isHyperEdge(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!(ilvGraphic instanceof IlvHyperEdge)) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            IlvGrapherObjectProperty ilvGrapherObjectProperty = (IlvGrapherObjectProperty)IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            return ilvGrapherObjectProperty != null && ilvGrapherObjectProperty.isHyperEdge() && ilvGraphic.getGraphicBag() == this;
        }
    }

    final void a(boolean bl) {
        IlvManager ilvManager = this.getParent();
        if (ilvManager == null) {
            return;
        }
        ilvManager.beforeTransform((IlvGraphic)this, bl, true, true);
    }

    final void b(boolean bl) {
        IlvManager ilvManager = this.getParent();
        if (ilvManager == null) {
            return;
        }
        ilvManager.afterTransform((IlvGraphic)this, bl, true, true, true);
    }

    protected void beforeTransformObj(IlvGraphic ilvGraphic, boolean bl, boolean bl2, boolean bl3) {
        if (this.a()) {
            ++this.g;
        }
        super.beforeTransformObj(ilvGraphic, bl, bl2, bl3);
        this.b(ilvGraphic);
        if (ilvGraphic instanceof IlvHyperEdge) {
            ((IlvHyperEdge)ilvGraphic).clearBoundingBoxCache();
        } else if (ilvGraphic instanceof IlvHyperEdgeConnector) {
            ((IlvHyperEdgeConnector)ilvGraphic).clearBoundingBoxCache();
        }
    }

    protected void afterTransformObj(IlvGraphic ilvGraphic, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super.afterTransformObj(ilvGraphic, bl, bl2, bl3, bl4);
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
        if (ilvHyperEdgeConnector != null) {
            ilvHyperEdgeConnector.actAfterOwnerTransform(bl);
        }
        if (this.a()) {
            --this.g;
            if (this.g <= 0) {
                this.g = 0;
            }
            this.c((IlvManager)this);
        }
    }

    private void b(IlvGraphic ilvGraphic) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
        if (ilvHyperEdgeConnector != null) {
            ilvHyperEdgeConnector.adjustAll();
        } else if (ilvGraphic instanceof IlvHyperEdge) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd;
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphic;
            Iterator iterator = ilvHyperEdge.getFromEnds();
            while (iterator.hasNext()) {
                ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
                ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvHyperEdgeEnd.getNode());
                if (ilvHyperEdgeConnector == null) continue;
                ilvHyperEdgeConnector.adjust(ilvHyperEdgeEnd);
            }
            iterator = ilvHyperEdge.getToEnds();
            while (iterator.hasNext()) {
                ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
                ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvHyperEdgeEnd.getNode());
                if (ilvHyperEdgeConnector == null) continue;
                ilvHyperEdgeConnector.adjust(ilvHyperEdgeEnd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeTransformDependentObjs(HashSet hashSet, boolean bl, boolean bl2) {
        this.c(false);
        try {
            super.beforeTransformDependentObjs(hashSet, bl, bl2);
        }
        finally {
            this.c(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterTransformDependentObjs(HashSet hashSet, boolean bl, boolean bl2) {
        this.c(false);
        try {
            super.afterTransformDependentObjs(hashSet, bl, bl2);
        }
        finally {
            this.c(true);
        }
    }

    private void c(boolean bl) {
        IlvHyperGrapher ilvHyperGrapher = this.b();
        ilvHyperGrapher.h = !bl;
    }

    private boolean a() {
        IlvHyperGrapher ilvHyperGrapher = this.b();
        return !ilvHyperGrapher.h;
    }

    private IlvHyperGrapher b() {
        if (this.getTreeLock() instanceof IlvHyperGrapher) {
            return (IlvHyperGrapher)((Object)this.getTreeLock());
        }
        IlvHyperGrapher ilvHyperGrapher = this;
        for (IlvHyperGrapher ilvHyperGrapher2 = this; ilvHyperGrapher2 != null; ilvHyperGrapher2 = ilvHyperGrapher2.getParent()) {
            if (!(ilvHyperGrapher2 instanceof IlvHyperGrapher)) continue;
            ilvHyperGrapher = ilvHyperGrapher2;
        }
        return ilvHyperGrapher;
    }

    public void replaceObject(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        if (ilvGraphic == null || ilvGraphic2 == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (ilvGraphic == ilvGraphic2) {
            throw new IllegalArgumentException("Object " + ilvGraphic2 + ": " + "Cannot replace with same object");
        }
        if (ilvGraphic2.getGraphicBag() != null) {
            throw new IllegalArgumentException("Object " + ilvGraphic2 + ": " + "New object is already in a bag");
        }
        if (!this.isManaged(ilvGraphic)) {
            throw new IllegalArgumentException("Object " + ilvGraphic + " is not in this manager");
        }
        if (this.isNode(ilvGraphic)) {
            this.a(ilvGraphic, ilvGraphic2, bl);
        } else if (this.isHyperEdge(ilvGraphic) && ilvGraphic2 instanceof IlvHyperEdge) {
            this.b(ilvGraphic, ilvGraphic2, bl);
        } else {
            super.replaceObject(ilvGraphic, ilvGraphic2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (bl) {
                this.initReDraws();
            }
            this.a(bl);
            try {
                int n;
                Object object2;
                int n2;
                Object object3;
                Object object4;
                ArrayList<Object> arrayList = null;
                ArrayList<IlvHyperEdge> arrayList2 = null;
                int n3 = this.getHyperEdgesFromCount(ilvGraphic);
                if (n3 != 0) {
                    arrayList = new ArrayList<Object>(n3);
                    IlvGraphicEnumeration ilvGraphicEnumeration = this.getHyperEdgesFrom(ilvGraphic);
                    while (ilvGraphicEnumeration.hasMoreElements()) {
                        object4 = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
                        object3 = new HyperEdgeInfo((IlvHyperEdge)((Object)object4));
                        arrayList.add(object3);
                        ((HyperEdgeInfo)object3).c = ((IlvHyperEdge)((Object)object4)).getFromEndsArray(ilvGraphic);
                    }
                }
                if ((n2 = this.getHyperEdgesToCount(ilvGraphic)) != 0) {
                    arrayList2 = new ArrayList<IlvHyperEdge>(n2);
                    object4 = this.getHyperEdgesTo(ilvGraphic);
                    while (object4.hasMoreElements()) {
                        object3 = (IlvHyperEdge)object4.nextElement();
                        object2 = new HyperEdgeInfo((IlvHyperEdge)((Object)object3));
                        arrayList2.add((IlvHyperEdge)((Object)object2));
                        ((HyperEdgeInfo)object2).c = ((IlvHyperEdge)((Object)object3)).getToEndsArray(ilvGraphic);
                    }
                }
                super.replaceObject(ilvGraphic, ilvGraphic2, bl);
                for (n = 0; n < n3; ++n) {
                    object3 = (HyperEdgeInfo)arrayList.get(n);
                    object2 = ((HyperEdgeInfo)object3).b;
                    object2.getGraphicBag().applyToObject((IlvGraphic)object2, new IlvApplyObject((HyperEdgeInfo)object3, (IlvHyperEdge)((Object)object2)){
                        final /* synthetic */ HyperEdgeInfo a;
                        final /* synthetic */ IlvHyperEdge b;
                        {
                            this.a = hyperEdgeInfo;
                            this.b = ilvHyperEdge;
                        }

                        public void apply(IlvGraphic ilvGraphic, Object object) {
                            for (int i = 0; i < this.a.c.length; ++i) {
                                IlvHyperEdgeEnd ilvHyperEdgeEnd = this.a.c[i];
                                IlvHyperEdgeEnd ilvHyperEdgeEnd2 = this.b.addFrom((IlvGraphic)object);
                                ilvHyperEdgeEnd2.setPosition(ilvHyperEdgeEnd.getPosition(null, false), null);
                            }
                        }
                    }, (Object)ilvGraphic2, bl);
                }
                for (n = 0; n < n2; ++n) {
                    object3 = (HyperEdgeInfo)arrayList2.get(n);
                    object2 = ((HyperEdgeInfo)object3).b;
                    object2.getGraphicBag().applyToObject((IlvGraphic)object2, new IlvApplyObject((HyperEdgeInfo)object3, (IlvHyperEdge)((Object)object2)){
                        final /* synthetic */ HyperEdgeInfo a;
                        final /* synthetic */ IlvHyperEdge b;
                        {
                            this.a = hyperEdgeInfo;
                            this.b = ilvHyperEdge;
                        }

                        public void apply(IlvGraphic ilvGraphic, Object object) {
                            for (int i = 0; i < this.a.c.length; ++i) {
                                IlvHyperEdgeEnd ilvHyperEdgeEnd = this.a.c[i];
                                IlvHyperEdgeEnd ilvHyperEdgeEnd2 = this.b.addTo((IlvGraphic)object);
                                ilvHyperEdgeEnd2.setPosition(ilvHyperEdgeEnd.getPosition(null, false), null);
                            }
                        }
                    }, (Object)ilvGraphic2, bl);
                }
            }
            finally {
                this.b(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (bl) {
                this.initReDraws();
            }
            this.a(bl);
            try {
                this.a((IlvHyperEdge)ilvGraphic, (IlvHyperEdge)ilvGraphic2, bl);
            }
            finally {
                this.b(bl);
                if (bl) {
                    this.reDrawViews();
                }
            }
        }
    }

    private void a(IlvHyperEdge ilvHyperEdge, IlvHyperEdge ilvHyperEdge2, boolean bl) {
        IlvPoint ilvPoint;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = ilvHyperEdge.getFromEndsArray();
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray2 = ilvHyperEdge.getToEndsArray();
        ilvHyperEdge2.setFrom(null);
        for (IlvHyperEdgeEnd ilvHyperEdgeEnd2 : ilvHyperEdgeEndArray) {
            ilvHyperEdgeEnd = ilvHyperEdge2.addFrom(ilvHyperEdgeEnd2.getNode());
            ilvPoint = ilvHyperEdgeEnd2.getPosition(null, false);
            ilvHyperEdgeEnd.setPosition(ilvPoint, null);
        }
        ilvHyperEdge2.setTo(null);
        for (IlvHyperEdgeEnd ilvHyperEdgeEnd2 : ilvHyperEdgeEndArray2) {
            ilvHyperEdgeEnd = ilvHyperEdge2.addTo(ilvHyperEdgeEnd2.getNode());
            ilvPoint = ilvHyperEdgeEnd2.getPosition(null, false);
            ilvHyperEdgeEnd.setPosition(ilvPoint, null);
        }
        String string = ilvHyperEdge.getName();
        boolean bl2 = this.isMovable(ilvHyperEdge);
        boolean bl3 = this.isEditable(ilvHyperEdge);
        boolean bl4 = this.isSelectable(ilvHyperEdge);
        boolean bl5 = this.isSelected(ilvHyperEdge);
        boolean bl6 = ilvHyperEdge.isVisible();
        int n = this.getLayer(ilvHyperEdge);
        this.removeObject(ilvHyperEdge, bl);
        ilvHyperEdge2.setVisible(bl6);
        this.addHyperEdge(ilvHyperEdge2, n, bl);
        if (bl5) {
            this.setSelected((IlvGraphic)ilvHyperEdge2, true, bl);
        }
        this.setSelectable(ilvHyperEdge2, bl4);
        this.setEditable(ilvHyperEdge2, bl3);
        this.setMovable(ilvHyperEdge2, bl2);
        if (string != null) {
            this.setObjectName(ilvHyperEdge2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(IlvGraphic ilvGraphic, boolean bl, boolean bl2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (bl == this.isSelected(ilvGraphic)) {
                return;
            }
            if (bl2) {
                this.initReDraws();
            }
            this.a(bl2);
            try {
                super.setSelected(ilvGraphic, bl, bl2);
                if (ilvGraphic instanceof IlvSegmentedHyperEdge) {
                    IlvSegmentedHyperEdge ilvSegmentedHyperEdge = (IlvSegmentedHyperEdge)ilvGraphic;
                    ilvSegmentedHyperEdge.deSelectAll(bl2);
                }
            }
            finally {
                this.b(bl2);
                if (bl2) {
                    this.reDrawViews();
                }
            }
        }
    }

    public void setSelected(IlvGraphic ilvGraphic, IlvPoint ilvPoint, IlvManagerView ilvManagerView) {
        IlvHyperGrapherPin ilvHyperGrapherPin;
        IlvHyperEdgePinConnector ilvHyperEdgePinConnector;
        IlvHyperEdgePinConnectorSelection ilvHyperEdgePinConnectorSelection;
        super.setSelected(ilvGraphic, ilvPoint, ilvManagerView);
        if (ilvGraphic instanceof IlvHyperEdgePinConnector && ilvManagerView.getInteractor() instanceof IlvSelectInteractor && (ilvHyperEdgePinConnectorSelection = (IlvHyperEdgePinConnectorSelection)this.getSelection(ilvHyperEdgePinConnector = (IlvHyperEdgePinConnector)ilvGraphic)) != null && (ilvHyperGrapherPin = ilvHyperEdgePinConnector.getClosestPin(ilvPoint, ilvManagerView.getTransformer())) != null) {
            ilvHyperEdgePinConnectorSelection.selectAllPins(false, false);
            ilvHyperEdgePinConnectorSelection.setPinSelected(ilvHyperGrapherPin, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(InputStream inputStream) throws IOException, IlvReadFileException {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.n = null;
            boolean bl = super.read(inputStream);
            IlvHyperGrapher.d((IlvManager)this);
            IlvHyperGrapher.b((IlvManager)this);
            return bl;
        }
    }

    private static void b(IlvManager ilvManager) {
        IlvGraphicEnumeration ilvGraphicEnumeration;
        IlvHyperGrapher ilvHyperGrapher;
        if (ilvManager instanceof IlvHyperGrapher) {
            ilvHyperGrapher = (IlvHyperGrapher)ilvManager;
            ilvGraphicEnumeration = ilvHyperGrapher.getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
                if (ilvHyperEdgeConnector == null) continue;
                ilvHyperEdgeConnector.actOnOwnerRead(ilvGraphic);
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            ilvHyperGrapher = ilvManager.getManagers();
            while (ilvHyperGrapher.hasMoreElements()) {
                ilvGraphicEnumeration = (IlvManager)ilvHyperGrapher.nextElement();
                IlvHyperGrapher.b((IlvManager)ilvGraphicEnumeration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelections(boolean bl, boolean bl2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getSelectedObjectsCount(bl) == 0) {
                return;
            }
            this.a(bl2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl, boolean bl2) {
        int n = this.getSelectedObjectsCount();
        this.setContentsAdjusting(true);
        this.setSelectionAdjusting(true);
        if (bl) {
            this.initReDraws();
        }
        this.a(bl);
        try {
            IlvGraphicVector ilvGraphicVector;
            if (n != 0) {
                IlvGraphic ilvGraphic;
                ilvGraphicVector = new IlvGraphicVector(n);
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelections();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    IlvSelection ilvSelection = (IlvSelection)ilvGraphicEnumeration.nextElement();
                    ilvGraphic = ilvSelection.getObject();
                    ilvGraphicVector.addElement(ilvGraphic);
                }
                int n2 = ilvGraphicVector.size();
                for (int i = 0; i < n2; ++i) {
                    ilvGraphic = ilvGraphicVector.elementAt(i);
                    if (ilvGraphic.getGraphicBag() != this) continue;
                    boolean bl3 = false;
                    if (this.isHyperEdge(ilvGraphic)) {
                        bl3 = ((IlvHyperEdge)ilvGraphic).deleteSelection(bl);
                    }
                    if (bl3) continue;
                    this.removeObject(ilvGraphic, bl);
                }
            }
            if (bl2 && this.getManagersCount() != 0) {
                ilvGraphicVector = this.getManagers();
                while (ilvGraphicVector.hasMoreElements()) {
                    IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)ilvGraphicVector.nextElement();
                    ilvHyperGrapher.a(bl, true);
                }
            }
        }
        finally {
            this.b(bl);
            if (bl) {
                this.reDrawViews();
            }
            this.setContentsAdjusting(false);
            this.setSelectionAdjusting(false);
        }
    }

    public void duplicateSelections(int n, int n2) {
        if (this.getSelectedObjectsCount() == 0) {
            return;
        }
        IlvGraphicVector ilvGraphicVector = this.d(true);
        this.a(ilvGraphicVector, false, true);
        IlvRect ilvRect = null;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelectedObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (ilvRect == null) {
                ilvRect = ilvGraphic.boundingBox(null);
                continue;
            }
            ilvRect.add(ilvGraphic.boundingBox(null));
        }
        this.copySelection();
        this.deSelectAll(true);
        this.pasteSelection(new IlvPoint(ilvRect.x + (float)n, ilvRect.y + (float)n2), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvGraphicEnumeration pasteSelection(IlvPoint ilvPoint, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.n = null;
            IlvGraphicEnumeration ilvGraphicEnumeration = super.pasteSelection(ilvPoint, bl);
            IlvHyperGrapher.d((IlvManager)this);
            return ilvGraphicEnumeration;
        }
    }

    public void copySelection() {
        IlvGraphicVector ilvGraphicVector = this.d(false);
        IlvGraphicVector ilvGraphicVector2 = this.c();
        this.a(ilvGraphicVector, false, false);
        this.a(ilvGraphicVector2, true, false);
        super.copySelection();
        this.a(ilvGraphicVector2, false, false);
        this.a(ilvGraphicVector, true, false);
    }

    private IlvGraphicVector c() {
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelectedObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvHyperEdgeConnector ilvHyperEdgeConnector;
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!this.isNode(ilvGraphic) || (ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic)) == null || ilvHyperEdgeConnector.getGraphicBag() != this || this.isSelected(ilvHyperEdgeConnector)) continue;
            ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdgeConnector);
        }
        return ilvGraphicVector;
    }

    private IlvGraphicVector d(boolean bl) {
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelectedObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!(ilvGraphic instanceof IlvHyperEdgeConnector)) continue;
            IlvHyperEdgeConnector ilvHyperEdgeConnector = (IlvHyperEdgeConnector)ilvGraphic;
            if (bl) {
                ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdgeConnector);
                continue;
            }
            IlvGraphic ilvGraphic2 = ilvHyperEdgeConnector.getOwner();
            if (ilvGraphic2 != null && ilvGraphic2.getGraphicBag() == this) {
                if (this.isSelected(ilvGraphic2)) continue;
                ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdgeConnector);
                continue;
            }
            ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdgeConnector);
        }
        return ilvGraphicVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphicVector ilvGraphicVector, boolean bl, boolean bl2) {
        if (ilvGraphicVector.size() == 0) {
            return;
        }
        if (bl2) {
            this.initReDraws();
        }
        this.setSelectionAdjusting(true);
        try {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvGraphicVector.elements();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                this.setSelected(ilvGraphic, bl, bl2);
            }
        }
        finally {
            this.setSelectionAdjusting(false);
            if (bl2) {
                this.reDrawViews();
            }
        }
    }

    public IlvGraphicEnumeration getSelectedMovingObjects(boolean[] blArray) {
        if (blArray[1]) {
            return this.a(blArray);
        }
        return super.getSelectedMovingObjects(blArray);
    }

    private IlvGraphicEnumeration a(boolean[] blArray) {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelectedObjects();
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector();
        HashSet<IlvGraphic> hashSet = new HashSet<IlvGraphic>();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!this.allowMoving(ilvGraphic)) continue;
            if (this.isNode(ilvGraphic)) {
                ilvGraphicVector.addElement(ilvGraphic);
                if (blArray[0]) {
                    this.a(ilvGraphic, hashSet, ilvGraphicVector);
                }
                if (!blArray[1]) continue;
                this.b(ilvGraphic, hashSet, ilvGraphicVector);
                continue;
            }
            if (this.isLink(ilvGraphic)) {
                if (this.a(hashSet, (IlvLinkImage)ilvGraphic)) {
                    ilvGraphicVector.addElement(ilvGraphic);
                }
                hashSet.add(ilvGraphic);
                continue;
            }
            if (this.isHyperEdge(ilvGraphic)) {
                if (this.a(hashSet, (IlvHyperEdge)ilvGraphic)) {
                    ilvGraphicVector.addElement(ilvGraphic);
                }
                hashSet.add(ilvGraphic);
                continue;
            }
            ilvGraphicVector.addElement(ilvGraphic);
        }
        return ilvGraphicVector.elements();
    }

    private void a(IlvGraphic ilvGraphic, HashSet hashSet, IlvGraphicVector ilvGraphicVector) {
        IlvLinkImage ilvLinkImage;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinksFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (this.a(hashSet, ilvLinkImage)) {
                ilvGraphicVector.addElement((IlvGraphic)ilvLinkImage);
            }
            hashSet.add(ilvLinkImage);
        }
        if (ilvGraphic instanceof IlvGrapher) {
            ilvGraphicEnumeration = ((IlvGrapher)ilvGraphic).getTreeExternalInterGraphLinks();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (this.a(hashSet, ilvLinkImage)) {
                    ilvGraphicVector.addElement((IlvGraphic)ilvLinkImage);
                }
                hashSet.add(ilvLinkImage);
            }
        }
    }

    private void b(IlvGraphic ilvGraphic, HashSet hashSet, IlvGraphicVector ilvGraphicVector) {
        IlvHyperEdge ilvHyperEdge;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getHyperEdgesFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvHyperEdge = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
            if (this.a(hashSet, ilvHyperEdge)) {
                ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdge);
            }
            hashSet.add(ilvHyperEdge);
        }
        if (ilvGraphic instanceof IlvHyperGrapher) {
            ilvGraphicEnumeration = ((IlvHyperGrapher)ilvGraphic).getTreeExternalInterGraphHyperEdges();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvHyperEdge = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
                if (this.a(hashSet, ilvHyperEdge)) {
                    ilvGraphicVector.addElement((IlvGraphic)ilvHyperEdge);
                }
                hashSet.add(ilvHyperEdge);
            }
        }
    }

    private IlvGraphic c(IlvGraphic ilvGraphic) {
        while (ilvGraphic != null) {
            if (ilvGraphic.getGraphicBag() == this) {
                return ilvGraphic;
            }
            ilvGraphic = (IlvGraphic)ilvGraphic.getGraphicBag();
        }
        return null;
    }

    private boolean a(HashSet hashSet, IlvLinkImage ilvLinkImage) {
        if (hashSet.contains(ilvLinkImage)) {
            return false;
        }
        if (ilvLinkImage.getGraphicBag() != this) {
            return false;
        }
        IlvGraphic ilvGraphic = this.c(ilvLinkImage.getFrom());
        if (ilvGraphic == null) {
            return false;
        }
        IlvGraphic ilvGraphic2 = this.c(ilvLinkImage.getTo());
        if (ilvGraphic2 == null) {
            return false;
        }
        if (!this.isSelected(ilvGraphic)) {
            return false;
        }
        if (!this.isSelected(ilvGraphic2)) {
            return false;
        }
        if (!this.allowMoving(ilvGraphic)) {
            return false;
        }
        return this.allowMoving(ilvGraphic2);
    }

    private boolean a(HashSet hashSet, IlvHyperEdge ilvHyperEdge) {
        IlvGraphic ilvGraphic;
        if (hashSet.contains((Object)ilvHyperEdge)) {
            return false;
        }
        if (ilvHyperEdge.getGraphicBag() != this) {
            return false;
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvHyperEdge.getFrom();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphic = this.c(ilvGraphicEnumeration.nextElement());
            if (ilvGraphic == null) {
                return false;
            }
            if (!this.isSelected(ilvGraphic)) {
                return false;
            }
            if (this.allowMoving(ilvGraphic)) continue;
            return false;
        }
        ilvGraphicEnumeration = ilvHyperEdge.getTo();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphic = this.c(ilvGraphicEnumeration.nextElement());
            if (ilvGraphic == null) {
                return false;
            }
            if (!this.isSelected(ilvGraphic)) {
                return false;
            }
            if (this.allowMoving(ilvGraphic)) continue;
            return false;
        }
        return true;
    }

    protected void afterHyperEdgeEndsChanged(Iterator iterator) {
        this.a(iterator, true);
    }

    private void c(IlvManager ilvManager) {
        if (ilvManager == null) {
            return;
        }
        if (ilvManager instanceof IlvHyperGrapher) {
            ((IlvHyperGrapher)ilvManager).d();
        }
        this.c(ilvManager.getParent());
    }

    private void d() {
        if (this.l != null && this.l.size() > 0) {
            Iterator iterator = this.l.iterator();
            this.l = new HashSet();
            this.afterHyperEdgeEndsChanged(iterator);
        }
    }

    void a(IlvHyperEdge ilvHyperEdge) {
        if (this.l != null) {
            this.l.add(ilvHyperEdge);
        }
    }

    public void setMinHyperEdgeEndCount(int n) {
        if (n != this.b) {
            int n2 = this.b;
            this.b = n;
            if (n > n2) {
                this.e();
            }
        }
    }

    public int getMinHyperEdgeEndCount() {
        return this.b;
    }

    private boolean h(IlvHyperEdge ilvHyperEdge) {
        int n = ilvHyperEdge.getToEndsCount() + ilvHyperEdge.getFromEndsCount();
        return n >= this.getMinHyperEdgeEndCount();
    }

    private void e() {
        if (this.getMinHyperEdgeEndCount() <= 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.a(this.getHyperEdges(), arrayList);
        this.a(this.getInterGraphHyperEdges(), arrayList);
        this.a(arrayList.iterator(), false);
    }

    private void a(IlvGraphicEnumeration ilvGraphicEnumeration, ArrayList arrayList) {
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
            if (this.h(ilvHyperEdge)) continue;
            arrayList.add(ilvHyperEdge);
        }
    }

    private void a(Iterator iterator, boolean bl) {
        if (this.getMinHyperEdgeEndCount() <= 0) {
            return;
        }
        while (iterator.hasNext()) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)((Object)iterator.next());
            if (ilvHyperEdge.getGraphicBag() != this || bl && this.h(ilvHyperEdge)) continue;
            this.removeObject(ilvHyperEdge, true);
        }
    }

    private static IlvGraphicVector a(HashSet hashSet) {
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ilvGraphicVector.addElement((IlvGraphic)iterator.next());
        }
        return ilvGraphicVector;
    }

    protected HashSet getBoundingBoxDependentObjects(IlvGraphic ilvGraphic, boolean bl) {
        HashSet<IlvHyperEdgeConnector> hashSet = super.getBoundingBoxDependentObjects(ilvGraphic, bl);
        if (this.isNode(ilvGraphic)) {
            if (hashSet == null) {
                hashSet = new HashSet<IlvHyperEdgeConnector>();
            }
            this.a(ilvGraphic, hashSet, bl);
            IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
            if (ilvHyperEdgeConnector != null && ilvHyperEdgeConnector.getGraphicBag() != null) {
                hashSet.add(ilvHyperEdgeConnector);
            }
        } else if (ilvGraphic instanceof IlvHyperGrapher && bl) {
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            this.a((IlvManager)ilvGraphic, (IlvHyperGrapher)ilvGraphic, hashSet);
        }
        return hashSet;
    }

    private void a(IlvGraphic ilvGraphic, HashSet hashSet, boolean bl) {
        IlvHyperEdge ilvHyperEdge;
        int n;
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
            return;
        }
        IlvHyperGrapherNodeProperty ilvHyperGrapherNodeProperty = (IlvHyperGrapherNodeProperty)ilvObjectProperty;
        IlvGraphicVector ilvGraphicVector = ilvHyperGrapherNodeProperty.c();
        int n2 = ilvGraphicVector == null ? 0 : ilvGraphicVector.size();
        for (n = 0; n < n2; ++n) {
            ilvHyperEdge = (IlvHyperEdge)ilvGraphicVector.elementAt(n);
            if (hashSet.contains((Object)ilvHyperEdge)) continue;
            hashSet.add(ilvHyperEdge);
        }
        ilvGraphicVector = ilvHyperGrapherNodeProperty.d();
        n2 = ilvGraphicVector == null ? 0 : ilvGraphicVector.size();
        for (n = 0; n < n2; ++n) {
            ilvHyperEdge = (IlvHyperEdge)ilvGraphicVector.elementAt(n);
            if (hashSet.contains((Object)ilvHyperEdge)) continue;
            hashSet.add(ilvHyperEdge);
        }
        if (ilvGraphic instanceof IlvHyperGrapher && bl) {
            this.a((IlvManager)ilvGraphic, (IlvHyperGrapher)ilvGraphic, hashSet);
        }
    }

    private void a(IlvManager ilvManager, IlvHyperGrapher ilvHyperGrapher, HashSet hashSet) {
        IlvHyperGrapher ilvHyperGrapher2;
        int n;
        if (ilvManager instanceof IlvHyperGrapher && (n = (ilvHyperGrapher2 = (IlvHyperGrapher)ilvManager).getExternalInterGraphHyperEdgesCount()) > 0) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvHyperGrapher2.getExternalInterGraphHyperEdges();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
                if (ilvManager != ilvHyperGrapher && !IlvHyperGrapher.b(ilvHyperGrapher, ilvHyperEdge) || ilvHyperEdge.getGraphicBag() == null || hashSet.contains((Object)ilvHyperEdge)) continue;
                hashSet.add(ilvHyperEdge);
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            ilvHyperGrapher2 = ilvManager.getManagers();
            while (ilvHyperGrapher2.hasMoreElements()) {
                IlvManager ilvManager2 = (IlvManager)ilvHyperGrapher2.nextElement();
                this.a(ilvManager2, ilvHyperGrapher, hashSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator getHyperEdgeEndsFrom(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            ArrayList arrayList = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).a();
            if (arrayList == null) {
                return IlvCollections.emptyIterator();
            }
            return arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator getHyperEdgeEndsTo(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            ArrayList arrayList = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).b();
            if (arrayList == null) {
                return IlvCollections.emptyIterator();
            }
            return arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHyperEdgeEndsFromCount(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            ArrayList arrayList = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).a();
            if (arrayList == null) {
                return 0;
            }
            return arrayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHyperEdgeEndsToCount(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            ArrayList arrayList = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).b();
            if (arrayList == null) {
                return 0;
            }
            return arrayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getHyperEdgesFrom(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            IlvGraphicVector ilvGraphicVector = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).c();
            if (ilvGraphicVector == null) {
                return IlvEmptyGraphicEnumeration.instance;
            }
            return ilvGraphicVector.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getHyperEdgesTo(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            IlvGraphicVector ilvGraphicVector = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).d();
            if (ilvGraphicVector == null) {
                return IlvEmptyGraphicEnumeration.instance;
            }
            return ilvGraphicVector.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHyperEdgesFromCount(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            IlvGraphicVector ilvGraphicVector = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).c();
            if (ilvGraphicVector == null) {
                return 0;
            }
            return ilvGraphicVector.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHyperEdgesToCount(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
            if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
                throw new IllegalArgumentException("Object " + ilvGraphic + ": not a node");
            }
            IlvGraphicVector ilvGraphicVector = ((IlvHyperGrapherNodeProperty)ilvObjectProperty).d();
            if (ilvGraphicVector == null) {
                return 0;
            }
            return ilvGraphicVector.size();
        }
    }

    void a(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
            throw new RuntimeException("Not a node in grapher");
        }
        ((IlvHyperGrapherNodeProperty)ilvObjectProperty).a(ilvHyperEdgeEnd);
    }

    void b(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
            throw new RuntimeException("Not a node in grapher");
        }
        ((IlvHyperGrapherNodeProperty)ilvObjectProperty).b(ilvHyperEdgeEnd);
    }

    void c(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector;
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (ilvObjectProperty instanceof IlvHyperGrapherNodeProperty) {
            ((IlvHyperGrapherNodeProperty)ilvObjectProperty).c(ilvHyperEdgeEnd);
        }
        if ((ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd)) != null) {
            ilvHyperEdgeConnector.disconnect(ilvHyperEdgeEnd);
        }
    }

    void d(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector;
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (ilvObjectProperty instanceof IlvHyperGrapherNodeProperty) {
            ((IlvHyperGrapherNodeProperty)ilvObjectProperty).d(ilvHyperEdgeEnd);
        }
        if ((ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd)) != null) {
            ilvHyperEdgeConnector.disconnect(ilvHyperEdgeEnd);
        }
    }

    public void disconnectHyperEdgesFrom(IlvGraphic ilvGraphic, boolean bl) {
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
            return;
        }
        IlvHyperGrapherNodeProperty ilvHyperGrapherNodeProperty = (IlvHyperGrapherNodeProperty)ilvObjectProperty;
        IlvGraphicVector ilvGraphicVector = ilvHyperGrapherNodeProperty.c();
        ilvHyperGrapherNodeProperty.e();
        if (ilvGraphicVector != null) {
            int n = ilvGraphicVector.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicVector.elementAt(i);
                IlvHyperGrapher.a(ilvGraphic, ilvHyperEdge, true, false, bl);
            }
        }
    }

    public void disconnectHyperEdgesTo(IlvGraphic ilvGraphic, boolean bl) {
        IlvObjectProperty ilvObjectProperty = IlvManager.getObjectProperty((IlvGraphic)ilvGraphic);
        if (!(ilvObjectProperty instanceof IlvHyperGrapherNodeProperty)) {
            return;
        }
        IlvHyperGrapherNodeProperty ilvHyperGrapherNodeProperty = (IlvHyperGrapherNodeProperty)ilvObjectProperty;
        IlvGraphicVector ilvGraphicVector = ilvHyperGrapherNodeProperty.d();
        ilvHyperGrapherNodeProperty.f();
        if (ilvGraphicVector != null) {
            int n = ilvGraphicVector.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicVector.elementAt(i);
                IlvHyperGrapher.a(ilvGraphic, ilvHyperEdge, false, true, bl);
            }
        }
    }

    private static void a(IlvGraphic ilvGraphic, IlvHyperEdge ilvHyperEdge, boolean bl, boolean bl2, boolean bl3) {
        IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)ilvHyperEdge.getGraphicBag();
        if (ilvHyperGrapher == null) {
            if (bl) {
                ilvHyperEdge.removeFrom(ilvGraphic);
            }
            if (bl2) {
                ilvHyperEdge.removeTo(ilvGraphic);
            }
        } else {
            ilvHyperGrapher.disconnectHyperEdge(ilvGraphic, ilvHyperEdge, bl, bl2, bl3);
        }
    }

    public void disconnectHyperEdge(IlvGraphic ilvGraphic, IlvHyperEdge ilvHyperEdge, boolean bl, boolean bl2, boolean bl3) {
        if (ilvHyperEdge.getGraphicBag() != this) {
            throw new RuntimeException("hyper edge is not in this hypergrapher");
        }
        final boolean bl4 = bl;
        final boolean bl5 = bl2;
        this.applyToObject(ilvHyperEdge, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                if (bl4) {
                    ((IlvHyperEdge)ilvGraphic).removeFrom((IlvGraphic)object);
                }
                if (bl5) {
                    ((IlvHyperEdge)ilvGraphic).removeTo((IlvGraphic)object);
                }
            }
        }, ilvGraphic, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getHyperEdgesVisibleFrom(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            return new IlvGraphicEnumeration(){
                IlvGraphicEnumeration a = IlvHyperGrapher.this.getHyperEdgesFrom(ilvGraphic2);
                IlvGraphicEnumeration b = null;
                IlvHyperEdge c;
                HashSet d = null;
                {
                    if (ilvGraphic2 instanceof IlvHyperGrapher && ((IlvHyperGrapher)ilvGraphic2).isCollapsed()) {
                        this.b = ((IlvHyperGrapher)ilvGraphic2).getTreeExternalInterGraphHyperEdges();
                        this.d = new HashSet();
                    }
                    this.a();
                }

                public boolean hasMoreElements() {
                    return this.c != null;
                }

                public IlvGraphic nextElement() {
                    if (this.c == null) {
                        throw new NoSuchElementException("getLinksVisibleTo");
                    }
                    IlvHyperEdge ilvHyperEdge = this.c;
                    this.a();
                    return ilvHyperEdge;
                }

                private void a() {
                    this.c = null;
                    while (this.a.hasMoreElements()) {
                        this.c = (IlvHyperEdge)this.a.nextElement();
                        if (!this.c.isVisibleFrom(ilvGraphic2)) continue;
                        if (this.d != null) {
                            this.d.add(this.c);
                        }
                        return;
                    }
                    if (this.b != null) {
                        while (this.b.hasMoreElements()) {
                            this.c = (IlvHyperEdge)this.b.nextElement();
                            if (this.d.contains((Object)this.c) || !this.c.isVisibleFrom(ilvGraphic2)) continue;
                            return;
                        }
                    }
                    this.c = null;
                }
            };
        }
    }

    public final int getHyperEdgesVisibleFromCount(IlvGraphic ilvGraphic) {
        int n = 0;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getHyperEdgesVisibleFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphicEnumeration.nextElement();
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getHyperEdgesVisibleTo(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            return new IlvGraphicEnumeration(){
                IlvGraphicEnumeration a = IlvHyperGrapher.this.getHyperEdgesTo(ilvGraphic2);
                IlvGraphicEnumeration b = null;
                IlvHyperEdge c;
                HashSet d = null;
                {
                    if (ilvGraphic2 instanceof IlvHyperGrapher && ((IlvHyperGrapher)ilvGraphic2).isCollapsed()) {
                        this.b = ((IlvHyperGrapher)ilvGraphic2).getTreeExternalInterGraphHyperEdges();
                        this.d = new HashSet();
                    }
                    this.a();
                }

                public boolean hasMoreElements() {
                    return this.c != null;
                }

                public IlvGraphic nextElement() {
                    if (this.c == null) {
                        throw new NoSuchElementException("getLinksVisibleTo");
                    }
                    IlvHyperEdge ilvHyperEdge = this.c;
                    this.a();
                    return ilvHyperEdge;
                }

                private void a() {
                    this.c = null;
                    while (this.a.hasMoreElements()) {
                        this.c = (IlvHyperEdge)this.a.nextElement();
                        if (!this.c.isVisibleTo(ilvGraphic2)) continue;
                        if (this.d != null) {
                            this.d.add(this.c);
                        }
                        return;
                    }
                    if (this.b != null) {
                        while (this.b.hasMoreElements()) {
                            this.c = (IlvHyperEdge)this.b.nextElement();
                            if (this.d.contains((Object)this.c) || !this.c.isVisibleTo(ilvGraphic2)) continue;
                            return;
                        }
                    }
                    this.c = null;
                }
            };
        }
    }

    public final int getHyperEdgesVisibleToCount(IlvGraphic ilvGraphic) {
        int n = 0;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getHyperEdgesVisibleTo(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvGraphicEnumeration.nextElement();
            ++n;
        }
        return n;
    }

    public final IlvGraphicEnumeration getHyperGraphNeighbors(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isNode(ilvGraphic)) {
                HashSet hashSet = new HashSet();
                this.a(hashSet, this.getHyperEdgesTo(ilvGraphic), true, true);
                this.a(hashSet, this.getHyperEdgesFrom(ilvGraphic), true, true);
                hashSet.remove(ilvGraphic);
                return IlvHyperGrapher.a(hashSet).elements();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": Not a node");
        }
    }

    public final IlvGraphicEnumeration getHyperGraphFromNeighbors(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isNode(ilvGraphic)) {
                HashSet hashSet = new HashSet();
                this.a(hashSet, this.getHyperEdgesFrom(ilvGraphic), false, true);
                return IlvHyperGrapher.a(hashSet).elements();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": Not a node");
        }
    }

    public final IlvGraphicEnumeration getHyperGraphToNeighbors(IlvGraphic ilvGraphic) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isNode(ilvGraphic)) {
                HashSet hashSet = new HashSet();
                this.a(hashSet, this.getHyperEdgesTo(ilvGraphic), true, false);
                return IlvHyperGrapher.a(hashSet).elements();
            }
            throw new IllegalArgumentException("Object " + ilvGraphic + ": Not a node");
        }
    }

    private void a(HashSet hashSet, IlvGraphicEnumeration ilvGraphicEnumeration, boolean bl, boolean bl2) {
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphicEnumeration ilvGraphicEnumeration2;
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
            if (bl) {
                ilvGraphicEnumeration2 = ilvHyperEdge.getFrom();
                while (ilvGraphicEnumeration2.hasMoreElements()) {
                    hashSet.add(ilvGraphicEnumeration2.nextElement());
                }
            }
            if (!bl2) continue;
            ilvGraphicEnumeration2 = ilvHyperEdge.getTo();
            while (ilvGraphicEnumeration2.hasMoreElements()) {
                hashSet.add(ilvGraphicEnumeration2.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translateObjects(IlvGraphicEnumeration ilvGraphicEnumeration, float f, float f2, IlvTransformer ilvTransformer) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                this.setContentsAdjusting(true, true);
                super.translateObjects(ilvGraphicEnumeration, f, f2, ilvTransformer);
            }
            finally {
                this.setContentsAdjusting(false, true);
            }
        }
    }

    public boolean allowMoving(IlvGraphic ilvGraphic) {
        if (super.allowMoving(ilvGraphic)) {
            return true;
        }
        if (this.isHyperEdge(ilvGraphic)) {
            IlvGraphic ilvGraphic2;
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphic;
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvHyperEdge.getFrom();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvGraphic2 = ilvGraphicEnumeration.nextElement();
                if (this.isSelected(ilvGraphic2) && this.isMovable(ilvGraphic2)) continue;
                return false;
            }
            ilvGraphicEnumeration = ilvHyperEdge.getTo();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvGraphic2 = ilvGraphicEnumeration.nextElement();
                if (this.isSelected(ilvGraphic2) && this.isMovable(ilvGraphic2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void registerWaitingForAdjustmentEnd(IlvHyperEdge ilvHyperEdge) {
        if (this.m == null) {
            this.m = new HashSet();
        }
        this.m.add(ilvHyperEdge);
    }

    public boolean isWaitingForAdjustmentEnd(IlvHyperEdge ilvHyperEdge) {
        if (this.m == null) {
            return false;
        }
        return this.m.contains((Object)ilvHyperEdge);
    }

    public void setContentsAdjusting(boolean bl) {
        boolean bl2 = this.isContentsAdjusting();
        super.setContentsAdjusting(bl);
        boolean bl3 = this.isContentsAdjusting();
        if (bl2 && !bl3) {
            if (this.m != null) {
                for (IlvHyperEdge ilvHyperEdge : this.m) {
                    ilvHyperEdge.actOnAdjustmentEnd();
                }
            }
            this.m = null;
        }
    }

    public final IlvGraphicEnumeration getHyperEdges() {
        if (this.i == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return new IlvIteratorGraphicEnumeration(this.i.iterator());
    }

    public final int getHyperEdgesCount() {
        return this.i == null ? 0 : this.i.size();
    }

    private void i(IlvHyperEdge ilvHyperEdge) {
        if (this.i == null) {
            this.i = new HashSet();
        }
        this.i.add(ilvHyperEdge);
    }

    private boolean j(IlvHyperEdge ilvHyperEdge) {
        if (this.i == null) {
            return false;
        }
        boolean bl = this.i.remove((Object)ilvHyperEdge);
        if (bl && this.i.size() == 0) {
            this.i = null;
        }
        return bl;
    }

    public final IlvGraphicEnumeration getExternalInterGraphHyperEdges() {
        if (this.j == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return new IlvIteratorGraphicEnumeration(this.j.iterator());
    }

    public final int getExternalInterGraphHyperEdgesCount() {
        return this.j == null ? 0 : this.j.size();
    }

    private void k(IlvHyperEdge ilvHyperEdge) {
        if (this.j == null) {
            this.j = new HashSet();
        }
        this.j.add(ilvHyperEdge);
    }

    private boolean l(IlvHyperEdge ilvHyperEdge) {
        if (this.j == null) {
            return false;
        }
        boolean bl = this.j.remove((Object)ilvHyperEdge);
        if (bl && this.j.size() == 0) {
            this.j = null;
        }
        return bl;
    }

    public final IlvGraphicEnumeration getTreeExternalInterGraphHyperEdges() {
        return new IlvGraphicEnumeration(){
            Stack a = new Stack();
            IlvHyperGrapher b = IlvHyperGrapher.this;
            IlvManager c = IlvHyperGrapher.this;
            IlvGraphicEnumeration d = this.b.getExternalInterGraphHyperEdges();
            IlvGraphic e;
            HashSet f = new HashSet();
            {
                this.a();
            }

            public boolean hasMoreElements() {
                return this.e != null;
            }

            public IlvGraphic nextElement() {
                if (this.e == null) {
                    throw new NoSuchElementException("getTreeExternalInterGraphHyperEdges");
                }
                IlvGraphic ilvGraphic = this.e;
                this.a();
                return ilvGraphic;
            }

            private void a() {
                this.c();
                while (this.e == null) {
                    this.b();
                    if (this.c == null) break;
                    if (!(this.c instanceof IlvHyperGrapher)) continue;
                    this.d = ((IlvHyperGrapher)this.c).getExternalInterGraphHyperEdges();
                    this.c();
                }
            }

            private void b() {
                IlvGraphicEnumeration ilvGraphicEnumeration = this.c.getManagers();
                if (ilvGraphicEnumeration.hasMoreElements()) {
                    this.c = (IlvManager)ilvGraphicEnumeration.nextElement();
                    this.a.push(ilvGraphicEnumeration);
                } else {
                    while (!this.a.empty()) {
                        ilvGraphicEnumeration = (IlvGraphicEnumeration)this.a.pop();
                        if (!ilvGraphicEnumeration.hasMoreElements()) continue;
                        this.c = (IlvManager)ilvGraphicEnumeration.nextElement();
                        this.a.push(ilvGraphicEnumeration);
                        return;
                    }
                    this.c = null;
                }
            }

            private void c() {
                this.e = null;
                while (this.d.hasMoreElements()) {
                    IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)this.d.nextElement();
                    if (this.f.contains((Object)ilvHyperEdge) || this.b != this.c && !IlvHyperGrapher.b(this.b, ilvHyperEdge)) continue;
                    this.e = ilvHyperEdge;
                    this.f.add(ilvHyperEdge);
                    return;
                }
            }
        };
    }

    public final int getTreeExternalInterGraphHyperEdgesCount() {
        return this.b((IlvManager)this, this, new HashSet());
    }

    private final int b(IlvManager ilvManager, IlvHyperGrapher ilvHyperGrapher, HashSet hashSet) {
        IlvGraphicEnumeration ilvGraphicEnumeration;
        IlvHyperGrapher ilvHyperGrapher2;
        int n = 0;
        if (ilvManager == ilvHyperGrapher) {
            n += ilvHyperGrapher.getExternalInterGraphHyperEdgesCount();
        } else if (ilvManager instanceof IlvHyperGrapher) {
            ilvHyperGrapher2 = (IlvHyperGrapher)ilvManager;
            ilvGraphicEnumeration = ilvHyperGrapher2.getExternalInterGraphHyperEdges();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphicEnumeration.nextElement();
                if (!IlvHyperGrapher.b(ilvHyperGrapher, ilvHyperEdge) || hashSet.contains((Object)ilvHyperEdge)) continue;
                hashSet.add(ilvHyperEdge);
                ++n;
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            ilvHyperGrapher2 = ilvManager.getManagers();
            while (ilvHyperGrapher2.hasMoreElements()) {
                ilvGraphicEnumeration = (IlvManager)ilvHyperGrapher2.nextElement();
                n += this.b((IlvManager)ilvGraphicEnumeration, ilvHyperGrapher, hashSet);
            }
        }
        return n;
    }

    public final IlvGraphicEnumeration getInterGraphHyperEdges() {
        if (this.k == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return new IlvIteratorGraphicEnumeration(this.k.iterator());
    }

    public final int getInterGraphHyperEdgesCount() {
        return this.k == null ? 0 : this.k.size();
    }

    private void m(IlvHyperEdge ilvHyperEdge) {
        if (this.k == null) {
            this.k = new HashSet();
        }
        this.k.add(ilvHyperEdge);
    }

    private boolean n(IlvHyperEdge ilvHyperEdge) {
        if (this.k == null) {
            return false;
        }
        boolean bl = this.k.remove((Object)ilvHyperEdge);
        if (bl && this.k.size() == 0) {
            this.k = null;
        }
        return bl;
    }

    void b(IlvHyperEdge ilvHyperEdge) {
        if (ilvHyperEdge.isInterGraphHyperEdge()) {
            this.m(ilvHyperEdge);
            HashSet hashSet = new HashSet();
            this.a(ilvHyperEdge, ilvHyperEdge.getFromEnds(), hashSet);
            this.a(ilvHyperEdge, ilvHyperEdge.getToEnds(), hashSet);
        } else {
            this.i(ilvHyperEdge);
        }
    }

    void c(IlvHyperEdge ilvHyperEdge) {
        if (ilvHyperEdge.isInterGraphHyperEdge()) {
            this.n(ilvHyperEdge);
            HashSet hashSet = new HashSet();
            this.b(ilvHyperEdge, ilvHyperEdge.getFromEnds(), hashSet);
            this.b(ilvHyperEdge, ilvHyperEdge.getToEnds(), hashSet);
        } else {
            this.j(ilvHyperEdge);
        }
    }

    private final void a(IlvHyperEdge ilvHyperEdge, Iterator iterator, HashSet hashSet) {
        while (iterator.hasNext()) {
            IlvHyperGrapher ilvHyperGrapher;
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
            if (ilvGraphic.getGraphicBag() == this || !(ilvGraphic.getGraphicBag() instanceof IlvHyperGrapher) || hashSet.contains((Object)(ilvHyperGrapher = (IlvHyperGrapher)ilvGraphic.getGraphicBag()))) continue;
            ilvHyperGrapher.k(ilvHyperEdge);
            hashSet.add(ilvHyperGrapher);
        }
    }

    private final void b(IlvHyperEdge ilvHyperEdge, Iterator iterator, HashSet hashSet) {
        while (iterator.hasNext()) {
            IlvHyperGrapher ilvHyperGrapher;
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
            if (ilvGraphic.getGraphicBag() == this || !(ilvGraphic.getGraphicBag() instanceof IlvHyperGrapher) || hashSet.contains((Object)(ilvHyperGrapher = (IlvHyperGrapher)ilvGraphic.getGraphicBag()))) continue;
            ilvHyperGrapher.l(ilvHyperEdge);
            hashSet.add(ilvHyperGrapher);
        }
    }

    private void b(IlvHyperEdge ilvHyperEdge, int n, boolean bl) {
        if (this.n == null) {
            this.n = new Vector();
        }
        this.n.addElement(new DelayEntry(ilvHyperEdge, n, bl));
    }

    private static void d(IlvManager ilvManager) {
        IlvHyperGrapher ilvHyperGrapher;
        if (ilvManager instanceof IlvHyperGrapher) {
            ilvHyperGrapher = (IlvHyperGrapher)ilvManager;
            if (ilvHyperGrapher.n != null) {
                int n = ilvHyperGrapher.n.size();
                for (int i = 0; i < n; ++i) {
                    DelayEntry delayEntry = (DelayEntry)ilvHyperGrapher.n.elementAt(i);
                    delayEntry.a(ilvHyperGrapher);
                }
                ilvHyperGrapher.n = null;
            }
        }
        if (ilvManager.getManagersCount() != 0) {
            ilvHyperGrapher = ilvManager.getManagers();
            while (ilvHyperGrapher.hasMoreElements()) {
                IlvManager ilvManager2 = (IlvManager)ilvHyperGrapher.nextElement();
                IlvHyperGrapher.d(ilvManager2);
            }
        }
    }

    public void setLayer(IlvGraphic ilvGraphic, int n, boolean bl) {
        super.setLayer(ilvGraphic, n, bl);
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
        if (ilvHyperEdgeConnector != null) {
            ilvHyperEdgeConnector.actAfterLayerChanged(ilvGraphic, bl);
        }
    }

    protected Object beforeInvalidateRegion(IlvGraphic ilvGraphic, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        if (ilvGraphic instanceof IlvHyperEdge) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphic;
            IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
            IlvPoint[] ilvPointArray = ilvHyperEdge.getFromConnectionPoints(ilvTransformer);
            IlvPoint[] ilvPointArray2 = ilvHyperEdge.getToConnectionPoints(ilvTransformer);
            return new Object[]{ilvRect, ilvPointArray, ilvPointArray2};
        }
        if (ilvGraphic instanceof IlvSelection && ((IlvSelection)ilvGraphic).getObject() instanceof IlvHyperEdge) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)((IlvSelection)ilvGraphic).getObject();
            IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
            IlvPoint[] ilvPointArray = ilvHyperEdge.getFromConnectionPoints(ilvTransformer);
            IlvPoint[] ilvPointArray3 = ilvHyperEdge.getToConnectionPoints(ilvTransformer);
            return new Object[]{ilvRect, ilvPointArray, ilvPointArray3};
        }
        return super.beforeInvalidateRegion(ilvGraphic, ilvManagerView, ilvTransformer);
    }

    protected boolean afterInvalidateRegion(IlvGraphic ilvGraphic, IlvRect ilvRect, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer, Object object) {
        IlvRect ilvRect2 = ilvRect;
        if (ilvGraphic instanceof IlvHyperEdge) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)ilvGraphic;
            IlvPoint[] ilvPointArray = ilvHyperEdge.getFromConnectionPoints(ilvTransformer);
            IlvPoint[] ilvPointArray2 = ilvHyperEdge.getToConnectionPoints(ilvTransformer);
            Object[] objectArray = (Object[])object;
            return objectArray == null || !this.a(ilvPointArray, objectArray[1]) || !this.a(ilvPointArray2, objectArray[2]) || !objectArray[0].equals(ilvRect2);
        }
        if (ilvGraphic instanceof IlvSelection && ((IlvSelection)ilvGraphic).getObject() instanceof IlvHyperEdge) {
            IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)((IlvSelection)ilvGraphic).getObject();
            IlvPoint[] ilvPointArray = ilvHyperEdge.getFromConnectionPoints(ilvTransformer);
            IlvPoint[] ilvPointArray3 = ilvHyperEdge.getToConnectionPoints(ilvTransformer);
            Object[] objectArray = (Object[])object;
            return objectArray == null || !this.a(ilvPointArray, objectArray[1]) || !this.a(ilvPointArray3, objectArray[2]) || !objectArray[0].equals(ilvRect2);
        }
        return super.afterInvalidateRegion(ilvGraphic, ilvRect, ilvManagerView, ilvTransformer, object);
    }

    private boolean a(IlvPoint[] ilvPointArray, Object object) {
        if (ilvPointArray == object) {
            return true;
        }
        if (ilvPointArray == null) {
            return false;
        }
        if (!(object instanceof IlvPoint[])) {
            return false;
        }
        IlvPoint[] ilvPointArray2 = (IlvPoint[])object;
        if (ilvPointArray.length != ilvPointArray2.length) {
            return false;
        }
        for (int i = 0; i < ilvPointArray.length; ++i) {
            if (ilvPointArray[i].equals((Object)ilvPointArray2[i])) continue;
            return false;
        }
        return true;
    }

    static class DelayEntry {
        private IlvHyperEdge a;
        private int b;
        private boolean c;

        DelayEntry(IlvHyperEdge ilvHyperEdge, int n, boolean bl) {
            this.a = ilvHyperEdge;
            this.b = n;
            this.c = bl;
        }

        void a(IlvHyperGrapher ilvHyperGrapher) {
            boolean bl = false;
            IlvGraphic[] ilvGraphicArray = this.a.getFromArray();
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                if (ilvGraphicArray[i].getGraphicBag() != null) continue;
                this.a.removeFrom(ilvGraphicArray[i]);
                bl = true;
            }
            IlvGraphic[] ilvGraphicArray2 = this.a.getToArray();
            for (int i = 0; i < ilvGraphicArray2.length; ++i) {
                if (ilvGraphicArray2[i].getGraphicBag() != null) continue;
                this.a.removeTo(ilvGraphicArray2[i]);
                bl = true;
            }
            ilvHyperGrapher.addHyperEdge(this.a, this.b, this.c);
            if (bl) {
                ArrayList<IlvHyperEdge> arrayList = new ArrayList<IlvHyperEdge>();
                arrayList.add(this.a);
                ilvHyperGrapher.afterHyperEdgeEndsChanged(arrayList.iterator());
            }
        }
    }

    private static class HyperEdgeInfo {
        IlvHyperGrapher a;
        IlvHyperEdge b;
        IlvHyperEdgeEnd[] c;

        HyperEdgeInfo(IlvHyperEdge ilvHyperEdge) {
            this.a = (IlvHyperGrapher)ilvHyperEdge.getGraphicBag();
            this.b = ilvHyperEdge;
        }
    }
}

