/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.hypergraph.IlvDefaultHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperEdgeEndList;
import ilog.views.hypergraph.IlvHyperEdgeSelection;
import ilog.views.hypergraph.IlvHyperGrapher;
import ilog.views.hypergraph.undo.IlvGraphicEdit;
import ilog.views.hypergraph.undo.IlvManagerLayerEdit;
import ilog.views.hypergraph.undo.IlvOrderedCompoundEdit;
import ilog.views.hypergraph.undo.IlvPropertiesEdit;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvTransformerDependentCache;
import ilog.views.internal.IlvUtility;
import ilog.views.internal.impl.IlvEmptyGraphicEnumeration;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class IlvHyperEdge
extends IlvGraphic {
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private IlvHyperEdgeEndList d;
    private IlvHyperEdgeEndList e;
    private Paint f;
    private byte g;
    private IlvBoundingBoxCache h;
    private IlvTransformerDependentCache<Object[]> i;
    static final IlvPoint[] j = new IlvPoint[3];
    static IlvHyperEdge k;

    public IlvHyperEdge() {
        this.h = new IlvBoundingBoxCache(3);
        this.i = new IlvTransformerDependentCache(3, false);
        this.d = null;
        this.e = null;
    }

    public IlvHyperEdge(IlvGraphicVector ilvGraphicVector, IlvGraphicVector ilvGraphicVector2) {
        this.setFrom(ilvGraphicVector);
        this.setTo(ilvGraphicVector2);
        this.h = new IlvBoundingBoxCache(3);
        this.i = new IlvTransformerDependentCache(3, false);
        this.b(this.d, true);
        this.b(this.e, false);
    }

    public IlvHyperEdge(IlvHyperEdge ilvHyperEdge) {
        super((IlvGraphic)ilvHyperEdge);
        this.h = new IlvBoundingBoxCache(ilvHyperEdge.getBoundingBoxCacheSize());
        this.i = new IlvTransformerDependentCache(ilvHyperEdge.getBoundingBoxCacheSize(), false);
        this.f = ilvHyperEdge.f;
        this.d = ilvHyperEdge.d == null ? null : ilvHyperEdge.d.a(this);
        this.e = ilvHyperEdge.e == null ? null : ilvHyperEdge.e.a(this);
        this.setLineWidth(ilvHyperEdge.getLineWidth());
        this.setMaximumLineWidth(ilvHyperEdge.getMaximumLineWidth());
        this.setLineStyle(ilvHyperEdge.getLineStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvHyperEdge(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.h = new IlvBoundingBoxCache(3);
        this.i = new IlvTransformerDependentCache(3, false);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            k = this;
            this.readEnds(ilvInputStream);
            k = null;
        }
        this.setBoundingBoxCacheSize(ilvInputStream.readInt("bboxCacheSize"));
        this.setStrokePaint(IlvUtility2D.readStrokePaint((IlvInputStream)ilvInputStream));
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.a(true);
    }

    protected void readEnds(IlvInputStream ilvInputStream) throws IlvReadFileException {
        IlvPersistentObject[] ilvPersistentObjectArray;
        try {
            ilvPersistentObjectArray = ilvInputStream.readPersistentObjects("from");
            this.d = ilvPersistentObjectArray.length == 0 ? null : new IlvHyperEdgeEndList(this, ilvPersistentObjectArray);
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
        try {
            ilvPersistentObjectArray = ilvInputStream.readPersistentObjects("to");
            this.e = ilvPersistentObjectArray.length == 0 ? null : new IlvHyperEdgeEndList(this, ilvPersistentObjectArray);
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
    }

    boolean a() {
        return this.a(2);
    }

    void a(boolean bl) {
        this.a(2, bl);
    }

    public void setBoundingBoxCacheSize(int n) {
        if (n < 2) {
            n = 2;
        }
        this.h.setSize(n);
        this.i.setSize(n);
    }

    public int getBoundingBoxCacheSize() {
        return this.h.getSize();
    }

    public IlvGraphic copy() {
        return null;
    }

    public final IlvGraphicEnumeration getFrom() {
        if (this.d == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return this.d.a().elements();
    }

    public final IlvGraphicEnumeration getTo() {
        if (this.e == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return this.e.a().elements();
    }

    public final IlvGraphic[] getFromArray() {
        if (this.d == null) {
            return new IlvGraphic[0];
        }
        return this.d.b();
    }

    public final IlvGraphic[] getToArray() {
        if (this.e == null) {
            return new IlvGraphic[0];
        }
        return this.e.b();
    }

    public final int getFromCount() {
        if (this.d == null) {
            return 0;
        }
        return this.d.a().size();
    }

    public final int getToCount() {
        if (this.e == null) {
            return 0;
        }
        return this.e.a().size();
    }

    public final Iterator getFromEnds() {
        if (this.d == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.d.iterator();
    }

    public final Iterator getToEnds() {
        if (this.e == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.e.iterator();
    }

    public IlvHyperEdgeEnd[] getFromEndsArray() {
        int n = this.d == null ? 0 : this.d.size();
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = new IlvHyperEdgeEnd[n];
        return this.d.toArray(ilvHyperEdgeEndArray);
    }

    public IlvHyperEdgeEnd[] getToEndsArray() {
        int n = this.e == null ? 0 : this.e.size();
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = new IlvHyperEdgeEnd[n];
        return this.e.toArray(ilvHyperEdgeEndArray);
    }

    public IlvHyperEdgeEnd[] getFromEndsArray(IlvGraphic ilvGraphic) {
        if (this.d == null) {
            return new IlvHyperEdgeEnd[0];
        }
        return this.d.b(ilvGraphic);
    }

    public IlvHyperEdgeEnd[] getToEndsArray(IlvGraphic ilvGraphic) {
        if (this.e == null) {
            return new IlvHyperEdgeEnd[0];
        }
        return this.e.b(ilvGraphic);
    }

    public final int getFromEndsCount() {
        if (this.d == null) {
            return 0;
        }
        return this.d.size();
    }

    public final int getToEndsCount() {
        if (this.e == null) {
            return 0;
        }
        return this.e.size();
    }

    public final boolean isFromEnd(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.d == null) {
            return false;
        }
        return this.d.contains(ilvHyperEdgeEnd);
    }

    public final boolean isToEnd(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.e == null) {
            return false;
        }
        return this.e.contains(ilvHyperEdgeEnd);
    }

    public HashMap copyShapeFrom(IlvHyperEdge ilvHyperEdge) {
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        Iterator iterator;
        HashMap<IlvHyperEdgeEnd, IlvHyperEdgeEnd> hashMap = new HashMap<IlvHyperEdgeEnd, IlvHyperEdgeEnd>();
        if (this.getGraphicBag() != null) {
            boolean bl = false;
            for (iterator = (IlvManager)ilvHyperEdge.getGraphicBag(); iterator != null; iterator = iterator.getParent()) {
                if (iterator != this.getGraphicBag()) continue;
                bl = true;
            }
            if (!bl) {
                throw new RuntimeException("Edge must be removed from grapher first");
            }
        }
        iterator = ilvHyperEdge.getFromEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            ilvHyperEdgeEnd = this.addFrom(ilvHyperEdgeEnd2.getNode());
            hashMap.put(ilvHyperEdgeEnd, ilvHyperEdgeEnd2);
            this.a(ilvHyperEdgeEnd2, ilvHyperEdgeEnd);
        }
        iterator = ilvHyperEdge.getToEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd3 = (IlvHyperEdgeEnd)iterator.next();
            ilvHyperEdgeEnd = this.addTo(ilvHyperEdgeEnd3.getNode());
            hashMap.put(ilvHyperEdgeEnd, ilvHyperEdgeEnd3);
            this.a(ilvHyperEdgeEnd3, ilvHyperEdgeEnd);
        }
        return hashMap;
    }

    private void a(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvHyperEdgeEnd ilvHyperEdgeEnd2) {
        IlvDefaultHyperEdgeEnd ilvDefaultHyperEdgeEnd = null;
        IlvDefaultHyperEdgeEnd ilvDefaultHyperEdgeEnd2 = null;
        if (ilvHyperEdgeEnd instanceof IlvDefaultHyperEdgeEnd) {
            ilvDefaultHyperEdgeEnd = (IlvDefaultHyperEdgeEnd)ilvHyperEdgeEnd;
        }
        if (ilvHyperEdgeEnd2 instanceof IlvDefaultHyperEdgeEnd) {
            ilvDefaultHyperEdgeEnd2 = (IlvDefaultHyperEdgeEnd)ilvHyperEdgeEnd2;
        }
        boolean bl = false;
        if (ilvDefaultHyperEdgeEnd != null) {
            bl = ilvDefaultHyperEdgeEnd.isAbsolutePositioning();
            ilvDefaultHyperEdgeEnd.setAbsolutePositioning(true);
        }
        if (ilvDefaultHyperEdgeEnd2 != null) {
            ilvDefaultHyperEdgeEnd2.setAbsolutePositioning(true);
        }
        IlvManager ilvManager = (IlvManager)ilvHyperEdgeEnd.getHyperEdge().getGraphicBag();
        IlvManager ilvManager2 = (IlvManager)ilvHyperEdgeEnd2.getHyperEdge().getGraphicBag();
        IlvTransformer ilvTransformer = null;
        IlvTransformer ilvTransformer2 = null;
        if (ilvManager != ilvManager2) {
            if (ilvManager != null && bl) {
                ilvTransformer = ilvManager.getTopLevelTransformer();
            }
            if (ilvManager2 != null && bl) {
                ilvTransformer2 = ilvManager2.getTopLevelTransformer();
            }
        }
        ilvHyperEdgeEnd2.setPosition(ilvHyperEdgeEnd.getPosition(ilvTransformer, false), ilvTransformer2);
        if (ilvDefaultHyperEdgeEnd != null) {
            ilvDefaultHyperEdgeEnd.setAbsolutePositioning(bl);
        }
        if (ilvDefaultHyperEdgeEnd2 != null) {
            ilvDefaultHyperEdgeEnd2.setAbsolutePositioning(bl);
        }
    }

    public void setFrom(IlvGraphicVector ilvGraphicVector) {
        IlvHyperGrapher ilvHyperGrapher;
        boolean bl;
        boolean bl2 = bl = this.h == null;
        if (!bl) {
            this.a(this.d, true);
        }
        if ((ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag()) == null) {
            this.d = ilvGraphicVector == null || ilvGraphicVector.isEmpty() ? null : new IlvHyperEdgeEndList(this, ilvGraphicVector, true);
        } else {
            IlvHyperEdgeEnd ilvHyperEdgeEnd;
            int n;
            int n2;
            ilvHyperGrapher.c(this);
            if (this.d != null) {
                n2 = this.d.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.d.get(n);
                    ilvHyperGrapher.c(ilvHyperEdgeEnd);
                    ilvHyperEdgeEnd.setHyperEdge(null);
                }
            }
            this.d = null;
            if (ilvGraphicVector != null) {
                n2 = ilvGraphicVector.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = ilvGraphicVector.elementAt(n);
                    this.c((IlvGraphic)ilvHyperEdgeEnd);
                    IlvHyperEdgeEnd ilvHyperEdgeEnd2 = this.a((IlvGraphic)ilvHyperEdgeEnd);
                    ilvHyperGrapher.a(ilvHyperEdgeEnd2);
                }
            }
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        if (!bl) {
            this.b(this.d, true);
            this.clearBoundingBoxCache();
        }
    }

    public void setTo(IlvGraphicVector ilvGraphicVector) {
        IlvHyperGrapher ilvHyperGrapher;
        boolean bl;
        boolean bl2 = bl = this.h == null;
        if (!bl) {
            this.a(this.e, false);
        }
        if ((ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag()) == null) {
            this.e = ilvGraphicVector == null || ilvGraphicVector.isEmpty() ? null : new IlvHyperEdgeEndList(this, ilvGraphicVector, false);
        } else {
            IlvHyperEdgeEnd ilvHyperEdgeEnd;
            int n;
            int n2;
            ilvHyperGrapher.c(this);
            if (this.e != null) {
                n2 = this.e.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.e.get(n);
                    ilvHyperGrapher.d(ilvHyperEdgeEnd);
                    ilvHyperEdgeEnd.setHyperEdge(null);
                }
            }
            this.e = null;
            if (ilvGraphicVector != null) {
                n2 = ilvGraphicVector.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = ilvGraphicVector.elementAt(n);
                    this.c((IlvGraphic)ilvHyperEdgeEnd);
                    IlvHyperEdgeEnd ilvHyperEdgeEnd2 = this.b((IlvGraphic)ilvHyperEdgeEnd);
                    ilvHyperGrapher.b(ilvHyperEdgeEnd2);
                }
            }
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        if (!bl) {
            this.b(this.e, false);
            this.clearBoundingBoxCache();
        }
    }

    private void a(ArrayList arrayList, boolean bl) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)arrayList.get(i);
                this.beforeRemoveEnd(ilvHyperEdgeEnd, bl);
            }
        }
    }

    private void b(ArrayList arrayList, boolean bl) {
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)arrayList.get(i);
                this.afterAddEnd(ilvHyperEdgeEnd, bl);
            }
        }
    }

    public IlvHyperEdgeEnd addFrom(IlvGraphic ilvGraphic) {
        this.c(ilvGraphic);
        IlvHyperEdgeEnd ilvHyperEdgeEnd = this.createEnd(ilvGraphic, true);
        this.a(ilvHyperEdgeEnd, false);
        return ilvHyperEdgeEnd;
    }

    void a(IlvHyperEdgeEnd ilvHyperEdgeEnd, boolean bl) {
        IlvHyperGrapher ilvHyperGrapher;
        if (bl) {
            ilvHyperEdgeEnd.setHyperEdge(this);
        }
        if ((ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag()) != null) {
            ilvHyperGrapher.c(this);
        }
        if (this.d == null) {
            this.d = new IlvHyperEdgeEndList();
        }
        this.d.add(ilvHyperEdgeEnd);
        this.clearBoundingBoxCache();
        if (ilvHyperGrapher != null) {
            ilvHyperGrapher.a(ilvHyperEdgeEnd);
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        this.afterAddEnd(ilvHyperEdgeEnd, true);
    }

    void a(ArrayList arrayList) {
        if (this.d != null) {
            this.d.a(arrayList);
        }
    }

    private IlvHyperEdgeEnd a(IlvGraphic ilvGraphic) {
        if (this.d == null) {
            this.d = new IlvHyperEdgeEndList();
        }
        return this.d.a(this, ilvGraphic, true);
    }

    public IlvHyperEdgeEnd addTo(IlvGraphic ilvGraphic) {
        this.c(ilvGraphic);
        IlvHyperEdgeEnd ilvHyperEdgeEnd = this.createEnd(ilvGraphic, false);
        this.b(ilvHyperEdgeEnd, false);
        return ilvHyperEdgeEnd;
    }

    void b(IlvHyperEdgeEnd ilvHyperEdgeEnd, boolean bl) {
        IlvHyperGrapher ilvHyperGrapher;
        if (bl) {
            ilvHyperEdgeEnd.setHyperEdge(this);
        }
        if ((ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag()) != null) {
            ilvHyperGrapher.c(this);
        }
        if (this.e == null) {
            this.e = new IlvHyperEdgeEndList();
        }
        this.e.add(ilvHyperEdgeEnd);
        this.clearBoundingBoxCache();
        if (ilvHyperGrapher != null) {
            ilvHyperGrapher.b(ilvHyperEdgeEnd);
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        this.afterAddEnd(ilvHyperEdgeEnd, true);
    }

    void b(ArrayList arrayList) {
        if (this.e != null) {
            this.e.a(arrayList);
        }
    }

    private IlvHyperEdgeEnd b(IlvGraphic ilvGraphic) {
        if (this.e == null) {
            this.e = new IlvHyperEdgeEndList();
        }
        return this.e.a(this, ilvGraphic, false);
    }

    private void c(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            throw new RuntimeException("null node");
        }
        if (this.getGraphicBag() == null) {
            return;
        }
        IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
        if (ilvManager == null) {
            throw new IllegalArgumentException("node must be in grapher");
        }
        while (ilvManager != null) {
            if (ilvManager == this.getGraphicBag()) {
                return;
            }
            ilvManager = ilvManager.getParent();
        }
        throw new IllegalArgumentException("node must be in same grapher as edge or in subgrapher of edge grapher");
    }

    public final void removeFrom(IlvGraphic ilvGraphic) {
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = this.getFromEndsArray(ilvGraphic);
        this.a(ilvHyperEdgeEndArray, true);
        IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
        if (ilvHyperGrapher == null) {
            if (this.d == null || !this.d.a(ilvGraphic)) {
                throw new RuntimeException("node is not origin of this hyperedge");
            }
        } else {
            ilvHyperGrapher.c(this);
            int n = ilvHyperEdgeEndArray.length;
            for (int i = 0; i < n; ++i) {
                this.d.remove(ilvHyperEdgeEndArray[i]);
                ilvHyperGrapher.c(ilvHyperEdgeEndArray[i]);
                ilvHyperEdgeEndArray[i].setHyperEdge(null);
            }
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        if (this.d != null && this.d.size() == 0) {
            this.d = null;
        }
        this.clearBoundingBoxCache();
    }

    public final void removeTo(IlvGraphic ilvGraphic) {
        IlvHyperEdgeEnd[] ilvHyperEdgeEndArray = this.getToEndsArray(ilvGraphic);
        this.a(ilvHyperEdgeEndArray, false);
        IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
        if (ilvHyperGrapher == null) {
            if (this.e == null || !this.e.a(ilvGraphic)) {
                throw new RuntimeException("node is not destination of this hyperedge");
            }
        } else {
            ilvHyperGrapher.c(this);
            int n = ilvHyperEdgeEndArray.length;
            for (int i = 0; i < n; ++i) {
                this.e.remove(ilvHyperEdgeEndArray[i]);
                ilvHyperGrapher.d(ilvHyperEdgeEndArray[i]);
                ilvHyperEdgeEndArray[i].setHyperEdge(null);
            }
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        if (this.e != null && this.e.size() == 0) {
            this.e = null;
        }
        this.clearBoundingBoxCache();
    }

    private void a(IlvHyperEdgeEnd[] ilvHyperEdgeEndArray, boolean bl) {
        int n = ilvHyperEdgeEndArray.length;
        for (int i = 0; i < n; ++i) {
            this.beforeRemoveEnd(ilvHyperEdgeEndArray[i], bl);
        }
    }

    public final void removeFrom(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            throw new RuntimeException("null end");
        }
        this.beforeRemoveEnd(ilvHyperEdgeEnd, true);
        IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
        if (ilvHyperGrapher != null) {
            ilvHyperGrapher.c(this);
        }
        if (this.d == null || !this.d.remove(ilvHyperEdgeEnd)) {
            throw new RuntimeException("end is not origin of this hyperedge");
        }
        if (this.d != null && this.d.size() == 0) {
            this.d = null;
        }
        this.clearBoundingBoxCache();
        if (ilvHyperGrapher != null) {
            ilvHyperGrapher.c(ilvHyperEdgeEnd);
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        ilvHyperEdgeEnd.setHyperEdge(null);
    }

    public final void removeTo(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            throw new RuntimeException("null end");
        }
        this.beforeRemoveEnd(ilvHyperEdgeEnd, false);
        IlvHyperGrapher ilvHyperGrapher = (IlvHyperGrapher)this.getGraphicBag();
        if (ilvHyperGrapher != null) {
            ilvHyperGrapher.c(this);
        }
        if (this.e == null || !this.e.remove(ilvHyperEdgeEnd)) {
            throw new RuntimeException("end is not destination of this hyperedge");
        }
        if (this.e != null && this.e.size() == 0) {
            this.e = null;
        }
        this.clearBoundingBoxCache();
        if (ilvHyperGrapher != null) {
            ilvHyperGrapher.d(ilvHyperEdgeEnd);
            ilvHyperGrapher.b(this);
            this.b();
            ilvHyperGrapher.a(this);
        }
        ilvHyperEdgeEnd.setHyperEdge(null);
    }

    protected IlvHyperEdgeEnd createEnd(IlvGraphic ilvGraphic, boolean bl) {
        return new IlvDefaultHyperEdgeEnd(this, ilvGraphic);
    }

    protected void afterAddEnd(IlvHyperEdgeEnd ilvHyperEdgeEnd, boolean bl) {
    }

    protected void beforeRemoveEnd(IlvHyperEdgeEnd ilvHyperEdgeEnd, boolean bl) {
    }

    public final boolean isInterGraphHyperEdge() {
        IlvGraphicBag ilvGraphicBag;
        IlvGraphic ilvGraphic;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        IlvGraphicBag ilvGraphicBag2 = null;
        Iterator iterator = this.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvGraphic = ilvHyperEdgeEnd.getNode();
            ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag == null) {
                return true;
            }
            if (ilvGraphicBag2 == null) {
                ilvGraphicBag2 = ilvGraphicBag;
                continue;
            }
            if (ilvGraphicBag2 == ilvGraphicBag) continue;
            return true;
        }
        iterator = this.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvGraphic = ilvHyperEdgeEnd.getNode();
            ilvGraphicBag = ilvGraphic.getGraphicBag();
            if (ilvGraphicBag == null) {
                return true;
            }
            if (ilvGraphicBag2 == null) {
                ilvGraphicBag2 = ilvGraphicBag;
                continue;
            }
            if (ilvGraphicBag2 == ilvGraphicBag) continue;
            return true;
        }
        return false;
    }

    public final IlvPoint[] getFromConnectionPoints(IlvTransformer ilvTransformer) {
        return this.a(ilvTransformer, true);
    }

    IlvPoint[] a(IlvTransformer ilvTransformer, boolean bl) {
        int n = this.getFromEndsCount();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.d.get(i);
            ilvPointArray[i] = ilvHyperEdgeEnd.getPosition(ilvTransformer, bl);
        }
        return ilvPointArray;
    }

    public final IlvPoint[] getToConnectionPoints(IlvTransformer ilvTransformer) {
        return this.b(ilvTransformer, true);
    }

    IlvPoint[] b(IlvTransformer ilvTransformer, boolean bl) {
        int n = this.getToEndsCount();
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.e.get(i);
            ilvPointArray[i] = ilvHyperEdgeEnd.getPosition(ilvTransformer, bl);
        }
        return ilvPointArray;
    }

    public void moveConnectionPoint(IlvHyperEdgeEnd ilvHyperEdgeEnd, float f, float f2, IlvTransformer ilvTransformer) {
        ilvHyperEdgeEnd.setPosition(new IlvPoint(f, f2), ilvTransformer);
        this.clearBoundingBoxCache();
    }

    public IlvHyperEdgeEnd getClosestEnd(float f, float f2, IlvTransformer ilvTransformer) {
        double d;
        double d2;
        double d3;
        IlvPoint ilvPoint;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        double d4 = Double.MAX_VALUE;
        IlvHyperEdgeEnd ilvHyperEdgeEnd2 = null;
        Iterator iterator = this.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvPoint = ilvHyperEdgeEnd.getPosition(ilvTransformer, true);
            d3 = ilvPoint.x - f;
            d2 = ilvPoint.y - f2;
            d = d3 * d3 + d2 * d2;
            if (ilvHyperEdgeEnd2 != null && !(d < d4)) continue;
            ilvHyperEdgeEnd2 = ilvHyperEdgeEnd;
            d4 = d;
        }
        iterator = this.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvPoint = ilvHyperEdgeEnd.getPosition(ilvTransformer, true);
            d3 = ilvPoint.x - f;
            d2 = ilvPoint.y - f2;
            d = d3 * d3 + d2 * d2;
            if (ilvHyperEdgeEnd2 != null && !(d < d4)) continue;
            ilvHyperEdgeEnd2 = ilvHyperEdgeEnd;
            d4 = d;
        }
        return ilvHyperEdgeEnd2;
    }

    public boolean deleteSelection(boolean bl) {
        return false;
    }

    public IlvPoint getCenter(IlvTransformer ilvTransformer) {
        if (this.getFromEndsCount() + this.getToEndsCount() == 2) {
            return this.a(this.a(ilvTransformer, true), this.b(ilvTransformer, true));
        }
        return this.a(this.a(ilvTransformer, false), this.b(ilvTransformer, false));
    }

    private IlvPoint a(IlvPoint[] ilvPointArray, IlvPoint[] ilvPointArray2) {
        int n;
        int n2 = ilvPointArray.length;
        int n3 = ilvPointArray2.length;
        if (n2 + n3 == 0) {
            return new IlvPoint(0.0f, 0.0f);
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < n2; ++n) {
            f += ilvPointArray[n].x;
            f2 += ilvPointArray[n].y;
        }
        for (n = 0; n < n3; ++n) {
            f += ilvPointArray2[n].x;
            f2 += ilvPointArray2[n].y;
        }
        return new IlvPoint(f / (float)(n2 += n3), f2 / (float)n2);
    }

    public final IlvRect getEndNodeBoundingBox(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic2 = this.getVisibleEndNode(ilvGraphic);
        ilvTransformer = this.a(ilvGraphic2, ilvTransformer);
        return ilvGraphic2.boundingBox(ilvTransformer);
    }

    public final IlvGraphic getVisibleEndNode(IlvGraphic ilvGraphic) {
        return IlvUtility.getRealVisibleObject((IlvGraphicBag)this.getGraphicBag(), (IlvGraphic)ilvGraphic);
    }

    public boolean isVisibleFrom(IlvGraphic ilvGraphic) {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getFrom();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            if (this.getVisibleEndNode(ilvGraphicEnumeration.nextElement()) != ilvGraphic) continue;
            return true;
        }
        return false;
    }

    public boolean isVisibleTo(IlvGraphic ilvGraphic) {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getTo();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            if (this.getVisibleEndNode(ilvGraphicEnumeration.nextElement()) != ilvGraphic) continue;
            return true;
        }
        return false;
    }

    private final IlvTransformer a(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        return IlvLinkImage.getLocalTransformerOf((IlvGraphic)this.getVisibleEndNode(ilvGraphic), (IlvGraphicBag)this.getGraphicBag(), (IlvTransformer)ilvTransformer);
    }

    protected void drawArrow(Graphics graphics, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvUtility.drawArrow((Graphics)graphics, (float)ilvPoint.x, (float)ilvPoint.y, (float)ilvPoint2.x, (float)ilvPoint2.y, (float)1.0f, (float)this.getArrowSize(this.a(ilvTransformer, false, false), ilvTransformer));
    }

    protected float getArrowSize(float f, IlvTransformer ilvTransformer) {
        return IlvUtility.arrowSize((float)f, (IlvTransformer)ilvTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlvRect arrowBBox(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = j;
        synchronized (j) {
            IlvUtility.ComputeArrow((float)ilvPoint.x, (float)ilvPoint.y, (float)ilvPoint2.x, (float)ilvPoint2.y, (float)1.0f, (IlvPoint[])j, (float)this.getArrowSize(this.a(ilvTransformer, true, false), ilvTransformer));
            IlvRect ilvRect = new IlvRect();
            IlvUtil.BoundingBox((IlvRect)ilvRect, (IlvPoint[])j, (int)3);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ilvRect;
        }
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getAdaptedStrokePaint(ilvTransformer));
        float[] fArray = this.getLineStyle();
        float f = this.getLineWidth();
        IlvPoint ilvPoint2 = ilvPoint = this.getCenter(ilvTransformer);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvPoint2 = new IlvPoint(ilvPoint);
            ilvTransformer.inverse(ilvPoint2);
        }
        float f2 = this.getMaximumLineWidth();
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        f = IlvStrokeInfo.zoomedLineWidth((float)f, (float)f2, (IlvTransformer)ilvTransformer, (boolean)false);
        fArray = IlvStrokeInfo.zoomedLineStyle((float[])fArray, (float)f, (float)f2, (IlvTransformer)ilvTransformer);
        this.a(graphics, ilvPoint2, ilvPoint, this.getFromConnectionPoints(ilvTransformer), f, fArray, ilvTransformer, false);
        this.a(graphics, ilvPoint2, ilvPoint, this.getToConnectionPoints(ilvTransformer), f, fArray, ilvTransformer, true);
        graphics2D.setPaint(paint);
    }

    private void a(Graphics graphics, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, float f, float[] fArray, IlvTransformer ilvTransformer, boolean bl) {
        IlvPoint[] ilvPointArray2 = new IlvPoint[2];
        IlvPoint ilvPoint3 = new IlvPoint();
        int n = ilvPointArray.length;
        float f2 = 0.0f;
        if (bl) {
            f2 = this.getArrowSize(this.a(ilvTransformer, false, false), ilvTransformer);
        }
        for (int i = 0; i < n; ++i) {
            ilvPointArray2[0] = ilvPoint2;
            ilvPointArray2[1] = ilvPoint3;
            ilvPoint3.move(ilvPointArray[i].x, ilvPointArray[i].y);
            if (bl) {
                this.shortenForArrowDraw(ilvPointArray2, f2);
            }
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvPointArray2[0] = ilvPoint;
                ilvTransformer.inverse(ilvPointArray2[1]);
            }
            IlvGraphicUtil.DrawPolyline((Graphics)graphics, (IlvPoint[])ilvPointArray2, (int)2, (float)f, (int)2, (int)1, (float[])fArray, (IlvTransformer)ilvTransformer);
            if (!bl) continue;
            ilvPointArray2[0] = ilvPoint2;
            ilvPointArray2[1] = ilvPointArray[i];
            this.drawArrow(graphics, ilvPointArray2[0], ilvPointArray2[1], ilvTransformer);
        }
    }

    protected void shortenForArrowDraw(IlvPoint[] ilvPointArray, float f) {
        if (f > 4.0f) {
            double d = ilvPointArray[1].x - ilvPointArray[0].x;
            double d2 = ilvPointArray[1].y - ilvPointArray[0].y;
            double d3 = Math.sqrt(d * d + d2 * d2);
            if ((double)(2.0f * f) > d3) {
                f = (float)d3 / 2.0f;
            }
            double d4 = 2.0 * (double)f;
            double d5 = 0.0;
            double d6 = 0.0;
            if (d3 != 0.0) {
                d5 = -d4 * d2 / d3;
                d6 = d4 * d / d3;
            }
            ilvPointArray[1].x += (float)(-d6);
            ilvPointArray[1].y += (float)d5;
        }
    }

    public IlvPoint[] getUnclippedSegmentPoints(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvTransformer ilvTransformer) {
        if (this.getFromEndsCount() + this.getToEndsCount() == 2) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{ilvHyperEdgeEnd.getPosition(ilvTransformer, false), this.a(ilvHyperEdgeEnd).getPosition(ilvTransformer, false)};
            return ilvPointArray;
        }
        IlvPoint[] ilvPointArray = new IlvPoint[]{ilvHyperEdgeEnd.getPosition(ilvTransformer, false), this.getCenter(ilvTransformer)};
        return ilvPointArray;
    }

    private IlvHyperEdgeEnd a(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        IlvHyperEdgeEnd ilvHyperEdgeEnd2;
        Iterator iterator = this.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            if (ilvHyperEdgeEnd2 == ilvHyperEdgeEnd) continue;
            return ilvHyperEdgeEnd2;
        }
        iterator = this.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
            if (ilvHyperEdgeEnd2 == ilvHyperEdgeEnd) continue;
            return ilvHyperEdgeEnd2;
        }
        return null;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.h.get(ilvTransformer);
        if (ilvRect == null) {
            ilvRect = this.calcBoundingBox(ilvTransformer);
            Object[] objectArray = this.a(ilvRect, ilvTransformer);
            this.a(ilvTransformer, ilvRect, objectArray);
        }
        return ilvRect;
    }

    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        float f = this.a(ilvTransformer, true, true);
        IlvPoint ilvPoint = this.getCenter(ilvTransformer);
        IlvRect ilvRect = new IlvRect(ilvPoint.x, ilvPoint.y, 1.0E-20f, 1.0E-20f);
        this.a(ilvRect, ilvPoint, this.getFromConnectionPoints(ilvTransformer), f, ilvTransformer, false);
        this.a(ilvRect, ilvPoint, this.getToConnectionPoints(ilvTransformer), f, ilvTransformer, true);
        return ilvRect;
    }

    Object[] a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        Paint paint = this.a(ilvRect, this.getStrokePaint());
        return new Object[]{paint};
    }

    Object[] a(IlvTransformer ilvTransformer) {
        return (Object[])this.i.get(ilvTransformer);
    }

    void a(IlvTransformer ilvTransformer, IlvRect ilvRect, Object[] objectArray) {
        this.h.put(ilvTransformer, ilvRect);
        this.i.put(ilvTransformer, (Object)objectArray);
    }

    private void a(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint[] ilvPointArray, float f, IlvTransformer ilvTransformer, boolean bl) {
        IlvPoint[] ilvPointArray2 = new IlvPoint[2];
        ilvPointArray2[0] = ilvPoint;
        for (IlvPoint ilvPointArray2[1] : ilvPointArray) {
            ilvRect.add((Point2D)ilvPointArray2[1]);
            ilvRect.add(IlvGraphicUtil.PolylineBBox((IlvPoint[])ilvPointArray2, (int)2, (float)f, (int)2, (int)1, null));
            if (!bl) continue;
            ilvRect.add(this.arrowBBox(ilvPointArray2[0], ilvPointArray2[1], ilvTransformer));
        }
    }

    protected void clearBoundingBoxCache() {
        IlvSelection ilvSelection;
        IlvHyperEdgeEnd ilvHyperEdgeEnd;
        if (this.h != null) {
            this.h.setInvalid();
        }
        if (this.i != null) {
            this.i.setInvalid();
        }
        Iterator iterator = this.getFromEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvHyperEdgeEnd.positionChanged();
        }
        iterator = this.getToEnds();
        while (iterator.hasNext()) {
            ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            ilvHyperEdgeEnd.positionChanged();
        }
        if (this.getGraphicBag() instanceof IlvManager && (ilvSelection = (ilvHyperEdgeEnd = (IlvManager)this.getGraphicBag()).getSelection(this)) != null && ilvSelection instanceof IlvHyperEdgeSelection) {
            ((IlvHyperEdgeSelection)ilvSelection).b();
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        float f = Math.max(1.0f, this.a(ilvTransformer, false, true));
        IlvPoint ilvPoint3 = this.getCenter(ilvTransformer);
        if (this.a(ilvPoint2, ilvPoint3, this.getFromConnectionPoints(ilvTransformer), f)) {
            return true;
        }
        return this.a(ilvPoint2, ilvPoint3, this.getToConnectionPoints(ilvTransformer), f);
    }

    private boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, float f) {
        IlvPoint[] ilvPointArray2 = new IlvPoint[2];
        ilvPointArray2[0] = ilvPoint2;
        for (IlvPoint ilvPointArray2[1] : ilvPointArray) {
            if (!IlvGraphicUtil.PointInPolyline((IlvPoint)ilvPoint, (IlvPoint[])ilvPointArray2, (int)2, (float)f, (int)2, (int)1, null)) continue;
            return true;
        }
        return false;
    }

    private void a(int n, boolean bl) {
        this.g = bl ? (byte)(this.g | n) : (byte)(this.g & ~n);
    }

    private boolean a(int n) {
        return (this.g & n) != 0;
    }

    public boolean zoomable() {
        return this.a(1);
    }

    void b() {
        if (this.getFromEndsCount() == 0 && this.getToEndsCount() == 0) {
            this.a(1, false);
        } else {
            this.a(1, this.a(this.getFromEnds()) && this.a(this.getToEnds()));
        }
        this.clearBoundingBoxCache();
    }

    private boolean a(Iterator iterator) {
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            if (ilvHyperEdgeEnd.zoomable()) continue;
            return false;
        }
        return true;
    }

    public void setForeground(Color color) {
        this.setStrokePaint(color);
    }

    public void setStrokePaint(Paint paint) {
        this.f = paint.equals(Color.black) ? null : paint;
    }

    public Paint getStrokePaint() {
        if (this.f == null) {
            return Color.black;
        }
        return this.f;
    }

    protected Paint getAdaptedStrokePaint(IlvTransformer ilvTransformer) {
        Paint paint;
        if (this.isPaintAbsolute()) {
            return this.getStrokePaint();
        }
        Object[] objectArray = this.a(ilvTransformer);
        Paint paint2 = paint = objectArray == null ? null : (Paint)objectArray[0];
        if (paint == null) {
            IlvRect ilvRect = this.calcBoundingBox(ilvTransformer);
            objectArray = this.a(ilvRect, ilvTransformer);
            this.a(ilvTransformer, ilvRect, objectArray);
            paint = (Paint)objectArray[0];
        }
        return paint;
    }

    Paint a(IlvRect ilvRect, Paint paint) {
        if (this.isPaintAbsolute()) {
            return paint;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        return this.adaptPaint(float_, paint);
    }

    protected Paint adaptPaint(Shape shape, Paint paint) {
        return IlvUtility2D.AdaptPaint((Shape)shape, (Paint)paint);
    }

    public boolean isPaintAbsolute() {
        return this.a(4);
    }

    public void setPaintAbsolute(boolean bl) {
        if (bl != this.isPaintAbsolute()) {
            this.a(4, bl);
            this.clearBoundingBoxCache();
        }
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth((IlvGraphic)this);
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        return Math.max(1.0f, this.a(ilvTransformer, false, true));
    }

    float a(IlvTransformer ilvTransformer, boolean bl, boolean bl2) {
        float f = this.getLineWidth();
        if (f > 0.0f) {
            f = IlvStrokeInfo.zoomedLineWidth((float)f, (float)this.getMaximumLineWidth(), (IlvTransformer)ilvTransformer, (boolean)bl);
            if (bl2) {
                double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
                return (float)((double)f * d);
            }
        }
        return f;
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f);
        }
        if (f != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth((IlvGraphic)this, (float)f);
        }
        this.clearBoundingBoxCache();
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth((IlvGraphic)this);
    }

    public void setMaximumLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("limit must be greater than 0 " + f);
        }
        if (f != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth((IlvGraphic)this, (float)f);
        }
        this.clearBoundingBoxCache();
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle((IlvGraphic)this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle((IlvGraphic)this, (float[])fArray);
        this.clearBoundingBoxCache();
    }

    public IlvSelection makeSelection() {
        return new IlvHyperEdgeSelection(this);
    }

    protected void actOnAdjustmentEnd() {
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float[] fArray;
        float f;
        super.write(ilvOutputStream);
        this.writeEnds(ilvOutputStream);
        ilvOutputStream.write("bboxCacheSize", this.getBoundingBoxCacheSize());
        IlvUtility2D.writeStrokePaint((IlvOutputStream)ilvOutputStream, (Paint)this.getStrokePaint());
        float f2 = this.getLineWidth();
        if (f2 != 0.0f) {
            ilvOutputStream.write("lineWidth", f2);
        }
        if ((f = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
    }

    protected void writeEnds(IlvOutputStream ilvOutputStream) throws IOException {
        IlvPersistentObject[] ilvPersistentObjectArray = this.getFromEndsArray();
        ilvOutputStream.write("from", ilvPersistentObjectArray);
        IlvPersistentObject[] ilvPersistentObjectArray2 = this.getToEndsArray();
        ilvOutputStream.write("to", ilvPersistentObjectArray2);
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke((IlvGraphic)this);
    }

    public IlvOrderedCompoundEdit beforeDo(String string) {
        IlvOrderedCompoundEdit ilvOrderedCompoundEdit = new IlvOrderedCompoundEdit(string);
        IlvManagerLayerEdit ilvManagerLayerEdit = new IlvManagerLayerEdit(string);
        ilvManagerLayerEdit.before(this);
        ilvOrderedCompoundEdit.addEditNoAbsorb(ilvManagerLayerEdit);
        UndoChangeFromTo undoChangeFromTo = new UndoChangeFromTo();
        undoChangeFromTo.a(this, this.d, true);
        ilvOrderedCompoundEdit.addEditNoAbsorb(undoChangeFromTo);
        UndoChangeFromTo undoChangeFromTo2 = new UndoChangeFromTo();
        undoChangeFromTo2.a(this, this.e, false);
        ilvOrderedCompoundEdit.addEditNoAbsorb(undoChangeFromTo2);
        UndoChangePinPosition undoChangePinPosition = new UndoChangePinPosition();
        undoChangePinPosition.a(this);
        ilvOrderedCompoundEdit.addEditNoAbsorb(undoChangePinPosition);
        String[] stringArray = new String[5];
        stringArray[0] = "getStrokePaint";
        stringArray[1] = "getLineWidth";
        stringArray[2] = "getMaximumLineWidth";
        stringArray[3] = "getLineStyle";
        stringArray[4] = "getBoundingBoxCacheSize";
        String[] stringArray2 = new String[5];
        stringArray2[0] = "setStrokePaint";
        stringArray2[1] = "setLineWidth";
        stringArray2[2] = "setMaximumLineWidth";
        stringArray2[3] = "setLineStyle";
        stringArray2[4] = "setBoundingBoxCacheSize";
        IlvPropertiesEdit ilvPropertiesEdit = new IlvPropertiesEdit(string, IlvHyperEdge.class, stringArray, stringArray2);
        ilvPropertiesEdit.before(this);
        ilvOrderedCompoundEdit.addEditNoAbsorb(ilvPropertiesEdit);
        return ilvOrderedCompoundEdit;
    }

    public void afterDo(IlvOrderedCompoundEdit ilvOrderedCompoundEdit) {
        IlvGraphicEdit ilvGraphicEdit = (IlvGraphicEdit)ilvOrderedCompoundEdit.getEdit(0);
        ilvGraphicEdit.after(this);
        UndoChangeFromTo undoChangeFromTo = (UndoChangeFromTo)ilvOrderedCompoundEdit.getEdit(1);
        undoChangeFromTo.a(this.d);
        UndoChangeFromTo undoChangeFromTo2 = (UndoChangeFromTo)ilvOrderedCompoundEdit.getEdit(2);
        undoChangeFromTo2.a(this.e);
        UndoChangePinPosition undoChangePinPosition = (UndoChangePinPosition)ilvOrderedCompoundEdit.getEdit(3);
        undoChangePinPosition.a();
        IlvGraphicEdit ilvGraphicEdit2 = (IlvGraphicEdit)ilvOrderedCompoundEdit.getEdit(4);
        ilvGraphicEdit2.after(this);
        ilvOrderedCompoundEdit.end();
    }

    static {
        for (int i = 0; i < 3; ++i) {
            IlvHyperEdge.j[i] = new IlvPoint(0.0f, 0.0f);
        }
    }

    static class UndoChangePinPosition
    extends AbstractUndoableEdit {
        private IlvHyperEdge a;
        private HashMap b;
        private HashMap c;

        UndoChangePinPosition() {
        }

        void a(IlvHyperEdge ilvHyperEdge) {
            this.a = ilvHyperEdge;
            this.b = new HashMap();
            this.a(ilvHyperEdge, this.b);
        }

        void a() {
            this.c = new HashMap();
            this.a(this.a, this.c);
        }

        private void a(IlvHyperEdge ilvHyperEdge, HashMap hashMap) {
            Iterator iterator = ilvHyperEdge.getFromEnds();
            while (iterator.hasNext()) {
                this.a((IlvHyperEdgeEnd)iterator.next(), hashMap);
            }
            iterator = ilvHyperEdge.getToEnds();
            while (iterator.hasNext()) {
                this.a((IlvHyperEdgeEnd)iterator.next(), hashMap);
            }
        }

        private void a(IlvHyperEdgeEnd ilvHyperEdgeEnd, HashMap hashMap) {
            IlvPoint ilvPoint = null;
            if (ilvHyperEdgeEnd instanceof IlvDefaultHyperEdgeEnd) {
                IlvDefaultHyperEdgeEnd ilvDefaultHyperEdgeEnd = (IlvDefaultHyperEdgeEnd)ilvHyperEdgeEnd;
                boolean bl = ilvDefaultHyperEdgeEnd.isAbsolutePositioning();
                ilvDefaultHyperEdgeEnd.setAbsolutePositioning(true);
                ilvPoint = ilvHyperEdgeEnd.getPosition(null, false);
                ilvDefaultHyperEdgeEnd.setAbsolutePositioning(bl);
            } else {
                ilvPoint = ilvHyperEdgeEnd.getPosition(null, false);
            }
            hashMap.put(ilvHyperEdgeEnd, ilvPoint);
        }

        private void b(IlvHyperEdge ilvHyperEdge, HashMap hashMap) {
            Iterator iterator = ilvHyperEdge.getFromEnds();
            while (iterator.hasNext()) {
                this.b((IlvHyperEdgeEnd)iterator.next(), hashMap);
            }
            iterator = ilvHyperEdge.getToEnds();
            while (iterator.hasNext()) {
                this.b((IlvHyperEdgeEnd)iterator.next(), hashMap);
            }
        }

        private void b(IlvHyperEdgeEnd ilvHyperEdgeEnd, HashMap hashMap) {
            IlvPoint ilvPoint = (IlvPoint)hashMap.get(ilvHyperEdgeEnd);
            if (ilvPoint == null) {
                return;
            }
            if (ilvHyperEdgeEnd instanceof IlvDefaultHyperEdgeEnd) {
                IlvDefaultHyperEdgeEnd ilvDefaultHyperEdgeEnd = (IlvDefaultHyperEdgeEnd)ilvHyperEdgeEnd;
                boolean bl = ilvDefaultHyperEdgeEnd.isAbsolutePositioning();
                ilvDefaultHyperEdgeEnd.setAbsolutePositioning(true);
                ilvHyperEdgeEnd.setPosition(ilvPoint, null);
                ilvDefaultHyperEdgeEnd.setAbsolutePositioning(bl);
            } else {
                ilvHyperEdgeEnd.setPosition(ilvPoint, null);
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.a == null) {
                return;
            }
            if (this.a.getGraphicBag() == null) {
                this.b();
            } else {
                this.a.getGraphicBag().applyToObject((IlvGraphic)this.a, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        UndoChangePinPosition.this.b();
                    }
                }, null, true);
            }
        }

        private void b() {
            this.b(this.a, this.b);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.a == null) {
                return;
            }
            if (this.a.getGraphicBag() == null) {
                this.c();
            } else {
                this.a.getGraphicBag().applyToObject((IlvGraphic)this.a, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        UndoChangePinPosition.this.c();
                    }
                }, null, true);
            }
        }

        private void c() {
            this.b(this.a, this.c);
        }
    }

    static class UndoChangeFromTo
    extends AbstractUndoableEdit {
        private IlvHyperEdge a;
        private ArrayList b;
        private ArrayList c;
        private ArrayList d;
        private ArrayList e;
        private boolean f;
        private boolean g;

        UndoChangeFromTo() {
        }

        void a(IlvHyperEdge ilvHyperEdge, IlvHyperEdgeEndList ilvHyperEdgeEndList, boolean bl) {
            this.g = bl;
            this.a = ilvHyperEdge;
            if (ilvHyperEdgeEndList == null) {
                this.c = null;
                this.d = null;
            } else {
                this.c = new ArrayList(ilvHyperEdgeEndList);
                this.d = new ArrayList(ilvHyperEdgeEndList);
            }
        }

        void a(IlvHyperEdgeEndList ilvHyperEdgeEndList) {
            if (ilvHyperEdgeEndList == null) {
                this.b = null;
                this.e = null;
            } else {
                this.b = new ArrayList(ilvHyperEdgeEndList);
                this.e = new ArrayList(ilvHyperEdgeEndList);
            }
            this.f = this.a(this.d, this.e);
            if (this.c != null && this.b != null) {
                Object e;
                int n;
                ArrayList arrayList = new ArrayList();
                int n2 = this.b.size();
                for (n = 0; n < n2; ++n) {
                    e = this.b.get(n);
                    if (!this.c.contains(e)) continue;
                    arrayList.add(e);
                }
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    e = arrayList.get(n);
                    this.c.remove(e);
                    this.b.remove(e);
                }
            }
        }

        private boolean a(ArrayList arrayList, ArrayList arrayList2) {
            if (arrayList == arrayList2) {
                return false;
            }
            if (arrayList == null) {
                return false;
            }
            if (arrayList2 == null) {
                return false;
            }
            int n = arrayList.size();
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                int n3 = arrayList2.indexOf(e);
                if (n3 < 0) continue;
                if (n3 < n2) {
                    return true;
                }
                n2 = n3;
            }
            return false;
        }

        public boolean isSignificant() {
            if (this.f) {
                return true;
            }
            if (this.b != null && this.b.size() > 0) {
                return true;
            }
            return this.c != null && this.c.size() > 0;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.a == null) {
                return;
            }
            if (this.a.getGraphicBag() == null) {
                this.a();
            } else {
                this.a.getGraphicBag().applyToObject((IlvGraphic)this.a, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        UndoChangeFromTo.this.a();
                    }
                }, null, true);
            }
        }

        private void a() {
            IlvHyperEdgeEnd ilvHyperEdgeEnd;
            int n;
            int n2;
            if (this.b != null) {
                n2 = this.b.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.b.get(n);
                    if (this.g) {
                        this.a.removeFrom(ilvHyperEdgeEnd);
                        continue;
                    }
                    this.a.removeTo(ilvHyperEdgeEnd);
                }
            }
            if (this.c != null) {
                n2 = this.c.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.c.get(n);
                    if (this.g) {
                        this.a.a(ilvHyperEdgeEnd, true);
                        continue;
                    }
                    this.a.b(ilvHyperEdgeEnd, true);
                }
            }
            if (this.g) {
                this.a.a(this.d);
            } else {
                this.a.b(this.d);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.a == null) {
                return;
            }
            if (this.a.getGraphicBag() == null) {
                this.redoImpl();
            } else {
                this.a.getGraphicBag().applyToObject((IlvGraphic)this.a, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        UndoChangeFromTo.this.redoImpl();
                    }
                }, null, true);
            }
        }

        public void redoImpl() {
            IlvHyperEdgeEnd ilvHyperEdgeEnd;
            int n;
            int n2;
            if (this.c != null) {
                n2 = this.c.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.c.get(n);
                    if (this.g) {
                        this.a.removeFrom(ilvHyperEdgeEnd);
                        continue;
                    }
                    this.a.removeTo(ilvHyperEdgeEnd);
                }
            }
            if (this.b != null) {
                n2 = this.b.size();
                for (n = 0; n < n2; ++n) {
                    ilvHyperEdgeEnd = (IlvHyperEdgeEnd)this.b.get(n);
                    if (this.g) {
                        this.a.a(ilvHyperEdgeEnd, true);
                        continue;
                    }
                    this.a.b(ilvHyperEdgeEnd, true);
                }
            }
            if (this.g) {
                this.a.a(this.e);
            } else {
                this.a.b(this.e);
            }
        }
    }
}

