/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.random;

import ilog.views.IlvGraphicVector;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.random.IlvRandomLayoutGrapherProperty;
import java.util.Enumeration;
import java.util.Random;

public class IlvRandomLayout
extends IlvGraphLayout {
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int NO_RESHAPE_STYLE = 0;
    static final int a = 1;
    private int b;

    public IlvRandomLayout() {
    }

    protected void init() {
        super.init();
        this.b = 1;
    }

    public IlvRandomLayout(IlvRandomLayout ilvRandomLayout) {
        super(ilvRandomLayout);
    }

    public IlvGraphLayout copy() {
        return new IlvRandomLayout(this);
    }

    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvRandomLayout) {
            IlvRandomLayout ilvRandomLayout = (IlvRandomLayout)ilvGraphLayout;
            this.setLinkStyle(ilvRandomLayout.getLinkStyle());
        }
    }

    protected void layout(boolean bl) throws IlvGraphLayoutException {
        this.checkAppropriateLinks();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        int n = ilvGraphModel.getNodesCount();
        int n2 = 1;
        int n3 = 5;
        IlvRect ilvRect = this.getCalcLayoutRegion();
        float f = ilvRect.x;
        float f2 = ilvRect.y;
        float f3 = ilvRect.x + ilvRect.width;
        float f4 = ilvRect.y + ilvRect.height;
        Random random = this.isUseSeedValueForRandomGenerator() ? new Random(this.getSeedValueForRandomGenerator()) : new Random();
        Enumeration enumeration = ilvGraphModel.getNodes();
        boolean bl2 = this.isPreserveFixedNodes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) {
                throw new RuntimeException("null node retrieved from graph model");
            }
            if (bl2 && this.isFixed(e)) continue;
            IlvRect ilvRect2 = ilvGraphModel.boundingBox(e);
            float f5 = random.nextFloat();
            float f6 = f + Math.max(0.0f, f3 - ilvRect2.width - f) * f5;
            f5 = random.nextFloat();
            float f7 = f2 + Math.max(0.0f, f4 - ilvRect2.height - f2) * f5;
            ilvGraphModel.moveNode(e, f6, f7, bl);
            this.increasePercentageComplete(n2++ * 100 / n);
            this.callLayoutStepPerformedIfNeeded();
            if (!this.isLayoutTimeElapsed() && !this.isStoppedImmediately()) continue;
            n3 = 7;
            break;
        }
        if (this.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this, bl);
        }
        this.increasePercentageComplete(100);
        this.layoutStepPerformed();
        ilvGraphLayoutReport.setCode(n3);
    }

    public final boolean supportsPreserveFixedNodes() {
        return true;
    }

    public final boolean supportsLayoutRegion() {
        return true;
    }

    public final boolean supportsPercentageComplete() {
        return true;
    }

    public final boolean supportsRandomGenerator() {
        return true;
    }

    public final boolean supportsAllowedTime() {
        return true;
    }

    public boolean supportsStopImmediately() {
        return true;
    }

    public boolean supportsSaveParametersToNamedProperties() {
        return true;
    }

    public void setLinkStyle(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("unsupported style option: " + n);
        }
        if (n != this.b) {
            this.b = n;
            this.onParameterChanged("LinkStyle");
        }
    }

    public int getLinkStyle() {
        return this.isUseDefaultParameters() ? 1 : this.b;
    }

    public int checkAppropriateLink(Object object) {
        if (this.getLinkStyle() == 0) {
            return 0;
        }
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel.isLinkCheckEnabled() && !ilvGraphModel.isReshapeableLink(object, true)) {
            return 1;
        }
        return 0;
    }

    public IlvGraphicVector getMovingNodes() {
        return LayoutUtil.getDefaultMovingNodes(this.getGraphModel());
    }

    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvRandomLayoutGrapherProperty(string, this, bl);
    }
}

