/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.circular;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.circular.ClusterLayoutAlgo;
import ilog.views.graphlayout.circular.IlvAbstractGraph;
import ilog.views.graphlayout.circular.IlvAbstractGraphicNode;
import ilog.views.graphlayout.circular.IlvCircularLayoutGrapherProperty;
import ilog.views.graphlayout.circular.IlvCircularLayoutNodeProperty;
import ilog.views.graphlayout.circular.IlvCircularLayoutOfSubTrees;
import ilog.views.graphlayout.circular.IlvClusterId;
import ilog.views.graphlayout.circular.IlvClusterIdCollection;
import ilog.views.graphlayout.circular.IlvClusterInfoProperty;
import ilog.views.graphlayout.circular.IlvClustersConnexion;
import ilog.views.graphlayout.circular.IlvGraphOfClusters;
import ilog.views.graphlayout.circular.IlvGrapherCluster;
import ilog.views.graphlayout.internalutil.IlvArrayStableSort;
import ilog.views.graphlayout.internalutil.IlvUnsyncVector;
import ilog.views.graphlayout.internalutil.LayoutParametersUtil;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IlvCircularLayout
extends IlvGraphLayout {
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int NO_RESHAPE_STYLE = 0;
    public static final int NO_INDEX = -1;
    public static final int BY_CLUSTER_IDS = 0;
    public static final int BY_SUBGRAPHS = 1;
    static final double a = 1.2566370614359172;
    private IlvGraphOfClusters b;
    private IlvUnsyncVector c;
    private IlvUnsyncVector d;
    private Hashtable e;
    private static final String f = "ClusterId";
    private static final String g = "StarCenter";
    private float h;
    private float i;
    static final float j = 10.0f;
    static final float k = 0.0f;
    static final float l = 10.0f;
    static final boolean m = false;
    static final int n = 1;
    static final int o = 0;
    static final int p = 200;
    private float q;
    private float r;
    private float s;
    private boolean t;
    private int u;
    private int v;
    private int w;
    private boolean x = false;
    private boolean y = false;
    static final int z = 9;
    private IlvArrayStableSort aa;
    private transient ClusterLayoutAlgo ab;
    private static final String ac = "No cluster found. You must provide clustering information.";

    public IlvCircularLayout() {
    }

    public IlvCircularLayout(IlvCircularLayout ilvCircularLayout) {
        super(ilvCircularLayout);
    }

    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvCircularLayout) {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)ilvGraphLayout;
            this.setOffset(ilvCircularLayout.getOffset());
            this.setLevelOffset(ilvCircularLayout.getLevelOffset());
            this.setDisconnectedGraphOffset(ilvCircularLayout.getDisconnectedGraphOffset());
            this.setAreaMinimizationEnabled(ilvCircularLayout.isAreaMinimizationEnabled());
            this.setLinkStyle(ilvCircularLayout.getLinkStyle());
            this.setClusteringMode(ilvCircularLayout.getClusteringMode());
            this.setMaxNumberOfPermutations(ilvCircularLayout.getMaxNumberOfPermutations());
        }
    }

    protected void init() {
        super.init();
        this.q = 10.0f;
        this.r = 0.0f;
        this.s = 10.0f;
        this.t = false;
        this.u = 1;
        this.v = 0;
        this.w = 200;
        this.aa = new SortNodesByIndex();
    }

    public IlvGraphLayout copy() {
        return new IlvCircularLayout(this);
    }

    public synchronized void detach() {
        this.e();
        this.d(false);
        super.detach();
    }

    private void e() {
        this.e = null;
        this.f();
    }

    private void f() {
        if (this.ab != null) {
            this.ab.cleanData();
        }
        this.ab = null;
    }

    private void a(IlvRect ilvRect) {
        this.h = ilvRect.x + ilvRect.width * 0.5f;
        this.i = ilvRect.y + ilvRect.height * 0.5f;
    }

    private void g() {
        this.d = null;
        this.b = null;
        this.c = null;
    }

    protected void layout(boolean bl) throws IlvGraphLayoutException {
        this.checkAppropriateLinks();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        IlvRect ilvRect = this.getCalcLayoutRegion();
        this.a(ilvRect);
        if (this.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this, false);
            this.clipAllLinks(true, bl);
        }
        switch (this.getClusteringMode()) {
            case 0: {
                this.a(ilvRect, bl);
                break;
            }
            case 1: {
                this.c(bl);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported clustering mode: " + this.getClusteringMode());
            }
        }
        ilvGraphLayoutReport.setCode(5);
    }

    private void c(boolean bl) throws IlvGraphLayoutException {
        this.ab = new ClusterLayoutAlgo(this);
        this.ab.layout(bl);
    }

    private void a(IlvRect ilvRect, boolean bl) throws IlvGraphLayoutException {
        this.d(false);
        if (!this.clusterize()) {
            throw new IlvGraphLayoutException(ac);
        }
        int n = this.c.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphOfClusters ilvGraphOfClusters = (IlvGraphOfClusters)this.c.elementAt(i);
            this.a(ilvGraphOfClusters, bl);
            if (n <= 1) continue;
            ilvGraphOfClusters.h();
        }
        if (n > 1) {
            IlvCircularLayoutOfSubTrees ilvCircularLayoutOfSubTrees = new IlvCircularLayoutOfSubTrees(this.c, this, ilvRect);
            ilvCircularLayoutOfSubTrees.a(bl);
        }
        this.d(true);
    }

    private void a(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
            int n = this.getClusterIdsCount(ilvGraphic);
            if (n > 0) continue;
            IlvClusterInfoProperty ilvClusterInfoProperty = (IlvClusterInfoProperty)ilvGraphic.getNamedProperty("ClusterInfoPropertyName");
            this.a(ilvGraphic, ilvClusterInfoProperty);
        }
    }

    final void a(IlvGraphic ilvGraphic, IlvClusterInfoProperty ilvClusterInfoProperty) {
        if (ilvGraphic == null) {
            return;
        }
        if (ilvClusterInfoProperty == null) {
            return;
        }
        IlvClusterId[] ilvClusterIdArray = ilvClusterInfoProperty.getClusterIds();
        int[] nArray = ilvClusterInfoProperty.getIndexes();
        for (int i = 0; i < ilvClusterIdArray.length; ++i) {
            int n = nArray[i];
            if (n >= 0) {
                this.addClusterId(ilvGraphic, ilvClusterIdArray[i], n);
                continue;
            }
            this.addClusterId(ilvGraphic, ilvClusterIdArray[i]);
        }
        this.setStarCenter(ilvGraphic, ilvClusterInfoProperty.isStarCenter());
    }

    public synchronized void setRootClusterId(IlvClusterId ilvClusterId) {
        this.b(ilvClusterId);
    }

    private void b(IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("clusterId cannot be null");
        }
        if (this.e == null) {
            this.e = new Hashtable(100, 100.0f);
        } else if (this.e.containsKey(ilvClusterId)) {
            return;
        }
        this.e.put(ilvClusterId, ilvClusterId);
        this.d(false);
        this.onParameterChanged("Clustering");
    }

    public synchronized void removeRootClusterId(IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("clusterId cannot be null");
        }
        if (this.e != null) {
            this.e.remove(ilvClusterId);
            this.d(false);
            this.onParameterChanged("Clustering");
        }
    }

    public synchronized void removeAllRootClusterIds() {
        if (this.e != null) {
            this.e = null;
            this.d(false);
            this.onParameterChanged("Clustering");
        }
    }

    public synchronized void setRootClusterIds(IlvClusterId[] ilvClusterIdArray) {
        this.removeAllRootClusterIds();
        if (ilvClusterIdArray != null) {
            int n = ilvClusterIdArray.length;
            for (int i = 0; i < n; ++i) {
                this.b(ilvClusterIdArray[i]);
            }
        }
    }

    public IlvClusterId[] getRootClusterIds() {
        if (this.e == null) {
            return null;
        }
        int n = this.e.size();
        if (n == 0) {
            return null;
        }
        Enumeration enumeration = this.e.keys();
        IlvClusterId[] ilvClusterIdArray = new IlvClusterId[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ilvClusterIdArray[n2++] = (IlvClusterId)enumeration.nextElement();
        }
        return ilvClusterIdArray;
    }

    private IlvGrapherCluster a(IlvGraphOfClusters ilvGraphOfClusters) {
        IlvClusterId ilvClusterId;
        if (this.e == null) {
            return ilvGraphOfClusters.a();
        }
        IlvGrapherCluster ilvGrapherCluster = null;
        Enumeration enumeration = this.e.keys();
        while (enumeration.hasMoreElements() && (ilvGrapherCluster = ilvGraphOfClusters.getCluster(ilvClusterId = (IlvClusterId)enumeration.nextElement())) == null) {
        }
        if (ilvGrapherCluster == null) {
            return ilvGraphOfClusters.a();
        }
        ilvGraphOfClusters.a(ilvGrapherCluster);
        return ilvGrapherCluster;
    }

    private final void a(IlvGraphOfClusters ilvGraphOfClusters, boolean bl) throws IlvGraphLayoutException {
        Level level;
        IlvGrapherCluster ilvGrapherCluster;
        Enumeration enumeration = ilvGraphOfClusters.getNodes();
        if (!enumeration.hasMoreElements()) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            ilvGrapherCluster = (IlvGrapherCluster)enumeration.nextElement();
            ilvGrapherCluster.a(this.getOffset(), this);
        }
        ilvGrapherCluster = this.a(ilvGraphOfClusters);
        float f = this.getOffset();
        ilvGrapherCluster.a(this.h, this.i);
        this.layoutStepPerformed();
        ilvGrapherCluster.a(true, this, this.h, this.i, 0.0f, f, bl);
        IlvUnsyncVector ilvUnsyncVector = new IlvUnsyncVector(10, 10);
        IlvUnsyncVector ilvUnsyncVector2 = ilvGrapherCluster.i();
        float f2 = ilvGrapherCluster.m();
        int n = 0;
        float f3 = 0.0f;
        double d = 0.0;
        float f4 = 0.0f;
        double d2 = 0.0;
        float f5 = 0.0f;
        double d3 = 0.0;
        float f6 = 0.0f;
        float f7 = 0.0f;
        Level level2 = level = this.isAreaMinimizationEnabled() ? new Level(50) : null;
        if (ilvUnsyncVector2.size() > 1) {
            float f8;
            int n2;
            IlvAbstractGraphicNode ilvAbstractGraphicNode;
            int n3;
            for (n3 = 0; n3 < ilvUnsyncVector2.size(); ++n3) {
                ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(n3);
                IlvUnsyncVector ilvUnsyncVector3 = ilvAbstractGraphicNode.a();
                if (ilvUnsyncVector3 == null || ilvUnsyncVector3.size() < 1) continue;
                int n4 = ilvUnsyncVector3.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector3.elementAt(n2);
                    if (ilvGrapherCluster2 == null) continue;
                    ilvUnsyncVector.addElement(ilvGrapherCluster2);
                    float f9 = ilvGrapherCluster2.m();
                    f2 = IlvCircularLayout.a(ilvGrapherCluster2, ilvGrapherCluster, ilvGrapherCluster.m(), f2, f);
                    if (!(f9 > f6)) continue;
                    f6 = f9;
                }
                f7 = f2 - f6;
                double d4 = IlvGrapherCluster.a(ilvAbstractGraphicNode, this.getGraphModel(), this.h, this.i);
                f8 = 0.0f;
                if (this.isAreaMinimizationEnabled() && ilvUnsyncVector.size() > 0) {
                    Interval interval = new Interval();
                    level.a(interval);
                    interval.a(ilvGrapherCluster);
                    interval.a(ilvGraphOfClusters, ilvUnsyncVector3);
                    interval.a(d4);
                    f8 = IlvCircularLayout.a(ilvUnsyncVector3, f7, f);
                }
                f8 = IlvCircularLayout.a(ilvAbstractGraphicNode, f7, f);
                if (n == 0) {
                    f3 = f8;
                    d = d4;
                }
                f4 = f8;
                d2 = d4;
                if (n > 0) {
                    double d5 = LayoutUtil.GetOrientedDeltaAlpha(LayoutUtil.CorrectAngle(d4), LayoutUtil.CorrectAngle(d3));
                    f7 = (float)Math.max((double)f7, (double)((f5 + f8) * 0.5f + f) / d5);
                    f2 = Math.max(f2, f7 + f6);
                }
                f5 = f8;
                d3 = d4;
                ++n;
            }
            if (n > 1) {
                f7 = (float)Math.max((double)f7, (double)((f3 + f4) * 0.5f + f) / LayoutUtil.GetDeltaAlpha(d, d2));
                f2 = Math.max(f2, f7 + f6);
            }
            f2 += this.getLevelOffset();
            if (this.isAreaMinimizationEnabled() && ilvUnsyncVector.size() > 0) {
                float f10 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
                float f11 = f2 - f10;
                for (int i = 0; i < level.b(); ++i) {
                    Interval interval = level.b(i);
                    f8 = IlvCircularLayout.a(interval.c(), f11, f);
                    interval.b(f11);
                    interval.a(f8, ilvGrapherCluster.m(), f2);
                    interval.a(interval.c().size());
                }
                level.a(f);
                this.a(level, f2, f, bl);
            } else {
                f7 = f2 - f6;
                n3 = ilvUnsyncVector2.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(n2);
                    this.a(ilvAbstractGraphicNode, f2, f7, f, bl);
                }
            }
            this.a(ilvUnsyncVector, ilvGraphOfClusters, this.h, this.i, f2, f, bl);
        } else {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(0);
            float f12 = LayoutUtil.getDiagonal(ilvAbstractGraphicNode.getGraphicObject(), this.getGraphModel());
            IlvUnsyncVector ilvUnsyncVector4 = ilvAbstractGraphicNode.a();
            float[] fArray = new float[1];
            if (ilvUnsyncVector4 == null || ilvUnsyncVector4.size() < 1) {
                return;
            }
            f2 = this.a(ilvUnsyncVector4, ilvGrapherCluster, fArray, f, f12) + this.getLevelOffset();
            this.a(ilvUnsyncVector4, ilvGrapherCluster, fArray[0], ilvGraphOfClusters, this.h, this.i, f2, f, bl);
        }
    }

    private final float a(IlvUnsyncVector ilvUnsyncVector, IlvGrapherCluster ilvGrapherCluster, float[] fArray, float f, float f2) {
        if (ilvUnsyncVector.size() == 1) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(0);
            fArray[0] = ilvGrapherCluster2.m();
            return f2 * 0.5f + f + ilvGrapherCluster2.o();
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (int i = 0; i < ilvUnsyncVector.size(); ++i) {
            IlvGrapherCluster ilvGrapherCluster3 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i);
            float f7 = ilvGrapherCluster3.m();
            float f8 = ilvGrapherCluster3.o();
            f4 += 2.0f * f7 + f;
            if (f8 > f5) {
                f5 = f8;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        f3 = (float)((double)f4 / (Math.PI * 2));
        f3 = Math.max(f3, f2 * 0.5f + f + f5);
        if (ilvUnsyncVector.size() > 1) {
            ilvGrapherCluster.a(f4);
        } else {
            ilvGrapherCluster.a(0.0f);
        }
        fArray[0] = f6;
        return f3;
    }

    private final void a(IlvUnsyncVector ilvUnsyncVector, IlvGrapherCluster ilvGrapherCluster, float f, IlvGraphOfClusters ilvGraphOfClusters, float f2, float f3, float f4, float f5, boolean bl) throws IlvGraphLayoutException {
        switch (ilvUnsyncVector.size()) {
            case 0: {
                return;
            }
            case 2: {
                IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(0);
                IlvGrapherCluster ilvGrapherCluster3 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(1);
                double d = 0.0;
                double d2 = Math.PI;
                ilvGrapherCluster2.a(d);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster2.a(this, d, f2, f3, f4, f5, bl);
                ilvGrapherCluster3.a(d2);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster3.a(this, d2, f2, f3, f4, f5, bl);
                break;
            }
            default: {
                double d = 0.0;
                float f6 = f4 - f;
                float f7 = (float)(Math.PI * 2 * (double)f6 - (ilvGrapherCluster.s() - (double)(f5 * (float)(ilvUnsyncVector.size() - 1)))) / (float)ilvUnsyncVector.size();
                double d3 = LayoutUtil.getEqualSidesTriangleAngle(f6, f7);
                int n = ilvUnsyncVector.size();
                for (int i = 0; i < n; ++i) {
                    IlvGrapherCluster ilvGrapherCluster4 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i);
                    float f8 = ilvGrapherCluster4.m();
                    if (i != 0) {
                        d += LayoutUtil.getEqualSidesTriangleAngle(f6, f8);
                    }
                    ilvGrapherCluster4.a(d);
                    this.callLayoutStepPerformedIfNeeded();
                    ilvGrapherCluster4.a(this, d, f2, f3, f4, f5, bl);
                    d += LayoutUtil.getEqualSidesTriangleAngle(f6, f8) + d3;
                }
            }
        }
        if (ilvUnsyncVector.size() > 0) {
            this.a(ilvUnsyncVector, ilvGraphOfClusters, f2, f3, f4, f5, bl);
        }
    }

    private final void a(IlvUnsyncVector ilvUnsyncVector, IlvGraphOfClusters ilvGraphOfClusters, float f, float f2, float f3, float f4, boolean bl) throws IlvGraphLayoutException {
        IlvGrapherCluster ilvGrapherCluster;
        int n;
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return;
        }
        IlvUnsyncVector ilvUnsyncVector2 = new IlvUnsyncVector(ilvUnsyncVector.size(), ilvUnsyncVector.size());
        float f5 = f3;
        int n2 = 0;
        float f6 = 0.0f;
        double d = 0.0;
        float f7 = 0.0f;
        double d2 = 0.0;
        float f8 = 0.0f;
        double d3 = 0.0;
        float[] fArray = new float[]{0.0f};
        float f9 = 0.0f;
        boolean bl2 = this.isAreaMinimizationEnabled();
        Level level = bl2 ? new Level(ilvUnsyncVector.size()) : null;
        int n3 = ilvUnsyncVector.size();
        for (n = 0; n < n3; ++n) {
            ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(n);
            IlvUnsyncVector ilvUnsyncVector3 = new IlvUnsyncVector(15);
            f5 = this.a(ilvGrapherCluster, ilvUnsyncVector3, f3, f5, fArray, f4);
            int n4 = ilvUnsyncVector3.size();
            for (int i = 0; i < n4; ++i) {
                ilvUnsyncVector2.addElement(ilvUnsyncVector3.elementAt(i));
            }
            if (f5 <= 0.0f || n4 < 1) {
                f5 = Math.abs(f5);
                f9 = f5 - fArray[0];
                continue;
            }
            f9 = f5 - fArray[0];
            float f10 = 0.0f;
            double d4 = ilvGrapherCluster.r();
            if (bl2 && ilvUnsyncVector2.size() > 0) {
                Interval interval = new Interval();
                level.a(interval);
                interval.a(ilvGrapherCluster);
                interval.a(ilvGraphOfClusters, ilvUnsyncVector3);
                interval.a(d4);
                f10 = IlvCircularLayout.a(ilvUnsyncVector3, f9, f4);
            } else {
                f10 = IlvCircularLayout.a(ilvGrapherCluster, ilvGraphOfClusters, f9, f4);
            }
            if (n2 == 0) {
                f6 = f10;
                d = d4;
            }
            f7 = f10;
            d2 = d4;
            if (n2 > 0) {
                double d5 = LayoutUtil.GetOrientedDeltaAlpha(LayoutUtil.CorrectAngle(d4), LayoutUtil.CorrectAngle(d3));
                f9 = (float)Math.max((double)f9, (double)((f8 + f10) * 0.5f + f4) / d5);
                f5 = Math.max(f5, f9 + fArray[0]);
            }
            f8 = f10;
            d3 = d4;
            ++n2;
        }
        if (n2 > 1) {
            f9 = (float)Math.max((double)f9, (double)((f6 + f7) * 0.5f + f4) / LayoutUtil.GetDeltaAlpha(d, d2));
            f5 = Math.max(f5, f9 + fArray[0]);
        }
        f5 += this.getLevelOffset();
        if (bl2 && ilvUnsyncVector2.size() > 0) {
            int n5 = level.b();
            for (int i = 0; i < n5; ++i) {
                Interval interval = level.b(i);
                ilvGrapherCluster = interval.a();
                float f11 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
                float f12 = f5 - f11;
                float f13 = IlvCircularLayout.a(interval.c(), f12, f4);
                interval.b(f12);
                interval.a(f13, f3, f5);
                interval.a(interval.c().size());
            }
            level.a(f4);
            this.a(level, f5, f4, bl);
        } else {
            for (n = 0; n < n3; ++n) {
                ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(n);
                this.a(ilvGrapherCluster, ilvGraphOfClusters, f5, f4, bl);
            }
        }
        if (ilvUnsyncVector2.size() > 0) {
            this.a(ilvUnsyncVector2, ilvGraphOfClusters, f, f2, f5, f4, bl);
        }
    }

    private final void a(IlvAbstractGraphicNode ilvAbstractGraphicNode, float f, float f2, float f3, boolean bl) throws IlvGraphLayoutException {
        double d = IlvGrapherCluster.a(ilvAbstractGraphicNode, this.getGraphModel(), this.h, this.i);
        IlvUnsyncVector ilvUnsyncVector = ilvAbstractGraphicNode.a();
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return;
        }
        float f4 = IlvCircularLayout.a(ilvUnsyncVector, f2, f3);
        d -= (double)(f4 / (2.0f * f2));
        float f5 = IlvCircularLayout.a(f3, f2);
        int n = ilvUnsyncVector.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                d += (double)(f5 / f2);
            }
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i);
            float f6 = IlvCircularLayout.a(ilvGrapherCluster.m(), f2);
            this.callLayoutStepPerformedIfNeeded();
            ilvGrapherCluster.a(false, this, d += (double)(f6 / f2), this.h, this.i, f, f3, bl);
            d += (double)(f6 / f2);
        }
    }

    private final void a(Level level, float f, float f2, boolean bl) throws IlvGraphLayoutException {
        if (level.b() < 1) {
            return;
        }
        float f3 = level.b(0).i();
        for (int i = 0; i < level.b(); ++i) {
            Interval interval = level.b(i);
            double d = interval.j();
            double d2 = interval.k();
            double d3 = interval.l();
            double d4 = interval.m();
            double d5 = 0.0;
            if (interval.e() > 1) {
                d5 = (LayoutUtil.GetOrientedDeltaAlpha(d2, d) - LayoutUtil.GetOrientedDeltaAlpha(d4, d3)) / (double)interval.e();
            }
            double d6 = interval.j();
            float f4 = IlvCircularLayout.a(f2, f3);
            IlvUnsyncVector ilvUnsyncVector = interval.c();
            d6 += d5 * 0.5;
            int n = ilvUnsyncVector.size();
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    d6 += d5 + (double)(f4 / f3);
                }
                IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(j);
                float f5 = IlvCircularLayout.a(ilvGrapherCluster.m(), f3);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster.a(false, this, d6 += (double)(f5 / f3), this.h, this.i, f, f2, bl);
                ilvGrapherCluster.a(d6);
                d6 += (double)(f5 / f3);
            }
        }
    }

    private final void a(IlvGrapherCluster ilvGrapherCluster, IlvGraphOfClusters ilvGraphOfClusters, float f, float f2, boolean bl) throws IlvGraphLayoutException {
        IlvUnsyncVector ilvUnsyncVector = ilvGrapherCluster.i();
        if (ilvUnsyncVector.size() < 1) {
            return;
        }
        double d = IlvCircularLayout.a(ilvGrapherCluster, this.h, this.i);
        float f3 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
        float f4 = f - f3;
        float f5 = IlvCircularLayout.a(ilvGrapherCluster, ilvGraphOfClusters, f4, f2);
        d -= (double)(f5 / (2.0f * f4));
        int n = 0;
        int n2 = ilvUnsyncVector.size();
        for (int i = 0; i < n2; ++i) {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector.elementAt(i);
            IlvUnsyncVector ilvUnsyncVector2 = ilvAbstractGraphicNode.a();
            if (ilvUnsyncVector2 == null || ilvUnsyncVector2.size() < 1) continue;
            float f6 = IlvCircularLayout.a(f2, f4);
            float f7 = f6 / f4;
            int n3 = ilvUnsyncVector2.size();
            for (int j = 0; j < n3; ++j) {
                if (n > 0) {
                    d += (double)f7;
                }
                IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector2.elementAt(j);
                float f8 = IlvCircularLayout.a(ilvGrapherCluster2.m(), f4);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster2.a(false, this, d += (double)(f8 / f4), this.h, this.i, f, f2, bl);
                ilvGrapherCluster2.a(d);
                d += (double)(f8 / f4);
                ++n;
            }
        }
    }

    private final boolean h() {
        return this.x;
    }

    private final void d(boolean bl) {
        if (this.x != bl) {
            if (!bl) {
                this.g();
            }
            this.x = bl;
        }
    }

    public void setStructureUpToDate(boolean bl) {
        super.setStructureUpToDate(bl);
        if (!bl) {
            this.d(false);
        }
    }

    private static final double a(IlvGrapherCluster ilvGrapherCluster, float f, float f2) {
        return Math.atan2(f2 - ilvGrapherCluster.u(), ilvGrapherCluster.t() - f);
    }

    private final float a(IlvGrapherCluster ilvGrapherCluster, IlvUnsyncVector ilvUnsyncVector, float f, float f2, float[] fArray, float f3) {
        float f4;
        IlvCircularLayout.a(ilvGrapherCluster, ilvUnsyncVector);
        IlvUnsyncVector ilvUnsyncVector2 = ilvUnsyncVector;
        if (ilvUnsyncVector2.size() < 1) {
            ilvGrapherCluster.a(0.0f);
            return -f2;
        }
        float f5 = f2;
        float f6 = 0.0f;
        for (int i = 0; i < ilvUnsyncVector2.size(); ++i) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector2.elementAt(i);
            float f7 = ilvGrapherCluster2.m();
            if (i > 0) {
                f6 += f3;
            }
            f6 += 2.0f * ilvGrapherCluster2.m();
            f5 = IlvCircularLayout.a(ilvGrapherCluster2, ilvGrapherCluster, f, f5, f3);
            if (!(f7 > fArray[0])) continue;
            fArray[0] = f7;
        }
        ilvGrapherCluster.a(f6);
        float f8 = f4 = f5 - fArray[0];
        float f9 = 1.2f * f6;
        if ((double)f4 > 1.0E-4 && f6 > 0.0f && ((double)(f9 / (2.0f * f4)) > Math.PI || Math.cos(f9 / (2.0f * f4)) <= (double)(f / f4))) {
            int n = 0;
            while (((double)(f9 / (2.0f * (f4 += f8))) > Math.PI || Math.cos(f9 / (2.0f * f4)) <= (double)(f / f4)) && ++n < 1000) {
            }
            n = 0;
            while ((double)(f9 / (2.0f * (f4 -= f8 / 10.0f))) <= Math.PI && Math.cos(f9 / (2.0f * f4)) > (double)(f / f4) && ++n < 1000) {
            }
            f5 = f4 + f5 / 10.0f + fArray[0];
        }
        return f5;
    }

    private static final float a(IlvGrapherCluster ilvGrapherCluster, IlvGrapherCluster ilvGrapherCluster2, float f, float f2, float f3) {
        float f4 = ilvGrapherCluster.g().getType() == 0 ? -ilvGrapherCluster2.n() : f3;
        return Math.max(f2, f + ilvGrapherCluster.o() + f4);
    }

    private void i() {
        if (!this.clusterize()) {
            throw new RuntimeException(ac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean clusterize() {
        if (this.y || this.h()) {
            return true;
        }
        this.y = true;
        boolean bl = false;
        try {
            Object object;
            bl = this.j();
            if (!bl && (object = this.getGrapher()) != null) {
                this.a(this.getGraphModel().getNodes());
                bl = this.j();
            }
            if (bl) {
                this.a(this.b);
                this.c = this.b.b();
                if (this.d == null) {
                    this.d = new IlvUnsyncVector(this.b.i().size());
                } else {
                    this.d.removeAllElements();
                }
                int n = this.c.size();
                for (int i = 0; i < n; ++i) {
                    object = (IlvGraphOfClusters)this.c.elementAt(i);
                    IlvUnsyncVector ilvUnsyncVector = ((IlvAbstractGraph)object).i();
                    int n2 = ilvUnsyncVector.size();
                    for (int j = 0; j < n2; ++j) {
                        this.d.addElement(ilvUnsyncVector.elementAt(j));
                    }
                }
                this.d(true);
            }
            this.b = null;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            this.y = false;
        }
        return bl;
    }

    private boolean j() {
        Object object;
        this.b = new IlvGraphOfClusters();
        Enumeration enumeration = this.getGraphModel().getNodes();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Enumeration enumeration2 = this.getClusterIds(object);
            while (enumeration2.hasMoreElements()) {
                IlvClusterId ilvClusterId = (IlvClusterId)enumeration2.nextElement();
                this.a(object, ilvClusterId);
            }
        }
        object = this.b.getNodes();
        if (!object.hasMoreElements()) {
            return false;
        }
        this.b.a(this);
        return true;
    }

    public final synchronized void setStarCenter(Object object, boolean bl) {
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, g, bl, false);
    }

    public boolean isStarCenter(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, g, false);
    }

    public final synchronized void setClusterId(Object object, IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.set(ilvClusterId);
            this.onParameterChanged(object, f);
        }
        this.d(false);
    }

    public final synchronized void setClusterId(Object object, IlvClusterId ilvClusterId, int n) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index must not be negative");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId, n));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.set(ilvClusterId, n);
            this.onParameterChanged(object, f);
        }
        this.d(false);
    }

    public final synchronized void addClusterId(Object object, IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.add(ilvClusterId);
            this.onParameterChanged(object, f);
        }
        this.d(false);
    }

    public final synchronized void addClusterId(Object object, IlvClusterId ilvClusterId, int n) {
        if (ilvClusterId == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("index must not be negative");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, new IlvClusterIdCollection(ilvClusterId, n));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.add(ilvClusterId, n);
            this.onParameterChanged(object, f);
        }
        this.d(false);
    }

    public final synchronized void removeClusterId(Object object, IlvClusterId ilvClusterId) {
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection != null && ilvClusterIdCollection.remove(ilvClusterId)) {
            this.onParameterChanged(object, f);
            this.d(false);
        }
    }

    public final synchronized void removeAllClusterIds(Object object) {
        LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, f, null);
        this.d(false);
    }

    public Vector getClusterIds() {
        this.i();
        if (this.d.size() < 1) {
            return null;
        }
        Vector<IlvClusterId> vector = new Vector<IlvClusterId>(this.d.size());
        int n = this.d.size();
        for (int i = 0; i < n; ++i) {
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(i);
            vector.addElement(ilvGrapherCluster.getId());
        }
        return vector;
    }

    public float getClusterRadius(int n) {
        this.i();
        if (n < 0) {
            throw new IllegalArgumentException("clusterIndex cannot be negative");
        }
        if (n >= this.d.size()) {
            throw new IllegalArgumentException("clusterIndex (" + n + " cannot be >= #clusters (" + this.d.size() + ")");
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(n);
        return ilvGrapherCluster.l();
    }

    public IlvPoint getClusterCenter(int n) {
        this.i();
        if (n < 0) {
            throw new IllegalArgumentException("clusterIndex cannot be negative");
        }
        if (n >= this.d.size()) {
            throw new IllegalArgumentException("clusterIndex (" + n + " cannot be >= #clusters (" + this.d.size() + ")");
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(n);
        return new IlvPoint(ilvGrapherCluster.t(), ilvGrapherCluster.u());
    }

    public Vector getClusterNodes(int n) {
        this.i();
        if (n < 0) {
            throw new IllegalArgumentException("clusterIndex cannot be negative");
        }
        if (n >= this.d.size()) {
            throw new IllegalArgumentException("clusterIndex (" + n + " cannot be >= #clusters (" + this.d.size() + ")");
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.d.elementAt(n);
        return ilvGrapherCluster.b();
    }

    public Enumeration getClusterIds(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        return ilvClusterIdCollection == null ? LayoutUtil.GetVoidEnumeration() : ilvClusterIdCollection.getClusterIds();
    }

    public int getClusterIdsCount(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        return ilvClusterIdCollection == null ? 0 : ilvClusterIdCollection.size();
    }

    public int getIndex(Object object, IlvClusterId ilvClusterId) {
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, f);
        if (ilvClusterIdCollection == null || !ilvClusterIdCollection.contains(ilvClusterId)) {
            throw new IllegalArgumentException("node is not contained in the cluster " + ilvClusterId);
        }
        return ilvClusterIdCollection.getIndex(ilvClusterId);
    }

    public final void setClusteringMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported clustering mode: " + n);
        }
        if (n != this.v) {
            this.v = n;
            this.onParameterChanged("ClusteringMode");
        }
    }

    public final int getClusteringMode() {
        return this.isUseDefaultParameters() ? 0 : this.v;
    }

    public final void setMaxNumberOfPermutations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative number of permutaions: " + n);
        }
        if (n != this.w) {
            this.w = n;
            this.onParameterChanged("MaxNumberOfPermutations");
        }
    }

    public final int getMaxNumberOfPermutations() {
        if (this.isUseDefaultParameters()) {
            return 200;
        }
        return this.w;
    }

    private final void a(Object object, IlvClusterId ilvClusterId) {
        int n;
        IlvGrapherCluster ilvGrapherCluster;
        if (object == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (!this.getGraphModel().isNode(object)) {
            throw new IllegalArgumentException("node is not (or no longer) in the attached graph");
        }
        if (this.b == null) {
            this.b = new IlvGraphOfClusters();
        }
        if ((ilvGrapherCluster = this.b.getCluster(ilvClusterId)) == null) {
            ilvGrapherCluster = new IlvGrapherCluster(ilvClusterId);
            ilvGrapherCluster.attach(this.getGraphModel());
            this.b.addNode(ilvGrapherCluster);
        }
        if ((n = this.getIndex(object, ilvClusterId)) >= 0) {
            ilvGrapherCluster.addNode(new IlvAbstractGraphicNode(object, n), this.isStarCenter(object));
        } else {
            ilvGrapherCluster.addNode(new IlvAbstractGraphicNode(object), this.isStarCenter(object));
        }
        this.d(false);
    }

    final void a(IlvClustersConnexion ilvClustersConnexion) {
        this.b.addLink(ilvClustersConnexion);
        this.d(false);
    }

    final IlvGrapherCluster a(IlvClusterId ilvClusterId) {
        this.i();
        return this.b.getCluster(ilvClusterId);
    }

    final IlvGraphOfClusters c() {
        return this.b;
    }

    public final boolean supportsPreserveFixedNodes() {
        return true;
    }

    public boolean supportsLayoutOfConnectedComponents() {
        return true;
    }

    public final boolean supportsLayoutRegion() {
        return true;
    }

    public final boolean supportsLinkConnectionBox() {
        return true;
    }

    public final boolean supportsLinkClipping() {
        return true;
    }

    public final boolean supportsSaveParametersToNamedProperties() {
        return true;
    }

    public synchronized void setAreaMinimizationEnabled(boolean bl) {
        if (bl != this.t) {
            this.t = bl;
            this.onParameterChanged("AreaMinimizationEnabled");
        }
    }

    public boolean isAreaMinimizationEnabled() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.t;
    }

    public void setLinkStyle(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("unsupported style option: " + n);
        }
        if (n != this.u) {
            this.u = n;
            this.onParameterChanged("LinkStyle");
        }
    }

    public int getLinkStyle() {
        if (this.isUseDefaultParameters()) {
            return 1;
        }
        return this.u;
    }

    public synchronized void setOffset(float f) {
        if (f != this.q) {
            this.q = f;
            this.onParameterChanged("Offset");
        }
    }

    public float getOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.q;
    }

    public synchronized void setLevelOffset(float f) {
        if (f != this.r) {
            this.r = f;
            this.onParameterChanged("LevelOffset");
        }
    }

    public float getLevelOffset() {
        if (this.isUseDefaultParameters()) {
            return 0.0f;
        }
        return this.r;
    }

    public synchronized void setDisconnectedGraphOffset(float f) {
        if (f != this.s) {
            this.s = f;
            this.onParameterChanged("DisconnectedGraphOffset");
        }
    }

    public float getDisconnectedGraphOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.s;
    }

    private static final void a(IlvGrapherCluster ilvGrapherCluster, IlvUnsyncVector ilvUnsyncVector) {
        IlvUnsyncVector ilvUnsyncVector2 = ilvGrapherCluster.i();
        if (ilvUnsyncVector2.size() < 1) {
            return;
        }
        int n = ilvUnsyncVector2.size();
        for (int i = 0; i < n; ++i) {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)ilvUnsyncVector2.elementAt(i);
            IlvUnsyncVector ilvUnsyncVector3 = ilvAbstractGraphicNode.a();
            if (ilvUnsyncVector3 == null || ilvUnsyncVector3.size() < 1) continue;
            for (int j = 0; j < ilvUnsyncVector3.size(); ++j) {
                ilvUnsyncVector.addElement(ilvUnsyncVector3.elementAt(j));
            }
        }
    }

    private static final IlvUnsyncVector a(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph) {
        Enumeration enumeration = ilvAbstractGraph.getLinksFrom(ilvGrapherCluster);
        IlvUnsyncVector ilvUnsyncVector = new IlvUnsyncVector(10, 10);
        while (enumeration.hasMoreElements()) {
            IlvClustersConnexion ilvClustersConnexion = (IlvClustersConnexion)enumeration.nextElement();
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvAbstractGraph.getOpposite(ilvClustersConnexion, ilvGrapherCluster);
            if (ilvGrapherCluster2.k()) continue;
            ilvUnsyncVector.addElement(ilvGrapherCluster2);
        }
        return ilvUnsyncVector;
    }

    private static final float a(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph, float f, float f2) {
        IlvUnsyncVector ilvUnsyncVector = IlvCircularLayout.a(ilvGrapherCluster, ilvAbstractGraph);
        return IlvCircularLayout.a(ilvUnsyncVector, f, f2);
    }

    private static final float a(IlvAbstractGraphicNode ilvAbstractGraphicNode, float f, float f2) {
        IlvUnsyncVector ilvUnsyncVector = ilvAbstractGraphicNode.a();
        return ilvUnsyncVector == null || ilvUnsyncVector.size() < 1 ? 0.0f : IlvCircularLayout.a(ilvUnsyncVector, f, f2);
    }

    private static final float a(IlvUnsyncVector ilvUnsyncVector, float f, float f2) {
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return 0.0f;
        }
        float f3 = 0.0f;
        float f4 = IlvCircularLayout.a(f2, f);
        int n = ilvUnsyncVector.size();
        for (int i = 0; i < n; ++i) {
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i);
            if (i > 0) {
                f3 += f4;
            }
            f3 += IlvCircularLayout.a(2.0f * ilvGrapherCluster.m(), f);
        }
        return f3;
    }

    private static final float b(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph) {
        IlvUnsyncVector ilvUnsyncVector = IlvCircularLayout.a(ilvGrapherCluster, ilvAbstractGraph);
        if (ilvUnsyncVector == null || ilvUnsyncVector.size() < 1) {
            return 0.0f;
        }
        float f = 0.0f;
        int n = ilvUnsyncVector.size();
        for (int i = 0; i < n; ++i) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvUnsyncVector.elementAt(i);
            float f2 = ilvGrapherCluster2.m();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    static float a(float f, float f2) {
        if (f2 == 0.0f) {
            throw new IllegalArgumentException("radius cannot be zero (internal error)");
        }
        return 2.0f * f2 * (float)Math.asin(f / (2.0f * f2));
    }

    final IlvArrayStableSort d() {
        return this.aa;
    }

    public int checkAppropriateLink(Object object) {
        if (this.getLinkStyle() == 0) {
            return 0;
        }
        int n = 0;
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        if (ilvGraphModel.isLinkCheckEnabled() && !ilvGraphModel.isReshapeableLink(object, true)) {
            n |= 1;
        }
        if (this.getLinkClipInterface() != null) {
            n |= LayoutUtil.CheckAppropriateLinkConnection(object, ilvGraphModel);
        }
        return n;
    }

    public IlvGraphicVector getMovingNodes() {
        return LayoutUtil.getDefaultMovingNodes(this.getGraphModel());
    }

    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvCircularLayoutGrapherProperty(string, this, bl);
    }

    protected IlvGraphLayoutNodeProperty createLayoutNodeProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvCircularLayoutNodeProperty(string, this, ilvGraphic, bl);
    }

    static String b(int n) {
        switch (n) {
            case 0: {
                return "BY_CLUSTER_IDS";
            }
            case 1: {
                return "BY_SUBGRAPHS";
            }
        }
        throw new IllegalArgumentException("Wrong clustering mode " + n);
    }

    static int a(String string) {
        if (string.equals("BY_CLUSTER_IDS")) {
            return 0;
        }
        if (string.equals("BY_SUBGRAPHS")) {
            return 1;
        }
        throw new IllegalArgumentException("Wrong clustering mode " + string);
    }

    private final class Interval {
        private IlvGrapherCluster a;
        private IlvUnsyncVector b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private float j = -1.0f;
        private double k;
        private float l;
        private int m;
        private float n;
        private boolean o = true;

        private Interval() {
        }

        void a(IlvGrapherCluster ilvGrapherCluster) {
            this.a = ilvGrapherCluster;
        }

        IlvGrapherCluster a() {
            return this.a;
        }

        void a(double d) {
            this.c = d;
        }

        double b() {
            return this.c;
        }

        void a(IlvGraphOfClusters ilvGraphOfClusters, IlvUnsyncVector ilvUnsyncVector) {
            this.b = ilvUnsyncVector;
            this.o = true;
            if (this.b != null) {
                int n = this.b.size();
                for (int i = 0; i < n; ++i) {
                    IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.b.elementAt(i);
                    if (ilvGraphOfClusters.getLinksCount(ilvGrapherCluster) <= 1) continue;
                    this.o = false;
                    break;
                }
            }
        }

        IlvUnsyncVector c() {
            return this.b;
        }

        boolean d() {
            return this.o;
        }

        void a(int n) {
            this.m = n;
        }

        int e() {
            return this.m;
        }

        void a(float f) {
            this.n = f;
        }

        float f() {
            return this.n;
        }

        private void a(float f, float f2, float f3) {
            this.j = f;
            if (this.l == 0.0f) {
                throw new RuntimeException("radius cannot be 0");
            }
            this.k = this.j / this.l;
            this.a(f2, f3);
            this.d = LayoutUtil.CorrectAngle(this.c - this.k * 0.5);
            this.e = LayoutUtil.CorrectAngle(this.c + this.k * 0.5);
            this.f = this.d;
            this.g = this.e;
        }

        float g() {
            return this.j;
        }

        double h() {
            return this.k;
        }

        void b(float f) {
            this.l = f;
        }

        float i() {
            return this.l;
        }

        void b(double d) {
            this.d = d;
        }

        double j() {
            return this.d;
        }

        void c(double d) {
            this.e = d;
        }

        double k() {
            return this.e;
        }

        double l() {
            return this.f;
        }

        double m() {
            return this.g;
        }

        private void a(float f, float f2) {
            if (this.j < 0.0f) {
                throw new RuntimeException("computeMinMax not allowed before setting minCurvLength");
            }
            double d = LayoutUtil.CorrectAngle(Math.min((double)0.8f * Math.abs(Math.acos(f / f2)), 1.2566370614359172));
            this.h = LayoutUtil.CorrectAngle(this.c - d);
            this.i = LayoutUtil.CorrectAngle(this.c + d);
        }

        double n() {
            return this.h;
        }

        double o() {
            return this.i;
        }
    }

    private final class Level {
        private IlvUnsyncVector a = null;

        Level(int n) {
            this.a = new IlvUnsyncVector(n);
        }

        void a() {
            this.a = null;
        }

        void a(int n) {
            this.a.removeAllElements();
            if (n > this.a.capacity()) {
                this.a.ensureCapacity(n);
            }
        }

        void a(float f) {
            Interval interval;
            if (this.a.size() == 0) {
                return;
            }
            if (this.a.size() == 1) {
                int n;
                Interval interval2 = (Interval)this.a.elementAt(0);
                if (!interval2.d() && (n = interval2.e()) > 1) {
                    double d;
                    double d2 = interval2.n();
                    if (d2 <= (d = interval2.o())) {
                        if (d - d2 <= Math.PI) {
                            interval2.b(LayoutUtil.CorrectAngle(d2));
                            interval2.c(LayoutUtil.CorrectAngle(d));
                        } else {
                            interval2.b(LayoutUtil.CorrectAngle(d));
                            interval2.c(LayoutUtil.CorrectAngle(d2));
                        }
                    } else if (d2 - d <= Math.PI) {
                        interval2.b(LayoutUtil.CorrectAngle(d));
                        interval2.c(LayoutUtil.CorrectAngle(d2));
                    } else {
                        interval2.b(LayoutUtil.CorrectAngle(d2));
                        interval2.c(LayoutUtil.CorrectAngle(d));
                    }
                }
                return;
            }
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                interval = (Interval)this.a.elementAt(i);
                interval.a((float)(interval.e() - 1));
            }
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < n; ++j) {
                    interval = (Interval)this.a.elementAt(j);
                    float f2 = interval.f();
                    if (f2 == 0.0f || interval.d()) continue;
                    Interval interval3 = null;
                    Interval interval4 = null;
                    if (j == 0) {
                        interval3 = (Interval)this.a.elementAt(n - 1);
                        interval4 = (Interval)this.a.elementAt(j + 1);
                    } else if (j == n - 1) {
                        interval3 = (Interval)this.a.elementAt(j - 1);
                        interval4 = (Interval)this.a.elementAt(0);
                    } else {
                        interval3 = (Interval)this.a.elementAt(j - 1);
                        interval4 = (Interval)this.a.elementAt(j + 1);
                    }
                    float f3 = interval3.f();
                    float f4 = interval4.f();
                    if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) continue;
                    double d = interval3.k();
                    double d3 = interval4.j();
                    double d4 = interval.j();
                    double d5 = interval.k();
                    double d6 = interval.n();
                    double d7 = interval.o();
                    double d8 = d < d3 ? d : d3;
                    d8 = d4 < d8 ? d4 : d8;
                    d8 = d5 < d8 ? d5 : d8;
                    double d9 = LayoutUtil.GetOrientedDeltaAlpha1(d4 -= d8, d -= d8);
                    double d10 = LayoutUtil.GetOrientedDeltaAlpha1(d3 -= d8, d5 -= d8);
                    double d11 = (double)(f3 + f2) > 1.0E-4 ? d9 * (double)f2 / (double)(f3 + f2) : 0.0;
                    double d12 = (double)(f4 + f2) > 1.0E-4 ? d10 * (double)f2 / (double)(f4 + f2) : 0.0;
                    d4 = LayoutUtil.CorrectAngle(d8 + d4 - d11);
                    d5 = LayoutUtil.CorrectAngle(d8 + d5 + d12);
                    if (d6 <= d7) {
                        if (d4 < d6 || d4 > d7) {
                            d4 = d6;
                        }
                        if (d5 < d6 || d5 > d7) {
                            d5 = d7;
                        }
                    } else {
                        if (d4 < d6 && d4 > d7) {
                            d4 = d6;
                        }
                        if (d5 < d6 && d5 > d7) {
                            d5 = d7;
                        }
                    }
                    interval.b(LayoutUtil.CorrectAngle(d4));
                    interval.c(LayoutUtil.CorrectAngle(d5));
                }
            }
        }

        int b() {
            return this.a.size();
        }

        void a(Interval interval) {
            this.a.addElement(interval);
        }

        Interval b(int n) {
            return (Interval)this.a.elementAt(n);
        }
    }

    private final class SortNodesByIndex
    extends IlvArrayStableSort {
        private SortNodesByIndex() {
        }

        protected final boolean compare(Object object, Object object2) {
            int n = ((IlvAbstractGraphicNode)object).getIndex();
            int n2 = ((IlvAbstractGraphicNode)object2).getIndex();
            if (n < 0) {
                return n2 < 0;
            }
            if (n2 < 0) {
                return true;
            }
            return n <= n2;
        }
    }
}

