/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.dashboard;

import ilog.views.IlvPoint;
import ilog.views.dashboard.FallbackPaletteSymbol;
import ilog.views.dashboard.IlvDashboardContext;
import ilog.views.dashboard.IlvDashboardDOM;
import ilog.views.dashboard.IlvDashboardDiagram;
import ilog.views.dashboard.IlvDashboardException;
import ilog.views.dashboard.IlvDashboardIO;
import ilog.views.dashboard.IlvDashboardSymbol;
import ilog.views.dashboard.IlvDashboardUtilities;
import ilog.views.dashboard.StringReaderInputStream;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.internal.IlvURLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class IlvDashboardReader
extends IlvDashboardIO {
    private IlvPalette[] a;
    private PaletteSymbolInfo[] b;
    private boolean c;
    private boolean d;
    int e = 0;
    int f;

    IlvDashboardReader(IlvDashboardDiagram ilvDashboardDiagram) {
        super(ilvDashboardDiagram);
    }

    void a(URL uRL) throws IOException, IlvDashboardException, ClassNotFoundException {
        InputStream inputStream = uRL.getProtocol().equals("file") ? new FileInputStream(IlvURLUtil.convertFileURLToFilename((URL)uRL)) : uRL.openConnection().getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.a(bufferedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(InputStream inputStream) throws IOException, IlvDashboardException, ClassNotFoundException {
        this.getDiagram().setAdjusting(true);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            String string = objectInputStream.readUTF();
            if (!"ILOGJViewsDashboardFile".equals(string)) {
                throw new IlvDashboardException("Not a valid dashboard file");
            }
            int n = objectInputStream.readInt();
            if (n > 810000) {
                throw new IlvDashboardException("Not supported dashboard file version: " + n);
            }
            this.b(objectInputStream);
            this.c(objectInputStream);
            this.e(objectInputStream);
            this.f(objectInputStream);
            this.i(objectInputStream);
        }
        finally {
            this.getDiagram().setAdjusting(false);
        }
    }

    private void b(ObjectInputStream objectInputStream) throws IOException, IlvDashboardException, ClassNotFoundException {
        IlvDashboardDiagram ilvDashboardDiagram = this.getDiagram();
        this.c = objectInputStream.readBoolean();
        this.d = objectInputStream.readBoolean();
        boolean bl = objectInputStream.readBoolean();
        if (bl != ilvDashboardDiagram.isLinkLayoutEnabled()) {
            ilvDashboardDiagram.setLinkLayoutEnabled(bl);
        }
        objectInputStream.readBoolean();
        objectInputStream.readUTF();
        int n = objectInputStream.readInt();
        ArrayList<Object> arrayList = null;
        if (n > 0) {
            arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(objectInputStream.readObject());
            }
        }
        this.a(arrayList);
    }

    private void c(ObjectInputStream objectInputStream) throws IOException, IlvDashboardException {
        int n = objectInputStream.readInt();
        if (n != 2000) {
            throw new IlvDashboardException("Bad file format: Palettes  keyword expected");
        }
        int n2 = objectInputStream.readInt();
        this.a = new IlvPalette[n2];
        for (int i = 0; i < n2; ++i) {
            this.a[i] = this.d(objectInputStream);
        }
    }

    private IlvPalette d(ObjectInputStream objectInputStream) throws IOException {
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        String string3 = objectInputStream.readUTF();
        IlvDashboardDiagram ilvDashboardDiagram = this.getDiagram();
        IlvDashboardContext ilvDashboardContext = ilvDashboardDiagram.getContext();
        IlvPaletteManager ilvPaletteManager = ilvDashboardContext.getPaletteManager();
        IlvPalette ilvPalette = ilvPaletteManager.getPalette(string);
        if (ilvPalette == null) {
            try {
                ilvPalette = ilvPaletteManager.load(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ilvPalette == null) {
                Logger logger = ilvDashboardContext.getLogger();
                if (!"".equals(string3)) {
                    try {
                        Object object;
                        File file = null;
                        File file2 = new File(new URL(string3).getFile());
                        if (file2.exists()) {
                            file = file2;
                        } else {
                            object = IlvDashboardUtilities.a(ilvDashboardDiagram.getURL());
                            String string4 = file2.getName();
                            File file3 = new File((String)object + string4);
                            file = file3.exists() ? file3 : IlvDashboardDOM.a(ilvDashboardDiagram, (String)object, string4);
                        }
                        if (file != null) {
                            object = new URL("file:" + file);
                            ilvPaletteManager.load((URL)object);
                            logger.log(Level.INFO, "Loaded the palette " + file.getPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ilvPalette = ilvPaletteManager.getPalette(string);
                }
                if (ilvPalette == null) {
                    logger.log(Level.SEVERE, "Could not find the palette " + string2);
                }
            }
        }
        return ilvPalette;
    }

    private void e(ObjectInputStream objectInputStream) throws IOException, IlvDashboardException {
        int n = objectInputStream.readInt();
        if (n != 2500) {
            throw new IlvDashboardException("Palette symbols key expected");
        }
        int n2 = objectInputStream.readInt();
        this.b = new PaletteSymbolInfo[n2];
        for (int i = 0; i < n2; ++i) {
            this.b[i] = this.a(objectInputStream);
        }
    }

    PaletteSymbolInfo a(ObjectInputStream objectInputStream) throws IOException {
        int n;
        int n2;
        PaletteSymbolInfo paletteSymbolInfo = new PaletteSymbolInfo();
        int n3 = objectInputStream.readInt();
        paletteSymbolInfo.b = objectInputStream.readUTF();
        paletteSymbolInfo.c = objectInputStream.readUTF();
        paletteSymbolInfo.d = objectInputStream.readUTF();
        if (this.a[n3] != null) {
            paletteSymbolInfo.a = this.a[n3].getSymbol(paletteSymbolInfo.b, paletteSymbolInfo.c);
        }
        FallbackPaletteSymbol fallbackPaletteSymbol = null;
        if (paletteSymbolInfo.a == null) {
            String string = IlvDashboardReader.b(paletteSymbolInfo.d);
            fallbackPaletteSymbol = new FallbackPaletteSymbol(this.getDiagram().getContext(), string);
            paletteSymbolInfo.a = fallbackPaletteSymbol;
        }
        paletteSymbolInfo.e = n2 = objectInputStream.readInt();
        paletteSymbolInfo.f = new String[n2];
        paletteSymbolInfo.g = new String[n2];
        paletteSymbolInfo.h = new int[n2];
        for (n = 0; n < n2; ++n) {
            paletteSymbolInfo.f[n] = objectInputStream.readUTF();
            paletteSymbolInfo.g[n] = objectInputStream.readUTF();
        }
        if (fallbackPaletteSymbol != null) {
            fallbackPaletteSymbol.a(paletteSymbolInfo.f, paletteSymbolInfo.g);
        }
        for (n = 0; n < n2; ++n) {
            paletteSymbolInfo.h[n] = this.a(paletteSymbolInfo, n);
            if (paletteSymbolInfo.h[n] != -1) continue;
            Logger logger = this.getDiagram().getContext().getLogger();
            logger.log(Level.WARNING, "The saved parameter " + paletteSymbolInfo.f[n] + " is not compatible with the palette symbol " + paletteSymbolInfo.d + ". Previously saved values and mappings are ignored.");
        }
        return paletteSymbolInfo;
    }

    private static String b(String string) {
        int n = string.lastIndexOf(".");
        if (n++ > 0 && n < string.length()) {
            return string.substring(n);
        }
        return string;
    }

    private int a(PaletteSymbolInfo paletteSymbolInfo, int n) {
        int n2;
        if (paletteSymbolInfo.a == null) {
            return -1;
        }
        int n3 = IlvDashboardIO.a(paletteSymbolInfo.a);
        for (n2 = n; n2 < n3; ++n2) {
            if (!IlvDashboardReader.a(paletteSymbolInfo, n, n2)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (!IlvDashboardReader.a(paletteSymbolInfo, n, n2)) continue;
            return n2;
        }
        return -1;
    }

    private static boolean a(PaletteSymbolInfo paletteSymbolInfo, int n, int n2) {
        IlvPaletteSymbolParameter ilvPaletteSymbolParameter = IlvDashboardIO.a(paletteSymbolInfo.a, n2);
        if (ilvPaletteSymbolParameter != null && paletteSymbolInfo.f[n].equals(ilvPaletteSymbolParameter.getID())) {
            String string = ilvPaletteSymbolParameter.getType();
            if (string == null) {
                string = "";
            }
            return paletteSymbolInfo.g[n].equals(string);
        }
        return false;
    }

    private void f(ObjectInputStream objectInputStream) throws IOException, IlvDashboardException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n != 20000) {
            throw new IlvDashboardException("Symbols key expected");
        }
        this.f = objectInputStream.readInt();
        this.g(objectInputStream);
        this.h(objectInputStream);
        IlvCSSEngine ilvCSSEngine = IlvStyleSheetRenderer.getInstance(this.getDiagram().getEngine()).getCSSEngine().getCSSengine();
        Rule[] ruleArray = ilvCSSEngine.getRules(false);
        int n2 = ruleArray.length;
        Rule[] ruleArray2 = new Rule[n2 + this.f];
        System.arraycopy(ruleArray, 0, ruleArray2, 0, n2);
        for (int i = 0; i < this.f; ++i) {
            IlvDashboardSymbol ilvDashboardSymbol = this.getDiagram().a(this.e + i);
            ilvDashboardSymbol.f();
            ruleArray2[n2 + i] = ilvDashboardSymbol.b();
        }
        ilvCSSEngine.setRules(ruleArray2);
    }

    private void g(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.a(objectInputStream, false);
        }
    }

    private IlvDashboardSymbol a(ObjectInputStream objectInputStream, boolean bl) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        int n = objectInputStream.readInt();
        PaletteSymbolInfo paletteSymbolInfo = this.b[n];
        IlvDashboardDiagram ilvDashboardDiagram = this.getDiagram();
        IlvDashboardSymbol ilvDashboardSymbol = new IlvDashboardSymbol(ilvDashboardDiagram, paletteSymbolInfo.a, (Object)null, string);
        if (bl) {
            this.b(ilvDashboardSymbol, objectInputStream);
        } else {
            this.a(ilvDashboardSymbol, objectInputStream);
        }
        ilvDashboardSymbol.setTargetDashboardURL(objectInputStream.readUTF());
        this.a(ilvDashboardSymbol, paletteSymbolInfo, objectInputStream);
        ilvDashboardDiagram.a(ilvDashboardSymbol);
        return ilvDashboardSymbol;
    }

    private void a(IlvDashboardSymbol ilvDashboardSymbol, ObjectInputStream objectInputStream) throws IOException {
        IlvSDMModel ilvSDMModel = ilvDashboardSymbol.getModel();
        Object object = ilvDashboardSymbol.getModelObject();
        ilvSDMModel.setObjectProperty(object, "x", new Float(objectInputStream.readFloat()));
        ilvSDMModel.setObjectProperty(object, "y", new Float(objectInputStream.readFloat()));
        ilvSDMModel.setObjectProperty(object, "width", new Float(objectInputStream.readFloat()));
        ilvSDMModel.setObjectProperty(object, "height", new Float(objectInputStream.readFloat()));
    }

    private void a(IlvDashboardSymbol ilvDashboardSymbol, PaletteSymbolInfo paletteSymbolInfo, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2 = paletteSymbolInfo.e;
        String[] stringArray = new String[n2];
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            String string;
            IlvDashboardIO.ValueIO valueIO;
            stringArray[i] = objectInputStream.readUTF();
            if ("".equals(stringArray[i])) {
                stringArray[i] = null;
            }
            objectArray[i] = (valueIO = this.a(string = paletteSymbolInfo.g[i])) != null ? valueIO.read(objectInputStream) : objectInputStream.readObject();
        }
        IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray = ilvDashboardSymbol.getPaletteSymbol() instanceof FallbackPaletteSymbol ? null : IlvPaletteSymbol.getGraphicParameters();
        int n3 = paletteSymbolInfo.a.getParameterCount();
        int n4 = ilvPaletteSymbolParameterArray == null ? 0 : ilvPaletteSymbolParameterArray.length;
        IlvDashboardSymbol.Parameter[] parameterArray = new IlvDashboardSymbol.Parameter[n3 + n4];
        for (n = 0; n < n3; ++n) {
            parameterArray[n] = new IlvDashboardSymbol.Parameter(paletteSymbolInfo.a.getParameter(n));
            parameterArray[n].c = paletteSymbolInfo.a.getParameter(n).getValue();
        }
        for (n = 0; n < n4; ++n) {
            parameterArray[n3 + n] = new IlvDashboardSymbol.Parameter(ilvPaletteSymbolParameterArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            int n5 = paletteSymbolInfo.h[n];
            if (n5 == -1) continue;
            IlvDashboardSymbol.Parameter parameter = parameterArray[n5];
            if (stringArray[n] != null) {
                parameter.b = stringArray[n];
                ilvDashboardSymbol.getModel().setObjectProperty(ilvDashboardSymbol.getModelObject(), stringArray[n], objectArray[n]);
            }
            parameter.c = objectArray[n];
        }
        ilvDashboardSymbol.a(parameterArray);
    }

    private void h(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.a(objectInputStream, true);
        }
    }

    private void b(IlvDashboardSymbol ilvDashboardSymbol, ObjectInputStream objectInputStream) throws IOException {
        int n;
        IlvPoint ilvPoint;
        boolean bl;
        String string;
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        Object object = ilvDashboardSymbol.getModelObject();
        IlvSDMModel ilvSDMModel = ilvDashboardSymbol.getModel();
        if (ilvDashboardSymbol.isLink()) {
            ilvSDMModel.setFrom(object, this.getDiagram().a(this.e + n2).getModelObject());
            ilvSDMModel.setTo(object, this.getDiagram().a(this.e + n3).getModelObject());
        }
        if (!"".equals(string = objectInputStream.readUTF())) {
            ilvDashboardSymbol.b(string);
        }
        if (!"".equals(string = objectInputStream.readUTF())) {
            ilvDashboardSymbol.c(string);
        }
        if (bl = objectInputStream.readBoolean()) {
            ilvPoint = new IlvPoint();
            ilvPoint.x = objectInputStream.readFloat();
            ilvPoint.y = objectInputStream.readFloat();
            ilvDashboardSymbol.a(ilvPoint);
        }
        if (bl = objectInputStream.readBoolean()) {
            ilvPoint = new IlvPoint();
            ilvPoint.x = objectInputStream.readFloat();
            ilvPoint.y = objectInputStream.readFloat();
            ilvDashboardSymbol.b(ilvPoint);
        }
        if ((n = objectInputStream.readInt()) > 0) {
            IlvPoint[] ilvPointArray = new IlvPoint[n];
            for (int i = 0; i < n; ++i) {
                ilvPointArray[i] = new IlvPoint(objectInputStream.readFloat(), objectInputStream.readFloat());
            }
            ilvDashboardSymbol.setIntermediateLinkPoints(ilvPointArray);
        }
    }

    private void i(ObjectInputStream objectInputStream) throws IOException {
        String string;
        if (this.d && !"".equals(string = objectInputStream.readUTF())) {
            StringReaderInputStream stringReaderInputStream = new StringReaderInputStream(string);
            this.getDiagram().readBackground(stringReaderInputStream);
        }
    }

    private static class PaletteSymbolInfo {
        IlvPaletteSymbol a;
        String b;
        String c;
        String d;
        int e;
        String[] f;
        String[] g;
        int[] h;

        private PaletteSymbolInfo() {
        }
    }
}

