/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.dashboard;

import ilog.views.IlvApplyObject;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.dashboard.IlvDashboardAction;
import ilog.views.dashboard.IlvDashboardDiagram;
import ilog.views.dashboard.IlvDashboardEditor;
import ilog.views.dashboard.IlvDashboardPanel;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.application.IlvDiagrammerToolBar;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.IlvReliefLabel;
import ilog.views.graphic.IlvShadowLabel;
import ilog.views.graphic.IlvShadowRectangle;
import ilog.views.graphic.IlvText;
import ilog.views.interactor.IlvEditLabelInteractor;
import ilog.views.interactor.IlvLabeledObjectFactory;
import ilog.views.interactor.IlvMakeArcInteractor;
import ilog.views.interactor.IlvMakeArrowPolylineInteractor;
import ilog.views.interactor.IlvMakeEllipseInteractor;
import ilog.views.interactor.IlvMakeLineInteractor;
import ilog.views.interactor.IlvMakePolyPointsInteractor;
import ilog.views.interactor.IlvMakePolygonInteractor;
import ilog.views.interactor.IlvMakePolylineInteractor;
import ilog.views.interactor.IlvMakeRectangleInteractor;
import ilog.views.interactor.IlvMakeReliefRectangleInteractor;
import ilog.views.interactor.IlvMakeSplineInteractor;
import ilog.views.sdm.IlvSDMView;
import ilog.views.swing.IlvToolTipManager;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.swing.layout.IlvBetterFlowLayout;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class IlvDashboardBackgroundBar
extends IlvDashboardPanel {
    private IlvDiagrammerToolBar a;
    private PaletteColorSelector b;
    private ResourceBundle c;
    private Cursor d;
    private Font e;
    private Color f;
    private Color g;
    private PropertyChangeSupport h;
    public static final String ID = "BackgroundPalette";
    public Action labelAction;
    public Action textAction;
    public Action lineAction;
    public Action polylineAction;
    public Action arrowPolylineAction;
    public Action polygonAction;
    public Action splineAction;
    public Action closedSplineAction;
    public Action rectangleAction;
    public Action roundRectangleAction;
    public Action reliefRectangleAction;
    public Action reliefLabelAction;
    public Action shadowRectangleAction;
    public Action shadowLabelAction;
    public Action ellipseAction;
    public Action arcAction;
    public Action iconAction;

    public IlvDashboardBackgroundBar(IlvDashboardEditor ilvDashboardEditor) {
        super(ilvDashboardEditor, ID);
        this.setLayout((LayoutManager)new IlvBetterFlowLayout(3, 0, 0));
        this.a();
    }

    public IlvDiagrammerToolBar getToolBar() {
        return this.a;
    }

    private void a() {
        this.h = new PropertyChangeSupport(this);
        this.d = Cursor.getPredefinedCursor(1);
        this.c = IlvResourceUtil.getBundle((String)"backgroundbar", IlvDashboardBackgroundBar.class);
        this.e = this.getFont();
        this.f = this.getForeground();
        this.g = this.getBackground();
        this.b();
        this.a = new IlvDiagrammerToolBar();
        this.a.setActions(this.getPredefinedActions());
        this.b = new PaletteColorSelector();
        this.setPaletteForeground(Color.BLACK);
        this.setPaletteBackground(Color.LIGHT_GRAY);
        this.add(this.a);
        this.add((Component)((Object)this.b));
    }

    public Action[] getPredefinedActions() {
        return new Action[]{this.labelAction, this.textAction, this.lineAction, this.polylineAction, this.arrowPolylineAction, this.polygonAction, this.splineAction, this.closedSplineAction, this.rectangleAction, this.roundRectangleAction, this.reliefRectangleAction, this.reliefLabelAction, this.shadowRectangleAction, this.shadowLabelAction, this.ellipseAction, this.arcAction, this.iconAction};
    }

    public Font getPaletteFont() {
        return this.e;
    }

    public void setPaletteFont(Font font) {
        this.e = font;
    }

    public Color getPaletteForeground() {
        return this.f;
    }

    public void setPaletteForeground(Color color) {
        this.f = color;
        this.b.b();
        Action[] actionArray = this.a.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!(actionArray[i] instanceof InteractorAction)) continue;
            IlvManagerViewInteractor ilvManagerViewInteractor = ((InteractorAction)((Object)actionArray[i])).d();
            if (ilvManagerViewInteractor instanceof IlvMakePolyPointsInteractor) {
                ((IlvMakePolyPointsInteractor)ilvManagerViewInteractor).setForeground(color);
            }
            if (!(ilvManagerViewInteractor instanceof IlvMakeRectangleInteractor)) continue;
            ((IlvMakeRectangleInteractor)ilvManagerViewInteractor).setForeground(color);
        }
    }

    public Color getPaletteBackground() {
        return this.g;
    }

    public void setPaletteBackground(Color color) {
        this.g = color;
        this.b.c();
        Action[] actionArray = this.a.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!(actionArray[i] instanceof InteractorAction)) continue;
            IlvManagerViewInteractor ilvManagerViewInteractor = ((InteractorAction)((Object)actionArray[i])).d();
            if (ilvManagerViewInteractor instanceof IlvMakePolyPointsInteractor) {
                ((IlvMakePolyPointsInteractor)ilvManagerViewInteractor).setBackground(color);
            }
            if (!(ilvManagerViewInteractor instanceof IlvMakeRectangleInteractor)) continue;
            ((IlvMakeRectangleInteractor)ilvManagerViewInteractor).setBackground(color);
        }
    }

    private static Color b(IlvGraphic ilvGraphic, String string) {
        try {
            Method method = ilvGraphic.getClass().getMethod(string, null);
            return (Color)method.invoke((Object)ilvGraphic, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InteractorAction a(IlvDiagrammer ilvDiagrammer) {
        Action[] actionArray = this.a.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!(actionArray[i] instanceof InteractorAction)) continue;
            InteractorAction interactorAction = (InteractorAction)((Object)actionArray[i]);
            try {
                if (!interactorAction.isSelected(ilvDiagrammer)) continue;
                return interactorAction;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void b() {
        this.labelAction = new InteractorAction("GraphicPalette.Action.CreateLabel", (IlvManagerViewInteractor)new EditLabelInteractor(), this.c);
        this.lineAction = new InteractorAction("GraphicPalette.Action.CreateLine", (IlvManagerViewInteractor)new MakeLineInteractor(), this.c);
        this.polylineAction = new InteractorAction("GraphicPalette.Action.CreatePolyline", (IlvManagerViewInteractor)new MakePolylineInteractor(), this.c);
        this.arrowPolylineAction = new InteractorAction("GraphicPalette.Action.CreateArrowPolyline", (IlvManagerViewInteractor)new MakeArrowPolylineInteractor(), this.c);
        this.polygonAction = new InteractorAction("GraphicPalette.Action.CreatePolygon", (IlvManagerViewInteractor)new MakePolygonInteractor(), this.c);
        this.splineAction = new InteractorAction("GraphicPalette.Action.CreateSpline", (IlvManagerViewInteractor)new MakeSplineInteractor(), this.c);
        this.closedSplineAction = new InteractorAction("GraphicPalette.Action.CreateClosedSpline", (IlvManagerViewInteractor)new MakeClosedSplineInteractor(), this.c);
        this.rectangleAction = new InteractorAction("GraphicPalette.Action.CreateRectangle", (IlvManagerViewInteractor)new MakeRectangleInteractor(), this.c);
        this.roundRectangleAction = new InteractorAction("GraphicPalette.Action.CreateRoundRectangle", (IlvManagerViewInteractor)new MakeRoundRectangleInteractor(), this.c);
        this.reliefRectangleAction = new InteractorAction("GraphicPalette.Action.CreateReliefRectangle", (IlvManagerViewInteractor)new MakeReliefRectangleInteractor(), this.c);
        EditLabelInteractor editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabeledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvText ilvText = new IlvText(ilvPoint, string);
                IlvDashboardBackgroundBar.this.a((IlvGraphic)ilvText);
                return ilvText;
            }
        });
        this.textAction = new InteractorAction("GraphicPalette.Action.CreateText", (IlvManagerViewInteractor)editLabelInteractor, this.c);
        editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabeledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvReliefLabel ilvReliefLabel = new IlvReliefLabel(ilvPoint, string, 2);
                IlvDashboardBackgroundBar.this.a((IlvGraphic)ilvReliefLabel);
                return ilvReliefLabel;
            }
        });
        this.reliefLabelAction = new InteractorAction("GraphicPalette.Action.CreateReliefLabel", (IlvManagerViewInteractor)editLabelInteractor, this.c);
        this.shadowRectangleAction = new InteractorAction("GraphicPalette.Action.CreateShadowRectangle", (IlvManagerViewInteractor)new MakeShadowRectangleInteractor(), this.c);
        editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabeledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvShadowLabel ilvShadowLabel = new IlvShadowLabel(ilvPoint, string, 2.0f, 6.0f, 6.0f, 10);
                IlvDashboardBackgroundBar.this.a((IlvGraphic)ilvShadowLabel);
                return ilvShadowLabel;
            }
        });
        this.shadowLabelAction = new InteractorAction("GraphicPalette.Action.CreateShadowLabel", (IlvManagerViewInteractor)editLabelInteractor, this.c);
        this.ellipseAction = new InteractorAction("GraphicPalette.Action.CreateEllipse", (IlvManagerViewInteractor)new MakeEllipseInteractor(), this.c);
        this.arcAction = new InteractorAction("GraphicPalette.Action.CreateArc", (IlvManagerViewInteractor)new MakeArcInteractor(), this.c);
        this.iconAction = new InteractorAction("GraphicPalette.Action.CreateIcon", new MakeIconInteractor(this, this.c), this.c);
    }

    private void a(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvFontInterface) {
            ((IlvFontInterface)ilvGraphic).setFont(this.e);
        }
        ilvGraphic.setForeground(this.f);
        ilvGraphic.setBackground(this.g);
    }

    public Cursor getInteractorCursor() {
        return this.d;
    }

    public void setInteractorCursor(Cursor cursor) {
        this.d = cursor;
    }

    private void a(IlvManager ilvManager, IlvGraphic ilvGraphic) {
        IlvDashboardDiagram ilvDashboardDiagram = this.getDiagram();
        if (ilvDashboardDiagram != null) {
            ilvDashboardDiagram.addUndoableEdit(new AddBackgroundEdit(ilvManager, ilvGraphic));
        }
    }

    private IlvRect a(IlvRect ilvRect) {
        if (ilvRect.width < 4.0f && ilvRect.height < 4.0f) {
            return new IlvRect(ilvRect.x, ilvRect.y, 100.0f, 100.0f);
        }
        return ilvRect;
    }

    public void addObjectPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.h.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeObjectPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.h.removePropertyChangeListener(propertyChangeListener);
    }

    private class SetForegroundEdit
    extends SetColorEdit {
        SetForegroundEdit(Color color) {
            super(color);
        }

        Color a(IlvGraphic ilvGraphic) {
            return IlvDashboardBackgroundBar.b(ilvGraphic, "getForeground");
        }

        void a(IlvGraphic ilvGraphic, Color color) {
            ilvGraphic.setForeground(color);
        }
    }

    private class SetBackgroundEdit
    extends SetColorEdit {
        SetBackgroundEdit(Color color) {
            super(color);
        }

        Color a(IlvGraphic ilvGraphic) {
            return IlvDashboardBackgroundBar.b(ilvGraphic, "getBackground");
        }

        void a(IlvGraphic ilvGraphic, Color color) {
            ilvGraphic.setBackground(color);
        }
    }

    private abstract class SetColorEdit
    extends AbstractUndoableEdit
    implements IlvApplyObject {
        private IlvGraphicVector a;
        private Color[] b;
        private Color c;

        abstract void a(IlvGraphic var1, Color var2);

        abstract Color a(IlvGraphic var1);

        protected SetColorEdit(Color color) {
            this.c = color;
            this.a = IlvDashboardBackgroundBar.this.getDiagram().c();
            int n = this.a.size();
            this.b = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = this.a(this.a.elementAt(i));
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.a.size() > 0) {
                IlvGrapher ilvGrapher = IlvDashboardBackgroundBar.this.getDiagram().getEngine().getGrapher();
                ilvGrapher.applyToObjects(this.a, (IlvApplyObject)this, (Object)this.c, true);
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            int n = this.a.size();
            IlvGrapher ilvGrapher = IlvDashboardBackgroundBar.this.getDiagram().getEngine().getGrapher();
            for (int i = 0; i < n; ++i) {
                ilvGrapher.applyToObject(this.a.elementAt(i), (IlvApplyObject)this, (Object)this.b[i], true);
            }
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            Color color = (Color)object;
            this.a(ilvGraphic, color);
        }
    }

    private class PaletteColorSelector
    extends IlvManagerView {
        IlvRectangle a;
        IlvRectangle b;
        private IlvRectangle c;
        private String d;
        private String e;

        PaletteColorSelector() {
            IlvToolTipManager.registerView((IlvManagerView)this);
            ResourceBundle resourceBundle = IlvResourceUtil.getBundle((String)"backgroundbar", IlvDashboardBackgroundBar.class);
            this.d = resourceBundle.getString("GraphicPalette.ColorSelector.ChooseForeground");
            this.e = resourceBundle.getString("GraphicPalette.ColorSelector.ChooseBackground");
            this.a = new ColorRectangle(){

                void a(Color color) {
                    IlvDashboardBackgroundBar.this.setPaletteForeground(color);
                    if (IlvDashboardBackgroundBar.this.getDiagram().isEditingAllowed()) {
                        PaletteColorSelector.this.b(color);
                    }
                }

                Color a() {
                    return IlvDashboardBackgroundBar.this.getPaletteForeground();
                }

                String b() {
                    return PaletteColorSelector.this.d;
                }
            };
            this.b = new ColorRectangle(){

                void a(Color color) {
                    IlvDashboardBackgroundBar.this.setPaletteBackground(color);
                    if (IlvDashboardBackgroundBar.this.getDiagram().isEditingAllowed()) {
                        PaletteColorSelector.this.a(color);
                    }
                }

                Color a() {
                    return IlvDashboardBackgroundBar.this.getPaletteBackground();
                }

                String b() {
                    return PaletteColorSelector.this.e;
                }
            };
            ((Component)((Object)this)).addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    PaletteColorSelector.this.a();
                }
            });
            IlvManager ilvManager = this.getManager();
            ilvManager.addObject((IlvGraphic)this.b, false);
            ilvManager.addObject((IlvGraphic)this.a, false);
            ((Component)((Object)this)).setSize(40, 22);
        }

        void a() {
            int n = ((Component)((Object)this)).getWidth() / 3 - 1;
            int n2 = ((Component)((Object)this)).getHeight() / 3 - 1;
            int n3 = n * 2;
            int n4 = n2 * 2;
            this.a.resize((float)n3, (float)n4);
            this.b.resize((float)n3, (float)n4);
            this.b.move((float)n, (float)n2);
        }

        void b() {
            this.a.setBackground(IlvDashboardBackgroundBar.this.f);
        }

        void c() {
            this.b.setBackground(IlvDashboardBackgroundBar.this.g);
        }

        private void a(Color color) {
            IlvGraphicVector ilvGraphicVector = IlvDashboardBackgroundBar.this.getDiagram().c();
            if (ilvGraphicVector.size() > 0) {
                final ArrayList arrayList = new ArrayList();
                SetBackgroundEdit setBackgroundEdit = new SetBackgroundEdit(color);
                IlvGrapher ilvGrapher = IlvDashboardBackgroundBar.this.getDiagram().getEngine().getGrapher();
                ilvGrapher.applyToObjects(ilvGraphicVector, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        Color color = (Color)object;
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(ilvGraphic, "background", IlvDashboardBackgroundBar.b(ilvGraphic, "getBackground"), color);
                        arrayList.add(propertyChangeEvent);
                        ilvGraphic.setBackground(color);
                    }
                }, (Object)color, true);
                IlvDashboardBackgroundBar.this.getDiagram().addUndoableEdit(setBackgroundEdit);
                for (int i = 0; i < arrayList.size(); ++i) {
                    IlvDashboardBackgroundBar.this.h.firePropertyChange((PropertyChangeEvent)arrayList.get(i));
                }
            }
        }

        private void b(Color color) {
            IlvGraphicVector ilvGraphicVector = IlvDashboardBackgroundBar.this.getDiagram().c();
            if (ilvGraphicVector.size() > 0) {
                final ArrayList arrayList = new ArrayList();
                SetForegroundEdit setForegroundEdit = new SetForegroundEdit(color);
                IlvGrapher ilvGrapher = IlvDashboardBackgroundBar.this.getDiagram().getEngine().getGrapher();
                ilvGrapher.applyToObjects(ilvGraphicVector, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        Color color = (Color)object;
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(ilvGraphic, "foreground", IlvDashboardBackgroundBar.b(ilvGraphic, "getForeground"), color);
                        arrayList.add(propertyChangeEvent);
                        ilvGraphic.setForeground(color);
                    }
                }, (Object)color, true);
                IlvDashboardBackgroundBar.this.getDiagram().addUndoableEdit(setForegroundEdit);
                for (int i = 0; i < arrayList.size(); ++i) {
                    IlvDashboardBackgroundBar.this.h.firePropertyChange((PropertyChangeEvent)arrayList.get(i));
                }
            }
        }

        private abstract class ColorRectangle
        extends IlvRectangle {
            ColorRectangle() {
                this.setFillOn(true);
                this.setObjectInteractor(new IlvObjectInteractor(){

                    public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
                        if (aWTEvent.getID() == 502) {
                            Color color = JColorChooser.showDialog((Component)((Object)PaletteColorSelector.this), ColorRectangle.this.b(), ColorRectangle.this.a());
                            if (color != null) {
                                ColorRectangle.this.a(color);
                            }
                            return true;
                        }
                        if (aWTEvent.getID() == 503) {
                            if (PaletteColorSelector.this.c != ColorRectangle.this) {
                                IlvDashboardBackgroundBar.this.getEditor().showStatus(ColorRectangle.this.b());
                                PaletteColorSelector.this.c = ColorRectangle.this;
                            }
                            return true;
                        }
                        return false;
                    }
                });
            }

            public String getToolTipText() {
                return this.b();
            }

            abstract void a(Color var1);

            abstract Color a();

            abstract String b();
        }
    }

    private class MakeReliefRectangleInteractor
    extends IlvMakeReliefRectangleInteractor {
        MakeReliefRectangleInteractor() {
            this.setCursor(IlvDashboardBackgroundBar.this.d);
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            IlvRect ilvRect = ilvGraphic.boundingBox();
            IlvRect ilvRect2 = IlvDashboardBackgroundBar.this.a(ilvRect);
            if (ilvRect2 != ilvRect) {
                ilvGraphic.moveResize(ilvRect2);
            }
            super.addObject(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakePolygonInteractor
    extends IlvMakePolygonInteractor {
        private MakePolygonInteractor() {
        }

        public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
                for (int i = 1; i < ilvPointArray.length; ++i) {
                    generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
                }
                generalPath.closePath();
                generalPath.setWindingRule(0);
                IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)generalPath);
                return ilvGeneralPath;
            }
            return super.createObject(ilvPointArray);
        }

        protected void addPolyPoints(IlvGraphic ilvGraphic) {
            super.addPolyPoints(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeArrowPolylineInteractor
    extends IlvMakeArrowPolylineInteractor {
        private MakeArrowPolylineInteractor() {
        }

        protected void addPolyPoints(IlvGraphic ilvGraphic) {
            super.addPolyPoints(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakePolylineInteractor
    extends IlvMakePolylineInteractor {
        private MakePolylineInteractor() {
        }

        public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
                for (int i = 1; i < ilvPointArray.length; ++i) {
                    generalPath.lineTo(ilvPointArray[i].x, ilvPointArray[i].y);
                }
                IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)generalPath);
                ilvGeneralPath.setFillOn(false);
                return ilvGeneralPath;
            }
            return super.createObject(ilvPointArray);
        }

        protected void addPolyPoints(IlvGraphic ilvGraphic) {
            super.addPolyPoints(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeLineInteractor
    extends IlvMakeLineInteractor {
        private MakeLineInteractor() {
        }

        public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                IlvGeneralPath ilvGeneralPath = null;
                if (ilvPointArray.length < 2) {
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
                    ilvGeneralPath = new IlvGeneralPath((Shape)generalPath);
                } else {
                    ilvGeneralPath = new IlvGeneralPath((Shape)new Line2D.Float(ilvPointArray[0].x, ilvPointArray[0].y, ilvPointArray[1].x, ilvPointArray[1].y));
                }
                ilvGeneralPath.setFillOn(false);
                ilvGeneralPath.setStrokeOn(true);
                return ilvGeneralPath;
            }
            return super.createObject(ilvPointArray);
        }

        protected void addPolyPoints(IlvGraphic ilvGraphic) {
            super.addPolyPoints(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeClosedSplineInteractor
    extends IlvMakeSplineInteractor {
        private IlvPoint[] a = null;

        MakeClosedSplineInteractor() {
            this.setClosed(true);
        }

        public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                return this.a(ilvPointArray, this.getSmoothness());
            }
            return super.createObject(ilvPointArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IlvGeneralPath a(IlvPoint[] ilvPointArray, float f) {
            int n = ilvPointArray.length;
            GeneralPath generalPath = new GeneralPath();
            MakeClosedSplineInteractor makeClosedSplineInteractor = this;
            synchronized (makeClosedSplineInteractor) {
                if (n > 2 && f != -1.0f) {
                    this.a = IlvGraphicUtil.GetSmoothSpline((IlvPoint[])ilvPointArray, (int)n, (float)f, (boolean)false, (IlvPoint[])this.a);
                    n = (n - 2) * 3 + 1;
                    ilvPointArray = this.a;
                }
                generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
                int n2 = 3 * ((n - 1) / 3);
                int n3 = 1;
                while (n3 < n2) {
                    generalPath.curveTo(ilvPointArray[n3].x, ilvPointArray[n3++].y, ilvPointArray[n3].x, ilvPointArray[n3++].y, ilvPointArray[n3].x, ilvPointArray[n3++].y);
                }
                if (n - ++n2 == 2) {
                    generalPath.curveTo(ilvPointArray[n2].x, ilvPointArray[n2++].y, ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[0].x, ilvPointArray[0].y);
                } else if (n - n2 == 1) {
                    generalPath.curveTo(ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[0].x, ilvPointArray[0].y);
                } else {
                    generalPath.closePath();
                }
            }
            makeClosedSplineInteractor = new IlvGeneralPath((Shape)generalPath);
            return makeClosedSplineInteractor;
        }

        protected void addPolyPoints(IlvGraphic ilvGraphic) {
            super.addPolyPoints(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeSplineInteractor
    extends IlvMakeSplineInteractor {
        private IlvPoint[] a = null;

        private MakeSplineInteractor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IlvGraphic createObject(IlvPoint[] ilvPointArray) {
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                int n = ilvPointArray.length;
                GeneralPath generalPath = new GeneralPath();
                MakeSplineInteractor makeSplineInteractor = this;
                synchronized (makeSplineInteractor) {
                    if (n > 2 && this.getSmoothness() != -1.0f) {
                        this.a = IlvGraphicUtil.GetSmoothSpline((IlvPoint[])ilvPointArray, (int)n, (float)this.getSmoothness(), (boolean)false, (IlvPoint[])this.a);
                        n = (n - 2) * 3 + 1;
                        ilvPointArray = this.a;
                    }
                    generalPath.moveTo(ilvPointArray[0].x, ilvPointArray[0].y);
                    int n2 = 3 * ((n - 1) / 3);
                    int n3 = 1;
                    while (n3 < n2) {
                        generalPath.curveTo(ilvPointArray[n3].x, ilvPointArray[n3++].y, ilvPointArray[n3].x, ilvPointArray[n3++].y, ilvPointArray[n3].x, ilvPointArray[n3++].y);
                    }
                    if (n - ++n2 == 2) {
                        generalPath.curveTo(ilvPointArray[n2].x, ilvPointArray[n2].y, ilvPointArray[n2].x, ilvPointArray[n2++].y, ilvPointArray[n2].x, ilvPointArray[n2].y);
                    } else if (n - n2 == 1) {
                        generalPath.lineTo(ilvPointArray[n2].x, ilvPointArray[n2].y);
                    }
                }
                makeSplineInteractor = new IlvGeneralPath((Shape)generalPath);
                makeSplineInteractor.setFillOn(false);
                return makeSplineInteractor;
            }
            return super.createObject(ilvPointArray);
        }

        protected void addPolyPoints(IlvGraphic ilvGraphic) {
            super.addPolyPoints(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeArcInteractor
    extends IlvMakeArcInteractor {
        MakeArcInteractor() {
            this.setCursor(IlvDashboardBackgroundBar.this.d);
        }

        public IlvGraphic createObject(IlvRect ilvRect) {
            IlvRect ilvRect2 = IlvDashboardBackgroundBar.this.a(ilvRect);
            Object object = IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled() ? new IlvGeneralPath((Shape)new Arc2D.Float(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height, this.getStartAngle(), this.getDeltaAngle(), this.isFillOn() ? 2 : 0)) : super.createObject(ilvRect2);
            object.moveResize(ilvRect2);
            return object;
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            super.addObject(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeEllipseInteractor
    extends IlvMakeEllipseInteractor {
        MakeEllipseInteractor() {
            this.setCursor(IlvDashboardBackgroundBar.this.d);
        }

        public IlvGraphic createObject(IlvRect ilvRect) {
            IlvRect ilvRect2 = IlvDashboardBackgroundBar.this.a(ilvRect);
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                return new IlvGeneralPath((Shape)new Ellipse2D.Float(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height));
            }
            return super.createObject(ilvRect2);
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            super.addObject(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    private class MakeShadowRectangleInteractor
    extends MakeRectangleInteractor {
        private MakeShadowRectangleInteractor() {
        }

        protected IlvGraphic makeObject(IlvRect ilvRect) {
            IlvRect ilvRect2 = IlvDashboardBackgroundBar.this.a(ilvRect);
            return new IlvShadowRectangle(ilvRect2);
        }
    }

    private class MakeRoundRectangleInteractor
    extends MakeRectangleInteractor {
        private MakeRoundRectangleInteractor() {
        }

        protected IlvGraphic makeObject(IlvRect ilvRect) {
            IlvRect ilvRect2 = IlvDashboardBackgroundBar.this.a(ilvRect);
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)new RoundRectangle2D.Float(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height, 30.0f, 30.0f));
                return ilvGeneralPath;
            }
            IlvRectangle ilvRectangle = (IlvRectangle)super.makeObject(ilvRect2);
            ilvRectangle.setRadius(15);
            return ilvRectangle;
        }
    }

    private class MakeRectangleInteractor
    extends IlvMakeRectangleInteractor {
        MakeRectangleInteractor() {
            this.setCursor(IlvDashboardBackgroundBar.this.d);
        }

        protected IlvGraphic makeObject(IlvRect ilvRect) {
            IlvRect ilvRect2 = IlvDashboardBackgroundBar.this.a(ilvRect);
            if (IlvDashboardBackgroundBar.this.getEditor().isGeneralPathEnabled()) {
                IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)new Rectangle2D.Float(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height));
                return ilvGeneralPath;
            }
            return super.makeObject(ilvRect2);
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            super.addObject(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    class AddBackgroundEdit
    extends AbstractUndoableEdit {
        private IlvManager a;
        private IlvGraphic b;

        AddBackgroundEdit(IlvManager ilvManager, IlvGraphic ilvGraphic) {
            this.a = ilvManager;
            this.b = ilvGraphic;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.a.isManaged(this.b)) {
                this.a.removeObject(this.b, true);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.a.initReDraws();
            this.a.addObject(this.b, true);
            this.a.deSelectAll(true);
            this.a.setSelected(this.b, true, true);
            this.a.reDrawViews();
        }
    }

    private class EditLabelInteractor
    extends IlvEditLabelInteractor {
        private Cursor a;
        private IlvPoint b;

        EditLabelInteractor() {
        }

        protected void attach(IlvManagerView ilvManagerView) {
            super.attach(ilvManagerView);
            this.a = ilvManagerView.getCursor();
            this.b = null;
            ilvManagerView.setCursor(IlvDashboardBackgroundBar.this.getInteractorCursor());
        }

        protected void detach() {
            this.getManagerView().setCursor(this.a);
            super.detach();
        }

        protected Component createEditComponent(boolean bl, boolean bl2, ActionListener actionListener, FocusListener focusListener) {
            Component component = super.createEditComponent(bl, bl2, actionListener, focusListener);
            component.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        EditLabelInteractor.this.getManagerView().popInteractor();
                    }
                }
            });
            return component;
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            ilvGraphic.setForeground(IlvDashboardBackgroundBar.this.getPaletteForeground());
            this.a(ilvGraphic);
            super.addObject(ilvGraphic);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }

        private void a(IlvGraphic ilvGraphic) {
            if (this.b != null) {
                IlvTransformer ilvTransformer = this.getTransformer();
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    ilvTransformer.inverse(this.b);
                }
                ilvGraphic.move(this.b);
            }
        }

        protected void setObjectLabel(IlvGraphic ilvGraphic, String string) {
            if (ilvGraphic instanceof IlvLabelInterface) {
                String string2 = ((IlvLabelInterface)ilvGraphic).getLabel();
                super.setObjectLabel(ilvGraphic, string);
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(ilvGraphic, "label", string2, string);
                IlvDashboardBackgroundBar.this.h.firePropertyChange(propertyChangeEvent);
            }
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.b = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
            }
            super.processMouseEvent(mouseEvent);
        }
    }

    private class MakeIconInteractor
    extends IlvManagerViewInteractor {
        private Component a;
        private ResourceBundle b;
        private JFileChooser c;
        private Cursor d;
        private Cursor e = Cursor.getPredefinedCursor(1);
        private FileFilter f;
        private boolean g = false;

        MakeIconInteractor(Component component, ResourceBundle resourceBundle) {
            this.a = component;
            this.b = resourceBundle;
            this.e = Cursor.getPredefinedCursor(1);
            this.f = new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png");
                }

                public String getDescription() {
                    return ".gif, .jpg, .png";
                }
            };
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 500) {
                JFileChooser jFileChooser = this.b();
                int n = jFileChooser.showOpenDialog(this.a);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    String string = null;
                    if (file != null) {
                        string = file.toString();
                    }
                    if (string != null && string.length() > 0) {
                        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                        IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
                        IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
                        if (ilvTransformer != null) {
                            ilvTransformer.inverse(ilvPoint);
                        }
                        string = "file:" + string;
                        try {
                            URL uRL = new URL(string);
                            MediaTracker mediaTracker = new MediaTracker((Component)this.getManagerView());
                            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                            mediaTracker.addImage(image, 0);
                            try {
                                mediaTracker.waitForAll();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int n2 = image.getWidth((ImageObserver)this.getManagerView());
                            int n3 = image.getHeight((ImageObserver)this.getManagerView());
                            if (n2 > 0 && n3 > 0) {
                                IlvRect ilvRect = new IlvRect(ilvPoint.x - (float)(n2 / 2), ilvPoint.y - (float)(n3 / 2), (float)n2, (float)n3);
                                IlvIcon ilvIcon = new IlvIcon(uRL, ilvRect);
                                this.addObject((IlvGraphic)ilvIcon);
                            } else {
                                String string2 = this.b.getString("GraphicPalette.MakeIconInteractor.CouldNotReadMsg");
                                String string3 = this.b.getString("GraphicPalette.MakeIconInteractor.CouldNotReadTitle");
                                JOptionPane.showMessageDialog(this.a, string2, string3, 0);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (!this.g) {
                    this.getManagerView().popInteractor();
                }
            }
        }

        protected void attach(IlvManagerView ilvManagerView) {
            super.attach(ilvManagerView);
            this.d = ilvManagerView.getCursor();
            ilvManagerView.setCursor(this.e);
        }

        protected void detach() {
            this.getManagerView().setCursor(this.d);
            this.d = null;
            super.detach();
        }

        private JFileChooser b() {
            if (this.c == null) {
                this.c = new JFileChooser();
                this.c.setDialogType(0);
                this.c.setDialogTitle(this.b.getString("GraphicPalette.IconFileChooser.Title"));
                this.c.setFileFilter(this.f);
            }
            return this.c;
        }

        public void setPermanent(boolean bl) {
            this.g = bl;
        }

        public boolean isPermanent() {
            return this.g;
        }

        Cursor a() {
            return this.e;
        }

        void a(Cursor cursor) {
            this.e = cursor;
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            this.getManager().addObject(ilvGraphic, true);
            IlvDashboardBackgroundBar.this.a(this.getManager(), ilvGraphic);
        }
    }

    class InteractorAction
    extends IlvDashboardAction {
        private IlvManagerViewInteractor a;

        InteractorAction(String string, IlvManagerViewInteractor ilvManagerViewInteractor, ResourceBundle resourceBundle) {
            super(string, resourceBundle);
            this.a = ilvManagerViewInteractor;
        }

        public boolean isSelectable() {
            return ((AbstractAction)((Object)this)).isEnabled();
        }

        protected boolean isEnabled(IlvDiagrammer ilvDiagrammer) throws Exception {
            return ilvDiagrammer != null && ilvDiagrammer.isEditingAllowed();
        }

        public void perform(ActionEvent actionEvent, IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer != null) {
                IlvSDMView ilvSDMView = ilvDiagrammer.getView();
                boolean bl = this.isSelected((Component)((Object)ilvSDMView));
                if (bl) {
                    ilvSDMView.popInteractor();
                } else {
                    InteractorAction interactorAction = IlvDashboardBackgroundBar.this.a(ilvDiagrammer);
                    if (interactorAction != this && interactorAction != null) {
                        ilvSDMView.popInteractor();
                    }
                    ilvSDMView.pushInteractor(this.a);
                }
                this.setSelected(!bl);
                if (!GraphicsEnvironment.isHeadless()) {
                    ilvSDMView.requestFocus();
                }
            }
        }

        protected boolean isSelected(IlvDiagrammer ilvDiagrammer) throws Exception {
            if (ilvDiagrammer != null) {
                return ilvDiagrammer.getView().getInteractor() == this.a;
            }
            return false;
        }

        IlvManagerViewInteractor d() {
            return this.a;
        }

        void a(IlvManagerViewInteractor ilvManagerViewInteractor) {
            this.a = ilvManagerViewInteractor;
        }
    }
}

