/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.animation;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvTransformer;
import ilog.views.animation.IlvGraphicAnimator;
import ilog.views.animation.IlvLinkImageAnimator;
import ilog.views.animation.IlvObjectAnimator;
import ilog.views.animation.IlvOptimizedAnimatedGraphic;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.PixelGrabber;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class IlvManagerAnimator {
    private IlvManager a;
    private Thread b;
    private int c;
    private int d;
    private boolean e = false;
    private boolean f;
    private boolean g;
    private boolean h;
    private AnimStepApply i = new AnimStepApply(this);
    private ViewData j;
    private static final String k = "__ilvAnimatorProperty";
    private ImageConsumer l;
    private IlvManagerView m;
    private int n;
    private int o;

    public IlvManagerAnimator(IlvManager ilvManager) {
        this(ilvManager, true);
    }

    public IlvManagerAnimator(IlvManager ilvManager, boolean bl) {
        this.h = bl;
        this.attach(ilvManager);
        this.c = 20;
        this.d = 50;
    }

    public synchronized void attach(IlvManager ilvManager) {
        if (this.a != null) {
            this.detach();
        }
        this.a = ilvManager;
        if (ilvManager == null) {
            return;
        }
        this.a(ilvManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvManager ilvManager) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.a((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                this.a(enumeration.nextElement());
            }
        }
    }

    public synchronized void detach() {
        if (this.a != null) {
            this.b(this.a);
            if (this.b != null && this.b.isAlive()) {
                throw new RuntimeException("Animation thread is still running on detach");
            }
            this.b = null;
            this.j = null;
            this.a = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(IlvManager ilvManager) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.b((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                ViewData viewData = this.a(enumeration.nextElement());
                viewData.a.setDoubleBuffering(viewData.b);
                viewData.a.setDoubleBufferFrozen(viewData.c);
            }
            ilvGraphicEnumeration = ilvManager.getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.b(ilvGraphicEnumeration.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        IlvManager ilvManager = this.a;
        synchronized (ilvManager) {
            this.e = false;
            Enumeration enumeration = this.a.getViews();
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                if (!(ilvManagerView.getParent() instanceof JComponent)) continue;
                this.e = true;
            }
        }
    }

    private void a(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null) {
            IlvObjectAnimator ilvObjectAnimator = this.createObjectAnimator(ilvGraphic);
            ilvGraphic.setProperty(k, (Object)ilvObjectAnimator);
        }
    }

    private void b(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null) {
            ilvGraphic.setProperty(k, null);
        }
    }

    public IlvObjectAnimator getObjectAnimator(IlvGraphic ilvGraphic, boolean bl) {
        Object object = ilvGraphic.getProperty(k);
        if (object != null) {
            return (IlvObjectAnimator)object;
        }
        if (!bl) {
            return null;
        }
        this.a(ilvGraphic);
        return (IlvObjectAnimator)ilvGraphic.getProperty(k);
    }

    protected IlvObjectAnimator createObjectAnimator(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvLinkImage) {
            return this.createLinkImageAnimator((IlvLinkImage)ilvGraphic);
        }
        return this.createGraphicAnimator(ilvGraphic);
    }

    protected IlvObjectAnimator createGraphicAnimator(IlvGraphic ilvGraphic) {
        IlvGraphicAnimator ilvGraphicAnimator = new IlvGraphicAnimator(ilvGraphic);
        boolean bl = ilvGraphic instanceof IlvManager ? false : this.isResizingObjects();
        ilvGraphicAnimator.setResizeAllowed(bl);
        return ilvGraphicAnimator;
    }

    protected IlvObjectAnimator createLinkImageAnimator(IlvLinkImage ilvLinkImage) {
        return new IlvLinkImageAnimator(ilvLinkImage);
    }

    public synchronized IlvManager getManager() {
        return this.a;
    }

    public synchronized void setAnimationRate(int n) {
        this.c = n;
    }

    public synchronized int getAnimationRate() {
        return this.c;
    }

    public synchronized void setAnimationDelay(int n) {
        this.d = n;
    }

    public synchronized int getAnimationDelay() {
        return this.d;
    }

    public void setResizingObjects(boolean bl) {
        this.h = bl;
    }

    public boolean isResizingObjects() {
        return this.h;
    }

    public boolean isMultiThreading() {
        return this.b != null;
    }

    public Thread getAnimationThread() {
        return this.b;
    }

    public synchronized void start(Runnable runnable) {
        this.start(new Thread(runnable));
    }

    public synchronized void start(Thread thread) {
        if (thread == null) {
            return;
        }
        this.b = thread;
        this.g = true;
        this.b.start();
    }

    public boolean isRunning() {
        return this.g;
    }

    private void a(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void recordState() {
        if (this.a == null) {
            return;
        }
        this.a();
        this.c(this.a);
        if (IlvSwingUtil.isDispatchThread()) {
            this.a(this.a, true);
        } else {
            try {
                final IlvManager ilvManager = this.a;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        IlvManagerAnimator.this.a(ilvManager, true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(IlvManager ilvManager) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.c((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                ViewData viewData = this.a(enumeration.nextElement());
                viewData.e = viewData.a.getTransformer();
            }
            ilvGraphicEnumeration = ilvManager.getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                IlvObjectAnimator ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, true);
                ilvObjectAnimator.recordState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvManager ilvManager, boolean bl) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.a((IlvManager)ilvGraphicEnumeration.nextElement(), bl);
            }
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                ViewData viewData = this.a(enumeration.nextElement());
                if (bl) {
                    viewData.a.setDoubleBuffering(true);
                    viewData.a.setDoubleBufferFrozen(true);
                    continue;
                }
                viewData.a.setDoubleBufferFrozen(viewData.c);
            }
        }
    }

    public synchronized void unrecordState() {
        if (this.a == null) {
            return;
        }
        this.a();
        this.a(this.a, false);
        this.g = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void animate() {
        if (this.a == null) {
            return;
        }
        this.g = true;
        boolean bl = this.isMultiThreading();
        int n = this.getAnimationRate();
        this.f(this.a);
        this.d(this.a);
        try {
            this.a(0);
            this.a(this.a, false);
            this.a.reDraw();
            boolean bl2 = true;
            for (int i = 1; i < n && bl2; ++i) {
                if (this.e && bl) {
                    long l = System.currentTimeMillis();
                    bl2 = this.animStep(i);
                    long l2 = System.currentTimeMillis();
                    long l3 = (long)this.getAnimationDelay() - (l2 - l);
                    if (l3 > 0L) {
                        this.a(l3);
                    }
                } else {
                    bl2 = this.animStep(i);
                    this.a((long)this.getAnimationDelay());
                }
                if (!bl) continue;
                Thread.yield();
            }
            this.animStep(n);
        }
        finally {
            this.e(this.a);
            this.g(this.a);
            this.g = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(IlvManager ilvManager) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.d((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            IlvGraphicEnumeration ilvGraphicEnumeration2 = ilvManager.getObjects();
            while (ilvGraphicEnumeration2.hasMoreElements()) {
                IlvObjectAnimator ilvObjectAnimator;
                IlvGraphic ilvGraphic = ilvGraphicEnumeration2.nextElement();
                if (ilvGraphic instanceof IlvOptimizedAnimatedGraphic) {
                    ((IlvOptimizedAnimatedGraphic)ilvGraphic).setAnimationDrawingMode(true);
                }
                if ((ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, false)) == null) {
                    this.a(ilvGraphic);
                    ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, false);
                }
                ilvObjectAnimator.animInit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(IlvManager ilvManager) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.e((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            IlvGraphicEnumeration ilvGraphicEnumeration2 = ilvManager.getObjects();
            while (ilvGraphicEnumeration2.hasMoreElements()) {
                IlvObjectAnimator ilvObjectAnimator;
                IlvGraphic ilvGraphic = ilvGraphicEnumeration2.nextElement();
                if (ilvGraphic instanceof IlvOptimizedAnimatedGraphic) {
                    ((IlvOptimizedAnimatedGraphic)ilvGraphic).setAnimationDrawingMode(false);
                }
                if ((ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, false)) == null) {
                    this.a(ilvGraphic);
                    ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, false);
                }
                ilvObjectAnimator.animCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f(IlvManager ilvManager) {
        boolean bl = this.isMultiThreading();
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.f((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                ViewData viewData = this.a(enumeration.nextElement());
                IlvManagerView ilvManagerView = viewData.a;
                viewData.d = ilvManagerView.getRedrawMode();
                ilvManagerView.setDoubleBuffering(true);
                if (!bl) {
                    ilvManagerView.setRedrawMode(1);
                } else {
                    ilvManagerView.setRedrawMode(0);
                }
                viewData.f = ilvManagerView.getTransformer();
                if (viewData.e == null) {
                    viewData.e = new IlvTransformer(viewData.f);
                }
                viewData.g = new IlvTransformer(viewData.e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(IlvManager ilvManager) {
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                this.g((IlvManager)ilvGraphicEnumeration.nextElement());
            }
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                ViewData viewData = this.a(enumeration.nextElement());
                viewData.a.setRedrawMode(viewData.d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean animStep(int n) {
        boolean bl = this.a(n);
        if (this.isMultiThreading() && this.e) {
            final IlvManager ilvManager = this.a;
            this.f = false;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IlvManagerAnimator ilvManagerAnimator = IlvManagerAnimator.this;
                    synchronized (ilvManagerAnimator) {
                        ilvManager.reDraw();
                        IlvManagerAnimator.this.f = true;
                        IlvManagerAnimator.this.notifyAll();
                    }
                }
            });
            IlvManagerAnimator ilvManagerAnimator = this;
            synchronized (ilvManagerAnimator) {
                while (!this.f) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean a(int n) {
        if (this.a == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = this.isMultiThreading();
        IlvManager ilvManager = this.a;
        synchronized (ilvManager) {
            this.a.setContentsAdjusting(true);
            this.i.setIndex(n);
            if (!bl2) {
                this.a.initReDraws();
            }
            try {
                if (!bl2) {
                    this.h(this.a);
                }
            }
            finally {
                if (bl2) {
                    if (!this.e) {
                        this.a.reDraw();
                    }
                } else {
                    this.a.reDrawViews();
                }
                this.a.setContentsAdjusting(false);
            }
        }
        this.afterAnimationStep(n);
        return bl |= this.a(this.a, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean a(IlvManager ilvManager, int n) {
        if (ilvManager == null) {
            return false;
        }
        int n2 = this.getAnimationRate();
        boolean bl = false;
        IlvManager ilvManager2 = ilvManager;
        synchronized (ilvManager2) {
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                ViewData viewData = this.a(enumeration.nextElement());
                IlvTransformer ilvTransformer = viewData.e;
                IlvTransformer ilvTransformer2 = viewData.f;
                if (n == n2) {
                    viewData.g = viewData.f;
                } else {
                    viewData.g.setValues(ilvTransformer.getx11() + (double)n * (ilvTransformer2.getx11() - ilvTransformer.getx11()) / (double)n2, ilvTransformer.getx12() + (double)n * (ilvTransformer2.getx12() - ilvTransformer.getx12()) / (double)n2, ilvTransformer.getx21() + (double)n * (ilvTransformer2.getx21() - ilvTransformer.getx21()) / (double)n2, ilvTransformer.getx22() + (double)n * (ilvTransformer2.getx22() - ilvTransformer.getx22()) / (double)n2, ilvTransformer.getx0() + (double)n * (ilvTransformer2.getx0() - ilvTransformer.getx0()) / (double)n2, ilvTransformer.gety0() + (double)n * (ilvTransformer2.gety0() - ilvTransformer.gety0()) / (double)n2);
                }
                viewData.a.setTransformer(viewData.g);
                if (viewData.g.equals((Object)viewData.f)) continue;
                bl = true;
            }
            if (ilvManager != this.a) {
                ilvManager.setContentsAdjusting(true);
            }
            try {
                IlvObjectAnimator ilvObjectAnimator;
                IlvGraphic ilvGraphic;
                IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvManager.applyToObject((IlvGraphic)((IlvManager)ilvGraphicEnumeration.nextElement()), (IlvApplyObject)this.i, null, false);
                    bl |= this.i.needContinue();
                }
                ilvGraphicEnumeration = ilvManager.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvGraphic = ilvGraphicEnumeration.nextElement();
                    ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, true);
                    if (ilvObjectAnimator instanceof IlvLinkImageAnimator) continue;
                    bl |= ilvObjectAnimator.animStep(ilvManager, n, n2);
                }
                ilvGraphicEnumeration = ilvManager.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ilvGraphic = ilvGraphicEnumeration.nextElement();
                    ilvObjectAnimator = this.getObjectAnimator(ilvGraphic, true);
                    if (!(ilvObjectAnimator instanceof IlvLinkImageAnimator)) continue;
                    bl |= ilvObjectAnimator.animStep(ilvManager, n, n2);
                }
            }
            finally {
                if (ilvManager != this.a) {
                    ilvManager.setContentsAdjusting(false);
                }
            }
        }
        return bl;
    }

    protected synchronized void afterAnimationStep(int n) {
        if (this.l != null) {
            this.b();
        }
    }

    public synchronized void animateToImages(ImageConsumer imageConsumer, int n, int n2, IlvTransformer ilvTransformer) {
        IlvManagerView ilvManagerView = new IlvManagerView(this.a, ilvTransformer);
        ilvManagerView.setBounds(0, 0, n, n2);
        ViewData viewData = this.a(ilvManagerView);
        viewData.e = viewData.a.getTransformer();
        this.animateToImages(imageConsumer, ilvManagerView);
        ilvManagerView.removeNotify();
    }

    public synchronized void animateToImages(ImageConsumer imageConsumer, IlvManagerView ilvManagerView) {
        if (imageConsumer == null) {
            return;
        }
        if (this.a == null || ilvManagerView == null) {
            imageConsumer.imageComplete(3);
            return;
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        this.l = imageConsumer;
        this.n = ilvManagerView.getWidth();
        this.o = ilvManagerView.getHeight();
        imageConsumer.setDimensions(this.n, this.o);
        imageConsumer.setColorModel(colorModel);
        imageConsumer.setHints(10);
        this.m = ilvManagerView;
        this.animate();
        imageConsumer.imageComplete(3);
        this.l = null;
        this.m = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        if (this.isMultiThreading()) {
            this.f = false;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IlvManagerAnimator ilvManagerAnimator = IlvManagerAnimator.this;
                    synchronized (ilvManagerAnimator) {
                        try {
                            IlvManagerAnimator.this.c();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        IlvManagerAnimator.this.f = true;
                        IlvManagerAnimator.this.notifyAll();
                    }
                }
            });
            IlvManagerAnimator ilvManagerAnimator = this;
            synchronized (ilvManagerAnimator) {
                while (!this.f) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else {
            this.c();
        }
    }

    private void c() {
        IlvManagerView ilvManagerView = this.m;
        Image image = ilvManagerView.createImage(this.n, this.o);
        if (image == null) {
            image = new BufferedImage(this.n, this.o, 1);
        }
        Graphics graphics = image.getGraphics();
        ilvManagerView.invalidateView();
        graphics.clipRect(0, 0, this.n, this.o);
        ilvManagerView.paint(graphics);
        int[] nArray = IlvManagerAnimator.a(image, this.n, this.o);
        ColorModel colorModel = ColorModel.getRGBdefault();
        this.l.setPixels(0, 0, this.n, this.o, colorModel, nArray, 0, this.n);
        this.l.imageComplete(2);
    }

    private static int[] a(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
        return nArray;
    }

    private void h(IlvManager ilvManager) {
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            this.h((IlvManager)ilvGraphicEnumeration.nextElement());
        }
        Enumeration enumeration = ilvManager.getViews();
        while (enumeration.hasMoreElements()) {
            IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
            ilvManagerView.getRegion().empty();
            ilvManagerView.invalidateView();
        }
    }

    private ViewData a(Object object) {
        ViewData viewData = this.j;
        ViewData viewData2 = null;
        while (viewData != null) {
            if (viewData.a == object) {
                return viewData;
            }
            viewData2 = viewData;
            viewData = viewData.h;
        }
        if (viewData2 == null) {
            this.j = viewData = new ViewData((IlvManagerView)object, null);
        } else {
            viewData2.h = viewData = new ViewData((IlvManagerView)object, null);
        }
        return viewData;
    }

    private static final class AnimStepApply
    implements IlvApplyObject {
        IlvManagerAnimator a;
        int b;
        boolean c;

        AnimStepApply(IlvManagerAnimator ilvManagerAnimator) {
            this.a = ilvManagerAnimator;
        }

        public void setIndex(int n) {
            this.b = n;
        }

        public boolean needContinue() {
            return this.c;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            this.c = this.a.a((IlvManager)ilvGraphic, this.b);
        }
    }

    private static final class ViewData {
        IlvManagerView a;
        boolean b;
        boolean c;
        int d = 0;
        IlvTransformer e;
        IlvTransformer f;
        IlvTransformer g;
        ViewData h;

        ViewData(IlvManagerView ilvManagerView, ViewData viewData) {
            this.a = ilvManagerView;
            this.b = ilvManagerView.isDoubleBuffering();
            this.c = ilvManagerView.isDoubleBufferFrozen();
            ilvManagerView.setDoubleBuffering(true);
            this.h = viewData;
        }
    }
}

