/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.ui.actions.AbstractActionDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.common.NameValidationPropertyChangeListener;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditor;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.common.RaptorTaskSerialiser;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanel;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelController;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelDBTask;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModel;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModelChangeListener;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModelTemplateWrapper;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelStoredProcUpdateListener;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class ProgramUpdateAction
extends AbstractActionDialog {
    ProgramPropertyPanelModelChangeListener modelChanges = new ProgramPropertyPanelModelChangeListener();
    ProgramPropertyPanelStoredProcUpdateListener storedProcUpdateListener;
    ProgramPropertyPanelModel model = null;
    DBObject dbObj = null;
    Node node = null;
    ViewerNode viewerNode = null;
    Context ctxt = null;
    String connectionName = null;
    String schema = null;
    String version = null;
    ProgramPropertyPanelModelTemplateWrapper modelWrapper;
    ProgramPropertyPanelController controller;

    protected String getTitle() {
        return SchedulerArb.getString("PROGRAMUPDATEDIALOG_TITLE");
    }

    protected JComponent createEditPane(Connection connection) {
        String string;
        this.ctxt = this.getContext();
        this.node = this.ctxt.getNode();
        if (this.node instanceof ViewerNode) {
            this.viewerNode = (ViewerNode)this.node;
            this.dbObj = this.viewerNode.getDBObject();
            if (this.dbObj.getObjectType().equals("SCHEDULER") && (string = this.ctxt.getView()) instanceof GraphicalEditor) {
                GraphicalEditor graphicalEditor = (GraphicalEditor)((Object)string);
                Element[] elementArray = graphicalEditor.getGraphicalEditorController().getSelection();
                this.dbObj = elementArray.length == 1 && elementArray[0] instanceof ObjectNode ? (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT") : null;
            }
        } else if (this.node instanceof ObjectFolder || this.node instanceof ObjectNode) {
            this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
        }
        if (this.dbObj != null) {
            string = this.dbObj.getObjectType();
            if (this.model == null) {
                this.model = new ProgramPropertyPanelModel();
                this.model.setProgram_type(ProgramPropertyPanelModel.PROG_TYPE_PLSQL_BLOCK);
                this.controller = new ProgramPropertyPanelController(this.model);
                this.model.addPropertyChangeListener(new NameValidationListener());
                this.modelWrapper = new ProgramPropertyPanelModelTemplateWrapper();
                this.modelWrapper.setModel(this.model);
            }
            this.connectionName = this.dbObj.getConnectionName();
            this.schema = this.dbObj.getSchemaName();
            this.version = this.dbObj.getDBVersion();
            this.storedProcUpdateListener = new ProgramPropertyPanelStoredProcUpdateListener(this.connectionName, this.version, this.model);
            if (this.connectionName != null) {
                return this.launchAction();
            }
        }
        return new JPanel();
    }

    public JComponent launchAction() {
        ProgramPropertyPanel programPropertyPanel = new ProgramPropertyPanel(PanelType.UPDATE, this.model, this.controller);
        HelpSystem.getHelpSystem().registerTopic((JComponent)programPropertyPanel, "f1_createProgramDialog_html");
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        this.model.setMetadata_argument_names(dBMSSchedulerCodeGenerator.generate(this.dbObj.getConnection(), "ARGUMENT_METADATA_ATTRIBUTES", null));
        String string = dBMSSchedulerCodeGenerator.generate(this.version, "PROGRAM_MODEL_UPDATE", null);
        ProgramPropertyPanelDBTask programPropertyPanelDBTask = new ProgramPropertyPanelDBTask(this.dbObj.getConnectionName(), this.dbObj.getObjectName(), this.dbObj.getSchemaName(), this.model, SchedulerArb.getString("PROGRAMUPDATEDIALOG_REFRESH_TASK") + "_01", string, ProgramPropertyPanelModel.MODEL_UPDATE_METHOD);
        string = dBMSSchedulerCodeGenerator.generate(this.version, "PROGRAM_MODEL_PROGRAM_ARGUMENTS", null);
        ProgramPropertyPanelDBTask programPropertyPanelDBTask2 = new ProgramPropertyPanelDBTask(this.dbObj.getConnectionName(), this.dbObj.getObjectName(), this.dbObj.getSchemaName(), this.model, SchedulerArb.getString("PROGRAMPANEL_MODEL_UPDATE.TASK") + "_02", string, ProgramPropertyPanelModel.PROG_ARGS_UPDATE_METHOD);
        string = dBMSSchedulerCodeGenerator.generate(this.version, "SCHEMAS_LIST", null);
        ProgramPropertyPanelDBTask programPropertyPanelDBTask3 = new ProgramPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("PROGRAMCREATEDIALOG_CREATE_TASK") + "_03", string, ProgramPropertyPanelModel.SCHEMA_LIST_UPDATE_METHOD);
        string = dBMSSchedulerCodeGenerator.generate(this.version, "CURRENT_SCHEMA", null);
        ProgramPropertyPanelDBTask programPropertyPanelDBTask4 = new ProgramPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("PROGRAMCREATEDIALOG_CREATE_TASK") + "_04", string, ProgramPropertyPanelModel.SCHEMA_UPDATE_METHOD);
        string = dBMSSchedulerCodeGenerator.generate(this.version, "PROGRAM_MODEL_PROCEDURES", null);
        ProgramPropertyPanelDBTask programPropertyPanelDBTask5 = new ProgramPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("PROGRAMPANEL_MODEL_UPDATE.TASK") + "_05", string, ProgramPropertyPanelModel.PROCEDURES_UPDATE_METHOD);
        string = dBMSSchedulerCodeGenerator.generate(this.version, "PROGRAM_MODEL_PKG_PROCEDURES", null);
        ProgramPropertyPanelDBTask programPropertyPanelDBTask6 = new ProgramPropertyPanelDBTask(this.connectionName, null, this.schema, this.model, SchedulerArb.getString("PROGRAMPANEL_MODEL_UPDATE.TASK") + "_06", string, ProgramPropertyPanelModel.PKG_PROCEDURES_UPDATE_METHOD);
        RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>("ClearModel_07"){

            protected Boolean doWork() {
                ProgramUpdateAction.this.modelChanges.clear();
                ProgramUpdateAction.this.model.addPropertyChangeListener(ProgramUpdateAction.this.modelChanges);
                ProgramUpdateAction.this.model.addPropertyChangeListener(ProgramUpdateAction.this.storedProcUpdateListener);
                return Boolean.TRUE;
            }
        };
        RaptorTaskSerialiser raptorTaskSerialiser = new RaptorTaskSerialiser(new RaptorTask[]{programPropertyPanelDBTask3, programPropertyPanelDBTask4, programPropertyPanelDBTask5, programPropertyPanelDBTask6, programPropertyPanelDBTask, programPropertyPanelDBTask2, raptorTask});
        raptorTaskSerialiser.run();
        return programPropertyPanel;
    }

    protected String getEditPaneTitle() {
        return SchedulerArb.getString("PROGRAMUPDATEDIALOG_TAB_TITLE");
    }

    protected String getScript() {
        int n;
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<ProgramPropertyPanelModel.ProgramArgument> vector = new Vector<ProgramPropertyPanelModel.ProgramArgument>();
        Vector<Integer> vector2 = new Vector<Integer>();
        hashtable.put("changes", this.modelChanges);
        hashtable.put("model", this.modelWrapper);
        hashtable.put("arguments", this.modelWrapper.getProgramArguments());
        hashtable.put("arguments_to_update", vector);
        hashtable.put("arguments_to_drop", vector2);
        if (this.model.getNumber_of_arguments() != this.model.getOriginalNumberOfArguments()) {
            this.modelChanges.propertyChange(new PropertyChangeEvent((Object)this, "number_of_arguments", this.model.getNumber_of_arguments(), this.model.getOriginalNumberOfArguments()));
        }
        for (n = 0; n < this.modelWrapper.getOriginalNumberOfArguments(); ++n) {
            vector2.add(n + 1);
        }
        for (n = 0; n < this.modelWrapper.getNumber_of_arguments(); ++n) {
            ProgramPropertyPanelModel.ProgramArgument programArgument = this.modelWrapper.getProgramArguments().get(n);
            vector.add(programArgument);
        }
        String string = dBMSSchedulerCodeGenerator.generate(this.version, "PROGRAM_UPDATE", hashtable);
        return string;
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    private class NameValidationListener
    extends NameValidationPropertyChangeListener {
        public NameValidationListener() {
            super("program_name");
        }

        @Override
        protected boolean validateImpl() {
            String string = null;
            String string2 = ProgramUpdateAction.this.model.getProgram_name();
            if (string2 != null && string2.length() > 0) {
                if (string2.contains("\"")) {
                    string = SchedulerArb.getString("VALIDATION_CANNOT_CONTAIN_DOUBLE_QUOTE");
                } else if (string2.length() > 30) {
                    string = SchedulerArb.getString("VALIDATION_CANNOT_BE_GREATER_THAN_N_BYTES");
                    string = MessageFormat.format(string, 30);
                }
            }
            ProgramUpdateAction.this.model.setProgram_nameValidMsg(string);
            return string != null;
        }
    }
}

