/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.ui.controls.TableActionControlPanel;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanel;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelController;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModel;

public class ProgramArgumentPanel
extends JPanel {
    public static final String PROGRAM_TYPE = "programType";
    private PanelType panelType = PanelType.UPDATE;
    private ProgramPropertyPanelController controller;
    private ProgramPropertyPanelModel model;
    private boolean refreshing = false;
    private List<ProgramPropertyPanelModel.ProgramArgument> arguments;
    private ProgramArgumentTableModel tableModel = new ProgramArgumentTableModel();
    private ProgramArgumentTableActionControlPanelController tableController = new ProgramArgumentTableActionControlPanelController();
    private Set<String> ignoreNotificationList = new TreeSet<String>();
    private TableActionControlPanel tableActionControlPanel = new TableActionControlPanel((TableModel)this.tableModel, (TableActionControlPanel.TableActionControlPanelController)this.tableController);
    private BorderLayout borderLayout1 = new BorderLayout();
    private JComboBox argumentTypeComboBox = new JComboBox();
    private DefaultCellEditor argumentTypeCellEditor = new DefaultCellEditor(this.argumentTypeComboBox);
    private JComboBox argumentDefaultValueComboBox = new JComboBox();
    private DefaultCellEditor argumentDefaultValueCellEditor = new DefaultCellEditor(this.argumentDefaultValueComboBox);
    private JComboBox argumentInOutComboBox = new JComboBox();
    private DefaultCellEditor argumentInOutCellEditor = new DefaultCellEditor(this.argumentInOutComboBox);
    private String type;
    private String title;

    public ProgramArgumentPanel(String string) {
        this.title = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tableActionControlPanel.setTitle(this.title);
        JTable jTable = this.tableActionControlPanel.getTable();
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jTable.getColumnModel().getColumn(1).setCellEditor(this.argumentTypeCellEditor);
        jTable.getColumnModel().getColumn(2).setCellEditor(this.argumentDefaultValueCellEditor);
        jTable.getColumnModel().getColumn(0).setMinWidth(16);
        jTable.getColumnModel().getColumn(1).setMinWidth(16);
        jTable.getColumnModel().getColumn(2).setMinWidth(16);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(16);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(16);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(64);
        jTable.setSelectionMode(0);
        this.add((Component)this.tableActionControlPanel, "Center");
        this.validate();
    }

    public void setController(ProgramPropertyPanelController programPropertyPanelController) {
        this.controller = programPropertyPanelController;
    }

    public void setModel(ProgramPropertyPanelModel programPropertyPanelModel) {
        this.model = programPropertyPanelModel;
        this.refresh();
    }

    public void setPanelType(PanelType panelType) {
        if (this.panelType != panelType) {
            this.panelType = panelType;
            this.configurePanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurePanel() {
        try {
            if (this.getType() != null && (this.getType().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE) || this.getType().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE))) {
                switch (this.panelType) {
                    case UPDATE: 
                    case CREATE: {
                        this.tableActionControlPanel.setButtons(63);
                        break;
                    }
                    case VIEW: {
                        this.tableActionControlPanel.setButtons(0);
                    }
                }
            }
            if (this.getType().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
                this.tableActionControlPanel.setEnabled(true);
            }
        }
        finally {
            this.validate();
        }
    }

    public void setArguments(List<ProgramPropertyPanelModel.ProgramArgument> list) {
        this.tableModel.setArguments(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.refreshing = true;
        try {
            this.argumentTypeComboBox.removeAllItems();
            List<String> list = ProgramPropertyPanelModel.getExecutable_argument_types();
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            this.argumentTypeComboBox.setModel(defaultComboBoxModel);
            this.argumentDefaultValueComboBox.removeAllItems();
            this.argumentDefaultValueComboBox.setEditable(true);
            list = this.model.getMetadata_argument_names();
            defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
            this.argumentDefaultValueComboBox.setModel(defaultComboBoxModel);
            this.argumentInOutComboBox.removeAllItems();
            this.argumentInOutComboBox.addItem("IN");
            this.argumentInOutComboBox.addItem("OUT");
            if (this.model == null) {
                // empty if block
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("argument_added")) {
                if (propertyChangeEvent.getNewValue() instanceof Integer) {
                    Integer n = (Integer)propertyChangeEvent.getNewValue();
                    this.tableModel.fireTableModelEvent(new TableModelEvent(this.tableModel, n, n, -1, 1));
                }
            } else if (propertyChangeEvent.getPropertyName().equals("argument_deleted")) {
                if (propertyChangeEvent.getNewValue() instanceof Integer) {
                    Integer n = (Integer)propertyChangeEvent.getNewValue();
                    this.tableModel.fireTableModelEvent(new TableModelEvent(this.tableModel, n, n, -1, -1));
                }
            } else if (propertyChangeEvent.getPropertyName().equals("argument_cleared")) {
                this.tableModel.fireTableModelEvent(new TableModelEvent(this.tableModel));
            } else if (propertyChangeEvent.getPropertyName().equals("argument_position")) {
                this.tableModel.fireTableModelEvent(new TableModelEvent(this.tableModel));
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(ProgramPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
    }

    public void setType(String string) {
        if (this.type != string) {
            this.type = string;
            this.configurePanel();
        }
    }

    public String getType() {
        return this.type;
    }

    private class ProgramArgumentTableModel
    implements TableModel {
        List<TableModelListener> listeners = new Vector<TableModelListener>();

        private ProgramArgumentTableModel() {
        }

        public void setArguments(List<ProgramPropertyPanelModel.ProgramArgument> list) {
            ProgramArgumentPanel.this.arguments = list;
            this.fireTableModelEvent(new TableModelEvent(this));
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (ProgramArgumentPanel.this.arguments != null) {
                n = ProgramArgumentPanel.this.arguments.size();
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Data Type";
                }
                case 2: {
                    return "Default";
                }
                case 3: {
                    return "In/Out";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            if (ProgramArgumentPanel.this.panelType != PanelType.VIEW) {
                if (ProgramArgumentPanel.this.getType().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE)) {
                    bl = true;
                } else if (ProgramArgumentPanel.this.getType().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_STORED_PROCEDURE)) {
                    bl = n2 == 0 || n2 == 2;
                } else if (ProgramArgumentPanel.this.getType().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
                    bl = n2 == 0 || n2 == 2;
                }
            }
            return bl;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= ProgramArgumentPanel.this.arguments.size()) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return ((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n)).getArgument_name();
                }
                case 1: {
                    return ((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n)).getArgument_type();
                }
                case 2: {
                    return ((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n)).getDefault_value();
                }
                case 3: {
                    if (((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n)).isOut_argument() == null) {
                        return "IN";
                    }
                    return ((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n)).isOut_argument() != false ? "OUT" : "IN";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    ProgramArgumentPanel.this.controller.setArgumentName((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n), (String)object);
                    break;
                }
                case 1: {
                    ProgramArgumentPanel.this.controller.setArgumentType((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n), (String)object);
                    break;
                }
                case 2: {
                    ProgramArgumentPanel.this.controller.setArgumentDefault((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n), (String)object);
                    break;
                }
                case 3: {
                    ProgramArgumentPanel.this.controller.setArgumentInOut((ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n), "OUT".equalsIgnoreCase(object.toString()));
                }
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            if (tableModelListener != null) {
                this.listeners.add(tableModelListener);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            if (tableModelListener != null) {
                this.listeners.remove(tableModelListener);
            }
        }

        private void fireTableModelEvent(TableModelEvent tableModelEvent) {
            for (TableModelListener tableModelListener : this.listeners) {
                tableModelListener.tableChanged(tableModelEvent);
            }
        }
    }

    private class ProgramArgumentTableActionControlPanelController
    implements TableActionControlPanel.TableActionControlPanelController {
        private ProgramArgumentTableActionControlPanelController() {
        }

        public void addButtonPressed(ActionEvent actionEvent) {
            int n = ProgramArgumentPanel.this.tableActionControlPanel.getTable().getSelectedRow();
            if (n >= 0) {
                ProgramArgumentPanel.this.controller.createProgramArgument(n + 1);
            } else {
                ProgramArgumentPanel.this.controller.createProgramArgument(ProgramArgumentPanel.this.tableActionControlPanel.getTable().getRowCount());
            }
        }

        public void removeButtonPressed(ActionEvent actionEvent) {
            int n = ProgramArgumentPanel.this.tableActionControlPanel.getTable().getSelectedRow();
            if (n >= 0) {
                ProgramArgumentPanel.this.controller.removeProgramArgument(n);
                if (ProgramArgumentPanel.this.tableActionControlPanel.getTable().getRowCount() > n) {
                    ProgramArgumentPanel.this.tableActionControlPanel.getTable().setRowSelectionInterval(n, n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firstButtonPressed(ActionEvent actionEvent) {
            if (ProgramArgumentPanel.this.model != null && ProgramArgumentPanel.this.controller != null) {
                ProgramPropertyPanelModel programPropertyPanelModel = ProgramArgumentPanel.this.model;
                synchronized (programPropertyPanelModel) {
                    if (!ProgramArgumentPanel.this.refreshing) {
                        int n = ProgramArgumentPanel.this.tableActionControlPanel.getTable().getSelectedRow();
                        ProgramPropertyPanelModel.ProgramArgument programArgument = (ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n);
                        ProgramArgumentPanel.this.controller.setArgumentPosition(programArgument, 0);
                        ProgramArgumentPanel.this.tableActionControlPanel.getTable().setRowSelectionInterval(0, 0);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void previousButtonPressed(ActionEvent actionEvent) {
            if (ProgramArgumentPanel.this.model != null && ProgramArgumentPanel.this.controller != null) {
                ProgramPropertyPanelModel programPropertyPanelModel = ProgramArgumentPanel.this.model;
                synchronized (programPropertyPanelModel) {
                    if (!ProgramArgumentPanel.this.refreshing) {
                        int n = ProgramArgumentPanel.this.tableActionControlPanel.getTable().getSelectedRow();
                        ProgramPropertyPanelModel.ProgramArgument programArgument = (ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n);
                        ProgramArgumentPanel.this.controller.setArgumentPosition(programArgument, n - 1);
                        ProgramArgumentPanel.this.tableActionControlPanel.getTable().setRowSelectionInterval(n - 1, n - 1);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nextButtonPressed(ActionEvent actionEvent) {
            if (ProgramArgumentPanel.this.model != null && ProgramArgumentPanel.this.controller != null) {
                ProgramPropertyPanelModel programPropertyPanelModel = ProgramArgumentPanel.this.model;
                synchronized (programPropertyPanelModel) {
                    if (!ProgramArgumentPanel.this.refreshing) {
                        int n = ProgramArgumentPanel.this.tableActionControlPanel.getTable().getSelectedRow();
                        ProgramPropertyPanelModel.ProgramArgument programArgument = (ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n);
                        ProgramArgumentPanel.this.controller.setArgumentPosition(programArgument, n + 1);
                        ProgramArgumentPanel.this.tableActionControlPanel.getTable().setRowSelectionInterval(n + 1, n + 1);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lastButtonPressed(ActionEvent actionEvent) {
            if (ProgramArgumentPanel.this.model != null && ProgramArgumentPanel.this.controller != null) {
                ProgramPropertyPanelModel programPropertyPanelModel = ProgramArgumentPanel.this.model;
                synchronized (programPropertyPanelModel) {
                    if (!ProgramArgumentPanel.this.refreshing) {
                        int n = ProgramArgumentPanel.this.tableActionControlPanel.getTable().getSelectedRow();
                        ProgramPropertyPanelModel.ProgramArgument programArgument = (ProgramPropertyPanelModel.ProgramArgument)ProgramArgumentPanel.this.arguments.get(n);
                        ProgramArgumentPanel.this.controller.setArgumentPosition(programArgument, ProgramArgumentPanel.this.model.getNumber_of_arguments() - 1);
                        ProgramArgumentPanel.this.tableActionControlPanel.getTable().setRowSelectionInterval(ProgramArgumentPanel.this.tableActionControlPanel.getTable().getRowCount() - 1, ProgramArgumentPanel.this.tableActionControlPanel.getTable().getRowCount() - 1);
                    }
                }
            }
        }
    }
}

