/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobWhatChainPropertyPanel
extends NewJobParentPanel {
    private JComboBox chainComboBox;
    private JLabel chainLabel;
    private JPanel whatTypeChainPanel;

    public NewJobWhatChainPropertyPanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController);
        try {
            this.initComponents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refresh();
    }

    private void initComponents() {
        this.whatTypeChainPanel = new JPanel();
        this.chainComboBox = new JComboBox();
        this.chainLabel = new JLabel();
        this.setPreferredSize(new Dimension(230, 97));
        this.whatTypeChainPanel.setPreferredSize(new Dimension(260, 130));
        this.chainComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.chainComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobWhatChainPropertyPanel.this.chainComboBoxActionPerformed(actionEvent);
            }
        });
        this.chainLabel.setText("Select Chain");
        this.chainComboBox.setName("chainComboBox");
        this.chainLabel.setName("chainLabel");
        GroupLayout groupLayout = new GroupLayout(this.whatTypeChainPanel);
        this.whatTypeChainPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.chainLabel).addContainerGap(171, Short.MAX_VALUE)).addComponent(this.chainComboBox, 0, 230, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.chainLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chainComboBox, -2, -1, -2).addContainerGap(41, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        this.add(this.whatTypeChainPanel);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.whatTypeChainPanel, -1, 230, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.whatTypeChainPanel, -1, 97, Short.MAX_VALUE));
    }

    public JPanel getPanel() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chainComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("jobWhatChains");
                    try {
                        if (this.chainComboBox.getSelectedIndex() == -1) {
                            this.controller.setChain(null);
                        } else {
                            String string = (String)this.chainComboBox.getSelectedItem();
                            this.controller.setChain(string);
                        }
                    }
                    finally {
                        this.ignoreNotificationList.remove("jobWhatChains");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.model == null) {
            this.chainComboBox.removeAllItems();
        } else {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                this.refreshing = true;
                try {
                    this.chainComboBox.removeAllItems();
                    List<String> list = this.model.getChainsList();
                    if (list != null) {
                        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                        this.chainComboBox.setModel(defaultComboBoxModel);
                    }
                    this.chainComboBox.setSelectedItem(this.model.getChain());
                }
                catch (Exception exception) {
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("setChainEvent")) {
                this.chainComboBox.setSelectedItem((String)propertyChangeEvent.getNewValue());
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(NewJobPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
    }
}

