/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhatChainPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhatExecutablePropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhatNamedProgramPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhatPLSQLBLOCKPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhatStoredProcedurePropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhenCalendarOncePropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhenCalendarRepeatPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhenEventPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhenFileWatcherNamePropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobWhenNamedSchedulePropertyPanel;
import oracle.dbtools.util.Logger;

public class NewJobPropertyPanel
extends NewJobParentPanel
implements LayoutControl {
    private static final long serialVersionUID = 1L;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JCheckBox enabledCheckBox;
    private JComboBox jobClassComboBox;
    private JLabel jobClassLabel;
    private JLabel jobNameText;
    private JTextField jobNameTextField;
    private JPanel newJobTopPanel;
    private CardLayoutPanel whatTypeOfJobPanel;
    private JComboBox whenChoiceComboBox;
    private JPanel whenMiddlePanel;
    private CardLayoutPanel whenToExecuteJobPanel;
    private CustomTabbedPane dialogTabbedPane;
    NewJobWhatNamedProgramPropertyPanel jobArgPanel = null;
    private final String[] WHEN_JOBS_CHOICES = new String[]{"", "IMMEDIATE", "ONCE", "CALENDAR_EXPRESSION", "EVENT", "NAMED_SCHEDULE", "FILE_WATCHER"};

    public NewJobPropertyPanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController, Connection connection, CustomTabbedPane customTabbedPane) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController, connection);
        this.dialogTabbedPane = customTabbedPane;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refresh();
    }

    public JComponent getTopPanel() {
        return this.newJobTopPanel;
    }

    private void jbInit() throws Exception {
        this.newJobTopPanel = new JPanel();
        this.whenMiddlePanel = new JPanel();
        this.whenChoiceComboBox = new JComboBox();
        this.jobNameText = new JLabel();
        this.descriptionLabel = new JLabel();
        this.jobClassLabel = new JLabel();
        this.enabledCheckBox = new JCheckBox();
        this.descriptionTextField = new JTextField();
        this.jobNameTextField = new JTextField();
        this.jobClassComboBox = new JComboBox();
        Hashtable<String, NewJobParentPanel> hashtable = new Hashtable<String, NewJobParentPanel>();
        hashtable.put(NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK, new NewJobWhatPLSQLBLOCKPropertyPanel(null, this.model, this.controller));
        hashtable.put(NewJobPropertyPanelModel.JOB_TYPE_CHAIN, new NewJobWhatChainPropertyPanel(null, this.model, this.controller));
        hashtable.put(NewJobPropertyPanelModel.JOB_TYPE_STORED_PROCEDURE, new NewJobWhatStoredProcedurePropertyPanel(null, this.model, this.controller));
        hashtable.put(NewJobPropertyPanelModel.JOB_TYPE_NAMED_PROGRAM, new NewJobWhatNamedProgramPropertyPanel(null, this.model, this.controller));
        hashtable.put(NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE, new NewJobWhatExecutablePropertyPanel(null, this.model, this.controller));
        this.whatTypeOfJobPanel = new CardLayoutPanel(hashtable, "Type of Job", CardLayoutPanel.Type.TITLE_BORDER);
        this.whatTypeOfJobPanel.setSelectedItem((Object)NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK);
        this.controller.setWhatJobSelection(NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK);
        this.whatTypeOfJobPanel.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (1 == itemEvent.getStateChange()) {
                    String string = itemEvent.getItem().toString();
                    NewJobPropertyPanelModel newJobPropertyPanelModel = NewJobPropertyPanel.this.model;
                    synchronized (newJobPropertyPanelModel) {
                        NewJobPropertyPanel.this.controller.setWhatJobSelection(string);
                    }
                }
            }
        });
        this.whatTypeOfJobPanel.setValidateOnChange(true);
        Hashtable<String, JPanel> hashtable2 = new Hashtable<String, JPanel>();
        hashtable2.put("NAMED_SCHEDULE", new NewJobWhenNamedSchedulePropertyPanel(null, this.model, this.controller));
        hashtable2.put("EVENT", new NewJobWhenEventPropertyPanel(null, this.model, this.controller));
        hashtable2.put("ONCE", new NewJobWhenCalendarOncePropertyPanel(null, this.model, this.controller));
        hashtable2.put("CALENDAR_EXPRESSION", new NewJobWhenCalendarRepeatPropertyPanel(null, this.model, this.controller));
        hashtable2.put("FILE_WATCHER", new NewJobWhenFileWatcherNamePropertyPanel(null, this.model, this.controller));
        hashtable2.put("IMMEDIATE", new JPanel());
        this.whenToExecuteJobPanel = new CardLayoutPanel(hashtable2, "When to Execute Job", CardLayoutPanel.Type.TITLE_BORDER);
        this.whenToExecuteJobPanel.setSelectedItem((Object)"IMMEDIATE");
        this.controller.setWhenJobSelection("IMMEDIATE");
        this.whenToExecuteJobPanel.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (1 == itemEvent.getStateChange()) {
                    String string = itemEvent.getItem().toString();
                    NewJobPropertyPanelModel newJobPropertyPanelModel = NewJobPropertyPanel.this.model;
                    synchronized (newJobPropertyPanelModel) {
                        NewJobPropertyPanel.this.controller.setWhenJobSelection(string);
                    }
                }
            }
        });
        this.whenToExecuteJobPanel.setBorder((Border)BorderFactory.createTitledBorder("When to Execute Job"));
        this.whenMiddlePanel.setLayout(new BorderLayout());
        this.whenChoiceComboBox.setName("whenChoiceComboBox");
        this.jobNameText.setText("Job Name");
        this.descriptionLabel.setText("Description ");
        this.jobClassLabel.setText("Job Class");
        this.enabledCheckBox.setText("Enabled");
        this.enabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobPropertyPanel.this.enabledCheckBoxActionPerformed(actionEvent);
            }
        });
        this.descriptionTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobPropertyPanel.this.descriptionTextFieldMouseExited(mouseEvent);
            }
        });
        this.descriptionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobPropertyPanel.this.descriptionTextFieldActionPerformed(actionEvent);
            }
        });
        this.descriptionTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewJobPropertyPanel.this.descriptionTextFieldFocusLost(focusEvent);
            }
        });
        this.jobNameTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobPropertyPanel.this.jobNameTextFieldMouseExited(mouseEvent);
            }
        });
        this.jobNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobPropertyPanel.this.jobNameTextFieldActionPerformed(actionEvent);
            }
        });
        this.jobNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewJobPropertyPanel.this.jobNameTextFieldFocusLost(focusEvent);
            }
        });
        this.jobClassComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"DEFAULT_JOB_CLASS"}));
        this.jobClassComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobPropertyPanel.this.jobClassComboBoxActionPerformed(actionEvent);
            }
        });
        this.jobNameText.setName("jobNameText");
        this.descriptionLabel.setName("descriptionLabel");
        this.jobClassLabel.setName("jobClassLabel");
        this.enabledCheckBox.setName("enabledCheckBox");
        this.descriptionTextField.setName("descriptionTextField");
        this.jobNameTextField.setName("jobNameTextField");
        this.jobClassComboBox.setName("jobClassComboBox");
        this.newJobTopPanel.setLayout(new GridBagLayout());
        this.newJobTopPanel.add((Component)this.jobNameText, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.newJobTopPanel.add((Component)this.jobNameTextField, LayoutControl.GBC.gbc((int)1, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.newJobTopPanel.add((Component)this.enabledCheckBox, LayoutControl.GBC.gbc((int)3, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
        this.newJobTopPanel.add((Component)this.descriptionLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.newJobTopPanel.add((Component)this.descriptionTextField, LayoutControl.GBC.gbc((int)1, (int)1, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.newJobTopPanel.add((Component)this.jobClassLabel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.newJobTopPanel.add((Component)this.jobClassComboBox, LayoutControl.GBC.gbc((int)1, (int)2, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        this.newJobTopPanel.add((Component)this.whatTypeOfJobPanel, LayoutControl.GBC.gbc((int)0, (int)3, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.newJobTopPanel.add((Component)this.whenToExecuteJobPanel, LayoutControl.GBC.gbc((int)2, (int)3, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.newJobTopPanel, LayoutControl.GBC.DIALOG_MAIN_PANEL);
    }

    private void jobNameTextFieldActionPerformed(ActionEvent actionEvent) {
        String string = this.jobNameTextField.getText();
        this.controller.setJobName(string);
    }

    private void jobNameTextFieldMouseExited(MouseEvent mouseEvent) {
        this.controller.setJobName(this.jobNameTextField.getText());
    }

    private void descriptionTextFieldActionPerformed(ActionEvent actionEvent) {
        this.controller.setJobDescription(this.descriptionTextField.getText());
    }

    private void descriptionTextFieldMouseExited(MouseEvent mouseEvent) {
        this.controller.setJobDescription(this.descriptionTextField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobClassComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                if (!this.refreshing) {
                    if (this.jobClassComboBox.getSelectedIndex() == -1) {
                        this.controller.setJobClass(null);
                    } else {
                        this.controller.setJobClass((String)this.jobClassComboBox.getSelectedItem());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enabledCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("enabled");
                    try {
                        this.controller.setEnabled(this.enabledCheckBox.isSelected());
                    }
                    finally {
                        this.ignoreNotificationList.remove("enabled");
                    }
                }
            }
        }
    }

    private void descriptionTextFieldFocusLost(FocusEvent focusEvent) {
    }

    private void jobNameTextFieldFocusLost(FocusEvent focusEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.model == null) {
            this.jobNameTextField.setText("");
            this.descriptionTextField.setText("");
            this.enabledCheckBox.setSelected(false);
            this.jobClassComboBox.removeAllItems();
        } else {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                this.refreshing = true;
                try {
                    this.jobNameTextField.setText(this.model.getJobName());
                    this.descriptionTextField.setText(this.model.getJobDescription());
                    this.enabledCheckBox.setSelected(this.model.getEnabled());
                    try {
                        this.jobClassComboBox.removeAllItems();
                        List<String> list = this.model.getJobCLassList();
                        if (list != null) {
                            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                            this.jobClassComboBox.setModel(defaultComboBoxModel);
                        } else {
                            this.jobClassComboBox.setSelectedItem(this.model.getJobClass());
                        }
                        this.controller.setAutoDrop(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }

    private void clearPanel(JPanel jPanel) {
        jPanel.removeAll();
        jPanel.validate();
        jPanel.repaint();
    }

    private void addNamedSchedulePanel() {
        this.clearPanel(this.whenMiddlePanel);
        this.whenMiddlePanel.setLayout(new FlowLayout());
        NewJobWhenNamedSchedulePropertyPanel newJobWhenNamedSchedulePropertyPanel = new NewJobWhenNamedSchedulePropertyPanel(null, this.model, this.controller);
        this.whenMiddlePanel.add(newJobWhenNamedSchedulePropertyPanel.getPanel());
        this.revalidatePanel(this.whenMiddlePanel);
    }

    private void addWhenCalendarRepeatPanel() {
        this.clearPanel(this.whenMiddlePanel);
        this.whenMiddlePanel.setLayout(new BorderLayout());
        NewJobWhenCalendarRepeatPropertyPanel newJobWhenCalendarRepeatPropertyPanel = new NewJobWhenCalendarRepeatPropertyPanel(null, this.model, this.controller, this.connection);
        this.whenMiddlePanel.add((Component)newJobWhenCalendarRepeatPropertyPanel.getPanel(), "Center");
        this.revalidatePanel(this.whenMiddlePanel);
    }

    private void addWhenCalendarOncePanel() {
        this.clearPanel(this.whenMiddlePanel);
        this.whenMiddlePanel.setLayout(new BorderLayout());
        NewJobWhenCalendarOncePropertyPanel newJobWhenCalendarOncePropertyPanel = new NewJobWhenCalendarOncePropertyPanel(null, this.model, this.controller, this.connection);
        this.whenMiddlePanel.add((Component)newJobWhenCalendarOncePropertyPanel.getPanel(), "Center");
        this.revalidatePanel(this.whenMiddlePanel);
    }

    private void addWhenCalendarImmediatePanel() {
        this.clearPanel(this.whenMiddlePanel);
        this.controller.setCalendarOption("IMMEDIATE");
    }

    private void addWhenEventPanel() {
        this.clearPanel(this.whenMiddlePanel);
        this.whenMiddlePanel.setLayout(new BorderLayout());
        NewJobWhenEventPropertyPanel newJobWhenEventPropertyPanel = new NewJobWhenEventPropertyPanel(null, this.model, this.controller, this.connection);
        this.whenMiddlePanel.add(newJobWhenEventPropertyPanel.getPanel());
        this.revalidatePanel(this.whenMiddlePanel);
    }

    private void addWhenFileWatcherNamePanel() {
        this.clearPanel(this.whenMiddlePanel);
        this.whenMiddlePanel.setLayout(new BorderLayout());
        NewJobWhenFileWatcherNamePropertyPanel newJobWhenFileWatcherNamePropertyPanel = new NewJobWhenFileWatcherNamePropertyPanel(null, this.model, this.controller, this.connection);
        this.whenMiddlePanel.add(newJobWhenFileWatcherNamePropertyPanel.getPanel());
        this.revalidatePanel(this.whenMiddlePanel);
    }

    private void revalidatePanel(JPanel jPanel) {
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            List list;
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("job_name")) {
                this.jobNameTextField.setText((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("job_class")) {
                this.jobClassComboBox.setSelectedItem(propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("comments")) {
                this.descriptionTextField.setText((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.enabledCheckBox.setSelected((Boolean)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("jobWhatSelectionsEvent")) {
                String string = (String)propertyChangeEvent.getNewValue();
                this.whatTypeOfJobPanel.setSelectedItem((Object)string);
            } else if (propertyChangeEvent.getPropertyName().equals("jobWhenSelectionsEvent")) {
                String string = (String)propertyChangeEvent.getNewValue();
                this.whenChoiceComboBox.setSelectedItem(string);
            } else if (propertyChangeEvent.getPropertyName().equals("jobClassList") && (list = (List)propertyChangeEvent.getNewValue()) != null) {
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                this.jobClassComboBox.setModel(defaultComboBoxModel);
            }
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), (Throwable)throwable);
        }
    }
}

