/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobProgramArgumentDBTask;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobProgramArgumentPanel
extends NewJobParentPanel
implements LayoutControl {
    private static final boolean DEBUG = false;
    Integer previousStateSpinnerValue = new Integer(0);
    String connectionName = null;
    String version = null;
    int serialNumberExecTable = 0;
    private JTabbedPane JobArgJTabbedPane;
    private JLabel SelectExecLabel;
    private JLabel SelectLabel;
    private JButton addExecButton;
    private JScrollPane argsNameExecScrollPane;
    private JTable argsNameExecTable;
    private JScrollPane argsNameScrollPane;
    private JTable argsNameTable;
    private JTable argsPositionExecTable;
    private JScrollPane argsPositionScrollPane;
    private JScrollPane argsPositionScrollPane1;
    private JTable argsPositionTable;
    private JLabel argumentsExecLabel;
    private JLabel argumentsLabel;
    private JPanel bottomExecPanel;
    private JRadioButton byNameExecRadioButton;
    private JRadioButton byNameRadioButton;
    private JRadioButton byPosExecRadioButton;
    private JRadioButton byPosRadioButton;
    private JButton deleteExecButton;
    private JPanel execJPanel2;
    private JPanel execTopPanel;
    private JButton fetchArgumentsButton;
    private JButton firstExecButton;
    private JPanel jPanel1;
    private JPanel jobArgPositionExecPanel;
    private JPanel jobArgPositionPanel;
    private JTabbedPane jobArgsExecSettingsTabbedPane1;
    private JTabbedPane jobArgsSettingsTabbedPane1;
    private JButton lastExecButton;
    private JLabel nameExecLabel;
    private JTextField nameExecTextField;
    private JLabel nameLabel;
    private JButton nextExecButton;
    private JPanel numArgExecPanel;
    private JPanel numArgPanel;
    private JButton prevExecButton;
    private JTextField programTextField;
    private JPanel setJobArgNameExecPanel;
    private JPanel setJobArgNamePanel;
    private JPanel topExecPanel;
    private JPanel topPanel;

    public NewJobProgramArgumentPanel(String string, String string2) {
        this.connectionName = string;
        this.version = string2;
        this.initComponents();
    }

    public NewJobProgramArgumentPanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController, String string, String string2) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController);
        this.connectionName = string;
        this.version = string2;
        this.initComponents();
        this.refresh();
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.programTextField = new JTextField();
        this.argumentsLabel = new JLabel();
        this.jobArgPositionPanel = new JPanel();
        this.argsPositionScrollPane = new JScrollPane();
        this.argsPositionTable = new JTable();
        this.deleteExecButton = new JButton();
        this.addExecButton = new JButton();
        this.nameLabel.setText("Name");
        this.programTextField.setName("programTextField");
        this.argumentsLabel.setText("Arguments");
        this.jobArgPositionPanel.add(this.argsPositionScrollPane);
        JobArgumentPositionTableModel jobArgumentPositionTableModel = new JobArgumentPositionTableModel();
        jobArgumentPositionTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                NewJobProgramArgumentPanel.this.jobArgsPositionTableModelTableChanged(tableModelEvent);
            }
        });
        this.argsPositionTable.setModel(jobArgumentPositionTableModel);
        this.argsPositionTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.argsPositionTable.setName("argsPositionTable");
        this.argsPositionScrollPane.setViewportView(this.argsPositionTable);
        this.deleteExecButton.setName("deleteExecButton");
        this.addExecButton.setName("addExecButton");
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.add((Component)this.nameLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.topPanel.add((Component)this.programTextField, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.topPanel.add((Component)this.argumentsLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.topPanel.add((Component)this.argsPositionScrollPane, LayoutControl.GBC.gbc((int)0, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.topPanel, LayoutControl.GBC.DIALOG_MAIN_PANEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.model == null) {
            this.programTextField.setText("");
        } else {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                this.refreshing = true;
                try {
                    if (this.model.getJobTypeSelection() != null) {
                        if (this.model.getJobTypeSelection().equals(NewJobPropertyPanelModel.JOB_TYPE_NAMED_PROGRAM)) {
                            this.programTextField.setEnabled(true);
                            this.programTextField.setText(this.model.getNamedProgram());
                            this.programTextField.setEnabled(false);
                            this.fetchArguments();
                        } else if (this.model.getJobTypeSelection().equals(NewJobPropertyPanelModel.JOB_TYPE_STORED_PROCEDURE)) {
                            this.programTextField.setEnabled(true);
                            this.programTextField.setText(this.model.getStoredProcedure());
                            this.programTextField.setEnabled(false);
                            this.fetchArguments();
                        } else {
                            this.programTextField.setEnabled(false);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("setNamedProgramEvent")) {
                this.programTextField.setText(this.model.getNamedProgram());
                this.programTextField.setEnabled(false);
                this.fetchArguments();
            }
            if (propertyChangeEvent.getPropertyName().equals("setStoredProcedureEvent")) {
                this.programTextField.setText(this.model.getStoredProcedure());
                this.programTextField.setEnabled(false);
                this.fetchArguments();
            }
            if (propertyChangeEvent.getPropertyName().equals("set_job_arguments_executable")) {
                this.nameExecTextField.setText(this.model.getNamedProgram());
                this.nameExecTextField.setEnabled(false);
            }
            if (propertyChangeEvent.getPropertyName().equals("job_argument_list_cleared")) {
                while (((DefaultTableModel)this.argsPositionTable.getModel()).getRowCount() > 0) {
                    ((DefaultTableModel)this.argsPositionTable.getModel()).removeRow(0);
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("job_argument_list_retrived")) {
                List<NewJobPropertyPanelModel.JobArgument> list = this.model.getJobArguments();
                int n = 0;
                for (NewJobPropertyPanelModel.JobArgument jobArgument : list) {
                    Integer n2 = jobArgument.getArgumentPosition();
                    String string = jobArgument.getArgumentType();
                    String string2 = jobArgument.getArgumentName();
                    String string3 = jobArgument.getArgumentDefaultValue();
                    String string4 = jobArgument.getArgumentInOut();
                    if (string == null) {
                        string = "";
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                    ++n;
                    Object[] objectArray = new Object[]{n2, string2, string, string3, ""};
                    ((DefaultTableModel)this.argsPositionTable.getModel()).addRow(objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(NewJobPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
    }

    private void jobArgsPositionTableModelTableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        if (n > -1 && n2 > -1) {
            String string = (String)((DefaultTableModel)this.argsPositionTable.getModel()).getValueAt(n2, n);
            this.controller.updateJobArgumentAt(n2, string);
        }
    }

    private void jobArgsNameTableModelTableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        if (n > -1 && n2 > -1) {
            String string = (String)((DefaultTableModel)this.argsNameTable.getModel()).getValueAt(n2, n);
            this.controller.updateJobArgumentAt(n2, string);
        }
    }

    private void fetchArguments() {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        String string2 = this.model.getJobTypeSelection();
        if (string2.equals(NewJobPropertyPanelModel.JOB_TYPE_NAMED_PROGRAM)) {
            object4 = this.model.getNamedProgram();
            if (object4 == null) {
                return;
            }
            object3 = ((String)object4).replace(this.model.getSchema() + ".", "").trim();
            string = this.model.getSchema().trim();
            object2 = DBMSSchedulerCodeGenerator.getInstance();
            String string3 = ((DBMSSchedulerCodeGenerator)object2).generate(this.version, "PROGRAM_MODEL_PROGRAM_ARGUMENTS", null);
            object = new NewJobProgramArgumentDBTask(this.connectionName, (String)object3, string, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string3, NewJobPropertyPanelModel.PROG_ARGS_UPDATE_METHOD);
            RaptorTaskManager.getInstance().addTask((RaptorTask)object);
        }
        if (string2.equals(NewJobPropertyPanelModel.JOB_TYPE_STORED_PROCEDURE)) {
            object4 = DBMSSchedulerCodeGenerator.getInstance();
            object3 = new Hashtable();
            string = this.model.getSchema();
            object2 = this.model.getStoredProcedure();
            int n = ((String)object2).indexOf(46);
            if (n > 0) {
                object = ((String)object2).substring(0, n);
                object2 = ((String)object2).substring(n + 1);
            } else {
                object = null;
            }
            object3.put("schemaName", string);
            object3.put("procName", object2);
            if (object != null) {
                object3.put("packageName", object);
            }
            String string4 = ((DBMSSchedulerCodeGenerator)object4).generate(this.version, "PROGRAM_MODEL_PROCEDURE_ARGUMENTS", (Map<String, Object>)object3);
            NewJobProgramArgumentDBTask newJobProgramArgumentDBTask = new NewJobProgramArgumentDBTask(this.connectionName, null, string, this.model, SchedulerArb.getString("JOBCREATEDIALOG_CREATE_TASK"), string4, NewJobPropertyPanelModel.PROCEDURE_ARGUMENTS_UPDATE_METHOD);
            RaptorTaskManager.getInstance().addTask((RaptorTask)newJobProgramArgumentDBTask);
        }
    }

    private void byPosRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.controller.setJobArgSelectionChoice(1);
    }

    private void byNameRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.controller.setJobArgSelectionChoice(2);
        this.byPosRadioButton.setSelected(false);
        this.byNameRadioButton.setSelected(true);
        this.jobArgsSettingsTabbedPane1.setSelectedIndex(1);
    }

    private void jobArgsExecPositionTableModelTableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        if (n > -1 && n2 > -1) {
            String string = (String)((DefaultTableModel)this.argsPositionTable.getModel()).getValueAt(n2, n);
            this.controller.updateJobArgumentAt(n2, string);
        }
    }

    private void jobArgsExecNameTableModelTableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        if (n > -1 && n2 > -1) {
            String string = (String)((DefaultTableModel)this.argsNameTable.getModel()).getValueAt(n2, n);
            this.controller.updateJobArgumentAt(n2, string);
        }
    }

    private void deleteExecButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.jobArgsExecSettingsTabbedPane1.getSelectedIndex();
        int n2 = -1;
        if (n == 0) {
            n2 = this.argsPositionExecTable.getSelectedRow();
        } else if (n == 1) {
            n2 = this.argsNameExecTable.getSelectedRow();
        }
        if (n2 > 0) {
            ((DefaultTableModel)this.argsPositionExecTable.getModel()).removeRow(n2);
            ((DefaultTableModel)this.argsNameExecTable.getModel()).removeRow(n2);
            --this.serialNumberExecTable;
        }
    }

    private void addExecButtonActionPerformed(ActionEvent actionEvent) {
        if (this.serialNumberExecTable == 0) {
            this.firstExecButton.setEnabled(false);
            this.lastExecButton.setEnabled(false);
            this.prevExecButton.setEnabled(false);
            this.nextExecButton.setEnabled(false);
        } else {
            this.firstExecButton.setEnabled(true);
            this.lastExecButton.setEnabled(true);
            this.prevExecButton.setEnabled(true);
            this.nextExecButton.setEnabled(true);
        }
        ++this.serialNumberExecTable;
        Object[] objectArray = new Object[]{new Integer(this.serialNumberExecTable), "", ""};
        ((DefaultTableModel)this.argsPositionExecTable.getModel()).addRow(objectArray);
        Object[] objectArray2 = new Object[]{new Integer(this.serialNumberExecTable), "", ""};
        ((DefaultTableModel)this.argsNameExecTable.getModel()).addRow(objectArray2);
    }

    class JobArgumentPositionTableModel
    extends DefaultTableModel {
        String[] columnHeaders;

        public JobArgumentPositionTableModel() {
            this.columnHeaders = new String[]{"Position", "Name", "Type", "Default Value", "Value"};
            this.setColumnIdentifiers(this.columnHeaders);
        }

        public JobArgumentPositionTableModel(int n, int n2) {
            super(n, n2);
            this.columnHeaders = new String[]{"Position", "Name", "Type", "Default Value", "Value"};
            this.setColumnIdentifiers(this.columnHeaders);
        }
    }
}

