/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobProgramArgumentDBTask
extends DatabaseQueryTask<Boolean> {
    private String connectionName;
    private String objectName;
    private String objectOwner;
    private String taskName;
    private String query;
    private String statement;
    private Method method;
    private NewJobPropertyPanelModel model;

    public NewJobProgramArgumentDBTask(String string, String string2, String string3, NewJobPropertyPanelModel newJobPropertyPanelModel, String string4, String string5, String string6) {
        super(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false, true);
        this.connectionName = string;
        this.objectName = string2;
        this.objectOwner = string3;
        this.taskName = string4;
        this.query = string5;
        try {
            this.method = NewJobPropertyPanelModel.class.getMethod(string6, ResultSet.class);
        }
        catch (Exception exception) {
            this.method = null;
        }
        this.model = newJobPropertyPanelModel;
    }

    public NewJobProgramArgumentDBTask(String string, String string2, String string3, String string4, String string5) {
        super(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false, true);
        this.connectionName = string;
        this.objectName = string2;
        this.objectOwner = string3;
        this.taskName = string4;
        this.statement = string5;
    }

    public NewJobProgramArgumentDBTask(String string, String string2, String string3, NewJobPropertyPanelModel newJobPropertyPanelModel, String string4, String string5, Method method) {
        super(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false, true);
        this.connectionName = string;
        this.objectName = string2;
        this.objectOwner = string3;
        this.taskName = string4;
        this.query = string5;
        this.method = method;
        this.model = newJobPropertyPanelModel;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getQuery() {
        return this.taskName;
    }

    protected Boolean doWork() throws TaskException {
        if (this.statement != null) {
            return this.doWorkStatement();
        }
        return this.doWorkQuery();
    }

    protected Boolean doWorkStatement() throws TaskException {
        Connection connection;
        try {
            connection = DBUtil.getConnectionResolver().getConnection(this.getConnectionName());
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
        DBUtil.getConnectionResolver().lock(connection);
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.objectName != null) {
                hashMap.put("PROGRAM_NAME", this.objectName);
            }
            if (this.objectOwner != null) {
                hashMap.put("OWNER", this.objectOwner);
            }
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            Boolean bl = dBUtil.execute(this.statement, hashMap);
            return bl;
        }
        catch (Throwable throwable) {
            throw new TaskException(throwable);
        }
        finally {
            DBUtil.getConnectionResolver().unlock(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doWorkQuery() throws TaskException {
        Connection connection;
        try {
            connection = DBUtil.getConnectionResolver().getConnection(this.getConnectionName());
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
        DBUtil.getConnectionResolver().lock(connection);
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.objectName != null) {
                hashMap.put("PROGRAM_NAME", this.objectName);
            }
            if (this.objectOwner != null) {
                hashMap.put("OWNER", this.objectOwner);
            }
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.query, hashMap);
            try {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                if (this.model != null && resultSet != null) {
                    this.method.invoke((Object)this.model, resultSet);
                } else {
                    this.model = null;
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new TaskException(throwable);
        }
        finally {
            DBUtil.getConnectionResolver().unlock(connection);
        }
        return Boolean.TRUE;
    }
}

