/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;
import oracle.dbtools.util.Logger;

public class NewJobEmailNotificationPanel
extends NewJobParentPanel {
    private JCheckBox bodyDefaultCheckBox;
    private JTextArea bodyTextArea;
    private JLabel recipientsLabel;
    private JPanel notificationPanel;
    private JTextField recipientsTextField;
    private JList eventList;
    private JCheckBox eventListDefaultCheckBox;
    private JTextField filterConditionTextField;
    private JLabel selectEventLabel;
    private JLabel senderLabel;
    private JLabel bodyLabel;
    private JLabel subjectLabel;
    private JLabel filterConditionLabel;
    private JScrollPane eventListScrollPane;
    private JScrollPane bodyTextAreaScrollPane;
    private JCheckBox senderNullCheckBox;
    private JTextField senderTextField;
    private JCheckBox subjectDefaultCheckBox;
    private JTextField subjectTextField;
    private JButton resetToDefaultButton;
    private String[] emailEvents = NewJobPropertyPanelModel.JOBEVENT_LIST;

    public NewJobEmailNotificationPanel() {
        this.initComponents();
    }

    public NewJobEmailNotificationPanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController);
        this.initComponents();
        this.refresh();
    }

    private void initComponents() {
        this.notificationPanel = new JPanel();
        this.recipientsTextField = new JTextField();
        this.recipientsLabel = new JLabel();
        this.eventList = new JList<String>(this.emailEvents);
        this.eventListScrollPane = new JScrollPane(this.eventList);
        this.selectEventLabel = new JLabel();
        this.senderLabel = new JLabel();
        this.senderTextField = new JTextField();
        this.senderNullCheckBox = new JCheckBox();
        this.bodyTextAreaScrollPane = new JScrollPane();
        this.bodyTextArea = new JTextArea();
        this.bodyLabel = new JLabel();
        this.subjectLabel = new JLabel();
        this.subjectTextField = new JTextField();
        this.subjectDefaultCheckBox = new JCheckBox();
        this.filterConditionLabel = new JLabel();
        this.filterConditionTextField = new JTextField();
        this.bodyDefaultCheckBox = new JCheckBox();
        this.eventListDefaultCheckBox = new JCheckBox();
        this.resetToDefaultButton = new JButton();
        this.recipientsTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobEmailNotificationPanel.this.recipientsTextFieldMouseExited(mouseEvent);
            }
        });
        this.recipientsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.recipientsTextFieldActionPerformed(actionEvent);
            }
        });
        this.recipientsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewJobEmailNotificationPanel.this.recipientsTextFieldFocusLost(focusEvent);
            }
        });
        this.recipientsLabel.setText("Recipients");
        this.eventList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NewJobEmailNotificationPanel.this.eventListMouseClicked(mouseEvent);
            }
        });
        this.selectEventLabel.setText("Select Events");
        this.senderLabel.setText("Sender");
        this.senderTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobEmailNotificationPanel.this.senderTextFieldMouseExited(mouseEvent);
            }
        });
        this.senderTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.senderTextFieldActionPerformed(actionEvent);
            }
        });
        this.senderTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewJobEmailNotificationPanel.this.senderTextFieldFocusLost(focusEvent);
            }
        });
        this.senderNullCheckBox.setText("NULL");
        this.senderNullCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.senderNullCheckBoxActionPerformed(actionEvent);
            }
        });
        this.bodyTextArea.setColumns(20);
        this.bodyTextArea.setRows(5);
        this.bodyTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobEmailNotificationPanel.this.bodyTextAreaMouseExited(mouseEvent);
            }
        });
        this.bodyTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewJobEmailNotificationPanel.this.bodyTextAreaFocusLost(focusEvent);
            }
        });
        this.bodyTextArea.setName("bodyTextArea");
        this.bodyTextAreaScrollPane.setViewportView(this.bodyTextArea);
        this.bodyLabel.setText("Body");
        this.subjectLabel.setText("Subject");
        this.subjectTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobEmailNotificationPanel.this.subjectTextFieldMouseExited(mouseEvent);
            }
        });
        this.subjectTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.subjectTextFieldActionPerformed(actionEvent);
            }
        });
        this.subjectDefaultCheckBox.setText("Default");
        this.subjectDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.subjectDefaultCheckBoxActionPerformed(actionEvent);
            }
        });
        this.filterConditionLabel.setText("Filter condition");
        this.filterConditionTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NewJobEmailNotificationPanel.this.filterConditionTextFieldMouseExited(mouseEvent);
            }
        });
        this.filterConditionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.filterConditionTextFieldActionPerformed(actionEvent);
            }
        });
        this.filterConditionTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NewJobEmailNotificationPanel.this.filterConditionTextFieldFocusLost(focusEvent);
            }
        });
        this.bodyDefaultCheckBox.setText("Default");
        this.bodyDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.bodyDefaultCheckBoxActionPerformed(actionEvent);
            }
        });
        this.eventListDefaultCheckBox.setText("Default");
        this.eventListDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.eventListDefaultCheckBoxActionPerformed(actionEvent);
            }
        });
        this.resetToDefaultButton.setText("Reset to Defaults");
        this.resetToDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobEmailNotificationPanel.this.resetToDefaultCheckBoxActionPerformed(actionEvent);
            }
        });
        this.recipientsTextField.setName("recipientsTextField");
        this.senderTextField.setName("senderTextField");
        this.senderNullCheckBox.setName("senderNullCheckBox");
        this.subjectDefaultCheckBox.setName("subjectDefaultCheckBox");
        this.filterConditionTextField.setName("filterConditionTextField");
        this.bodyDefaultCheckBox.setName("bodyDefaultCheckBox");
        this.eventListDefaultCheckBox.setName("eventListDefaultCheckBox");
        this.notificationPanel.setLayout(new GridBagLayout());
        this.notificationPanel.add((Component)this.recipientsLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        this.notificationPanel.add((Component)this.recipientsTextField, LayoutControl.GBC.gbc((int)1, (int)0, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.notificationPanel.add((Component)this.senderLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.notificationPanel.add((Component)this.senderTextField, LayoutControl.GBC.gbc((int)1, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.notificationPanel.add((Component)this.subjectLabel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.notificationPanel.add((Component)this.subjectTextField, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.notificationPanel.add((Component)this.bodyLabel, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.notificationPanel.add((Component)this.bodyTextAreaScrollPane, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.notificationPanel.add((Component)this.selectEventLabel, LayoutControl.GBC.gbc((int)0, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        this.notificationPanel.add((Component)this.eventListScrollPane, LayoutControl.GBC.gbc((int)1, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.notificationPanel.add((Component)this.filterConditionLabel, LayoutControl.GBC.gbc((int)0, (int)5, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.notificationPanel.add((Component)this.filterConditionTextField, LayoutControl.GBC.gbc((int)1, (int)5, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.notificationPanel.add((Component)this.resetToDefaultButton, LayoutControl.GBC.gbc((int)0, (int)6, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.notificationPanel.add(Box.createGlue(), LayoutControl.GBC.gbc((int)0, (int)7, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.notificationPanel, LayoutControl.GBC.DIALOG_MAIN_PANEL);
    }

    private void recipientsTextFieldActionPerformed(ActionEvent actionEvent) {
        String string = this.recipientsTextField.getText().trim();
        if (string != null && string.length() > 0) {
            this.activateFields(true);
        } else {
            this.activateFields(false);
        }
        this.controller.setEmailRecipients(string);
    }

    private void activateFields(boolean bl) {
        this.senderTextField.setEnabled(bl);
        this.senderNullCheckBox.setEnabled(bl);
        this.subjectDefaultCheckBox.setEnabled(bl);
        this.subjectTextField.setEnabled(bl);
        this.bodyTextArea.setEnabled(bl);
        this.bodyDefaultCheckBox.setEnabled(bl);
        this.eventListDefaultCheckBox.setEnabled(bl);
        this.eventList.setEnabled(bl);
        this.filterConditionTextField.setEnabled(bl);
    }

    private void recipientsTextFieldMouseExited(MouseEvent mouseEvent) {
        String string = this.recipientsTextField.getText().trim();
        this.controller.setEmailRecipients(string);
    }

    private void recipientsTextFieldFocusLost(FocusEvent focusEvent) {
        String string = this.recipientsTextField.getText().trim();
        this.controller.setEmailRecipients(string);
    }

    private void senderTextFieldActionPerformed(ActionEvent actionEvent) {
        this.controller.setEmailSender(this.senderTextField.getText());
    }

    private void senderTextFieldMouseExited(MouseEvent mouseEvent) {
        this.controller.setEmailSender(this.senderTextField.getText());
    }

    private void senderTextFieldFocusLost(FocusEvent focusEvent) {
        this.controller.setEmailSender(this.senderTextField.getText());
    }

    private void senderNullCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.senderNullCheckBox.isSelected()) {
            this.senderTextField.setEnabled(false);
        } else {
            this.senderTextField.setEnabled(true);
        }
        this.controller.setEmailSender("");
    }

    private void subjectDefaultCheckBoxActionPerformed(ActionEvent actionEvent) {
        String string = "Oracle Scheduler Job Notification - " + this.model.getSchema() + "." + this.model.getJobName();
        this.controller.setEmailSubject(string);
        if (this.subjectDefaultCheckBox.isSelected()) {
            this.subjectTextField.setEnabled(false);
        } else {
            this.subjectTextField.setEnabled(true);
        }
    }

    private void subjectTextFieldActionPerformed(ActionEvent actionEvent) {
        this.controller.setEmailSubject(this.subjectTextField.getText());
    }

    private void subjectTextFieldMouseExited(MouseEvent mouseEvent) {
        this.controller.setEmailSubject(this.subjectTextField.getText());
    }

    private void bodyTextAreaMouseExited(MouseEvent mouseEvent) {
        this.controller.setEmailBody(this.bodyTextArea.getText());
    }

    private void bodyTextAreaFocusLost(FocusEvent focusEvent) {
        this.controller.setEmailBody(this.bodyTextArea.getText());
    }

    private void bodyDefaultCheckBoxActionPerformed(ActionEvent actionEvent) {
        String string = "Oracle Scheduler Job Notification - " + this.model.getSchema() + "." + this.model.getJobName();
        this.controller.setEmailBody(string);
        if (this.bodyDefaultCheckBox.isSelected()) {
            this.bodyTextArea.setEnabled(false);
        } else {
            this.bodyTextArea.setEnabled(true);
        }
    }

    private void eventListMouseClicked(MouseEvent mouseEvent) {
        Object[] objectArray = this.eventList.getSelectedValues();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        this.controller.setEmailSelectedEvents(stringArray);
    }

    private void eventListDefaultCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.eventListDefaultCheckBox.isSelected()) {
            this.eventList.setEnabled(false);
        } else {
            this.eventList.setEnabled(true);
        }
        String[] stringArray = new String[]{"JOB_FAILED,JOB_BROKEN", "JOB_SCH_LIM_REACHED", "JOB_CHAIN_STALLED", "JOB_OVER_MAX_DUR"};
        this.controller.setEmailSelectedEvents(stringArray);
    }

    private void resetToDefaultCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.controller.setEmailSender("");
        this.controller.setEmailRecipients("");
        this.controller.setEmailBody(this.model.getDefaultEmailBody());
        this.controller.setEmailSelectedEvents(this.model.getDefaultEmailSelectedEvents());
        this.controller.setEmailSubject(this.model.getDefaultEmailSubject());
        this.controller.setEmailFilterCondition("");
    }

    private void filterConditionTextFieldActionPerformed(ActionEvent actionEvent) {
        this.controller.setEmailFilterCondition(this.filterConditionTextField.getText());
    }

    private void filterConditionTextFieldMouseExited(MouseEvent mouseEvent) {
        this.controller.setEmailFilterCondition(this.filterConditionTextField.getText());
    }

    private void filterConditionTextFieldFocusLost(FocusEvent focusEvent) {
        this.controller.setEmailFilterCondition(this.filterConditionTextField.getText());
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("emailRecipientsEvent")) {
                this.recipientsTextField.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("emailSenderEvent")) {
                this.senderTextField.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("emailFilterConditionEvent")) {
                this.filterConditionTextField.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("emailNotificationBodyChangeEvent")) {
                this.bodyTextArea.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("emailNotificationSubjectChangeEvent")) {
                this.subjectTextField.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("emailNotificationEventsChangeEvent")) {
                String[] stringArray = (String[])propertyChangeEvent.getNewValue();
                int[] nArray = new int[stringArray.length];
                int n = 0;
                for (String string : stringArray) {
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[0])) {
                        nArray[n] = 0;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[1])) {
                        nArray[n] = 1;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[2])) {
                        nArray[n] = 2;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[3])) {
                        nArray[n] = 3;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[4])) {
                        nArray[n] = 4;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[5])) {
                        nArray[n] = 5;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[6])) {
                        nArray[n] = 6;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[7])) {
                        nArray[n] = 7;
                    }
                    if (string.equals(NewJobPropertyPanelModel.JOBEVENT_LIST[8])) {
                        nArray[n] = 8;
                    }
                    ++n;
                }
                this.eventList.setSelectedIndices(nArray);
            }
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.model == null) {
            this.recipientsTextField.setText("");
            this.bodyTextArea.setText("");
            this.subjectTextField.setText("");
            this.eventList.setSelectedIndex(0);
            this.senderTextField.setText("");
            this.filterConditionTextField.setText("");
        } else {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                this.refreshing = true;
                try {
                    this.recipientsTextField.setText(this.model.getEmailRecipients());
                    this.bodyTextArea.setText(this.model.getEmailBody());
                    this.subjectTextField.setText(this.model.getEmailSubject());
                    this.senderTextField.setText(this.model.getEmailSender());
                    this.eventList.setSelectedIndices(new int[]{5, 1, 8, 2, 6});
                    this.filterConditionTextField.setText(this.model.getEmailFilterCondition());
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }
}

