/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobDestinationMultipleExternalPanel
extends NewJobParentPanel {
    private JLabel destinationLabel;
    private JComboBox credentialComboBox;
    private JLabel credentialLabel;
    private JComboBox destinationComboBox;
    private JLabel headerLabel;
    private JPanel multipleExternalPanel;

    public NewJobDestinationMultipleExternalPanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController);
        this.initComponents();
        this.refresh();
    }

    private void initComponents() {
        this.multipleExternalPanel = new JPanel();
        this.credentialLabel = new JLabel();
        this.credentialComboBox = new JComboBox();
        this.destinationLabel = new JLabel();
        this.destinationComboBox = new JComboBox();
        this.headerLabel = new JLabel();
        this.credentialLabel.setText("Credentials Group");
        this.credentialComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.credentialComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobDestinationMultipleExternalPanel.this.credentialComboBoxActionPerformed(actionEvent);
            }
        });
        this.destinationLabel.setText("External Destination Group ");
        this.destinationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.destinationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobDestinationMultipleExternalPanel.this.destinationComboBoxActionPerformed(actionEvent);
            }
        });
        this.headerLabel.setText("Select a Credential Group and an External Destination Group");
        this.credentialComboBox.setName("credentialComboBox");
        this.multipleExternalPanel.setLayout(new GridBagLayout());
        this.multipleExternalPanel.add((Component)this.headerLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.multipleExternalPanel.add((Component)this.credentialLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.multipleExternalPanel.add((Component)this.credentialComboBox, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.multipleExternalPanel.add((Component)this.destinationLabel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.multipleExternalPanel.add((Component)this.destinationComboBox, LayoutControl.GBC.gbc((int)1, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.multipleExternalPanel.add(Box.createGlue(), LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.setLayout(new BorderLayout());
        this.add((Component)this.multipleExternalPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void credentialComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                if (!this.refreshing) {
                    if (this.credentialComboBox.getSelectedIndex() == -1) {
                        this.controller.setMultipleCredentialSelection(null);
                    } else {
                        String string = (String)this.credentialComboBox.getSelectedItem();
                        this.controller.setMultipleCredentialSelection(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destinationComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                if (!this.refreshing) {
                    if (this.destinationComboBox.getSelectedIndex() == -1) {
                        this.controller.setMultipleExternalDestinationSelection(null);
                    } else {
                        String string = (String)this.destinationComboBox.getSelectedItem();
                        this.controller.setMultipleExternalDestinationSelection(string);
                    }
                }
            }
        }
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            List list;
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("jobWheresMultipleCred")) {
                List list2 = (List)propertyChangeEvent.getNewValue();
                if (list2 != null) {
                    this.credentialComboBox.removeAllItems();
                    DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list2.toArray());
                    this.credentialComboBox.setModel(defaultComboBoxModel);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("jobWheresMultipleExternalDest") && (list = (List)propertyChangeEvent.getNewValue()) != null) {
                this.destinationComboBox.removeAllItems();
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                this.destinationComboBox.setModel(defaultComboBoxModel);
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(NewJobPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh() {
        if (this.model == null) {
            this.credentialComboBox.removeAllItems();
            this.destinationComboBox.removeAllItems();
        } else {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                this.refreshing = true;
                try {
                    try {
                        Object object;
                        this.credentialComboBox.removeAllItems();
                        List<String> list = this.model.getMultipleCredentialList();
                        if (list != null) {
                            object = new DefaultComboBoxModel<Object>(list.toArray());
                            this.credentialComboBox.setModel(object);
                        }
                        this.credentialComboBox.setSelectedItem(this.model.getCredentialName());
                        this.destinationComboBox.removeAllItems();
                        object = this.model.getMultipleExternalDestinationList();
                        if (object != null) {
                            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(object.toArray());
                            this.destinationComboBox.setModel(defaultComboBoxModel);
                        }
                        this.destinationComboBox.setSelectedItem(this.model.getDestinationName());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }

    private void clearPanel(JPanel jPanel) {
        jPanel.removeAll();
        jPanel.validate();
        jPanel.repaint();
    }

    private void revalidatePanel(JPanel jPanel) {
        jPanel.revalidate();
        jPanel.repaint();
    }
}

