/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobDestinationLocalPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobDestinationMultiplePanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobDestinationRemotePanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobDestinationCommonPanel
extends NewJobParentPanel
implements LayoutControl {
    private CardLayoutPanel whereJobPanel;
    Map<String, JPanel> jobDestinationPanelMap;

    public NewJobDestinationCommonPanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refresh();
    }

    private void jbInit() throws Exception {
        this.jobDestinationPanelMap = new Hashtable<String, JPanel>();
        this.jobDestinationPanelMap.put(NewJobPropertyPanelModel.JOB_WHERE_LOCAL, new NewJobDestinationLocalPanel(null, this.model, this.controller));
        this.jobDestinationPanelMap.put(NewJobPropertyPanelModel.JOB_WHERE_REMOTE, new NewJobDestinationRemotePanel(null, this.model, this.controller));
        this.jobDestinationPanelMap.put(NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE, new NewJobDestinationMultiplePanel(null, this.model, this.controller));
        this.whereJobPanel = new CardLayoutPanel(this.jobDestinationPanelMap, "", CardLayoutPanel.Type.PLAIN);
        this.whereJobPanel.setSelectedItem((Object)NewJobPropertyPanelModel.JOB_WHERE_LOCAL);
        this.controller.setWhereJobSelection((String)this.whereJobPanel.getSelectedItem());
        this.whereJobPanel.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (1 == itemEvent.getStateChange()) {
                    String string = itemEvent.getItem().toString();
                    NewJobPropertyPanelModel newJobPropertyPanelModel = NewJobDestinationCommonPanel.this.model;
                    synchronized (newJobPropertyPanelModel) {
                        NewJobDestinationCommonPanel.this.controller.setWhereJobSelection(string);
                    }
                    NewJobDestinationCommonPanel.this.getRelevantPanel();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.whereJobPanel, "Center");
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("setWhereSelectionEvent")) {
                String string = (String)propertyChangeEvent.getNewValue();
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(NewJobPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
    }

    @Override
    protected void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRelevantPanel() {
        if (this.model != null && this.controller != null) {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                NewJobParentPanel newJobParentPanel;
                String string = this.model.getDestinationSelection();
                if (string.equals(NewJobPropertyPanelModel.JOB_WHERE_LOCAL)) {
                    this.whereJobPanel.setSelectedItem((Object)NewJobPropertyPanelModel.JOB_WHERE_LOCAL);
                    newJobParentPanel = (NewJobDestinationLocalPanel)this.jobDestinationPanelMap.get(NewJobPropertyPanelModel.JOB_WHERE_LOCAL);
                    ((NewJobDestinationLocalPanel)newJobParentPanel).updatePanel();
                }
                if (string.equals(NewJobPropertyPanelModel.JOB_WHERE_REMOTE)) {
                    this.whereJobPanel.setSelectedItem((Object)NewJobPropertyPanelModel.JOB_WHERE_REMOTE);
                    newJobParentPanel = (NewJobDestinationRemotePanel)this.jobDestinationPanelMap.get(NewJobPropertyPanelModel.JOB_WHERE_REMOTE);
                    ((NewJobDestinationRemotePanel)newJobParentPanel).updatePanel();
                }
                if (string.equals(NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE)) {
                    this.whereJobPanel.setSelectedItem((Object)NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE);
                    newJobParentPanel = (NewJobDestinationMultiplePanel)this.jobDestinationPanelMap.get(NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE);
                    ((NewJobDestinationMultiplePanel)newJobParentPanel).updatePanel();
                }
            }
        }
    }

    private void clearPanel(JPanel jPanel) {
        jPanel.removeAll();
        jPanel.validate();
        jPanel.repaint();
    }

    private void revalidatePanel(JPanel jPanel) {
        jPanel.revalidate();
        jPanel.repaint();
    }
}

