/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.groups;

import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class GroupDropAction
extends ActionDialog {
    private static final String GROUP_NAME = "name";
    private static final String FORCE = "force";
    private static final String DROP_MSG = "msg";
    private String groupName;
    private boolean force = false;

    public GroupDropAction() {
        this.setScriptEditingEnabled(false);
    }

    protected List<ActionControl> createControls(Connection connection) {
        try {
            String string = this.getObjectName();
            this.groupName = "\"" + string + "\"";
        }
        catch (Exception exception) {
            return null;
        }
        try {
            String string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
            if (GroupDropAction.checkNull(string) != null) {
                this.groupName = "\"" + string + "\"." + this.groupName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(GROUP_NAME, SchedulerArb.getString("GROUP_DROP_NAME_LABEL"), this.groupName);
        LabelActionControl labelActionControl = new LabelActionControl(DROP_MSG, SchedulerArb.getString("GROUP_DROP_LABEL"));
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(FORCE, SchedulerArb.getString("GROUP_DROP_FORCE_LABEL"), this.force);
        Vector<ActionControl> vector = new Vector<ActionControl>();
        textBoxActionControl.setEditable(false);
        vector.add((ActionControl)textBoxActionControl);
        vector.add((ActionControl)booleanCheckBoxActionControl);
        vector.add((ActionControl)labelActionControl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(FORCE);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(GROUP_NAME, this.groupName);
        treeMap.put(FORCE, string2);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string3 = null;
        string3 = dBMSSchedulerCodeGenerator.generate(string, "GROUP_DROP", treeMap2);
        return string3;
    }

    protected String getTitle() {
        return SchedulerArb.getString("GROUP_DROP_ACTION_TITLE");
    }

    public static String checkNull(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String checkQuotes(String string) {
        if ((string = GroupDropAction.checkNull(string)) != null && string.length() > 0) {
            string = string.replace("'", "''");
        }
        return string;
    }
}

