/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseComplexity;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.CombinedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NamedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.PreDefinedFrequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelContext;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UnaryClauseModel;
import oracle.javatools.util.Version;

public class RepeatIntervalModel {
    public static final int MAX_INTERVAL_PROPERTY = 0;
    public static final int MIN_INTERVAL_PROPERTY = 1;
    public static final int MAX_SETPOS_PROPERTY = 2;
    public static final int MIN_SETPOS_PROPERTY = 3;
    public static final int MAX_PERIODS_PROPERTY = 4;
    public static final int MIN_PERIODS_PROPERTY = 5;
    public static final int MAX_PERIOD_PROPERTY = 6;
    public static final int MIN_PERIOD_PROPERTY = 7;
    public static final int MAX_BYPERIOD_PROPERTY = 8;
    public static final int MIN_BYPERIOD_PROPERTY = 9;
    public static final int MAX_BYSUBPERIOD_PROPERTY = 10;
    public static final int MIN_BYSUBPERIOD_PROPERTY = 11;
    public static final int MAX_YEARDAY_PROPERTY = 12;
    public static final int MIN_YEARDAY_PROPERTY = 13;
    public static final int MAX_WEEKNO_PROPERTY = 14;
    public static final int MIN_WEEKNO_PROPERTY = 15;
    public static final int MAX_MONTHDAY_PROPERTY = 16;
    public static final int MIN_MONTHDAY_PROPERTY = 17;
    public static final int MAX_MONTH_PROPERTY = 18;
    public static final int MIN_MONTH_PROPERTY = 19;
    public static final int MAX_DAY_PROPERTY = 20;
    public static final int MIN_DAY_PROPERTY = 21;
    public static final int MAX_HOUR_PROPERTY = 22;
    public static final int MIN_HOUR_PROPERTY = 23;
    public static final int MAX_MINUTE_PROPERTY = 24;
    public static final int MIN_MINUTE_PROPERTY = 25;
    public static final int MAX_SECOND_PROPERTY = 26;
    public static final int MIN_SECOND_PROPERTY = 27;
    public static final int YEARLY_MAX_INTERVAL_VALUE = 99;
    public static final int MONTHLY_MAX_INTERVAL_VALUE = 99;
    public static final int WEEKLY_MAX_INTERVAL_VALUE = 49;
    public static final int DAILY_MAX_INTERVAL_VALUE = 199;
    public static final int HOURLY_MAX_INTERVAL_VALUE = 1999;
    public static final int MINUTELY_MAX_INTERVAL_VALUE = 2999;
    public static final int SECONDLY_MAX_INTERVAL_VALUE = 7999;
    public static final int DEFAULT_MAX_INTERVAL_VALUE = 999;
    public static final int MAX_INTERVAL_VALUE = 7999;
    public static final int MIN_INTERVAL_VALUE = 1;
    public static final int MAX_SETPOS_VALUE = 9999;
    public static final int MIN_SETPOS_VALUE = -9999;
    public static final int MAX_PERIODS_VALUE = 100;
    public static final int MIN_PERIODS_VALUE = 1;
    public static final int MAX_PERIOD_VALUE = 100;
    public static final int MIN_PERIOD_VALUE = 1;
    public static final int MAX_BYPERIOD_VALUE = 100;
    public static final int MIN_BYPERIOD_VALUE = 1;
    public static final int MAX_BYSUBPERIOD_VALUE = 100;
    public static final int MIN_BYSUBPERIOD_VALUE = 1;
    public static final int MAX_YEARDAY_VALUE = 366;
    public static final int MIN_YEARDAY_VALUE = -366;
    public static final int MAX_WEEKNO_VALUE = 53;
    public static final int MIN_WEEKNO_VALUE = 1;
    public static final int MAX_MONTHDAY_VALUE = 31;
    public static final int MIN_MONTHDAY_VALUE = 1;
    public static final int MAX_MONTH_VALUE = 12;
    public static final int MIN_MONTH_VALUE = 1;
    public static final int MONTHLY_MAX_DAY_VALUE = 5;
    public static final int MONTHLY_MIN_DAY_VALUE = -5;
    public static final int YEARLY_MAX_DAY_VALUE = 53;
    public static final int YEARLY_MIN_DAY_VALUE = -53;
    public static final int DEFAULT_MAX_DAY_VALUE = 53;
    public static final int DEFAULT_MIN_DAY_VALUE = -53;
    public static final int MAX_HOUR_VALUE = 23;
    public static final int MIN_HOUR_VALUE = 0;
    public static final int MAX_MINUTE_VALUE = 59;
    public static final int MIN_MINUTE_VALUE = 0;
    public static final int MAX_SECOND_VALUE = 59;
    public static final int MIN_SECOND_VALUE = 0;
    public static final Integer NON_INDEX = -1;
    Object[][] propertyTable = new Object[][]{{7999, Arrays.asList(ClauseType.INTERVAL)}, {1, Arrays.asList(ClauseType.INTERVAL)}, {9999, Arrays.asList(ClauseType.BYSETPOS)}, {-9999, Arrays.asList(ClauseType.BYSETPOS)}, {100, ClauseType.PERIODS}, {1, ClauseType.PERIODS}, {100, ClauseType.PERIOD}, {1, ClauseType.PERIOD}, {100, ClauseType.BYPERIOD}, {1, ClauseType.BYPERIOD}, {100, ClauseType.BYSUBPERIOD}, {1, ClauseType.BYSUBPERIOD}, {366, null}, {-366, null}, {53, null}, {1, null}, {31, null}, {1, null}, {12, ClauseType.BYMONTH}, {1, ClauseType.BYMONTH}, {53, ClauseType.BYDAY}, {-53, ClauseType.BYDAY}, {23, ClauseType.BYHOUR}, {0, ClauseType.BYHOUR}, {59, ClauseType.BYMINUTE}, {0, ClauseType.BYMINUTE}, {59, ClauseType.BYSECOND}, {0, ClauseType.BYSECOND}};
    protected final RepeatIntervalModelContext context;
    protected EventListenerList modelEventListeners = new EventListenerList();
    Map<ClauseType, ClauseModel> clauseModelMap = new HashMap<ClauseType, ClauseModel>();

    public RepeatIntervalModel(RepeatIntervalModelContext repeatIntervalModelContext) {
        this.context = repeatIntervalModelContext;
    }

    public RepeatIntervalModelContext getContext() {
        return this.context;
    }

    public Object[] getAll(ClauseType clauseType) {
        ClauseModel clauseModel = this.clauseModelMap.get((Object)clauseType);
        return clauseModel.getAll();
    }

    public void clear(ClauseType clauseType) {
        ClauseModel clauseModel = this.clauseModelMap.get((Object)clauseType);
        clauseModel.clear();
    }

    public ClauseModel getClauseModel(ClauseType clauseType) {
        return this.clauseModelMap.get((Object)clauseType);
    }

    public void registerClauseModel(ClauseModel clauseModel) {
        this.clauseModelMap.put(clauseModel.getClauseType(), clauseModel);
    }

    public void unregisterClauseModel(ClauseModel clauseModel) {
        this.clauseModelMap.remove(clauseModel);
    }

    public Frequency getFreq() {
        UnaryClauseModel unaryClauseModel = (UnaryClauseModel)this.getClauseModel(ClauseType.FREQ);
        if (unaryClauseModel != null) {
            return (Frequency)unaryClauseModel.get();
        }
        return null;
    }

    public void setFreq(Frequency frequency) {
        UnaryClauseModel unaryClauseModel = (UnaryClauseModel)this.getClauseModel(ClauseType.FREQ);
        if (unaryClauseModel != null) {
            unaryClauseModel.set(frequency);
        }
    }

    public void clearAllModels() {
        this.clearExceptModel(null);
    }

    public void clearAllModels(ClauseType[] clauseTypeArray) {
        if (clauseTypeArray != null) {
            for (ClauseType clauseType : clauseTypeArray) {
                ClauseModel clauseModel;
                if (clauseType == null || (clauseModel = this.getClauseModel(clauseType)) == null) continue;
                clauseModel.clear();
            }
        } else {
            this.clearAllModels();
        }
    }

    public void clearExceptModel(ClauseType clauseType) {
        ClauseType[] clauseTypeArray = new ClauseType[]{clauseType};
        this.clearExceptModels(clauseTypeArray);
    }

    public void clearExceptModels(ClauseType[] clauseTypeArray) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (clauseTypeArray != null) {
            for (ClauseType clauseType : clauseTypeArray) {
                if (clauseType == null) continue;
                treeSet.add((Object)clauseType);
            }
        }
        for (Map.Entry entry : this.clauseModelMap.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null || treeSet.contains(entry.getKey())) continue;
            ((ClauseModel)entry.getValue()).clear();
        }
    }

    public void addRepeatIntervalModelListener(RepeatIntervalModelListener repeatIntervalModelListener) {
        this.modelEventListeners.add(RepeatIntervalModelListener.class, repeatIntervalModelListener);
    }

    public void removeRepeatIntervalModelListener(RepeatIntervalModelListener repeatIntervalModelListener) {
        this.modelEventListeners.remove(RepeatIntervalModelListener.class, repeatIntervalModelListener);
    }

    void fireRepeatIntervalModelEvent(RepeatIntervalModelEvent repeatIntervalModelEvent) {
        if (repeatIntervalModelEvent == null) {
            repeatIntervalModelEvent = new RepeatIntervalModelEvent(this);
        }
        this.preRepeatIntervalChanged(repeatIntervalModelEvent);
        Object[] objectArray = this.modelEventListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RepeatIntervalModelListener.class) continue;
            ((RepeatIntervalModelListener)objectArray[i + 1]).repeatIntervalChanged(repeatIntervalModelEvent);
        }
        this.postRepeatIntervalChanged(repeatIntervalModelEvent);
    }

    public static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedSchedule[] getNamedScheduleList() {
        Connection connection = this.context.getConnection();
        if (connection != null) {
            ArrayList<NamedSchedule> arrayList = new ArrayList<NamedSchedule>();
            String string = this.getQuery(connection, "getSchedules");
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        arrayList.add(new NamedSchedule(string2, string3));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return arrayList.toArray(new NamedSchedule[arrayList.size()]);
        }
        return new NamedSchedule[0];
    }

    protected void preRepeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
        switch (repeatIntervalModelEvent.getClauseType()) {
            case FREQ: {
                if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.REFRESH) break;
                ClauseType[] clauseTypeArray = new ClauseType[]{ClauseType.FREQ};
                this.clearExceptModels(clauseTypeArray);
                break;
            }
            case COMBINEDSCHED: {
                Object[] objectArray;
                Class<?> clazz;
                Object object;
                if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || (object = repeatIntervalModelEvent.getNewValue()) == null || (clazz = object.getClass()).isArray() && (objectArray = (CombinedSchedule[])object).length == 0) break;
                objectArray = new ClauseType[]{ClauseType.COMBINEDSCHED, ClauseType.EMBEDDEDSCHED};
                this.clearExceptModels((ClauseType[])objectArray);
                break;
            }
            case PERIODS: {
                Integer[] integerArray;
                SortedClauseModel sortedClauseModel;
                Integer n;
                if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || (n = (Integer)repeatIntervalModelEvent.getNewValue()) == null || (sortedClauseModel = (SortedClauseModel)this.getClauseModel(ClauseType.BYPERIOD)) == null) break;
                for (Integer n2 : integerArray = sortedClauseModel.getTailList(n, false)) {
                    sortedClauseModel.remove(n2);
                }
                break;
            }
            case PERIOD: {
                Integer[] integerArray;
                SortedClauseModel sortedClauseModel;
                Integer n;
                if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE || (n = (Integer)repeatIntervalModelEvent.getNewValue()) == null || (sortedClauseModel = (SortedClauseModel)this.getClauseModel(ClauseType.BYSUBPERIOD)) == null) break;
                for (Integer n3 : integerArray = sortedClauseModel.getTailList(n, false)) {
                    sortedClauseModel.remove(n3);
                }
                break;
            }
        }
    }

    protected void postRepeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(RepeatIntervalModel.class, (Connection)connection, (String)string);
    }

    public ClauseComplexity getClauseComplexity() {
        Frequency frequency = this.getFreq();
        if (frequency instanceof PreDefinedFrequency) {
            Version version = this.context.getVersion();
            int[] nArray = version.toIntArray();
            if (nArray[0] < 12) {
                PreDefinedFrequency preDefinedFrequency = (PreDefinedFrequency)frequency;
                switch (preDefinedFrequency) {
                    case YEARLY: {
                        return ClauseComplexity.BASIC;
                    }
                    case MINUTELY: 
                    case SECONDLY: {
                        return ClauseComplexity.ADVANCED;
                    }
                }
                return ClauseComplexity.BASIC;
            }
            return ClauseComplexity.BASIC;
        }
        return ClauseComplexity.ADVANCED;
    }
}

