/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Identifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;

public class QualifiedIdentifier
implements Comparable<QualifiedIdentifier>,
Identifier {
    protected final String orig;
    protected final IdentifierImpl userName;
    protected final IdentifierImpl objectName;
    protected final IdentifierImpl subObjectName;

    public QualifiedIdentifier(String string, String string2) {
        this(string, string2, null);
    }

    public QualifiedIdentifier(String string, String string2, String string3) {
        this.userName = new IdentifierImpl(string);
        this.objectName = new IdentifierImpl(string2);
        this.subObjectName = new IdentifierImpl(string3);
        this.orig = this.getId();
    }

    public QualifiedIdentifier(String string) {
        this.orig = string;
        if (string == null) {
            this.userName = new IdentifierImpl(null);
            this.objectName = new IdentifierImpl(null);
            this.subObjectName = new IdentifierImpl(null);
        } else {
            int n = this.getFullStopIndex(string);
            this.userName = new IdentifierImpl(n != -1 ? string.substring(0, n) : null);
            if (n != -1) {
                string = string.length() > n + 1 ? string.substring(n + 1) : "";
            }
            this.objectName = new IdentifierImpl((n = this.getFullStopIndex(string)) == -1 ? string : string.substring(0, n));
            string = n != -1 ? (string.length() > n + 1 ? string.substring(n + 1) : "") : null;
            this.subObjectName = new IdentifierImpl(string);
        }
    }

    protected int getFullStopIndex(String string) {
        if (string == null) {
            return -1;
        }
        if (string.startsWith("\"")) {
            Pattern pattern = Pattern.compile("([\"]([^\"]|([\"][\"]))+[\"])[.]");
            Matcher matcher = pattern.matcher(string);
            boolean bl = matcher.find();
            if (bl) {
                if (matcher.start() == 0) {
                    return matcher.end() - 1;
                }
            } else {
                pattern = Pattern.compile("([\"]([^\"]|([\"][\"]))+[\"])");
                matcher = pattern.matcher(string);
                bl = matcher.find();
                if (bl && matcher.start() == 0) {
                    return matcher.end();
                }
            }
        }
        return string.indexOf(".");
    }

    public String toString() {
        return this.orig;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        QualifiedIdentifier qualifiedIdentifier = (QualifiedIdentifier)object;
        return QualifiedIdentifier.areEqual(this.userName, qualifiedIdentifier.userName) && QualifiedIdentifier.areEqual(this.objectName, qualifiedIdentifier.objectName);
    }

    @Override
    public int compareTo(QualifiedIdentifier qualifiedIdentifier) {
        int n = 0;
        if (this != qualifiedIdentifier) {
            if (this.userName != qualifiedIdentifier.userName) {
                n = this.userName == null && qualifiedIdentifier.userName != null ? -1 : (this.userName != null && qualifiedIdentifier.userName == null ? 1 : this.userName.compareTo(qualifiedIdentifier.userName));
            }
            if (n == 0 && this.objectName != qualifiedIdentifier.objectName) {
                n = this.objectName == null && qualifiedIdentifier.objectName != null ? -1 : (this.objectName != null && qualifiedIdentifier.objectName == null ? 1 : this.objectName.compareTo(qualifiedIdentifier.objectName));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        n = n * 31 + (this.objectName == null ? 0 : this.objectName.hashCode());
        return n;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public String getObjectName() {
        return this.objectName.toString();
    }

    public String getSubObjectName() {
        return this.subObjectName.toString();
    }

    public Identifier getUserNameId() {
        return this.userName;
    }

    public Identifier getObjectNameId() {
        return this.objectName;
    }

    public Identifier getSubObjectNameId() {
        return this.subObjectName;
    }

    @Override
    public String getId(Boolean bl) {
        String string = this.userName.getId(bl);
        String string2 = this.objectName.getId(bl);
        String string3 = this.subObjectName == null ? null : this.subObjectName.getId(bl);
        String string4 = "" + (string != null ? string + "." : "") + (string2 != null ? string2 : "") + (string3 != null && string3.length() > 0 && !string3.equals("\"\"") ? "." + string3 : "");
        return string4;
    }

    @Override
    public String getId() {
        return this.getId(null);
    }

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }
}

