/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Date;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;

public class ByDate
implements Comparable<ByDate>,
ClauseElement {
    protected final Date date;
    protected final DateModifier duration;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public ByDate(Date date, DateModifier dateModifier) {
        this.date = date;
        this.duration = dateModifier;
    }

    public ByDate(Date date) {
        this.date = date;
        this.duration = null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ByDate byDate = (ByDate)object;
        return ByDate.areEqual(this.date, byDate.date) && ByDate.areEqual(this.duration, byDate.duration);
    }

    @Override
    public int compareTo(ByDate byDate) {
        int n = 0;
        if (this != byDate) {
            if (this.date != byDate.date) {
                n = this.date == null && byDate.date != null ? -1 : (this.date != null && byDate.date == null ? 1 : this.date.compareTo(byDate.date));
            }
            if (n == 0 && this.duration != byDate.duration) {
                n = this.duration == null && byDate.duration != null ? -1 : (this.duration != null && byDate.duration == null ? 1 : DateModifier.compare(this.duration, byDate.duration));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.date == null ? 0 : this.date.hashCode());
        n = n * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        return n;
    }

    public Date getDate() {
        return this.date;
    }

    public DateModifier getDurationValue() {
        return this.duration;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        if (this.date != null) {
            this.date.buildClause(stringBuilder);
            if (this.duration != null) {
                this.duration.buildClause(stringBuilder);
            }
        }
        return stringBuilder;
    }
}

